/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class BreakpointListDialog
extends AppDialog {
    private SWF swf;
    private JTable table = new JTable();
    private List<Breakpoint> breakpointList = new ArrayList<Breakpoint>();
    private Timer refreshTimer = null;
    private static final int REFRESH_TIMEOUT = 1000;

    public BreakpointListDialog(Window owner, SWF swf) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title") + " - " + swf.getShortFileName());
        this.swf = swf;
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int row = BreakpointListDialog.this.table.rowAtPoint(e.getPoint());
                    if (BreakpointListDialog.this.table.getSelectedRow() != -1 && row != -1) {
                        BreakpointListDialog.this.gotoButtonActionPerformed(null);
                    }
                }
            }
        });
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton gotoButton = new JButton(this.translate("button.goto"));
        gotoButton.addActionListener(this::gotoButtonActionPerformed);
        buttonsPanel.add(gotoButton);
        JButton removeButton = new JButton(this.translate("button.remove"));
        removeButton.addActionListener(this::removeButtonActionPerformed);
        buttonsPanel.add(removeButton);
        JButton removeAllButton = new JButton(this.translate("button.removeAll"));
        removeAllButton.addActionListener(this::removeAllButtonActionPerformed);
        buttonsPanel.add(removeAllButton);
        JButton closeButton = new JButton(this.translate("button.close"));
        closeButton.addActionListener(this::closeButtonActionPerformed);
        buttonsPanel.add(closeButton);
        cnt.add((Component)buttonsPanel, "South");
        this.refresh();
        this.setSize(500, 300);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage("breakpointlist16"));
        this.setIconImages(images);
        View.centerScreen(this);
    }

    private Breakpoint getSelected() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.breakpointList.get(row);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Breakpoint breakpoint = this.getSelected();
        if (breakpoint == null) {
            return;
        }
        Main.getDebugHandler().removeBreakPoint(this.swf, breakpoint.scriptName, breakpoint.line);
        this.refreshMarkers();
        this.refresh();
    }

    private void refreshMarkers() {
        if (this.swf.isAS3()) {
            Main.getMainFrame().getPanel().getABCPanel().decompiledTextArea.refreshMarkers();
            Main.getMainFrame().getPanel().getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.refreshMarkers();
        } else {
            Main.getMainFrame().getPanel().getActionPanel().decompiledEditor.refreshMarkers();
            Main.getMainFrame().getPanel().getActionPanel().editor.refreshMarkers();
        }
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        Main.getDebugHandler().clearBreakPoints(this.swf);
        this.refreshMarkers();
        this.refresh();
    }

    private void gotoButtonActionPerformed(ActionEvent evt) {
        Breakpoint breakpoint = this.getSelected();
        if (breakpoint == null) {
            return;
        }
        int classIndex = -1;
        int traitIndex = -1;
        int methodIndex = -1;
        Pattern abcPcodePattern = Pattern.compile("^#PCODE abc:(?<abc>[0-9]+),body:(?<body>[0-9]+);.*");
        Matcher m = abcPcodePattern.matcher(breakpoint.scriptName);
        if (m.matches()) {
            int abcIndex = Integer.parseInt(m.group("abc"));
            int bodyIndex = Integer.parseInt(m.group("body"));
            ABC abc = ((ABCContainerTag)this.swf.getAbcList().get(abcIndex)).getABC();
            methodIndex = ((MethodBody)abc.bodies.get((int)bodyIndex)).method_info;
        }
        Main.getMainFrame().getPanel().gotoScriptLine(this.swf, breakpoint.scriptName, breakpoint.line, classIndex, traitIndex, methodIndex, breakpoint.scriptName.startsWith("#PCODE"));
    }

    public void refresh() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        defaultTableModel.addColumn(this.translate("breakpoint.scriptName"));
        defaultTableModel.addColumn(this.translate("breakpoint.line"));
        defaultTableModel.addColumn(this.translate("breakpoint.status"));
        Map<String, Set<Integer>> breakpoints = Main.getDebugHandler().getAllBreakPoints(this.swf, false);
        ArrayList<Breakpoint> newBreakpointList = new ArrayList<Breakpoint>();
        for (String scriptName : breakpoints.keySet()) {
            for (int line : breakpoints.get(scriptName)) {
                newBreakpointList.add(new Breakpoint(scriptName, line));
                String status = "unknown";
                if (Main.getDebugHandler().isBreakpointInvalid(this.swf, scriptName, line)) {
                    status = "invalid";
                } else if (Main.getDebugHandler().isBreakpointConfirmed(this.swf, scriptName, line)) {
                    status = "confirmed";
                }
                defaultTableModel.addRow(new Object[]{scriptName, line, this.translate("breakpoint.status." + status)});
            }
        }
        this.breakpointList = newBreakpointList;
        int selectedRow = this.table.getSelectedRow();
        this.table.setModel(defaultTableModel);
        if (selectedRow >= 0 && selectedRow < defaultTableModel.getRowCount()) {
            this.table.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.table.getColumnModel().getColumn(1).setMaxWidth(50);
        this.table.getColumnModel().getColumn(2).setMaxWidth(75);
    }

    @Override
    public void setVisible(boolean b) {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
        if (b) {
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    View.execInEventDispatch(new Runnable(){

                        @Override
                        public void run() {
                            BreakpointListDialog.this.refresh();
                        }
                    });
                }
            }, 1000L, 1000L);
        }
        super.setVisible(b);
    }

    private class Breakpoint {
        public String scriptName;
        public int line;

        public Breakpoint(String scriptName, int line) {
            this.scriptName = scriptName;
            this.line = line;
        }
    }
}

