/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class CollectDepthAsSpritesDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JList<Integer> depthsList;
    private final JCheckBox replaceCheckBox;
    private final JCheckBox offsetCheckBox;
    private final JCheckBox firstMatrixCheckBox;
    private int result = -1;

    public CollectDepthAsSpritesDialog(Window owner) {
        super(owner);
        this.setSize(400, 150);
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        cnt.add(new JLabel(this.translate("collect.depths")));
        this.depthsList = new JList();
        this.depthsList.setVisibleRowCount(7);
        this.depthsList.setSelectionMode(2);
        FasterScrollPane listScroller = new FasterScrollPane(this.depthsList);
        listScroller.setPreferredSize(new Dimension(400, 200));
        cnt.add(listScroller);
        this.replaceCheckBox = new JCheckBox(this.translate("collect.replace"));
        cnt.add(this.replaceCheckBox);
        this.offsetCheckBox = new JCheckBox(this.translate("collect.offset"));
        cnt.add(this.offsetCheckBox);
        this.firstMatrixCheckBox = new JCheckBox(this.translate("collect.matrix"));
        cnt.add(this.firstMatrixCheckBox);
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        this.add((Component)panButtons, "South");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        View.setWindowIcon(this);
        this.setTitle(this.translate("dialog.title"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        View.centerScreen(this);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public List<Integer> getDepths() {
        if (this.result == -1) {
            return null;
        }
        return this.depthsList.getSelectedValuesList();
    }

    public boolean getReplace() {
        return this.replaceCheckBox.isSelected();
    }

    public boolean getOffset() {
        return this.offsetCheckBox.isSelected();
    }

    public boolean getEnsureFirstMatrix() {
        return this.firstMatrixCheckBox.isSelected();
    }

    public int showDialog(Collection<Integer> depths) {
        this.depthsList.setListData((Integer[])depths.toArray(new Integer[depths.size()]));
        this.depthsList.setVisibleRowCount(7);
        this.setVisible(true);
        return this.result;
    }
}

