/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.ColorNames;
import com.jpexs.decompiler.flash.gui.FocusablePanel;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorSelectionButton
extends FocusablePanel {
    private JPanel colorPanel;
    private final JLabel colorLabel;

    public ColorSelectionButton(Color value, String description) {
        this.setLayout(new FlowLayout(0));
        this.colorPanel = new JPanel();
        this.setToolTipText(description);
        this.colorPanel.setSize(16, 16);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorLabel = new JLabel();
        this.colorPanel.setBackground(value);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorSelectionButton.this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ColorSelectionButton.this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = ViewMessages.showColorDialog(ColorSelectionButton.this.colorPanel, ColorSelectionButton.this.colorPanel.getBackground(), false);
                if (newColor != null) {
                    ColorSelectionButton.this.colorPanel.setBackground(newColor);
                }
            }
        });
        this.colorLabel.setText(ColorSelectionButton.colorToHex(value));
        this.add(this.colorPanel);
        this.add(this.colorLabel);
    }

    public static String colorToHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color getValue() {
        return this.colorPanel.getBackground();
    }

    public void setValue(Color color) {
        String colorName = ColorNames.getNameOfColor(color);
        String text = ColorSelectionButton.colorToHex(color);
        if (colorName != null) {
            text = text + " (" + colorName + ")";
        }
        this.colorLabel.setText(text);
        this.colorPanel.setBackground(color);
    }
}

