/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigurationDirectorySelection
extends JPanel {
    private JTextField textField;

    public ConfigurationDirectorySelection(ConfigurationItem item, String value, String description) {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setText(value);
        this.textField.setToolTipText(description);
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.add((Component)this.textField, "Center");
        JButton butSelect = new JButton(View.getIcon("folderopen16"));
        butSelect.setToolTipText(ResourceBundle.getBundle(AppStrings.getResourcePath(MainFrame.class)).getString("FileChooser.openButtonText"));
        butSelect.setMargin(new Insets(2, 2, 2, 2));
        butSelect.addActionListener(e -> this.textField.setText(ConfigurationDirectorySelection.selectConfigDirectory(item, this.textField.getText())));
        this.add((Component)butSelect, "East");
    }

    private static String selectConfigDirectory(ConfigurationItem config, String current) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(current));
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File((String)config.get()));
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(Main.getDefaultMessagesComponent());
        if (returnVal == 0) {
            return Helper.fixDialogFile((File)fc.getSelectedFile()).getAbsolutePath();
        }
        return (String)config.get();
    }

    public String getValue() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

