/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ErrorState;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;

public class ErrorLogFrame
extends AppFrame {
    private static ErrorLogFrame instance;
    private final JPanel logView = new JPanel();
    private final JPanel logViewInner = new JPanel();
    private final Handler handler;
    private final ImageIcon expandIcon;
    private final ImageIcon collapseIcon;
    private ErrorState errorState = ErrorState.NO_ERROR;
    private static final int MAX_LOG_ITEM_COUNT = 100;
    private final AtomicInteger logItemCount = new AtomicInteger();
    private List<String> logHistory = new ArrayList<String>();
    private JButton saveToFileButton;

    public Handler getHandler() {
        return this.handler;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static ErrorLogFrame getInstance() {
        if (instance == null) {
            instance = new ErrorLogFrame();
            Logger logger = Logger.getLogger("");
            logger.addHandler(instance.getHandler());
        }
        return instance;
    }

    public static ErrorLogFrame createNewInstance() {
        if (instance != null) {
            Logger logger = Logger.getLogger("");
            logger.removeHandler(instance.getHandler());
            instance.setVisible(false);
            instance.dispose();
            instance = null;
        }
        return ErrorLogFrame.getInstance();
    }

    public ErrorState getErrorState() {
        return this.errorState;
    }

    public ErrorLogFrame() {
        this.setTitle(this.translate("dialog.title"));
        this.setSize(700, 400);
        if (View.isOceanic()) {
            this.setBackground(Color.white);
        }
        View.centerScreenMain(this);
        View.setWindowIcon(this);
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        if (View.isOceanic()) {
            this.logView.setBackground(Color.white);
        }
        this.logView.setLayout(new BorderLayout());
        if (View.isOceanic()) {
            cnt.setBackground(Color.white);
        }
        this.logViewInner.setLayout(new BoxLayout(this.logViewInner, 1));
        this.logView.add((Component)this.logViewInner, "North");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton clearButton = new JButton(this.translate("clear"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorLogFrame.this.clearLog();
            }
        });
        this.saveToFileButton = new JButton(this.translate("saveToFile"));
        this.saveToFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = View.getFileChooserWithIcon("save");
                fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
                FileFilter txtFilter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".txt") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return ErrorLogFrame.this.translate("filter.txt");
                    }
                };
                fc.addChoosableFileFilter(txtFilter);
                fc.setAcceptAllFileFilterUsed(true);
                if (fc.showSaveDialog(Main.getDefaultMessagesComponent()) != 0) {
                    return;
                }
                File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                try (FileWriter w = new FileWriter(file);
                     PrintWriter pw = new PrintWriter(w);){
                    ArrayList logHistoryCopy = new ArrayList(ErrorLogFrame.this.logHistory);
                    boolean first = true;
                    for (String entry : logHistoryCopy) {
                        if (!first) {
                            pw.println("-------------------------");
                        }
                        pw.println(entry);
                        first = false;
                    }
                }
                catch (IOException ex) {
                    ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), ErrorLogFrame.this.translate("error.cannotSave").replace("%error%", ex.getLocalizedMessage()), AppStrings.translate("error"), 0);
                }
            }
        });
        buttonsPanel.add(clearButton);
        this.saveToFileButton.setEnabled(false);
        buttonsPanel.add(this.saveToFileButton);
        this.expandIcon = View.getIcon("expand16");
        this.collapseIcon = View.getIcon("collapse16");
        cnt.add((Component)buttonsPanel, "South");
        cnt.add((Component)new FasterScrollPane(this.logView), "Center");
        this.handler = new Handler(){
            SimpleFormatter formatter = new SimpleFormatter();

            @Override
            public void publish(LogRecord record) {
                if (this.getLevel().intValue() <= record.getLevel().intValue()) {
                    ErrorLogFrame.this.log(record.getLevel(), this.formatter.formatMessage(record), record.getThrown());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        this.handler.setLevel(Level.WARNING);
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceLookAndFeel.setWidgetVisible((JRootPane)this.rootPane, (boolean)false, (SubstanceConstants.SubstanceWidgetType[])new SubstanceConstants.SubstanceWidgetType[]{SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS});
        }
    }

    public void clearLog() {
        this.saveToFileButton.setEnabled(false);
        this.logHistory.clear();
        this.logViewInner.removeAll();
        this.logItemCount.set(0);
        Main.clearLogFile();
        this.revalidate();
        this.repaint();
    }

    public void clearErrorState() {
        this.errorState = ErrorState.NO_ERROR;
        MainFrame mainFrame = Main.getMainFrame();
        if (mainFrame != null) {
            mainFrame.getPanel().setErrorState(this.errorState);
        }
    }

    private void notifyMainFrame(Level level) {
        MainFrame mainFrame;
        boolean stateChanged = false;
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.errorState != ErrorState.ERROR) {
                this.errorState = ErrorState.ERROR;
                stateChanged = true;
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.errorState != ErrorState.ERROR && this.errorState != ErrorState.WARNING) {
                this.errorState = ErrorState.WARNING;
                stateChanged = true;
            }
        } else if (level.intValue() >= Level.INFO.intValue() && this.errorState == ErrorState.NO_ERROR) {
            this.errorState = ErrorState.INFO;
            stateChanged = true;
        }
        if (stateChanged && (mainFrame = Main.getMainFrame()) != null) {
            mainFrame.getPanel().setErrorState(this.errorState);
        }
    }

    private void log(Level level, String msg, String detail) {
        View.execInEventDispatchLater(() -> {
            JPanel detailPanel;
            JTextArea detailComponent;
            if (this.logItemCount.getAndIncrement() > 100) {
                this.logHistory.remove(0);
                if (this.logViewInner != null) {
                    this.logViewInner.remove(0);
                }
            }
            this.notifyMainFrame(level);
            JPanel pan = new JPanel();
            if (View.isOceanic()) {
                pan.setBackground(Color.white);
            }
            pan.setLayout(new BoxLayout(pan, 1));
            if (detail == null) {
                detailComponent = null;
            } else {
                JTextArea detailTextArea = new JTextArea(detail);
                detailTextArea.setEditable(false);
                detailTextArea.setOpaque(false);
                detailTextArea.setFont(new JLabel().getFont());
                if (View.isOceanic()) {
                    detailTextArea.setBackground(Color.white);
                }
                detailComponent = detailTextArea;
            }
            JPanel header = new JPanel();
            header.setLayout(new BoxLayout(header, 0));
            if (View.isOceanic()) {
                header.setBackground(Color.white);
            }
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            String dateStr = format.format(new Date());
            final String logEntry = dateStr + " " + level.toString() + " " + msg + "\r\n" + detail;
            JToggleButton copyButton = new JToggleButton(View.getIcon("copy16"));
            copyButton.setFocusPainted(false);
            copyButton.setBorderPainted(false);
            copyButton.setFocusable(false);
            copyButton.setContentAreaFilled(false);
            copyButton.setCursor(Cursor.getPredefinedCursor(12));
            copyButton.setMargin(new Insets(2, 2, 2, 2));
            copyButton.setToolTipText(this.translate("copy"));
            copyButton.addActionListener(new ActionListener(){
                final /* synthetic */ ErrorLogFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(logEntry);
                    clipboard.setContents(stringSelection, null);
                }
            });
            this.logHistory.add(logEntry);
            final JToggleButton expandButton = new JToggleButton(this.collapseIcon);
            expandButton.setFocusPainted(false);
            expandButton.setBorderPainted(false);
            expandButton.setFocusable(false);
            expandButton.setContentAreaFilled(false);
            expandButton.setCursor(Cursor.getPredefinedCursor(12));
            expandButton.setMargin(new Insets(2, 2, 2, 2));
            expandButton.setToolTipText(this.translate("details"));
            if (detailComponent != null) {
                detailPanel = new JPanel(new BorderLayout());
                detailPanel.add((Component)detailComponent, "Center");
                detailPanel.setAlignmentX(0.0f);
            } else {
                detailPanel = null;
            }
            if (detailComponent != null) {
                expandButton.addActionListener(new ActionListener(){
                    final /* synthetic */ ErrorLogFrame this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        expandButton.setIcon(expandButton.isSelected() ? this.this$0.expandIcon : this.this$0.collapseIcon);
                        detailPanel.setVisible(expandButton.isSelected());
                        this.this$0.revalidate();
                        this.this$0.repaint();
                    }
                });
            }
            if (detailComponent != null) {
                header.add(expandButton);
            }
            JLabel dateLabel = new JLabel(dateStr);
            dateLabel.setPreferredSize(new Dimension(200, (int)dateLabel.getPreferredSize().getHeight()));
            dateLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            header.add(dateLabel);
            JLabel levelLabel = new JLabel(level.getName());
            levelLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            header.add(levelLabel);
            JTextArea msgLabel = new JTextArea(msg);
            msgLabel.setEditable(false);
            msgLabel.setOpaque(false);
            msgLabel.setFont(levelLabel.getFont());
            msgLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            header.add(msgLabel);
            header.setAlignmentX(0.0f);
            header.add(copyButton);
            pan.add(header);
            if (detailComponent != null) {
                pan.add(detailPanel);
                detailPanel.setVisible(false);
            }
            pan.setAlignmentX(0.0f);
            if (this.logViewInner != null) {
                this.logViewInner.add(pan);
            }
            this.saveToFileButton.setEnabled(true);
            this.revalidate();
            this.repaint();
        });
    }

    public void log(Level level, String msg) {
        this.log(level, msg, (String)null);
    }

    public void log(Level level, String msg, Throwable ex) {
        StringWriter sw = new StringWriter();
        if (ex != null) {
            ex.printStackTrace(new PrintWriter(sw));
        }
        this.log(level, msg, sw.toString());
        if (!this.isVisible() && ((Boolean)Configuration.showDialogOnError.get()).booleanValue()) {
            this.setVisible(true);
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
        Helper.emptyObject((Object)this);
        super.dispose();
    }
}

