/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.FrameExportMode;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ExportDialog;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportSubspriteAnimationDialog
extends AppDialog {
    private int result = -1;
    private JTextField lengthTextField = new JTextField("2", 3);
    private JComboBox<String> formatComboBox;
    private final MainPanel mainPanel;
    private JButton okButton;
    private JTextField zoomTextField = new JTextField(4);
    private JCheckBox transparentFrameBackgroundCheckBox;
    private List<FrameExportMode> modes = new ArrayList<FrameExportMode>();

    public ExportSubspriteAnimationDialog(MainPanel mainPanel, Window owner) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        this.setSize(800, 600);
        cnt.setLayout(new BorderLayout());
        JPanel centralPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 23;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        centralPanel.add((Component)new JLabel(this.translate("format")), gbc);
        Vector<String> optionNames = new Vector<String>();
        String exportFormatsStr = (String)Configuration.lastSelectedExportFormats.get();
        if ("".equals(exportFormatsStr)) {
            exportFormatsStr = null;
        }
        String[] exportFormatsArr = new String[]{};
        if (exportFormatsStr != null) {
            exportFormatsArr = exportFormatsStr.contains(",") ? exportFormatsStr.split(",") : new String[]{exportFormatsStr};
        }
        List<String> exportFormats = Arrays.asList(exportFormatsArr);
        int selectedFormat = -1;
        for (FrameExportMode mode : FrameExportMode.values()) {
            if (mode == FrameExportMode.SWF || mode == FrameExportMode.CANVAS) continue;
            String key = "frames." + mode.toString().toLowerCase(Locale.ENGLISH);
            optionNames.add(AppStrings.translate(ExportDialog.class, key));
            if (exportFormats.contains(key)) {
                selectedFormat = this.modes.size();
            }
            this.modes.add(mode);
        }
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        this.formatComboBox = new JComboBox(optionNames);
        if (selectedFormat != -1) {
            this.formatComboBox.setSelectedIndex(selectedFormat);
        }
        centralPanel.add(this.formatComboBox, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.transparentFrameBackgroundCheckBox = new JCheckBox(AppStrings.translate(ExportDialog.class, "transparentFrameBackground"));
        this.transparentFrameBackgroundCheckBox.setVisible(true);
        centralPanel.add((Component)this.transparentFrameBackgroundCheckBox, gbc);
        if (((Boolean)Configuration.lastExportTransparentBackground.get()).booleanValue()) {
            this.transparentFrameBackgroundCheckBox.setSelected(true);
        }
        JLabel zlab = new JLabel(this.translateTitle("zoom"));
        JLabel pctLabel = new JLabel(AppStrings.translate(ExportDialog.class, "zoom.percent"));
        zlab.setLabelFor(this.zoomTextField);
        String pct = "" + (Double)Configuration.lastSelectedExportZoom.get() * 100.0;
        if (pct.endsWith(".0")) {
            pct = pct.substring(0, pct.length() - 2);
        }
        this.zoomTextField.setText(pct);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 22;
        centralPanel.add((Component)zlab, gbc);
        ++gbc.gridx;
        gbc.anchor = 21;
        centralPanel.add((Component)this.zoomTextField, gbc);
        ++gbc.gridx;
        gbc.anchor = 21;
        centralPanel.add((Component)pctLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        centralPanel.add((Component)new JLabel(this.translate("length")), gbc);
        ++gbc.gridx;
        gbc.fill = 0;
        this.lengthTextField.setMinimumSize(this.lengthTextField.getPreferredSize());
        this.lengthTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportSubspriteAnimationDialog.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportSubspriteAnimationDialog.this.check();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportSubspriteAnimationDialog.this.check();
            }
        });
        centralPanel.add((Component)this.lengthTextField, gbc);
        ++gbc.gridx;
        centralPanel.add((Component)new JLabel(this.translate("frames")), gbc);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.okButton = new JButton(this.translate("button.ok"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(cancelButton);
        cnt.add((Component)centralPanel, "Center");
        cnt.add((Component)buttonsPanel, "South");
        cnt.setMinimumSize(cnt.getPreferredSize());
        this.setSize(350, 200);
        View.centerScreen(this);
        View.setWindowIcon(this, "export");
        this.getRootPane().setDefaultButton(this.okButton);
        this.setModal(true);
        this.mainPanel = mainPanel;
    }

    private void check() {
        try {
            int len = Integer.parseInt(this.lengthTextField.getText());
            this.okButton.setEnabled(len > 1);
        }
        catch (NumberFormatException nfe) {
            this.okButton.setEnabled(false);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        try {
            this.saveConfig();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, AppStrings.translate(ExportDialog.class, "zoom.invalid"), AppStrings.translate("error"), 0);
            this.zoomTextField.requestFocusInWindow();
            return;
        }
        this.setVisible(false);
    }

    private void saveConfig() {
        String format = this.getFormat().toString().toLowerCase(Locale.ENGLISH);
        String formats = (String)Configuration.lastSelectedExportFormats.get();
        String[] parts = formats.split(",", -1);
        ArrayList<String> newFormats = new ArrayList<String>();
        for (String part : parts) {
            if (part.startsWith("frames.")) {
                newFormats.add("frames." + format);
                continue;
            }
            newFormats.add(part);
        }
        String cfg = String.join((CharSequence)",", newFormats);
        Configuration.lastSelectedExportZoom.set((Object)(Double.parseDouble(this.zoomTextField.getText()) / 100.0));
        Configuration.lastSelectedExportFormats.set((Object)cfg);
        Configuration.lastExportTransparentBackground.set((Object)this.transparentFrameBackgroundCheckBox.isSelected());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public int getLength() {
        try {
            return Integer.parseInt(this.lengthTextField.getText());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public FrameExportMode getFormat() {
        return this.modes.get(this.formatComboBox.getSelectedIndex());
    }

    private String translateTitle(String title) {
        return AppStrings.translate(ExportDialog.class, "titleFormat").replace("%title%", AppStrings.translate(ExportDialog.class, title));
    }

    public boolean isTransparentFrameBackgroundEnabled() {
        return this.transparentFrameBackgroundCheckBox.isSelected();
    }

    public double getZoom() {
        return Double.parseDouble(this.zoomTextField.getText()) / 100.0;
    }
}

