/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.FontEmbedDialog;
import com.jpexs.decompiler.flash.gui.FontFace;
import com.jpexs.decompiler.flash.gui.FontFamily;
import com.jpexs.decompiler.flash.gui.FontPreviewDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.helpers.TableLayoutHelper;
import com.jpexs.decompiler.flash.tags.DefineFontTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import layout.TableLayout;

public class FontPanel
extends JPanel
implements TagEditorPanel {
    private final MainPanel mainPanel;
    private FontTag fontTag;
    private boolean allowSave = true;
    private JButton cancelButton;
    private JButton editButton;
    private JButton previewFontButton;
    private JButton setAdvanceValuesButton;
    private JButton saveButton;
    private JTextField fontAddCharactersField;
    private JButton fontAddCharsButton;
    private JButton fontRemoveCharsButton;
    private JTextField fontAscentTextField;
    private JLabel fontAscentLabel;
    private JScrollPane fontCharactersScrollPane;
    private JTextArea fontCharactersTextArea;
    private JTextArea fontCopyrightTextArea;
    private JLabel fontDescentLabel;
    private JTextField fontDescentTextField;
    private JTextArea fontNameTextArea;
    private JButton fontEmbedButton;
    private JCheckBox fontIsBoldCheckBox;
    private JCheckBox fontIsItalicCheckBox;
    private JLabel fontLeadingLabel;
    private JTextField fontLeadingTextField;
    private JTextField fontNameIntagTextField;
    private JLabel fontNameIntagLabel;
    private JComboBox<FontFamily> fontFamilyNameSelection;
    private JComboBox<FontFace> fontFaceSelection;
    private JLabel fontSourceLabel;
    private JPanel fontParamsPanel;
    private JPanel addCharsPanel;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;

    public FontPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.initComponents();
        this.setEditable(false);
    }

    public FontTag getFontTag() {
        return this.fontTag;
    }

    public void clear() {
        this.fontTag = null;
    }

    public static ComboBoxModel<FontFamily> getFamilyModel() {
        TreeSet<FontFamily> famSet = new TreeSet<FontFamily>();
        for (Font f : FontTag.getInstalledFontsByName().values()) {
            famSet.add(new FontFamily(f));
        }
        return new DefaultComboBoxModel<FontFamily>(new Vector(famSet));
    }

    public static ComboBoxModel<FontFace> getFaceModel(FontFamily family) {
        TreeSet<FontFace> faceSet = new TreeSet<FontFace>();
        for (Font f : ((Map)FontTag.getInstalledFontsByFamily().get(family.familyEn)).values()) {
            faceSet.add(new FontFace(f));
        }
        return new DefaultComboBoxModel<FontFace>(new Vector(faceSet));
    }

    @Override
    public boolean isEditing() {
        return this.saveButton.isVisible();
    }

    private void setEditable(boolean editable) {
        if (editable) {
            boolean layoutEditable;
            this.editButton.setVisible(false);
            this.saveButton.setVisible(true);
            this.cancelButton.setVisible(true);
            if (this.fontTag.isBoldEditable()) {
                this.fontIsBoldCheckBox.setEnabled(true);
            }
            if (this.fontTag.isItalicEditable()) {
                this.fontIsItalicCheckBox.setEnabled(true);
            }
            if (this.fontTag.isFontNameInTagEditable()) {
                this.fontNameIntagTextField.setVisible(true);
                this.fontNameIntagLabel.setVisible(false);
            }
            boolean bl = layoutEditable = (this.fontTag.hasLayout() || this.fontTag.getCharacterCount() == 0) && !(this.fontTag instanceof DefineFontTag);
            if (layoutEditable) {
                this.fontAscentTextField.setVisible(true);
                this.fontAscentLabel.setVisible(false);
                this.fontDescentTextField.setVisible(true);
                this.fontDescentLabel.setVisible(false);
                this.fontLeadingTextField.setVisible(true);
                this.fontLeadingLabel.setVisible(false);
            }
        } else {
            this.editButton.setVisible(true);
            this.saveButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.fontIsBoldCheckBox.setEnabled(false);
            this.fontIsItalicCheckBox.setEnabled(false);
            this.fontNameIntagTextField.setVisible(false);
            this.fontNameIntagLabel.setVisible(true);
            this.fontAscentTextField.setVisible(false);
            this.fontAscentLabel.setVisible(true);
            this.fontDescentTextField.setVisible(false);
            this.fontDescentLabel.setVisible(true);
            this.fontLeadingTextField.setVisible(false);
            this.fontLeadingLabel.setVisible(true);
        }
    }

    private String translate(String key) {
        return this.mainPanel.translate(key);
    }

    private void fontAddChars(FontTag ft, Set<Integer> selChars, Font font) {
        FontTag f = (FontTag)this.mainPanel.getCurrentTree().getCurrentTreeItem();
        String oldchars = f.getCharacters();
        for (int ic : selChars) {
            char c = (char)ic;
            if (oldchars.indexOf(c) != -1) continue;
            if (font.getSize() != 1024) {
                font = font.deriveFont(f.getFontStyle(), 1024.0f);
            }
            if (Utf8Helper.charToCodePoint((char)c, (String)ft.getCodesCharset()) == -1) {
                String msg = this.translate("error.charset.nocharacter").replace("%char%", "" + c);
                Logger.getLogger(FontPanel.class.getName()).log(Level.SEVERE, msg);
                ViewMessages.showMessageDialog(this, msg, this.translate("error"), 0);
                return;
            }
            if (font.canDisplay(c)) continue;
            String msg = this.translate("error.font.nocharacter").replace("%char%", "" + c);
            Logger.getLogger(FontPanel.class.getName()).log(Level.SEVERE, msg);
            ViewMessages.showMessageDialog(this, msg, this.translate("error"), 0);
            return;
        }
        Object[] yesno = new String[]{this.translate("button.yes"), this.translate("button.no"), this.translate("button.yes.all"), this.translate("button.no.all")};
        boolean yestoall = false;
        boolean notoall = false;
        boolean replaced = false;
        int numAdded = 0;
        for (int ic : selChars) {
            char c = (char)ic;
            if (oldchars.indexOf(c) > -1) {
                int opt = -1;
                if (!yestoall && !notoall) {
                    opt = ViewMessages.showOptionDialog(this, this.translate("message.font.add.exists").replace("%char%", "" + c), this.translate("message.warning"), 0, 2, null, yesno, this.translate("button.yes"));
                    if (opt == 2) {
                        yestoall = true;
                    }
                    if (opt == 3) {
                        notoall = true;
                    }
                }
                if (yestoall) {
                    opt = 0;
                } else if (notoall) {
                    opt = 1;
                }
                if (opt == 1) continue;
                replaced = true;
            }
            if (!f.addCharacter(c, font)) {
                ViewMessages.showMessageDialog(this.mainPanel, AppStrings.translate("error.font.cannotaddcharacter").replace("%numchars%", "" + numAdded), AppStrings.translate("error"), 0);
                break;
            }
            ++numAdded;
            oldchars = oldchars + c;
        }
        if (replaced && ViewMessages.showConfirmDialog(this, this.translate("message.font.replace.updateTexts"), this.translate("message.warning"), 0, 1) == 0) {
            int fontId = ft.getCharacterId();
            SWF swf = ft.getSwf();
            for (Tag tag : swf.getTags()) {
                TextTag textTag;
                if (!(tag instanceof TextTag) || !(textTag = (TextTag)tag).getFontIds().contains(fontId)) continue;
                String text = textTag.getFormattedText((boolean)true).text;
                this.mainPanel.saveText(textTag, text, null, null, null);
            }
        }
    }

    private void fontRemoveChars(FontTag ft, Set<Integer> selChars) {
        FontTag f = (FontTag)this.mainPanel.getCurrentTree().getCurrentTreeItem();
        for (int ic : selChars) {
            char c = (char)ic;
            f.removeCharacter(c);
        }
    }

    public void showFontTag(FontTag ft) {
        SWF swf = ft.getSwf();
        this.fontTag = ft;
        this.fontNameIntagLabel.setText(ft.getFontNameIntag());
        this.fontNameIntagTextField.setText(ft.getFontNameIntag());
        this.fontNameTextArea.setText(ft.getFontName());
        this.fontCopyrightTextArea.setText(ft.getFontCopyright());
        this.fontIsBoldCheckBox.setSelected(ft.isBold());
        this.fontIsItalicCheckBox.setSelected(ft.isItalic());
        this.fontAscentLabel.setText(ft.getAscent() == -1 ? this.translate("value.unknown") : Integer.toString(ft.getAscent()));
        this.fontAscentTextField.setText(ft.getAscent() == -1 ? "0" : "" + ft.getAscent());
        this.fontDescentLabel.setText(ft.getDescent() == -1 ? this.translate("value.unknown") : Integer.toString(ft.getDescent()));
        this.fontDescentTextField.setText(ft.getDescent() == -1 ? "0" : "" + ft.getDescent());
        this.fontLeadingLabel.setText(ft.getLeading() == -1 ? this.translate("value.unknown") : Integer.toString(ft.getLeading()));
        this.fontLeadingTextField.setText(ft.getLeading() == -1 ? "0" : "" + ft.getLeading());
        String chars = ft.getCharacters();
        this.fontCharactersTextArea.setText(chars);
        try {
            this.fontCharactersScrollPane.getVerticalScrollBar().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAllowSave(false);
        Font selFont = ft.getSystemFont();
        this.fontFamilyNameSelection.setSelectedItem(new FontFamily(selFont));
        this.fontFaceSelection.setSelectedItem(new FontFace(selFont));
        this.setAllowSave(true);
        this.setEditable(false);
        boolean readOnly = ft.isReadOnly();
        if (readOnly) {
            this.addCharsPanel.setVisible(false);
            this.editButton.setVisible(false);
        }
    }

    private void initComponents() {
        this.contentScrollPane = new FasterScrollPane();
        this.addCharsPanel = new JPanel();
        this.fontParamsPanel = new JPanel();
        this.fontNameIntagTextField = new JTextField(30);
        this.fontNameIntagLabel = new JLabel();
        FasterScrollPane fontDisplayNameScrollPane = new FasterScrollPane();
        this.fontNameTextArea = new JTextArea();
        JLabel jLabel3 = new JLabel();
        FasterScrollPane fontCopyrightScrollPane = new FasterScrollPane();
        this.fontCopyrightTextArea = new JTextArea();
        JLabel jLabel4 = new JLabel();
        this.fontIsBoldCheckBox = new JCheckBox();
        JLabel jLabel5 = new JLabel();
        this.fontIsItalicCheckBox = new JCheckBox();
        JLabel jLabel6 = new JLabel();
        this.fontAscentLabel = new JLabel();
        this.fontAscentTextField = new JTextField(30);
        JLabel jLabel7 = new JLabel();
        this.fontDescentLabel = new JLabel();
        this.fontDescentTextField = new JTextField(30);
        JLabel jLabel8 = new JLabel();
        this.fontLeadingLabel = new JLabel();
        this.fontLeadingTextField = new JTextField(30);
        JLabel jLabel9 = new JLabel();
        this.fontCharactersScrollPane = new FasterScrollPane();
        this.fontCharactersTextArea = new JTextArea();
        JLabel fontCharsAddLabel = new JLabel();
        this.fontAddCharactersField = new JTextField();
        this.fontAddCharsButton = new JButton();
        this.fontRemoveCharsButton = new JButton();
        this.fontSourceLabel = new JLabel();
        this.fontFamilyNameSelection = new JComboBox();
        this.fontFaceSelection = new JComboBox();
        this.fontEmbedButton = new JButton();
        this.editButton = new JButton();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.previewFontButton = new JButton();
        this.setAdvanceValuesButton = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FontPanel.this.formComponentResized(evt);
            }
        });
        this.contentPanel = new JPanel();
        this.contentScrollPane.setBorder(null);
        this.contentScrollPane.setVerticalScrollBarPolicy(21);
        TableLayout tlFontParamsPanel = new TableLayout((double[][])new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0}});
        this.fontParamsPanel.setLayout((LayoutManager)tlFontParamsPanel);
        JLabel fontNameIntagLabLabel = new JLabel();
        fontNameIntagLabLabel.setText(AppStrings.translate("font.name.intag"));
        this.fontParamsPanel.add((Component)fontNameIntagLabLabel, "0,0,R");
        this.fontNameIntagTextField.setText(AppStrings.translate("value.unknown"));
        this.fontNameIntagLabel.setText(AppStrings.translate("value.unknown"));
        this.fontNameIntagLabel.setMinimumSize(new Dimension(100, this.fontNameIntagLabel.getMinimumSize().height));
        this.fontNameIntagLabel.setPreferredSize(new Dimension(250, this.fontNameIntagLabel.getPreferredSize().height));
        JPanel fontNamePanel = new JPanel(new FlowLayout(0, 0, 0));
        fontNamePanel.add(this.fontNameIntagTextField);
        fontNamePanel.add(this.fontNameIntagLabel);
        this.fontNameIntagTextField.setVisible(false);
        this.fontParamsPanel.add((Component)fontNamePanel, "1,0");
        JLabel fontNameNameLabLabel = new JLabel();
        fontNameNameLabLabel.setText(AppStrings.translate("font.name"));
        this.fontParamsPanel.add((Component)fontNameNameLabLabel, "0,1,R");
        fontDisplayNameScrollPane.setBorder(null);
        fontDisplayNameScrollPane.setHorizontalScrollBarPolicy(31);
        fontDisplayNameScrollPane.setHorizontalScrollBar(null);
        this.fontNameTextArea.setEditable(false);
        this.fontNameTextArea.setColumns(20);
        this.fontNameTextArea.setFont(new JLabel().getFont());
        this.fontNameTextArea.setLineWrap(true);
        this.fontNameTextArea.setText(AppStrings.translate("value.unknown"));
        this.fontNameTextArea.setWrapStyleWord(true);
        this.fontNameTextArea.setMinimumSize(new Dimension(100, this.fontNameTextArea.getMinimumSize().height));
        this.fontNameTextArea.setOpaque(false);
        ((JScrollPane)fontDisplayNameScrollPane).setViewportView(this.fontNameTextArea);
        this.fontParamsPanel.add((Component)fontDisplayNameScrollPane, "1,1");
        jLabel3.setText(AppStrings.translate("fontName.copyright"));
        this.fontParamsPanel.add((Component)jLabel3, "0,2,R");
        fontCopyrightScrollPane.setBorder(null);
        fontCopyrightScrollPane.setHorizontalScrollBarPolicy(31);
        fontCopyrightScrollPane.setHorizontalScrollBar(null);
        this.fontCopyrightTextArea.setEditable(false);
        this.fontCopyrightTextArea.setColumns(20);
        this.fontCopyrightTextArea.setFont(new JLabel().getFont());
        this.fontCopyrightTextArea.setLineWrap(true);
        this.fontCopyrightTextArea.setText(AppStrings.translate("value.unknown"));
        this.fontCopyrightTextArea.setWrapStyleWord(true);
        this.fontCopyrightTextArea.setMinimumSize(new Dimension(100, this.fontCopyrightTextArea.getMinimumSize().height));
        this.fontCopyrightTextArea.setOpaque(false);
        ((JScrollPane)fontCopyrightScrollPane).setViewportView(this.fontCopyrightTextArea);
        this.fontParamsPanel.add((Component)fontCopyrightScrollPane, "1,2");
        jLabel4.setText(AppStrings.translate("font.isbold"));
        this.fontParamsPanel.add((Component)jLabel4, "0,3,R");
        this.fontIsBoldCheckBox.setEnabled(false);
        this.fontParamsPanel.add((Component)this.fontIsBoldCheckBox, "1,3");
        jLabel5.setText(AppStrings.translate("font.isitalic"));
        this.fontParamsPanel.add((Component)jLabel5, "0,4,R");
        this.fontIsItalicCheckBox.setEnabled(false);
        this.fontParamsPanel.add((Component)this.fontIsItalicCheckBox, "1,4");
        jLabel6.setText(AppStrings.translate("font.ascent"));
        this.fontParamsPanel.add((Component)jLabel6, "0,5,R");
        this.fontAscentLabel.setText(AppStrings.translate("value.unknown"));
        JPanel fontAscentPanel = new JPanel(new FlowLayout(0, 0, 0));
        fontAscentPanel.add(this.fontAscentLabel);
        fontAscentPanel.add(this.fontAscentTextField);
        this.fontAscentTextField.setVisible(false);
        this.fontParamsPanel.add((Component)fontAscentPanel, "1,5");
        jLabel7.setText(AppStrings.translate("font.descent"));
        this.fontParamsPanel.add((Component)jLabel7, "0,6,R");
        this.fontDescentLabel.setText(AppStrings.translate("value.unknown"));
        JPanel fontDescentPanel = new JPanel(new FlowLayout(0, 0, 0));
        fontDescentPanel.add(this.fontDescentLabel);
        fontDescentPanel.add(this.fontDescentTextField);
        this.fontDescentTextField.setVisible(false);
        this.fontParamsPanel.add((Component)fontDescentPanel, "1,6");
        jLabel8.setText(AppStrings.translate("font.leading"));
        this.fontParamsPanel.add((Component)jLabel8, "0,7,R");
        this.fontLeadingLabel.setText(AppStrings.translate("value.unknown"));
        JPanel fontLeadingPanel = new JPanel(new FlowLayout(0, 0, 0));
        fontLeadingPanel.add(this.fontLeadingLabel);
        fontLeadingPanel.add(this.fontLeadingTextField);
        this.fontLeadingTextField.setVisible(false);
        this.fontParamsPanel.add((Component)fontLeadingPanel, "1,7");
        jLabel9.setText(AppStrings.translate("font.characters"));
        this.fontParamsPanel.add((Component)jLabel9, "0,8,R,T");
        this.fontCharactersScrollPane.setBorder(null);
        this.fontCharactersScrollPane.setHorizontalScrollBarPolicy(31);
        this.fontCharactersScrollPane.setHorizontalScrollBar(null);
        this.fontCharactersScrollPane.setVerticalScrollBarPolicy(20);
        this.fontCharactersTextArea.setEditable(false);
        this.fontCharactersTextArea.setColumns(20);
        this.fontCharactersTextArea.setFont(new JLabel().getFont());
        this.fontCharactersTextArea.setLineWrap(true);
        this.fontCharactersTextArea.setWrapStyleWord(true);
        this.fontCharactersTextArea.setMinimumSize(new Dimension(100, this.fontCharactersTextArea.getMinimumSize().height));
        this.fontCharactersTextArea.setOpaque(false);
        this.fontCharactersScrollPane.setViewportView(this.fontCharactersTextArea);
        this.fontParamsPanel.add((Component)this.fontCharactersScrollPane, "1,8");
        fontCharsAddLabel.setText(AppStrings.translate("font.characters.add"));
        this.fontAddCharsButton.setText(AppStrings.translate("button.ok"));
        this.fontAddCharsButton.addActionListener(this::fontAddCharsButtonActionPerformed);
        this.fontRemoveCharsButton.setText(AppStrings.translate("button.remove"));
        this.fontRemoveCharsButton.addActionListener(this::fontRemoveCharsButtonActionPerformed);
        this.fontSourceLabel.setText(AppStrings.translate("font.source"));
        this.fontFamilyNameSelection.setPreferredSize(new Dimension(100, this.fontFamilyNameSelection.getMinimumSize().height));
        this.fontFamilyNameSelection.setModel(FontPanel.getFamilyModel());
        this.fontFamilyNameSelection.setSelectedItem(FontTag.getDefaultFontName());
        this.fontFaceSelection.setModel(FontPanel.getFaceModel((FontFamily)this.fontFamilyNameSelection.getSelectedItem()));
        this.fontFamilyNameSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontPanel.this.fontFamilySelectionItemStateChanged();
            }
        });
        this.fontFaceSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontPanel.this.fontFaceSelectionItemStateChanged();
            }
        });
        this.fontEmbedButton.setText(AppStrings.translate("button.font.embed"));
        this.fontEmbedButton.addActionListener(this::fontEmbedButtonActionPerformed);
        this.editButton.setIcon(View.getIcon("edit16"));
        this.editButton.setText(AppStrings.translate("button.edit"));
        this.editButton.addActionListener(this::editButtonActionPerformed);
        this.saveButton.setIcon(View.getIcon("save16"));
        this.saveButton.setText(AppStrings.translate("button.save"));
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        this.cancelButton.setIcon(View.getIcon("cancel16"));
        this.cancelButton.setText(AppStrings.translate("button.cancel"));
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.previewFontButton.setText(AppStrings.translate("button.preview"));
        this.previewFontButton.addActionListener(this::previewButtonFontActionPerformed);
        this.setAdvanceValuesButton.setText(AppStrings.translate("button.setAdvanceValues"));
        this.setAdvanceValuesButton.addActionListener(this::setAdvanceValuesButtonActionPerformed);
        TableLayout tlAddCharsPanel = new TableLayout((double[][])new double[][]{{-2.0, -1.0, -2.0, -2.0, -2.0, -2.0}, {-2.0, -2.0, -2.0}});
        this.addCharsPanel.setLayout((LayoutManager)tlAddCharsPanel);
        this.addCharsPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addCharsPanel.add((Component)fontCharsAddLabel, "0,0,R");
        this.addCharsPanel.add((Component)this.fontAddCharactersField, "1,0,2,0");
        this.addCharsPanel.add((Component)this.fontAddCharsButton, "3,0");
        this.addCharsPanel.add((Component)this.fontEmbedButton, "4,0");
        this.addCharsPanel.add((Component)this.fontSourceLabel, "0,1,R");
        this.addCharsPanel.add(this.fontFamilyNameSelection, "1,1");
        this.addCharsPanel.add(this.fontFaceSelection, "2,1");
        this.addCharsPanel.add((Component)this.previewFontButton, "3,1");
        this.addCharsPanel.add((Component)this.setAdvanceValuesButton, "4,1");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.editButton);
        buttonsPanel.add(this.saveButton);
        buttonsPanel.add(this.cancelButton);
        TableLayout tlAll = new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, -2.0, -2.0}});
        this.contentPanel.setLayout((LayoutManager)tlAll);
        this.contentPanel.add((Component)this.fontParamsPanel, "0,0");
        this.contentPanel.add((Component)buttonsPanel, "0,1");
        this.contentPanel.add((Component)this.addCharsPanel, "0,2");
        this.contentScrollPane.setViewportView(this.contentPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentScrollPane, "Center");
        TableLayoutHelper.addTableSpaces(tlAddCharsPanel, 10.0);
        TableLayoutHelper.addTableSpaces(tlFontParamsPanel, 10.0);
        TableLayoutHelper.addTableSpaces(tlAll, 10.0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FontPanel.this.contentPanel.setPreferredSize(new Dimension(Math.max(FontPanel.this.getSize().width, ((FontPanel)FontPanel.this).addCharsPanel.getPreferredSize().width + 20), FontPanel.this.getSize().height));
                FontPanel.this.contentPanel.revalidate();
            }
        });
    }

    private void fontAddCharsButtonActionPerformed(ActionEvent evt) {
        String newchars = this.fontAddCharactersField.getText();
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof FontTag) {
            FontTag ft = (FontTag)item;
            TreeSet<Integer> selChars = new TreeSet<Integer>();
            for (int c = 0; c < newchars.length(); ++c) {
                selChars.add(newchars.codePointAt(c));
            }
            if (!selChars.isEmpty()) {
                this.fontAddChars(ft, selChars, ((FontFace)this.fontFaceSelection.getSelectedItem()).font);
                this.fontAddCharactersField.setText("");
                this.mainPanel.repaintTree();
            }
        }
    }

    private void fontRemoveCharsButtonActionPerformed(ActionEvent evt) {
        String newchars = this.fontAddCharactersField.getText();
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof FontTag) {
            FontTag ft = (FontTag)item;
            TreeSet<Integer> selChars = new TreeSet<Integer>();
            for (int c = 0; c < newchars.length(); ++c) {
                selChars.add(newchars.codePointAt(c));
            }
            if (!selChars.isEmpty()) {
                this.fontRemoveChars(ft, selChars);
                this.fontAddCharactersField.setText("");
                this.mainPanel.repaintTree();
            }
        }
    }

    public boolean fontEmbed(TreeItem item, boolean create) {
        Set<Integer> selChars;
        if (item == null) {
            return false;
        }
        FontTag ft = (FontTag)item;
        FontEmbedDialog fed = new FontEmbedDialog(Main.getDefaultDialogsOwner(), ft.hasLayout() || ft.getCharacterCount() == 0, (FontFace)this.fontFaceSelection.getSelectedItem(), this.fontAddCharactersField.getText(), create);
        if (fed.showDialog() == 0 && (!(selChars = fed.getSelectedChars()).isEmpty() || fed.isImportAscentDescentLeading())) {
            if (ft.getCharacterCount() == 0) {
                ft.setHasLayout(true);
            }
            Font selFont = fed.getSelectedFont();
            this.fontFamilyNameSelection.setSelectedItem(new FontFamily(selFont));
            this.fontFaceSelection.setSelectedItem(new FontFace(selFont));
            this.fontAddChars(ft, selChars, selFont);
            if (fed.isImportAscentDescentLeading()) {
                Font adlFont = selFont;
                if (selFont.getSize() != 1024) {
                    adlFont = selFont.deriveFont(1024.0f);
                }
                ft.setAscent((int)(ft.getDivider() * (double)this.getFontMetrics(adlFont).getAscent()));
                ft.setDescent((int)(ft.getDivider() * (double)this.getFontMetrics(adlFont).getDescent()));
                int leading = this.getFontMetrics(adlFont).getAscent() + this.getFontMetrics(adlFont).getDescent() - 1024;
                ft.setLeading((int)(ft.getDivider() * (double)leading));
            }
            if (create) {
                ft.setFontNameIntag(fed.getCreateFontName());
                ft.setBold(fed.isBold());
                ft.setItalic(fed.isItalic());
            }
            this.fontAddCharactersField.setText("");
            ft.setModified(true);
            this.mainPanel.reload(true);
            return true;
        }
        return false;
    }

    private void fontEmbedButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof FontTag) {
            this.fontEmbed(item, false);
        }
    }

    private synchronized void setAllowSave(boolean v) {
        this.allowSave = v;
    }

    private synchronized void savePair() {
        if (!this.allowSave) {
            return;
        }
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof FontTag) {
            FontTag f = (FontTag)item;
            SWF swf = f.getSwf();
            String selectedName = ((FontFace)this.fontFaceSelection.getSelectedItem()).font.getFontName(Locale.ENGLISH);
            swf.sourceFontNamesMap.put(f.getCharacterId(), selectedName);
            Configuration.addFontPair((String)swf.getShortPathTitle(), (int)f.getCharacterId(), (String)f.getFontNameIntag(), (String)selectedName);
        }
    }

    private void fontFamilySelectionItemStateChanged() {
        this.savePair();
        this.fontFaceSelection.setModel(FontPanel.getFaceModel((FontFamily)this.fontFamilyNameSelection.getSelectedItem()));
    }

    private void fontFaceSelectionItemStateChanged() {
        this.savePair();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.setEditable(true);
        this.mainPanel.setEditingStatus();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (!(this.fontTag instanceof DefineFontTag)) {
            if (this.fontTag.getCharacterCount() == 0 && !this.fontTag.hasLayout()) {
                this.fontTag.setHasLayout(true);
            }
            if (this.fontTag.hasLayout()) {
                try {
                    int ascent = Integer.parseInt(this.fontAscentTextField.getText());
                    int descent = Integer.parseInt(this.fontDescentTextField.getText());
                    int leading = Integer.parseInt(this.fontLeadingTextField.getText());
                    if (ascent < 0 || descent < 0) {
                        return;
                    }
                    this.fontTag.setAscent(ascent);
                    this.fontTag.setDescent(descent);
                    this.fontTag.setLeading(leading);
                    this.fontAscentLabel.setText("" + ascent);
                    this.fontDescentLabel.setText("" + descent);
                    this.fontLeadingLabel.setText("" + leading);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
        }
        if (this.fontTag.isBoldEditable()) {
            this.fontTag.setBold(this.fontIsBoldCheckBox.isSelected());
        }
        if (this.fontTag.isItalicEditable()) {
            this.fontTag.setItalic(this.fontIsItalicCheckBox.isSelected());
        }
        if (this.fontTag.isFontNameInTagEditable()) {
            this.fontTag.setFontNameIntag(this.fontNameIntagTextField.getText());
            this.fontNameIntagLabel.setText(this.fontNameIntagTextField.getText());
        }
        this.mainPanel.getCurrentTree().repaint();
        this.fontTag.setModified(true);
        this.setEditable(false);
        this.mainPanel.clearEditingStatus();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.showFontTag(this.fontTag);
        this.setEditable(false);
        this.mainPanel.clearEditingStatus();
    }

    private void previewButtonFontActionPerformed(ActionEvent evt) {
        new FontPreviewDialog(null, true, ((FontFace)this.fontFaceSelection.getSelectedItem()).font).setVisible(true);
    }

    private void setAdvanceValuesButtonActionPerformed(ActionEvent evt) {
        if (ViewMessages.showConfirmDialog(this, AppStrings.translate("message.font.setadvancevalues"), AppStrings.translate("message.warning"), 2, 2, (ConfigurationItem<Boolean>)Configuration.showSetAdvanceValuesMessage, 0) == 0) {
            this.fontTag.setAdvanceValues(((FontFace)this.fontFaceSelection.getSelectedItem()).font);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.fontParamsPanel.updateUI();
    }

    private void importTTFButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.getCurrentTree().getCurrentTreeItem();
        if (item instanceof FontTag) {
            FontTag ft = (FontTag)item;
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
            FileFilter ttfFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".ttf") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "TTF files";
                }
            };
            fc.setFileFilter(ttfFilter);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showOpenDialog(Main.getDefaultMessagesComponent());
            if (returnVal == 0) {
                Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
                File selfile = Helper.fixDialogFile((File)fc.getSelectedFile());
                HashSet<Integer> selChars = new HashSet<Integer>();
                try {
                    Font f = Font.createFont(0, selfile);
                    int[] required = new int[]{1, 0, 13, 32};
                    block3: for (int i = 0; i < 65535; i = (int)((char)(i + 1))) {
                        for (int r : required) {
                            if (r == i) continue block3;
                        }
                        if (!f.canDisplay(i)) continue;
                        selChars.add(i);
                    }
                    this.fontAddChars(ft, selChars, f);
                    this.mainPanel.reload(true);
                }
                catch (FontFormatException ex) {
                    JOptionPane.showMessageDialog(this.mainPanel, "Invalid TTF font");
                }
                catch (IOException ex) {
                    Logger.getLogger(FontPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void startEdit() {
        if (!this.editButton.isVisible()) {
            return;
        }
        this.editButtonActionPerformed(null);
    }

    @Override
    public boolean tryAutoSave() {
        if (((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveButtonActionPerformed(null);
            return !this.saveButton.isVisible() || !this.saveButton.isEnabled();
        }
        return false;
    }
}

