/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.exporters.script.PcodeGraphVizExporter;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.graph.AbstractGraphPanel;
import com.jpexs.decompiler.flash.gui.graph.GraphPanelSimple;
import com.jpexs.decompiler.flash.gui.graph.GraphVizGraphPanel;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.graph.Graph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class GraphDialog
extends AppDialog {
    AbstractGraphPanel gp;
    int scrollBarWidth;
    int scrollBarHeight;
    int frameWidthDiff;
    int frameHeightDiff;
    private Graph graph;
    private static final Logger logger = Logger.getLogger(GraphDialog.class.getName());

    public GraphDialog(Window owner, Graph graph, String name) throws InterruptedException {
        super(owner);
        this.graph = graph;
        this.setSize(500, 500);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        if (GraphVizGraphPanel.isAvailable()) {
            this.gp = new GraphVizGraphPanel(graph);
        } else {
            this.gp = new GraphPanelSimple(graph);
            JPanel betterGraphInfo = new JPanel(new FlowLayout());
            JLabel lab = new JLabel("<html><font color=\"#0000CF\"><u>" + this.translate("graph.better.dot") + "</u></font></html>");
            lab.setCursor(Cursor.getPredefinedCursor(12));
            lab.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Main.advancedSettings("paths");
                }
            });
            betterGraphInfo.add(lab);
            cnt.add((Component)betterGraphInfo, "South");
        }
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyMenuItem = new JMenuItem(this.translate("menu.copygraph.gv"));
        copyMenuItem.addActionListener(this::copyToClipBoardActionPerformed);
        popupMenu.add(copyMenuItem);
        this.gp.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ GraphDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setTitle(this.translate("graph") + " " + name);
        FasterScrollPane scrollPane = new FasterScrollPane(this.gp);
        this.scrollBarWidth = scrollPane.getVerticalScrollBar().getPreferredSize().width;
        this.scrollBarHeight = scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        cnt.add((Component)scrollPane, "Center");
        this.pack();
        Dimension size = this.getSize();
        Dimension innerSize = this.getContentPane().getSize();
        this.frameWidthDiff = size.width - innerSize.width;
        this.frameHeightDiff = size.height - innerSize.height;
        View.setWindowIcon(this);
        MouseAdapter ma = new MouseAdapter(){
            private Point origin;

            @Override
            public void mousePressed(MouseEvent e) {
                this.origin = new Point(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                JViewport viewPort;
                if (this.origin != null && (viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, GraphDialog.this.gp)) != null) {
                    int deltaX = this.origin.x - e.getX();
                    int deltaY = this.origin.y - e.getY();
                    Rectangle view = viewPort.getViewRect();
                    view.x += deltaX;
                    view.y += deltaY;
                    GraphDialog.this.gp.scrollRectToVisible(view);
                }
            }
        };
        this.gp.addMouseListener(ma);
        this.gp.addMouseMotionListener(ma);
    }

    private void copyToClipBoardActionPerformed(ActionEvent evt) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            StringBuilderTextWriter stringBuilderWriter = new StringBuilderTextWriter(null, stringBuilder);
            new PcodeGraphVizExporter().export(this.graph, (GraphTextWriter)stringBuilderWriter);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while generating graph", ex);
            return;
        }
        try {
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cannot copy to clipboard", ex);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Dimension screen = new Dimension(screenBounds.width - insets.left - insets.right, screenBounds.height - insets.top - insets.bottom);
        Dimension dim = new Dimension(0, 0);
        Dimension panDim = this.gp.getPreferredSize();
        panDim = new Dimension(panDim.width + 3, panDim.height + 2);
        boolean tooHigh = false;
        boolean tooWide = false;
        if (panDim.width + this.frameWidthDiff < screen.width) {
            dim.width = panDim.width;
        } else {
            dim.width = screen.width - this.frameWidthDiff;
            tooWide = true;
        }
        if (panDim.height + this.frameHeightDiff < screen.height) {
            dim.height = panDim.height;
        } else {
            dim.height = screen.height - this.frameHeightDiff;
            tooHigh = true;
        }
        if (tooWide) {
            dim.height += this.scrollBarHeight;
            dim.height = Math.min(dim.height, screen.height);
        }
        if (tooHigh) {
            dim.width += this.scrollBarWidth;
            dim.width = Math.min(dim.width, screen.width);
        }
        this.setVisibleSize(dim);
        View.centerScreen(this);
    }

    private void setVisibleSize(Dimension dim) {
        this.setSize(new Dimension(dim.width + this.frameWidthDiff, dim.height + this.frameHeightDiff));
    }
}

