/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.helpers.TableLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import layout.TableLayout;

public class HeaderInfoPanel
extends JPanel
implements TagEditorPanel {
    private final JLabel signatureLabel = new JLabel();
    private final JLabel compressionLabel = new JLabel();
    private final JLabel gfxLabel = new JLabel();
    private final JLabel encryptedLabel = new JLabel();
    private final JLabel versionLabel = new JLabel();
    private final JLabel fileSizeLabel = new JLabel();
    private final JLabel frameRateLabel = new JLabel();
    private final JLabel frameCountLabel = new JLabel();
    private final JSpinner frameCountEditor = new JSpinner();
    private final JPanel frameCountEditorPanel = new JPanel();
    private final JLabel displayRectTwipsLabel = new JLabel();
    private final JLabel displayRectPixelsLabel = new JLabel();
    private final JPanel compressionEditorPanel = new JPanel();
    private final JComboBox<ComboBoxItem<SWFCompression>> compressionComboBox = new JComboBox();
    private final JPanel versionEditorPanel = new JPanel();
    private final JSpinner versionEditor = new JSpinner();
    private final JCheckBox gfxCheckBox = new JCheckBox();
    private final JCheckBox encryptedCheckBox = new JCheckBox();
    private final JPanel frameRateEditorPanel = new JPanel();
    private final JSpinner frameRateEditor = new JSpinner();
    private final JPanel propertiesPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton editButton = new JButton(AppStrings.translate("button.edit"), View.getIcon("edit16"));
    private final JButton saveButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    private final JButton cancelButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    private final JPanel displayRectEditorPanel = new JPanel();
    private final JSpinner xMinEditor = new JSpinner();
    private final JSpinner xMaxEditor = new JSpinner();
    private final JSpinner yMinEditor = new JSpinner();
    private final JSpinner yMaxEditor = new JSpinner();
    private final JPanel warningPanel = new JPanel();
    private final JLabel warningLabel = new JLabel();
    private JComboBox<String> unitComboBox;
    private final int UNIT_PIXELS = 0;
    private final int UNIT_TWIPS = 1;
    private int unit = 0;
    private SWF swf;
    private MainPanel mainPanel;

    public HeaderInfoPanel(MainPanel mainPanel) {
        this.setLayout(new BorderLayout());
        this.mainPanel = mainPanel;
        TableLayout tl = new TableLayout((double[][])new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0}});
        this.propertiesPanel.setLayout((LayoutManager)tl);
        FlowLayout layout = new FlowLayout(7);
        layout.setHgap(0);
        layout.setVgap(0);
        this.compressionEditorPanel.setLayout(layout);
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>(AppStrings.translate("header.uncompressed"), SWFCompression.NONE));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("Zlib", SWFCompression.ZLIB));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("LZMA", SWFCompression.LZMA));
        this.compressionComboBox.addActionListener(e -> this.validateHeader());
        this.compressionEditorPanel.add(this.compressionComboBox);
        this.versionEditorPanel.setLayout(layout);
        this.versionEditor.setPreferredSize(new Dimension(80, this.versionEditor.getPreferredSize().height));
        this.versionEditor.addChangeListener(e -> this.validateHeader());
        this.versionEditorPanel.add(this.versionEditor);
        this.encryptedCheckBox.addChangeListener(e -> this.validateHeader());
        this.gfxCheckBox.addChangeListener(e -> this.validateHeader());
        this.frameRateEditorPanel.setLayout(layout);
        this.frameRateEditor.setPreferredSize(new Dimension(80, this.frameRateEditor.getPreferredSize().height));
        this.frameRateEditorPanel.add(this.frameRateEditor);
        this.frameCountEditorPanel.setLayout(layout);
        this.frameCountEditor.setPreferredSize(new Dimension(80, this.frameCountEditor.getPreferredSize().height));
        this.frameCountEditorPanel.add(this.frameCountEditor);
        JLabel frameCountWarningIcon = new JLabel(View.getIcon("warning16"));
        frameCountWarningIcon.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        frameCountWarningIcon.setCursor(new Cursor(12));
        frameCountWarningIcon.setToolTipText(AppStrings.translate("warning.icon"));
        frameCountWarningIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ViewMessages.showMessageDialog(HeaderInfoPanel.this, AppStrings.translate("warning.edit.headerframecount"), AppStrings.translate("message.warning"), 2);
                }
            }
        });
        this.frameCountEditorPanel.add(frameCountWarningIcon);
        this.displayRectEditorPanel.setLayout(layout);
        this.displayRectEditorPanel.setMinimumSize(new Dimension(10, this.displayRectEditorPanel.getMinimumSize().height));
        this.xMinEditor.setPreferredSize(new Dimension(80, this.xMinEditor.getPreferredSize().height));
        this.xMaxEditor.setPreferredSize(new Dimension(80, this.xMaxEditor.getPreferredSize().height));
        this.yMinEditor.setPreferredSize(new Dimension(80, this.yMinEditor.getPreferredSize().height));
        this.yMaxEditor.setPreferredSize(new Dimension(80, this.yMaxEditor.getPreferredSize().height));
        this.displayRectEditorPanel.add(this.xMinEditor);
        this.displayRectEditorPanel.add(new JLabel(","));
        this.displayRectEditorPanel.add(this.yMinEditor);
        this.displayRectEditorPanel.add(new JLabel(" => "));
        this.displayRectEditorPanel.add(this.xMaxEditor);
        this.displayRectEditorPanel.add(new JLabel(","));
        this.displayRectEditorPanel.add(this.yMaxEditor);
        this.unitComboBox = new JComboBox<String>(new String[]{AppStrings.translate("header.displayrect.unit.pixels"), AppStrings.translate("header.displayrect.unit.twips")});
        this.displayRectEditorPanel.add(this.unitComboBox);
        this.unitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int newUnit = HeaderInfoPanel.this.unitComboBox.getSelectedIndex();
                    double multiplier = 1.0;
                    if (HeaderInfoPanel.this.unit == 0 && newUnit == 1) {
                        multiplier = 20.0;
                    }
                    if (HeaderInfoPanel.this.unit == 1 && newUnit == 0) {
                        multiplier = 0.05;
                    }
                    HeaderInfoPanel.this.unit = newUnit;
                    HeaderInfoPanel.this.xMinEditor.setValue((Double)HeaderInfoPanel.this.xMinEditor.getValue() * multiplier);
                    HeaderInfoPanel.this.yMinEditor.setValue((Double)HeaderInfoPanel.this.yMinEditor.getValue() * multiplier);
                    HeaderInfoPanel.this.xMaxEditor.setValue((Double)HeaderInfoPanel.this.xMaxEditor.getValue() * multiplier);
                    HeaderInfoPanel.this.yMaxEditor.setValue((Double)HeaderInfoPanel.this.yMaxEditor.getValue() * multiplier);
                }
            }
        });
        this.warningLabel.setIcon(View.getIcon("warning16"));
        this.warningPanel.setLayout(layout);
        this.warningPanel.setBackground(new Color(255, 213, 29));
        this.warningPanel.add(this.warningLabel);
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.signature")), "0,0");
        this.propertiesPanel.add((Component)this.signatureLabel, "1,0");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.compression")), "0,1");
        this.propertiesPanel.add((Component)this.compressionLabel, "1,1");
        this.propertiesPanel.add((Component)this.compressionEditorPanel, "1,1");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.version")), "0,2");
        this.propertiesPanel.add((Component)this.versionLabel, "1,2");
        this.propertiesPanel.add((Component)this.versionEditorPanel, "1,2");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.encrypted")), "0,3");
        this.propertiesPanel.add((Component)this.encryptedLabel, "1,3");
        this.propertiesPanel.add((Component)this.encryptedCheckBox, "1,3");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.gfx")), "0,4");
        this.propertiesPanel.add((Component)this.gfxLabel, "1,4");
        this.propertiesPanel.add((Component)this.gfxCheckBox, "1,4");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.filesize")), "0,5");
        this.propertiesPanel.add((Component)this.fileSizeLabel, "1,5");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.framerate")), "0,6");
        this.propertiesPanel.add((Component)this.frameRateLabel, "1,6");
        this.propertiesPanel.add((Component)this.frameRateEditorPanel, "1,6");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.framecount")), "0,7");
        this.propertiesPanel.add((Component)this.frameCountLabel, "1,7");
        this.propertiesPanel.add((Component)this.frameCountEditorPanel, "1,7");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.displayrect")), "0,8");
        this.propertiesPanel.add((Component)this.displayRectTwipsLabel, "1,8");
        this.propertiesPanel.add((Component)this.displayRectEditorPanel, "1,8");
        this.propertiesPanel.add((Component)new JLabel(""), "0,9");
        this.propertiesPanel.add((Component)this.displayRectPixelsLabel, "1,9");
        this.propertiesPanel.add((Component)this.warningPanel, "0,10,1,10");
        this.add((Component)this.propertiesPanel, "Center");
        this.editButton.addActionListener(this::editButtonActionPerformed);
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.editButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.saveButton.setEnabled(false);
            this.cancelButton.setVisible(false);
            this.cancelButton.setEnabled(false);
        } else {
            this.editButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.cancelButton.setVisible(false);
        }
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.setBorder(new BevelBorder(0));
        this.buttonsPanel.add(this.editButton);
        this.buttonsPanel.add(this.saveButton);
        this.buttonsPanel.add(this.cancelButton);
        this.add((Component)this.buttonsPanel, "South");
        TableLayoutHelper.addTableSpaces(tl, 10.0);
        this.setEditMode(false);
    }

    private int getVersionNumber() {
        return (Integer)this.versionEditor.getModel().getValue();
    }

    private SWFCompression getCompression() {
        ComboBoxItem item = (ComboBoxItem)this.compressionComboBox.getSelectedItem();
        return (SWFCompression)item.getValue();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(true);
        this.mainPanel.setEditingStatus();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.swf.compression = this.getCompression();
        this.swf.version = this.getVersionNumber();
        this.swf.gfx = this.gfxCheckBox.isSelected();
        this.swf.encrypted = this.encryptedCheckBox.isSelected() && !this.gfxCheckBox.isSelected();
        this.swf.frameRate = ((Number)this.frameRateEditor.getModel().getValue()).floatValue();
        this.swf.frameCount = ((Number)this.frameCountEditor.getModel().getValue()).intValue();
        double multiplier = 1.0;
        if (this.unit == 0) {
            multiplier = 20.0;
        }
        this.swf.displayRect.Xmin = (int)(multiplier * (Double)this.xMinEditor.getModel().getValue());
        this.swf.displayRect.Xmax = (int)(multiplier * (Double)this.xMaxEditor.getModel().getValue());
        this.swf.displayRect.Ymin = (int)(multiplier * (Double)this.yMinEditor.getModel().getValue());
        this.swf.displayRect.Ymax = (int)(multiplier * (Double)this.yMaxEditor.getModel().getValue());
        this.swf.setHeaderModified(true);
        this.load(this.swf);
        this.mainPanel.repaintTree();
        this.setEditMode(false);
        this.mainPanel.clearEditingStatus();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.load(this.swf);
        this.setEditMode(false);
        this.mainPanel.clearEditingStatus();
    }

    public void load(SWF swf) {
        this.swf = swf;
        this.signatureLabel.setText(new String(swf.getHeaderBytes()));
        switch (swf.compression) {
            case LZMA: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.lzma"));
                this.compressionComboBox.setSelectedIndex(2);
                break;
            }
            case ZLIB: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.zlib"));
                this.compressionComboBox.setSelectedIndex(1);
                break;
            }
            case NONE: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.none"));
                this.compressionComboBox.setSelectedIndex(0);
            }
        }
        this.versionLabel.setText(Integer.toString(swf.version));
        this.versionEditor.setModel(new SpinnerNumberModel(swf.version, 1, 64, 1));
        this.encryptedLabel.setText(swf.encrypted ? AppStrings.translate("yes") : AppStrings.translate("no"));
        this.encryptedCheckBox.setSelected(swf.encrypted);
        this.gfxLabel.setText(swf.gfx ? AppStrings.translate("yes") : AppStrings.translate("no"));
        this.gfxCheckBox.setSelected(swf.gfx);
        this.fileSizeLabel.setText(Long.toString(swf.fileSize));
        this.frameRateLabel.setText(Float.toString(swf.frameRate));
        this.frameRateEditor.setModel(new SpinnerNumberModel(swf.frameRate, -2.147483648E9, 2.147483647E9, 1.0));
        this.frameCountLabel.setText("" + swf.frameCount);
        this.frameCountEditor.setModel(new SpinnerNumberModel(swf.frameCount, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.displayRectTwipsLabel.setText(AppStrings.translate("header.displayrect.value.twips").replace("%xmin%", Integer.toString(swf.displayRect.Xmin)).replace("%ymin%", Integer.toString(swf.displayRect.Ymin)).replace("%xmax%", Integer.toString(swf.displayRect.Xmax)).replace("%ymax%", Integer.toString(swf.displayRect.Ymax)));
        this.displayRectPixelsLabel.setText(AppStrings.translate("header.displayrect.value.pixels").replace("%xmin%", this.fmtDouble((double)swf.displayRect.Xmin / 20.0)).replace("%ymin%", this.fmtDouble((double)swf.displayRect.Ymin / 20.0)).replace("%xmax%", this.fmtDouble((double)swf.displayRect.Xmax / 20.0)).replace("%ymax%", this.fmtDouble((double)swf.displayRect.Ymax / 20.0)));
        double multiplier = 1.0;
        if (this.unit == 0) {
            multiplier = 0.05;
        }
        this.xMinEditor.setModel(new SpinnerNumberModel((double)swf.displayRect.Xmin * multiplier, -2.147483648E9, 2.147483647E9, 1.0));
        this.xMaxEditor.setModel(new SpinnerNumberModel((double)swf.displayRect.Xmax * multiplier, -2.147483648E9, 2.147483647E9, 1.0));
        this.yMinEditor.setModel(new SpinnerNumberModel((double)swf.displayRect.Ymin * multiplier, -2.147483648E9, 2.147483647E9, 1.0));
        this.yMaxEditor.setModel(new SpinnerNumberModel((double)swf.displayRect.Ymax * multiplier, -2.147483648E9, 2.147483647E9, 1.0));
        this.compressionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HeaderInfoPanel.this.setModified();
            }
        });
        this.versionEditor.addChangeListener(e -> this.setModified());
        this.encryptedCheckBox.addChangeListener(e -> this.setModified());
        this.gfxCheckBox.addChangeListener(e -> this.setModified());
        this.frameRateEditor.addChangeListener(e -> this.setModified());
        this.xMinEditor.addChangeListener(e -> this.setModified());
        this.xMaxEditor.addChangeListener(e -> this.setModified());
        this.yMinEditor.addChangeListener(e -> this.setModified());
        this.yMaxEditor.addChangeListener(e -> this.setModified());
        this.setEditMode((Boolean)Configuration.editorMode.get());
    }

    private void setModified() {
        this.saveButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.mainPanel.setEditingStatus();
    }

    public void clear() {
        this.swf = null;
    }

    private String fmtDouble(double d) {
        String r = Double.toString(d);
        if (r.endsWith(".0")) {
            r = r.substring(0, r.length() - 2);
        }
        return r;
    }

    private void setEditMode(boolean edit) {
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            edit = true;
        }
        this.compressionLabel.setVisible(!edit);
        this.compressionEditorPanel.setVisible(edit);
        this.versionLabel.setVisible(!edit);
        this.versionEditorPanel.setVisible(edit);
        this.encryptedLabel.setVisible(!edit);
        this.encryptedCheckBox.setVisible(edit);
        this.gfxLabel.setVisible(!edit);
        this.gfxCheckBox.setVisible(edit);
        this.frameRateLabel.setVisible(!edit);
        this.frameRateEditorPanel.setVisible(edit);
        this.frameCountLabel.setVisible(!edit);
        this.frameCountEditorPanel.setVisible(edit);
        this.displayRectTwipsLabel.setVisible(!edit);
        this.displayRectPixelsLabel.setVisible(!edit);
        this.displayRectEditorPanel.setVisible(edit);
        this.warningPanel.setVisible(false);
        if (((Boolean)Configuration.editorMode.get()).booleanValue()) {
            this.editButton.setVisible(false);
            this.saveButton.setVisible(true);
            this.saveButton.setEnabled(false);
            this.cancelButton.setVisible(true);
            this.cancelButton.setEnabled(false);
        } else {
            this.editButton.setVisible(!edit);
            this.saveButton.setVisible(edit);
            this.cancelButton.setVisible(edit);
        }
    }

    private boolean validateHeader() {
        int version = this.getVersionNumber();
        boolean gfx = this.gfxCheckBox.isSelected();
        boolean encrypted = this.encryptedCheckBox.isSelected();
        SWFCompression compression = this.getCompression();
        String resultStr = "";
        boolean result = true;
        if (gfx && compression != SWFCompression.NONE && compression != SWFCompression.ZLIB) {
            resultStr = resultStr + AppStrings.translate("header.warning.unsupportedGfxCompression") + " ";
            result = false;
        }
        if (gfx && encrypted) {
            resultStr = resultStr + AppStrings.translate("header.warning.unsupportedGfxEncryption") + " ";
            result = false;
        }
        if (compression == SWFCompression.ZLIB && version < 6) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumZlibVersion") + " ";
            result = false;
        }
        if (compression == SWFCompression.LZMA && version < 13) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumLzmaVersion") + " ";
            result = false;
        }
        this.warningPanel.setVisible(!result);
        if (!result) {
            this.warningLabel.setText(resultStr);
        }
        return result;
    }

    @Override
    public boolean tryAutoSave() {
        if (this.saveButton.isVisible() && this.saveButton.isEnabled() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveButtonActionPerformed(null);
        }
        return !this.saveButton.isVisible() || !this.saveButton.isEnabled();
    }

    @Override
    public boolean isEditing() {
        return this.saveButton.isVisible() && this.saveButton.isEnabled();
    }

    public void startEdit() {
        if (!this.editButton.isVisible()) {
            return;
        }
        this.editButtonActionPerformed(null);
    }
}

