/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;

public class PinButton
extends JPanel {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private boolean pinned;
    private boolean mouseOverPin = false;
    private boolean mouseOver = false;
    private JLabel button;
    private TreeItem item;
    private boolean selected;
    private Color color;
    private Color hilightedColor;
    private Color hilightedTextColor;
    private Color selectedColor;
    private Color selectedTextColor;
    private Color borderColor;
    private Color textColor;
    private JLabel label;
    private MainPanel mainPanel;

    public PinButton(final MainPanel mainPanel, final TreeItem item, boolean pinned) {
        this.mainPanel = mainPanel;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.item = item;
        this.pinned = pinned;
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceSkin skin = SubstanceLookAndFeel.getCurrentSkin();
            this.color = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
            this.hilightedColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
            this.borderColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED).getUltraDarkColor();
            this.textColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getForegroundColor();
            this.hilightedTextColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getForegroundColor();
        } else {
            this.color = SystemColor.control;
            this.hilightedColor = SystemColor.textHighlight;
            this.borderColor = SystemColor.controlShadow;
            this.textColor = SystemColor.controlText;
            this.hilightedTextColor = SystemColor.textHighlightText;
        }
        Color color2 = Color.white;
        this.selectedColor = new Color((this.color.getRed() + color2.getRed()) / 2, (this.color.getGreen() + color2.getGreen()) / 2, (this.color.getBlue() + color2.getBlue()) / 2);
        Color color3 = Color.black;
        this.selectedTextColor = new Color((this.textColor.getRed() + color3.getRed()) / 2, (this.textColor.getGreen() + color3.getGreen()) / 2, (this.textColor.getBlue() + color3.getBlue()) / 2);
        this.label = new JLabel();
        this.label.setIcon(AbstractTagTree.getIconFor(item));
        this.refresh();
        this.button = new JLabel();
        this.button.setMinimumSize(new Dimension(26, 16));
        this.button.setPreferredSize(new Dimension(26, 16));
        MouseAdapter adapter = new MouseAdapter(this){
            final /* synthetic */ PinButton this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (mainPanel.checkEdited()) {
                        return;
                    }
                    ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
                    itemList.add(item);
                    mainPanel.getContextPopupMenu().update(itemList, false);
                    mainPanel.getContextPopupMenu().show(this.this$0, 0, this.this$0.getHeight());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.this$0.fireAction();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.this$0.mouseOver = false;
                this.this$0.updateIcon();
                if (this.this$0.selected) {
                    this.this$0.setBackground(this.this$0.selectedColor);
                    this.this$0.label.setForeground(this.this$0.selectedTextColor);
                } else {
                    this.this$0.setBackground(this.this$0.color);
                    this.this$0.label.setForeground(this.this$0.textColor);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.this$0.mouseOver = true;
                if (this.this$0.selected) {
                    this.this$0.setBackground(this.this$0.selectedColor);
                    this.this$0.label.setForeground(this.this$0.selectedTextColor);
                } else {
                    this.this$0.setBackground(this.this$0.hilightedColor);
                    this.this$0.label.setForeground(this.this$0.hilightedTextColor);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.this$0.mouseOver = true;
                this.this$0.updateIcon();
            }
        };
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.label.addMouseListener(adapter);
        this.label.addMouseMotionListener(adapter);
        this.button.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.button.setCursor(Cursor.getPredefinedCursor(12));
        if (pinned) {
            this.button.setIcon(View.getIcon("pinned16"));
            this.button.setToolTipText(AppStrings.translate("unpin"));
        } else {
            this.button.setToolTipText(AppStrings.translate("pin"));
        }
        MouseAdapter buttonAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PinButton.this.mouseOverPin = true;
                PinButton.this.mouseOver = true;
                if (PinButton.this.selected) {
                    PinButton.this.setBackground(PinButton.this.selectedColor);
                    PinButton.this.label.setForeground(PinButton.this.selectedTextColor);
                } else {
                    PinButton.this.setBackground(PinButton.this.hilightedColor);
                    PinButton.this.label.setForeground(PinButton.this.hilightedTextColor);
                }
                PinButton.this.updateIcon();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PinButton.this.mouseOverPin = false;
                PinButton.this.mouseOver = false;
                if (PinButton.this.selected) {
                    PinButton.this.setBackground(PinButton.this.selectedColor);
                    PinButton.this.label.setForeground(PinButton.this.selectedTextColor);
                } else {
                    PinButton.this.setBackground(PinButton.this.color);
                    PinButton.this.label.setForeground(PinButton.this.textColor);
                }
                PinButton.this.updateIcon();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    PinButton.this.pinned = !PinButton.this.pinned;
                    if (PinButton.this.pinned) {
                        PinButton.this.button.setToolTipText(AppStrings.translate("unpin"));
                    } else {
                        PinButton.this.button.setToolTipText(AppStrings.translate("pin"));
                    }
                    PinButton.this.updateIcon();
                    PinButton.this.fireChange();
                }
            }
        };
        this.button.addMouseListener(buttonAdapter);
        this.button.addMouseMotionListener(buttonAdapter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
    }

    private void updateIcon() {
        if (this.pinned) {
            this.button.setIcon(View.getIcon("pinned16"));
        } else if (this.mouseOverPin) {
            this.button.setIcon(View.getIcon(this.pinned ? "pinned16" : "pin16"));
        } else if (this.mouseOver) {
            this.button.setIcon(View.getIcon(this.pinned ? "pinned16" : "canpin16"));
        } else {
            this.button.setIcon(null);
        }
    }

    private void fireAction() {
        ActionEvent ev = new ActionEvent(this, 0, "");
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(ev);
        }
    }

    private void fireChange() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(ev);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public TreeItem getItem() {
        return this.item;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBackground(this.selectedColor);
            this.label.setForeground(this.selectedTextColor);
        } else if (!this.mouseOver) {
            this.setBackground(this.color);
            this.label.setForeground(this.textColor);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.borderColor);
        g.drawLine(0, 0, this.getWidth() - 1, 0);
        g.drawLine(0, 0, 0, this.getHeight() - 1);
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        if (this.selected) {
            g.setColor(this.hilightedColor);
            g.drawLine(0, 0, this.getWidth() - 1, 0);
            g.drawLine(0, 1, this.getWidth() - 1, 1);
            g.drawLine(0, 2, this.getWidth() - 1, 2);
        }
    }

    private String getTreeItemPath(TreeItem item) {
        TreePath path = this.mainPanel.getCurrentTree().getFullModel().getTreePath(item);
        if (path == null) {
            return "";
        }
        StringBuilder pathString = new StringBuilder();
        for (int i = 1; i < path.getPathCount(); ++i) {
            if (pathString.length() > 0) {
                pathString.append(" / ");
            }
            pathString.append(this.mainPanel.itemToString((TreeItem)path.getPathComponent(i)));
        }
        return pathString.toString();
    }

    public void refresh() {
        this.label.setText(this.mainPanel.itemToString(this.item));
        this.label.setToolTipText(this.getTreeItemPath(this.item));
    }
}

