/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class PopupButton
extends JToggleButton {
    private boolean insideButton = false;
    private PopupMenuListener popupListener;
    private JPopupMenu popupMenu;

    public PopupButton(Icon icon) {
        super(icon);
        this.initListeners();
    }

    public PopupButton(String text) {
        super(text);
        this.initListeners();
    }

    public PopupButton(String text, Icon icon) {
        super(text, icon);
        this.initListeners();
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PopupButton.this.insideButton = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PopupButton.this.insideButton = false;
            }
        });
        this.addActionListener(this::popupOpenActionPerformed);
        this.popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (!PopupButton.this.insideButton) {
                    PopupButton.this.setSelected(false);
                }
                if (PopupButton.this.popupMenu != null) {
                    PopupButton.this.popupMenu.removePopupMenuListener(PopupButton.this.popupListener);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    protected abstract JPopupMenu getPopupMenu();

    private void popupOpenActionPerformed(ActionEvent evt) {
        if (!this.isSelected()) {
            return;
        }
        this.popupMenu = this.getPopupMenu();
        this.popupMenu.addPopupMenuListener(this.popupListener);
        JToggleButton sourceButton = (JToggleButton)evt.getSource();
        this.popupMenu.show(sourceButton, 0, sourceButton.getHeight());
    }
}

