/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.WrapLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.DocumentSearchData;
import jsyntaxpane.components.Markers;

public class QuickFindPanel
extends JPanel {
    public JTextField findTextField;
    public JButton prevButton;
    public JButton nextButton;
    public JCheckBox ignoreCaseCheckbox;
    public JCheckBox regExpCheckbox;
    public JCheckBox wrapCheckbox;
    public JLabel statusLabel;
    private final Markers.SimpleMarker marker = new Markers.SimpleMarker(Color.pink);
    private WeakReference<JTextComponent> target;
    private WeakReference<DocumentSearchData> dsd;
    private int oldCaretPosition;

    public QuickFindPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createBevelBorder(0));
        JPanel pan1 = new JPanel(new WrapLayout());
        JPanel pan2 = new JPanel(new WrapLayout());
        pan1.setAlignmentX(0.0f);
        pan2.setAlignmentX(0.0f);
        pan1.setAlignmentY(0.0f);
        pan2.setAlignmentY(0.0f);
        JLabel jLabel1 = new JLabel();
        this.findTextField = new JTextField();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.ignoreCaseCheckbox = new JCheckBox();
        this.regExpCheckbox = new JCheckBox();
        this.wrapCheckbox = new JCheckBox();
        this.statusLabel = new JLabel();
        this.setName("QuickFindDialog");
        jLabel1.setLabelFor(this.findTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        jLabel1.setText(bundle.getString("QuickFindDialog.jLabel1.text"));
        pan1.add(jLabel1);
        this.findTextField.setColumns(30);
        this.findTextField.setBorder(BorderFactory.createLineBorder(Color.black));
        this.findTextField.setMaximumSize(new Dimension(200, 24));
        this.findTextField.setMinimumSize(new Dimension(60, 24));
        pan1.add(this.findTextField);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-up.png")));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setOpaque(false);
        this.prevButton.setVerticalTextPosition(3);
        this.prevButton.addActionListener(this::previousButtonActionPerformed);
        pan1.add(this.prevButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-down.png")));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.setOpaque(false);
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.addActionListener(this::nextButtonActionPerformed);
        pan1.add(this.nextButton);
        this.ignoreCaseCheckbox.setMnemonic('C');
        this.ignoreCaseCheckbox.setText(bundle.getString("QuickFindDialog.jChkIgnoreCase.text"));
        this.ignoreCaseCheckbox.setFocusable(false);
        this.ignoreCaseCheckbox.setOpaque(false);
        this.ignoreCaseCheckbox.setVerticalTextPosition(3);
        pan2.add(this.ignoreCaseCheckbox);
        this.regExpCheckbox.setMnemonic('R');
        this.regExpCheckbox.setText(bundle.getString("QuickFindDialog.jChkRegExp.text"));
        this.regExpCheckbox.setFocusable(false);
        this.regExpCheckbox.setOpaque(false);
        this.regExpCheckbox.setVerticalTextPosition(3);
        pan2.add(this.regExpCheckbox);
        this.wrapCheckbox.setMnemonic('W');
        this.wrapCheckbox.setText(bundle.getString("QuickFindDialog.jChkWrap.text"));
        this.wrapCheckbox.setFocusable(false);
        this.wrapCheckbox.setOpaque(false);
        this.wrapCheckbox.setVerticalTextPosition(3);
        pan2.add(this.wrapCheckbox);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(this.statusLabel.getFont().getStyle() | 1, this.statusLabel.getFont().getSize() - 2));
        this.statusLabel.setForeground(Color.red);
        pan2.add(this.statusLabel);
        this.add(pan1);
        this.add(pan2);
        this.setPreferredSize(this.getMinimumSize());
        this.setVisible(false);
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (((DocumentSearchData)this.dsd.get()).doFindPrev((JTextComponent)this.target.get())) {
            this.statusLabel.setText(null);
        } else {
            this.statusLabel.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (((DocumentSearchData)this.dsd.get()).doFindNext((JTextComponent)this.target.get())) {
            this.statusLabel.setText(null);
        } else {
            this.statusLabel.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
        }
    }

    public void showQuickFind(JTextComponent t, DocumentSearchData ds) {
        this.dsd = new WeakReference<DocumentSearchData>(ds);
        this.oldCaretPosition = t.getCaretPosition();
        Container view = t.getParent();
        Dimension wd = this.getSize();
        wd.width = t.getVisibleRect().width;
        Point loc = new Point(0, view.getHeight());
        this.setSize(wd);
        SwingUtilities.convertPointToScreen(loc, view);
        this.setLocation(loc);
        this.findTextField.setFont(t.getFont());
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateFind();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateFind();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateFind();
            }

            private void updateFind() {
                JTextComponent t = (JTextComponent)QuickFindPanel.this.target.get();
                DocumentSearchData d = (DocumentSearchData)QuickFindPanel.this.dsd.get();
                String toFind = QuickFindPanel.this.findTextField.getText();
                if (toFind == null || toFind.isEmpty()) {
                    QuickFindPanel.this.statusLabel.setText(null);
                    return;
                }
                try {
                    d.setWrap(QuickFindPanel.this.wrapCheckbox.isSelected());
                    d.setPattern(toFind, QuickFindPanel.this.regExpCheckbox.isSelected(), QuickFindPanel.this.ignoreCaseCheckbox.isSelected());
                    QuickFindPanel.this.statusLabel.setText(null);
                    t.setCaretPosition(QuickFindPanel.this.oldCaretPosition);
                    if (!d.doFindNext(t)) {
                        QuickFindPanel.this.statusLabel.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("QuickFindDialog.NotFound"));
                    } else {
                        QuickFindPanel.this.statusLabel.setText(null);
                    }
                }
                catch (PatternSyntaxException e) {
                    QuickFindPanel.this.statusLabel.setText(e.getDescription());
                }
            }
        };
        this.findTextField.getDocument().addDocumentListener(dl);
        this.target = new WeakReference<JTextComponent>(t);
        Pattern p = ((DocumentSearchData)this.dsd.get()).getPattern();
        if (p != null) {
            this.findTextField.setText(p.pattern());
        }
        this.wrapCheckbox.setSelected(((DocumentSearchData)this.dsd.get()).isWrap());
        this.setVisible(true);
        this.getParent().revalidate();
        this.getParent().repaint();
        this.findTextField.requestFocusInWindow();
    }
}

