/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.MyTextField;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends AppDialog {
    public JTextField searchField = new MyTextField();
    public JTextField replaceField = new MyTextField();
    public JCheckBox ignoreCaseCheckBox = new JCheckBox(this.translate("checkbox.ignorecase"));
    public JCheckBox regexpCheckBox = new JCheckBox(this.translate("checkbox.regexp"));
    public JCheckBox replaceInParametersCheckBox = new JCheckBox(this.translate("checkbox.replaceInParameters"));
    public JRadioButton searchInASRadioButton = new JRadioButton(this.translate("checkbox.searchAS"));
    public JRadioButton searchInPCodeRadioButton = new JRadioButton(this.translate("checkbox.searchPCode"));
    public JRadioButton searchInTextsRadioButton = new JRadioButton(this.translate("checkbox.searchText"));
    private JComboBox<String> scopeComboBox;
    private int result = -1;
    public static final int SCOPE_SELECTION = 0;
    public static final int SCOPE_CURRENT_FILE = 1;
    public static final int SCOPE_ALL_FILES = 2;

    public int getCurrentScope() {
        int index = this.scopeComboBox.getSelectedIndex();
        if (this.scopeComboBox.getModel().getSize() == 3) {
            return index;
        }
        return 1 + index;
    }

    public SearchDialog(Window owner, boolean replace, String selection, boolean selectionFirst, boolean currentAbc) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.ignoreCaseCheckBox.setSelected(true);
        Container cnt = this.getContentPane();
        this.setSize(400, 150);
        cnt.setLayout(new BoxLayout(cnt, 3));
        JPanel panButtons = new JPanel(new FlowLayout());
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(okButton);
        panButtons.add(cancelButton);
        JPanel panField = new JPanel(new FlowLayout());
        this.searchField.setPreferredSize(new Dimension(250, this.searchField.getPreferredSize().height));
        panField.add(new JLabel(this.translate("label.searchtext")));
        panField.add(this.searchField);
        cnt.add(panField);
        if (replace) {
            panField = new JPanel(new FlowLayout());
            this.replaceField.setPreferredSize(new Dimension(250, this.replaceField.getPreferredSize().height));
            panField.add(new JLabel(this.translate("label.replacementtext")));
            panField.add(this.replaceField);
            cnt.add(panField);
        }
        panField = new JPanel(new FlowLayout());
        ArrayList<String> scopeItems = new ArrayList<String>();
        if (selection != null) {
            scopeItems.add(this.translate("scope.selection").replace("%selection%", selection));
        }
        scopeItems.add(this.translate(currentAbc ? "scope.currentFile.abc" : "scope.currentFile"));
        scopeItems.add(this.translate("scope.allFiles"));
        panField.add(new JLabel(this.translate("label.scope")));
        this.scopeComboBox = new JComboBox<String>(scopeItems.toArray(new String[scopeItems.size()]));
        panField.add(this.scopeComboBox);
        if (selection != null && !selectionFirst) {
            this.scopeComboBox.setSelectedIndex(1);
        }
        cnt.add(panField);
        JPanel checkPanel = new JPanel(new FlowLayout());
        checkPanel.add(this.ignoreCaseCheckBox);
        checkPanel.add(this.regexpCheckBox);
        if (replace) {
            checkPanel.add(this.replaceInParametersCheckBox);
        }
        cnt.add(checkPanel);
        if (!replace) {
            ButtonGroup group = new ButtonGroup();
            group.add(this.searchInASRadioButton);
            group.add(this.searchInPCodeRadioButton);
            group.add(this.searchInTextsRadioButton);
            JPanel rbPanel = new JPanel(new FlowLayout());
            this.searchInASRadioButton.setSelected(true);
            this.searchInPCodeRadioButton.setSelected(false);
            this.searchInTextsRadioButton.setSelected(false);
            rbPanel.add(this.searchInASRadioButton);
            rbPanel.add(this.searchInPCodeRadioButton);
            rbPanel.add(this.searchInTextsRadioButton);
            cnt.add(rbPanel);
        }
        cnt.add(panButtons);
        this.getRootPane().setDefaultButton(okButton);
        View.centerScreen(this);
        this.setIconImage(View.loadImage(replace ? "replace16" : "search16"));
        this.setTitle(replace ? this.translate("dialog.title.replace") : this.translate("dialog.title"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage(replace ? "replace16" : "search16"));
        images.add(View.loadImage(replace ? "replace32" : "search32"));
        this.setIconImages(images);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
            this.searchField.requestFocusInWindow();
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        if (this.regexpCheckBox.isSelected()) {
            try {
                Pattern pattern = Pattern.compile(this.searchField.getText());
            }
            catch (PatternSyntaxException ex) {
                ViewMessages.showMessageDialog(this, this.translate("error.invalidregexp"), this.translate("error"), 0);
                return;
            }
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

