/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Language;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jsyntaxpane.DefaultSyntaxKit;

public class SelectLanguageDialog
extends AppDialog {
    private final JComboBox<Language> languageCombobox = new JComboBox();
    public String languageCode = null;
    protected static final String[] languages = new String[]{"en", "ca", "cs", "zh", "de", "es", "fr", "hu", "it", "ja", "nl", "pl", "pt", "pt-BR", "ru", "sv", "tr", "uk"};

    public SelectLanguageDialog(Window owner) {
        super(owner);
        this.setSize(350, 130);
        Container cnt1 = this.getContentPane();
        JPanel cnt = new JPanel();
        cnt1.setLayout(new BorderLayout());
        cnt1.add((Component)cnt, "Center");
        String currentLanguage = (String)Configuration.locale.get((Object)Locale.getDefault().getLanguage());
        boolean found = false;
        int enIndex = 0;
        for (String code : languages) {
            String name = ResourceBundle.getBundle(AppStrings.getResourcePath(this.getClass()), Locale.forLanguageTag(code.equals("en") ? "" : code)).getString("language");
            if (name.length() > 1) {
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            if (code.equals("en")) {
                enIndex = this.languageCombobox.getItemCount();
            }
            this.languageCombobox.addItem(new Language(code, name));
            if (!code.equals(currentLanguage)) continue;
            this.languageCombobox.setSelectedIndex(this.languageCombobox.getItemCount() - 1);
            found = true;
        }
        if (!found) {
            this.languageCombobox.setSelectedIndex(enIndex);
        }
        cnt.setBorder(new EmptyBorder(10, 10, 10, 10));
        cnt.setLayout(new BoxLayout(cnt, 1));
        JLabel langLabel = new JLabel(this.translate("language.label"));
        langLabel.setAlignmentX(0.5f);
        cnt.add(langLabel);
        this.languageCombobox.setAlignmentX(0.5f);
        cnt.add(this.languageCombobox);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.setAlignmentX(0.5f);
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.add(buttonsPanel);
        this.getRootPane().setDefaultButton(okButton);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        View.setWindowIcon(this);
        View.centerScreen(this);
        this.setTitle(this.translate("dialog.title"));
        this.pack();
        if (this.getWidth() < 350) {
            this.setSize(350, this.getHeight());
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.languageCombobox.getSelectedIndex() != -1) {
            this.languageCode = ((Language)this.languageCombobox.getSelectedItem()).code;
            String newLanguage = this.languageCode;
            if (newLanguage.equals("en")) {
                newLanguage = "";
            }
            Configuration.locale.set((Object)newLanguage);
            SelectLanguageDialog.reloadUi();
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void reloadUi() {
        Locale.setDefault(Locale.forLanguageTag((String)Configuration.locale.get()));
        DefaultSyntaxKit.reloadConfigs();
        Main.initLang();
        Main.reloadApp();
    }

    public static String[] getAvailableLanguages() {
        return languages;
    }

    public String display() {
        this.setVisible(true);
        return this.languageCode;
    }
}

