/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class TagInfoPanel
extends JPanel {
    private final MainPanel mainPanel;
    private final JEditorPane editorPane = new JEditorPane();
    private TagInfo tagInfo = new TagInfo(null);

    public TagInfoPanel(final MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)new FasterScrollPane(this.editorPane), "Center");
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        HyperlinkListener listener = new HyperlinkListener(){
            final /* synthetic */ TagInfoPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperLink) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperLink.getEventType())) {
                    URI url;
                    try {
                        url = new URI(hyperLink.getDescription());
                    }
                    catch (Exception ex) {
                        return;
                    }
                    String scheme = url.getScheme();
                    String strId = url.getHost();
                    Integer id = "expand".equals(scheme) ? null : Integer.valueOf(Integer.parseInt(strId));
                    SWF swf = mainPanel.getCurrentSwf();
                    CharacterTag item = null;
                    if ("expand".equals(scheme)) {
                        if ("all".equals(strId)) {
                            this.this$0.updateHtmlContent(true, false);
                        }
                        if ("details".equals(strId)) {
                            this.this$0.updateHtmlContent(true, true);
                        }
                    } else if ("char".equals(scheme)) {
                        item = swf.getCharacter(id.intValue());
                    } else if ("frame".equals(scheme)) {
                        item = swf.getTimeline().getFrame(id.intValue());
                    }
                    if (item != null) {
                        if (mainPanel.checkEdited()) {
                            return;
                        }
                        mainPanel.setTagTreeSelectedNode(mainPanel.getCurrentTree(), (TreeItem)item);
                    }
                }
            }
        };
        this.editorPane.addHyperlinkListener(listener);
    }

    public void setTagInfos(TagInfo tagInfo) {
        this.tagInfo = tagInfo;
        this.buildHtmlContent();
    }

    public void clear() {
        this.tagInfo = new TagInfo(null);
        this.buildHtmlContent();
    }

    private void updateHtmlContent(boolean expand, boolean showDetails) {
        String categoryName = "general";
        StringBuilder result = new StringBuilder();
        result.append("<html><body><table cellspacing='0' cellpadding='0'>");
        Boolean flipFlop = false;
        ArrayList items = (ArrayList)this.tagInfo.getInfos().get(categoryName);
        if (items == null) {
            items = new ArrayList();
        }
        if (View.isOceanic()) {
            result.append("<tr bgcolor='#FDFDFD'>");
        } else {
            result.append("</tr>");
        }
        result.append(String.format("<td width='50%%' style='text-align:center;'>%s</td>", this.mainPanel.translate("tagInfo.header.name")));
        result.append(String.format("<td width='50%%' style='text-align:center;'>%s</td>", this.mainPanel.translate("tagInfo.header.value")));
        result.append("</tr>");
        SWF swf = this.tagInfo.getSwf();
        for (TagInfo.TagInfoItem item : items) {
            boolean convertToLinkList;
            boolean frameList;
            String name;
            block19: {
                flipFlop = flipFlop == false;
                if (View.isOceanic()) {
                    result.append("<tr bgcolor='").append(flipFlop != false ? "#FDFDFD" : "#F4F4F4").append("'>");
                } else {
                    result.append("<tr>");
                }
                name = item.getName();
                String key = "tagInfo." + name;
                frameList = name.equals("dependentFrames");
                convertToLinkList = name.equals("dependentCharacters") || name.equals("neededCharacters") || frameList;
                try {
                    name = this.mainPanel.translate(key);
                }
                catch (MissingResourceException mes) {
                    if (!((Boolean)Configuration._debugMode.get()).booleanValue()) break block19;
                    Logger.getLogger(TagInfoPanel.class.getName()).log(Level.WARNING, "Resource not found: {0}", key);
                }
            }
            result.append("<td>").append(name).append("</td>");
            StringBuilder valueBuilder = new StringBuilder();
            Object value = item.getValue();
            if (value instanceof Boolean) {
                boolean boolValue = (Boolean)value;
                valueBuilder.append(boolValue ? AppStrings.translate("yes") : AppStrings.translate("no"));
            } else if (convertToLinkList) {
                String[] strIds = ((String)value).split(", ");
                ArrayList<Integer> sortedIds = new ArrayList<Integer>();
                StringBuilder strValue = new StringBuilder();
                for (String strId : strIds) {
                    sortedIds.add(Integer.parseInt(strId));
                }
                Collections.sort(sortedIds);
                String scheme = frameList ? "frame" : "char";
                Iterator iterator = sortedIds.iterator();
                while (iterator.hasNext()) {
                    int displayId;
                    int id = (Integer)iterator.next();
                    int n = displayId = frameList ? id + 1 : id;
                    if (!frameList && expand) {
                        String charName;
                        CharacterTag character;
                        CharacterTag characterTag = character = swf == null ? null : swf.getCharacter(id);
                        if (showDetails) {
                            charName = swf == null || character == null ? "???" : Helper.escapeHTML((String)character.toString());
                            strValue.append(String.format("<a href='%s://%d'>%s</a><br>", scheme, id, charName, id));
                            continue;
                        }
                        charName = swf == null || character == null ? "???" : character.getTagName();
                        strValue.append(String.format("<a href='%s://%d'>%s (%d)</a><br>", scheme, id, charName, id));
                        continue;
                    }
                    strValue.append(String.format("<a href='%s://%d'>%d</a>, ", scheme, id, displayId));
                }
                String sVal = strValue.toString();
                valueBuilder.append(sVal.substring(0, sVal.length() - 2));
                if (!frameList && !expand) {
                    valueBuilder.append(" <a href='expand://all'>+</a>");
                } else if (!frameList && expand && !showDetails) {
                    valueBuilder.append("<br><a href='expand://details'>+</a>");
                }
            } else {
                valueBuilder.append(value.toString());
            }
            result.append("<td>").append(valueBuilder.toString()).append("</td>");
            result.append("</tr>");
        }
        result.append("</table></body></html>");
        this.editorPane.setText(result.toString());
    }

    private void buildHtmlContent() {
        this.updateHtmlContent(false, false);
        Font font = UIManager.getFont("Table.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;} table { width:100%;";
        if (View.isOceanic()) {
            bodyRule = bodyRule + "color:#053E6A;padding:1px;}td { border: 1px solid #e4e4e4; }html { border: 1px solid #789AC4; }";
        } else {
            Color bgColor = UIManager.getColor("Table.background");
            int light = (bgColor.getRed() + bgColor.getGreen() + bgColor.getBlue()) / 3;
            boolean nightMode = light <= 128;
            Color linkColor = Color.blue;
            if (nightMode) {
                linkColor = new Color(136, 136, 255);
            }
            bodyRule = bodyRule + "background-color: " + TagInfoPanel.getUIColorToHex("Table.background") + ";color:" + TagInfoPanel.getUIColorToHex("Table.foreground") + ";padding:1px;}td { border: 1px solid " + TagInfoPanel.getUIColorToHex("Table.gridColor") + "; }html { border: 1px solid " + TagInfoPanel.getUIColorToHex("Table.gridColor") + "; }a {color: " + TagInfoPanel.getColorToHex(linkColor) + "}";
        }
        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        this.editorPane.setOpaque(false);
        this.editorPane.setBorder(null);
        this.editorPane.setEditable(false);
    }

    private static String getColorToHex(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    private static String getUIColorToHex(String name) {
        Color c = UIManager.getColor(name);
        return TagInfoPanel.getColorToHex(c);
    }
}

