/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.easygui.DoableOperation;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.SearchPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.controls.JRepeatButton;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;

public class TextPanel
extends JPanel
implements TagEditorPanel {
    private static final Logger logger = Logger.getLogger(TextPanel.class.getName());
    private final MainPanel mainPanel;
    private final SearchPanel<TextTag> textSearchPanel;
    private final LineMarkedEditorPane textValue;
    private final JPanel buttonsPanel;
    private final JButton textEditButton;
    private final JButton textSaveButton;
    private final JButton textCancelButton;
    private final JButton selectPreviousTagButton;
    private final JButton selectNextTagButton;
    private final JButton textAlignLeftButton;
    private final JButton textAlignCenterButton;
    private final JButton textAlignRightButton;
    private final JButton textAlignJustifyButton;
    private final JButton decreaseTranslateXButton;
    private final JButton increaseTranslateXButton;
    private final JButton changeCaseButton;
    private final JButton undoChangesButton;
    private TextTag textTag;
    private final UndoManager undoManager;
    private String oldText = null;

    public TextPanel(MainPanel mainPanel, UndoManager undoManager) {
        super(new BorderLayout());
        this.undoManager = undoManager;
        this.mainPanel = mainPanel;
        this.textSearchPanel = new SearchPanel<TextTag>((LayoutManager)new FlowLayout(), mainPanel);
        this.textSearchPanel.setAlignmentX(0.0f);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(this.textSearchPanel);
        this.textValue = new LineMarkedEditorPane();
        FasterScrollPane sp = new FasterScrollPane(this.textValue);
        sp.setPreferredSize(new Dimension(200, 200));
        this.add((Component)sp, "Center");
        this.textValue.setFont(Configuration.getSourceFont());
        this.textValue.changeContentType("text/swftext");
        this.textValue.addTextChangedListener(this::textChanged);
        JPanel textButtonsPanel = new JPanel();
        textButtonsPanel.setLayout(new FlowLayout(0));
        this.selectPreviousTagButton = this.createButton(null, "arrowup16", "selectPreviousTag", e -> mainPanel.previousTag());
        this.selectNextTagButton = this.createButton(null, "arrowdown16", "selectNextTag", e -> mainPanel.nextTag());
        this.textAlignLeftButton = this.createButton(null, "textalignleft16", "text.align.left", e -> this.textAlign(TextAlign.LEFT));
        this.textAlignCenterButton = this.createButton(null, "textaligncenter16", "text.align.center", e -> this.textAlign(TextAlign.CENTER));
        this.textAlignRightButton = this.createButton(null, "textalignright16", "text.align.right", e -> this.textAlign(TextAlign.RIGHT));
        this.textAlignJustifyButton = this.createButton(null, "textalignjustify16", "text.align.justify", e -> this.textAlign(TextAlign.JUSTIFY));
        this.decreaseTranslateXButton = this.createButton(null, "textunindent16", "text.align.translatex.decrease", e -> this.translateX(-20, ((JRepeatButton)e.getSource()).getRepeatCount()), true);
        this.increaseTranslateXButton = this.createButton(null, "textindent16", "text.align.translatex.increase", e -> this.translateX(20, ((JRepeatButton)e.getSource()).getRepeatCount()), true);
        this.changeCaseButton = this.createButton(null, "textuppercase16", "text.toggleCase", e -> this.changeCase(0));
        this.undoChangesButton = this.createButton(null, "reload16", "text.undo", e -> this.undoChanges());
        textButtonsPanel.add(this.selectPreviousTagButton);
        textButtonsPanel.add(this.selectNextTagButton);
        textButtonsPanel.add(this.textAlignLeftButton);
        textButtonsPanel.add(this.textAlignCenterButton);
        textButtonsPanel.add(this.textAlignRightButton);
        textButtonsPanel.add(this.textAlignJustifyButton);
        textButtonsPanel.add(this.decreaseTranslateXButton);
        textButtonsPanel.add(this.increaseTranslateXButton);
        textButtonsPanel.add(this.changeCaseButton);
        if (undoManager == null) {
            textButtonsPanel.add(this.undoChangesButton);
        }
        textButtonsPanel.setAlignmentX(0.0f);
        topPanel.add(textButtonsPanel);
        this.add((Component)topPanel, "North");
        this.buttonsPanel = new JPanel(new FlowLayout());
        this.textEditButton = this.createButton("button.edit", "edit16", null, e -> this.editText());
        this.textSaveButton = this.createButton("button.save", "save16", null, e -> this.saveText(true));
        this.textCancelButton = this.createButton("button.cancel", "cancel16", null, e -> this.cancelText());
        this.textEditButton.setVisible(false);
        this.textSaveButton.setVisible(false);
        this.textCancelButton.setVisible(false);
        this.buttonsPanel.add(this.textEditButton);
        this.buttonsPanel.add(this.textSaveButton);
        this.buttonsPanel.add(this.textCancelButton);
        this.add((Component)this.buttonsPanel, "South");
    }

    public TextTag getTextTag() {
        return this.textTag;
    }

    private JButton createButton(String textResource, String iconName, String toolTipResource, ActionListener actionListener) {
        return this.createButton(textResource, iconName, toolTipResource, actionListener, false);
    }

    private JButton createButton(String textResource, String iconName, String toolTipResource, ActionListener actionListener, boolean repeat) {
        String text = textResource == null ? "" : this.mainPanel.translate(textResource);
        JButton button = repeat ? new JRepeatButton(text, View.getIcon(iconName)) : new JButton(text, View.getIcon(iconName));
        button.setMargin(new Insets(3, 3, 3, 10));
        button.addActionListener(actionListener);
        if (toolTipResource != null) {
            button.setToolTipText(this.mainPanel.translate(toolTipResource));
        }
        return button;
    }

    public SearchPanel<TextTag> getSearchPanel() {
        return this.textSearchPanel;
    }

    public void refresh() {
        String formattedText;
        if (this.textTag == null) {
            return;
        }
        try {
            formattedText = this.textTag.getFormattedText((boolean)false).text;
        }
        catch (IndexOutOfBoundsException ex) {
            formattedText = "Invalid text tag";
        }
        this.textValue.setText(formattedText);
        this.oldText = formattedText;
    }

    public void setText(TextTag textTag) {
        boolean readOnly;
        this.textTag = textTag;
        this.refresh();
        this.textValue.setCaretPosition(0);
        this.setModified(false);
        this.setEditText(false);
        boolean bl = readOnly = textTag == null ? true : textTag.isReadOnly();
        if (readOnly) {
            this.textValue.setEditable(false);
        }
        this.buttonsPanel.setVisible(!readOnly);
        this.textAlignLeftButton.setVisible(!readOnly);
        this.textAlignCenterButton.setVisible(!readOnly);
        this.textAlignRightButton.setVisible(!readOnly);
        this.textAlignJustifyButton.setVisible(!readOnly);
        this.decreaseTranslateXButton.setVisible(!readOnly);
        this.increaseTranslateXButton.setVisible(!readOnly);
        this.changeCaseButton.setVisible(!readOnly);
        this.undoChangesButton.setVisible(!readOnly);
        this.selectPreviousTagButton.setVisible(this.mainPanel.getCurrentView() == 0);
        this.selectNextTagButton.setVisible(this.mainPanel.getCurrentView() == 0);
        this.updateButtonsVisibility();
    }

    private boolean isModified() {
        return this.textSaveButton.isVisible() && this.textSaveButton.isEnabled();
    }

    private void setModified(boolean value) {
        this.textSaveButton.setEnabled(value);
        this.textCancelButton.setEnabled(value);
    }

    public void focusTextValue() {
        this.textValue.requestFocusInWindow();
        if (this.textTag != null && !this.isModified()) {
            HighlightedText text = this.textTag.getFormattedText(false);
            for (Highlighting highlight : text.getSpecialHighlights()) {
                if (highlight.getProperties().subtype != HighlightSpecialType.TEXT) continue;
                this.textValue.select(highlight.startPos, highlight.startPos + highlight.len);
                break;
            }
        }
    }

    private void changeCase(int caseMode) {
        int selStart = this.textValue.getSelectionStart();
        int selEnd = this.textValue.getSelectionEnd();
        if (selEnd > selStart) {
            String str;
            int end;
            int start;
            int hEnd;
            int hStart;
            StringBuilder selected = new StringBuilder(this.textValue.getSelectedText());
            HighlightedText text = this.textTag.getFormattedText(false);
            boolean allUpper = true;
            for (Highlighting highlight : text.getSpecialHighlights()) {
                if (highlight.getProperties().subtype != HighlightSpecialType.TEXT) continue;
                hStart = highlight.startPos;
                hEnd = highlight.startPos + highlight.len;
                start = Math.max(selStart, hStart);
                if (start >= (end = Math.min(selEnd, hEnd))) continue;
                try {
                    str = this.textValue.getDocument().getText(start, end - start);
                    if (str.equals(str.toUpperCase())) continue;
                    allUpper = false;
                    break;
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            for (Highlighting highlight : text.getSpecialHighlights()) {
                if (highlight.getProperties().subtype != HighlightSpecialType.TEXT) continue;
                hStart = highlight.startPos;
                hEnd = highlight.startPos + highlight.len;
                start = Math.max(selStart, hStart);
                if (start >= (end = Math.min(selEnd, hEnd))) continue;
                try {
                    str = this.textValue.getDocument().getText(start, end - start);
                    str = allUpper ? str.toLowerCase() : str.toUpperCase();
                    selected.replace(start - selStart, end - selStart, str);
                }
                catch (BadLocationException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            boolean editable = this.textValue.isEditable();
            this.textValue.setEditable(true);
            this.textValue.replaceSelection(selected.toString());
            this.textValue.setEditable(editable);
            if (!editable) {
                this.saveText(true);
                this.updateButtonsVisibility();
            }
            this.textTag.getSwf().clearImageCache();
            this.mainPanel.repaintTree();
            this.textValue.requestFocusInWindow();
            this.textValue.select(selStart, selEnd);
        }
    }

    public void closeTag() {
        this.textTag = null;
    }

    private void setEditText(boolean edit) {
        this.textValue.setEditable((Boolean)Configuration.editorMode.get() != false || edit);
        this.updateButtonsVisibility();
    }

    private void updateButtonsVisibility() {
        boolean edit = this.textValue.isEditable();
        boolean editorMode = (Boolean)Configuration.editorMode.get();
        this.textEditButton.setVisible(!edit);
        this.textSaveButton.setVisible(edit);
        boolean modified = this.isModified();
        this.textCancelButton.setVisible(edit);
        this.textCancelButton.setEnabled(modified || !editorMode);
        this.changeCaseButton.setEnabled(!modified);
        boolean alignable = false;
        if (this.textTag != null && !(this.textTag instanceof DefineEditTextTag)) {
            alignable = !edit || editorMode && !modified;
        }
        this.textAlignLeftButton.setVisible(alignable);
        this.textAlignCenterButton.setVisible(alignable);
        this.textAlignRightButton.setVisible(alignable);
        this.textAlignJustifyButton.setVisible(alignable);
        this.increaseTranslateXButton.setVisible(alignable);
        this.decreaseTranslateXButton.setVisible(alignable);
        this.undoChangesButton.setVisible(this.textTag != null && this.textTag.isModified());
    }

    public void updateSearchPos() {
        this.textValue.setCaretPosition(0);
        this.textSearchPanel.showQuickFindDialog(this.textValue);
    }

    private void editText() {
        this.setEditText(true);
        this.showTextComparingPreview();
        this.mainPanel.setEditingStatus();
    }

    private void cancelText() {
        this.setEditText(false);
        this.refresh();
        this.mainPanel.reload(true);
        this.mainPanel.clearEditingStatus();
    }

    private void saveText(boolean refresh) {
        if (this.mainPanel.saveText(this.textTag, this.textValue.getText(), null, this.textValue, this.undoManager)) {
            this.setEditText(false);
            this.setModified(false);
            this.textTag.getSwf().clearImageCache();
            if (refresh) {
                this.mainPanel.repaintTree();
            }
            this.mainPanel.clearEditingStatus();
        }
    }

    private void textAlign(final TextAlign textAlign) {
        if (this.undoManager != null) {
            final String prevText = this.textTag.getFormattedText((boolean)false).text;
            this.undoManager.doOperation(new DoableOperation(){
                final /* synthetic */ TextPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void doOperation() {
                    this.this$0.textAlignInternal(textAlign);
                }

                @Override
                public void undoOperation() {
                    try {
                        this.this$0.textTag.setFormattedText(null, prevText, null);
                    }
                    catch (TextParseException textParseException) {
                        // empty catch block
                    }
                }

                @Override
                public String getDescription() {
                    return EasyStrings.translate("action.change").replace("%item%", EasyStrings.translate("action.change.text"));
                }
            }, this.textTag.getSwf());
            return;
        }
        this.textAlignInternal(textAlign);
    }

    private void textAlignInternal(TextAlign textAlign) {
        if (this.textTag.alignText(textAlign)) {
            this.updateButtonsVisibility();
            this.refresh();
            this.textTag.getSwf().clearImageCache();
            this.mainPanel.repaintTree();
        }
    }

    private void translateX(final int delta, final int repeatCount) {
        if (this.undoManager != null) {
            this.undoManager.doOperation(new DoableOperation(){
                final /* synthetic */ TextPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void doOperation() {
                    this.this$0.translateXInternal(delta, repeatCount);
                }

                @Override
                public void undoOperation() {
                    this.this$0.translateXInternal(-delta, repeatCount);
                }

                @Override
                public String getDescription() {
                    return EasyStrings.translate("action.change").replace("%item%", EasyStrings.translate("action.change.text"));
                }
            }, this.textTag.getSwf());
            return;
        }
        this.translateXInternal(delta, repeatCount);
    }

    private void translateXInternal(int delta, int repeatCount) {
        if (this.textTag.translateText(delta * (repeatCount + 1))) {
            this.updateButtonsVisibility();
            this.refresh();
            this.textTag.getSwf().clearImageCache();
            this.mainPanel.repaintTree();
        }
    }

    private void undoChanges() {
        try {
            this.textTag.undo();
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.textTag.getSwf().clearImageCache();
        this.mainPanel.repaintTree();
    }

    private void textChanged() {
        this.setModified(true);
        this.showTextComparingPreview();
    }

    private void showTextComparingPreview() {
        if (!((Boolean)Configuration.showOldTextDuringTextEditing.get()).booleanValue()) {
            return;
        }
        if (this.textValue.isEditable()) {
            boolean ok = false;
            try {
                TextTag copyTextTag = (TextTag)this.textTag.cloneTag();
                if (copyTextTag.setFormattedText(new MissingCharacterHandler(){

                    public boolean handle(TextTag textTag, FontTag font, char character) {
                        return false;
                    }
                }, this.textValue.getText(), null)) {
                    ok = true;
                    this.mainPanel.showTextTagWithNewValue(this.textTag, copyTextTag);
                }
            }
            catch (TextParseException | IOException | InterruptedException throwable) {
                // empty catch block
            }
            if (!ok) {
                this.mainPanel.showTextTagWithNewValue(this.textTag, null);
            }
        }
    }

    @Override
    public boolean tryAutoSave() {
        if (this.isModified() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            try {
                this.saveText(false);
                this.updateButtonsVisibility();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Cannot auto-save text tag.", ex);
            }
        }
        return !this.isModified();
    }

    @Override
    public boolean isEditing() {
        return this.textSaveButton.isVisible() && this.textSaveButton.isEnabled();
    }

    public void startEdit() {
        if (!this.textEditButton.isVisible()) {
            return;
        }
        this.editText();
    }
}

