/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.MyCommandButtonUI;
import com.jpexs.decompiler.flash.gui.MyProgressBarUI;
import com.jpexs.decompiler.flash.gui.MyResizableIcon;
import com.jpexs.decompiler.flash.gui.MyRibbonApplicationMenuButtonUI;
import com.jpexs.decompiler.flash.gui.MyRibbonApplicationMenuPopupPanelUI;
import com.jpexs.decompiler.flash.gui.OceanicSkin;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.gui.translator.Translator;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicColorChooserUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;

public class View {
    private static boolean heapWidgetInited = false;
    private static Color swfBackgroundColor = null;
    private static final BufferedImage transparentTexture;
    public static final TexturePaint transparentPaint;
    private static FontPolicy defaultFontPolicy;
    private static final Color transparentColor1;
    private static final Color transparentColor2;
    private static final KeyStroke escapeStroke;
    private static final String dispatchWindowClosingActionMapKey = "com.jpexs.dispatch:WINDOW_CLOSING";
    private static GraphicsEnvironment env;
    private static GraphicsConfiguration conf;

    public static Color getDefaultBackgroundColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue() && SubstanceLookAndFeel.getCurrentSkin() != null) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public static void setSwfBackgroundColor(Color swfBackgroundColor) {
        View.swfBackgroundColor = swfBackgroundColor;
    }

    public static Color getSwfBackgroundColor() {
        if (swfBackgroundColor == null) {
            return View.getDefaultBackgroundColor();
        }
        return swfBackgroundColor;
    }

    public static void setLookAndFeel() {
        final Font defaultFont = new JLabel().getFont();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        try {
            SubstanceSkin currentSkin;
            LookAndFeel oldLookAndFeel = UIManager.getLookAndFeel();
            if (!(oldLookAndFeel instanceof SubstanceOfficeBlue2007LookAndFeel)) {
                UIManager.setLookAndFeel((LookAndFeel)new SubstanceOfficeBlue2007LookAndFeel());
                oldLookAndFeel.uninitialize();
            }
            if ((currentSkin = SubstanceLookAndFeel.getCurrentSkin()) != null) {
                String newSkinName;
                String currentSkinName = currentSkin.getClass().getName();
                if (!currentSkinName.equals(newSkinName = (String)Configuration.guiSkin.get())) {
                    SubstanceLookAndFeel.setSkin((String)newSkinName);
                }
            } else {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, "Current skin is null");
                SubstanceLookAndFeel.setSkin((String)"com.jpexs.decompiler.flash.gui.OceanicSkin");
            }
            UIManager.put("substancelaf.colorizationFactor", 0.999);
            if (((Boolean)Configuration.showHeapStatusWidget.get()).booleanValue() && !heapWidgetInited) {
                SubstanceLookAndFeel.setWidgetVisible(null, (boolean)true, (SubstanceConstants.SubstanceWidgetType[])new SubstanceConstants.SubstanceWidgetType[]{SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS});
            }
            heapWidgetInited = true;
            if (View.isOceanic()) {
                UIManager.put("Tree.expandedIcon", View.getIcon("expand16"));
                UIManager.put("Tree.collapsedIcon", View.getIcon("collapse16"));
            }
            UIManager.put("ColorChooserUI", BasicColorChooserUI.class.getName());
            UIManager.put("ColorChooser.swatchesRecentSwatchSize", new Dimension(20, 20));
            UIManager.put("ColorChooser.swatchesSwatchSize", new Dimension(20, 20));
            UIManager.put("RibbonApplicationMenuPopupPanelUI", MyRibbonApplicationMenuPopupPanelUI.class.getName());
            UIManager.put("RibbonApplicationMenuButtonUI", MyRibbonApplicationMenuButtonUI.class.getName());
            UIManager.put("ProgressBarUI", MyProgressBarUI.class.getName());
            if (View.isOceanic()) {
                UIManager.put("TextField.background", Color.white);
                UIManager.put("FormattedTextField.background", Color.white);
            }
            UIManager.put("CommandButtonUI", MyCommandButtonUI.class.getName());
            if (defaultFontPolicy == null) {
                defaultFontPolicy = SubstanceLookAndFeel.getFontPolicy();
            }
            FontPolicy pol = defaultFontPolicy;
            final FontSet fs = pol.getFontSet("Substance", null);
            final double fontSizeMultiplier = (Double)Configuration.guiFontSizeMultiplier.get();
            SubstanceLookAndFeel.setFontPolicy((FontPolicy)new FontPolicy(){
                private final FontSet fontSet;
                {
                    this.fontSet = new FontSet(){
                        private FontUIResource controlFont;
                        private FontUIResource menuFont;
                        private FontUIResource titleFont;
                        private FontUIResource windowTitleFont;
                        private FontUIResource smallFont;
                        private FontUIResource messageFont;
                        final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        private int getFontSize(int defaultFontSize) {
                            return (int)((double)defaultFontSize * fontSizeMultiplier);
                        }

                        public FontUIResource getControlFont() {
                            if (this.controlFont == null) {
                                FontUIResource f = fs.getControlFont();
                                this.controlFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.controlFont;
                        }

                        public FontUIResource getMenuFont() {
                            if (this.menuFont == null) {
                                FontUIResource f = fs.getMenuFont();
                                this.menuFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.menuFont;
                        }

                        public FontUIResource getTitleFont() {
                            if (this.titleFont == null) {
                                FontUIResource f = fs.getTitleFont();
                                this.titleFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.titleFont;
                        }

                        public FontUIResource getWindowTitleFont() {
                            if (this.windowTitleFont == null) {
                                FontUIResource f = fs.getWindowTitleFont();
                                this.windowTitleFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.windowTitleFont;
                        }

                        public FontUIResource getSmallFont() {
                            if (this.smallFont == null) {
                                FontUIResource f = fs.getSmallFont();
                                this.smallFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.smallFont;
                        }

                        public FontUIResource getMessageFont() {
                            if (this.messageFont == null) {
                                FontUIResource f = fs.getMessageFont();
                                this.messageFont = new FontUIResource(defaultFont.getName(), f.getStyle(), this.getFontSize(f.getSize()));
                            }
                            return this.messageFont;
                        }
                    };
                }

                public FontSet getFontSet(String string, UIDefaults uid) {
                    return this.fontSet;
                }
            });
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
        }
        UIManager.put("substancelaf.tabbedPaneContentBorderKind", SubstanceConstants.TabContentPaneBorderKind.SINGLE_FULL);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    public static BufferedImage loadImage(String name) {
        URL imageURL = View.class.getResource("/com/jpexs/decompiler/flash/gui/graphics/" + name + ".png");
        try {
            return ImageIO.read(imageURL);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void setWindowIcon(Window f, String icon) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage(icon + "16"));
        images.add(View.loadImage(icon + "32"));
        f.setIconImages(images);
    }

    public static void setWindowIcon(Window f) {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            int[] sizes;
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            MyResizableIcon[] icons = MyRibbonApplicationMenuButtonUI.getIcons();
            MyResizableIcon icon = icons[1];
            for (int size : sizes = new int[]{256, 128, 64, 42, 40, 32, 20, 16}) {
                icon.setIconSize(size, size);
                BufferedImage bi = new BufferedImage(size, size, 6);
                icon.paintIcon(f, bi.getGraphics(), 0, 0);
                images.add(bi);
            }
            f.setIconImages(images);
        } else {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            images.add(View.loadImage("icon16"));
            images.add(View.loadImage("icon32"));
            images.add(View.loadImage("icon48"));
            images.add(View.loadImage("icon256"));
            f.setIconImages(images);
        }
    }

    public static void setWindowIcon16(Window f, String icon) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage(icon + "16"));
        f.setIconImages(images);
    }

    public static void centerScreenMain(Window f) {
        View.centerScreen(f, true);
    }

    public static void centerScreen(Window f) {
        View.centerScreen(f, false);
    }

    public static void centerScreen(Window f, boolean mainWindow) {
        GraphicsDevice device = mainWindow || Main.getMainFrame() == null ? View.getMainDefaultScreenDevice() : View.getWindowDevice(Main.getMainFrame().getWindow());
        int topLeftX = device.getDefaultConfiguration().getBounds().x;
        int topLeftY = device.getDefaultConfiguration().getBounds().y;
        int screenX = device.getDefaultConfiguration().getBounds().width;
        int screenY = device.getDefaultConfiguration().getBounds().height;
        Insets bounds = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
        int windowPosX = ((screenX -= bounds.right) - f.getWidth()) / 2 + topLeftX;
        int windowPosY = ((screenY -= bounds.bottom) - f.getHeight()) / 2 + topLeftY;
        f.setLocation(windowPosX, windowPosY);
    }

    public static void saveScreen() {
        MainFrame mainFrame = Main.getMainFrame();
        if (mainFrame == null) {
            return;
        }
        Window w = mainFrame.getWindow();
        if (w == null) {
            return;
        }
        GraphicsDevice device = View.getWindowDevice(w);
        GraphicsDevice[] allDevices = View.getEnv().getScreenDevices();
        int deviceIndex = -1;
        for (int i = 0; i < allDevices.length; ++i) {
            if (allDevices[i] != device) continue;
            deviceIndex = i;
            break;
        }
        if (deviceIndex != -1) {
            Configuration.lastMainWindowScreenIndex.set((Object)deviceIndex);
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            Configuration.lastMainWindowScreenX.set((Object)bounds.x);
            Configuration.lastMainWindowScreenY.set((Object)bounds.y);
            Configuration.lastMainWindowScreenWidth.set((Object)bounds.width);
            Configuration.lastMainWindowScreenHeight.set((Object)bounds.height);
        }
    }

    public static GraphicsDevice getMainDefaultScreenDevice() {
        GraphicsDevice[] allDevices;
        if (!((Boolean)Configuration.rememberLastScreen.get()).booleanValue()) {
            return View.getEnv().getDefaultScreenDevice();
        }
        int deviceIndex = (Integer)Configuration.lastMainWindowScreenIndex.get();
        if (deviceIndex >= (allDevices = View.getEnv().getScreenDevices()).length || deviceIndex == -1) {
            return View.getEnv().getDefaultScreenDevice();
        }
        Rectangle expectedBounds = allDevices[deviceIndex].getDefaultConfiguration().getBounds();
        if ((Integer)Configuration.lastMainWindowScreenX.get() != expectedBounds.x || (Integer)Configuration.lastMainWindowScreenY.get() != expectedBounds.y || (Integer)Configuration.lastMainWindowScreenWidth.get() != expectedBounds.width || (Integer)Configuration.lastMainWindowScreenHeight.get() != expectedBounds.height) {
            return View.getEnv().getDefaultScreenDevice();
        }
        return allDevices[deviceIndex];
    }

    public static int getWindowDeviceIndex(Window window) {
        GraphicsDevice device = View.getWindowDevice(window);
        GraphicsDevice[] allDevices = View.getEnv().getScreenDevices();
        for (int i = 0; i < allDevices.length; ++i) {
            if (allDevices[i] != device) continue;
            return i;
        }
        return -1;
    }

    public static GraphicsDevice getWindowDevice(Window window) {
        Rectangle bounds = window.getBounds();
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).stream().filter(d -> d.getDefaultConfiguration().getBounds().intersects(bounds)).sorted((f, s) -> Long.compare(View.square(f.getDefaultConfiguration().getBounds().intersection(bounds)), View.square(s.getDefaultConfiguration().getBounds().intersection(bounds)))).reduce((f, s) -> s).orElse(window.getGraphicsConfiguration().getDevice());
    }

    private static long square(Rectangle rec) {
        return Math.abs(rec.width * rec.height);
    }

    public static ImageIcon getIcon(String name, int size) {
        ImageIcon icon = View.getIcon(View.getPreferredIconName(name, size));
        if (icon.getIconWidth() == size && icon.getIconHeight() == size) {
            return icon;
        }
        icon.getImage();
        BufferedImage bi = new BufferedImage(size, size, 2);
        bi.createGraphics().drawImage(icon.getImage(), 0, 0, size, size, null, null);
        return new ImageIcon(bi);
    }

    public static ImageIcon getIcon(String name) {
        return new ImageIcon(View.class.getClassLoader().getResource("com/jpexs/decompiler/flash/gui/graphics/" + name + ".png"));
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, dispatchWindowClosingActionMapKey);
        root.getActionMap().put(dispatchWindowClosingActionMapKey, dispatchClosing);
    }

    public static boolean iconExists(String resource) {
        return View.class.getResource("/com/jpexs/decompiler/flash/gui/graphics/" + resource + ".png") != null;
    }

    private static String getPreferredIconName(String resource, int preferredSize) {
        Matcher m = Pattern.compile("(.*[^0-9])([0-9]+)").matcher(resource);
        if (m.matches()) {
            int origSize = Integer.parseInt(m.group(2));
            String name = m.group(1);
            if (origSize != preferredSize && View.iconExists(name + preferredSize)) {
                return name + preferredSize;
            }
        }
        return resource;
    }

    public static ImageWrapperResizableIcon getResizableIcon(String resource, int preferredSize) {
        return View.getResizableIcon(View.getPreferredIconName(resource, preferredSize));
    }

    public static ImageWrapperResizableIcon getResizableIcon(String resource) {
        return ImageWrapperResizableIcon.getIcon((URL)View.class.getResource("/com/jpexs/decompiler/flash/gui/graphics/" + resource + ".png"), (Dimension)new Dimension(256, 256));
    }

    public static MyResizableIcon getMyResizableIcon(String resource) {
        try {
            return new MyResizableIcon(ImageIO.read(View.class.getResourceAsStream("/com/jpexs/decompiler/flash/gui/graphics/" + resource + ".png")));
        }
        catch (IOException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void checkAccess() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("This method should be called from UI thread.");
        }
    }

    public static void execInEventDispatch(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void execInEventDispatchLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static SubstanceColorScheme getColorScheme() {
        return SubstanceColorSchemeUtilities.getActiveColorScheme((Component)new JButton(), (ComponentState)ComponentState.ENABLED);
    }

    public static void refreshTree(JTree tree, TreeModel model) {
        List<List<String>> expandedNodes = View.getExpandedNodes(tree);
        tree.setModel(model);
        View.expandTreeNodes(tree, expandedNodes);
    }

    public static List<List<String>> getExpandedNodes(JTree tree) {
        ArrayList<List<String>> expandedNodes = new ArrayList<List<String>>();
        int rowCount = tree.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            try {
                TreePath path = tree.getPathForRow(i);
                if (!tree.isExpanded(path)) continue;
                ArrayList<String> pathAsStringList = new ArrayList<String>();
                for (Object pathComponent : path.getPath()) {
                    pathAsStringList.add(pathComponent.toString());
                }
                expandedNodes.add(pathAsStringList);
                continue;
            }
            catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return expandedNodes;
    }

    private static TreePath expandTreeNode(JTree tree, List<String> pathAsStringList) {
        TreePath tp = View.getTreePathByPathStrings(tree, pathAsStringList);
        tree.expandPath(tp);
        return tp;
    }

    public static TreePath getTreePathByPathStrings(JTree tree, List<String> pathAsStringList) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return null;
        }
        Object node = model.getRoot();
        if (pathAsStringList.isEmpty()) {
            return null;
        }
        if (!pathAsStringList.get(0).equals(node.toString())) {
            return null;
        }
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(node);
        block0: for (int i = 1; i < pathAsStringList.size(); ++i) {
            String name = pathAsStringList.get(i);
            int childCount = model.getChildCount(node);
            for (int j = 0; j < childCount; ++j) {
                AbstractTagTreeModel aModel;
                Object child = model.getChild(node, j);
                String childStr = child.toString();
                int index = 1;
                if (model instanceof AbstractTagTreeModel && (index = (aModel = (AbstractTagTreeModel)model).getItemIndex((TreeItem)child)) > 1) {
                    childStr = childStr + " [" + index + "]";
                }
                if (!childStr.equals(name)) continue;
                node = child;
                path.add(node);
                continue block0;
            }
        }
        TreePath tp = new TreePath(path.toArray(new Object[path.size()]));
        return tp;
    }

    public static void expandTreeNodes(JTree tree, List<List<String>> pathsToExpand) {
        for (List<String> pathAsStringList : pathsToExpand) {
            View.expandTreeNode(tree, pathAsStringList);
        }
    }

    public static void expandTreeNodes(JTree tree, TreePath parent, boolean expand) {
        View.expandTreeNodesRecursive(tree, parent, expand);
    }

    private static void expandTreeNodesRecursive(JTree tree, TreePath parent, boolean expand) {
        TreeModel model = tree.getModel();
        Object node = parent.getLastPathComponent();
        int childCount = model.getChildCount(node);
        for (int j = 0; j < childCount; ++j) {
            Object child = model.getChild(node, j);
            TreePath path = parent.pathByAddingChild(child);
            View.expandTreeNodesRecursive(tree, path, expand);
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void addEditorAction(JEditorPane editor, AbstractAction a, String key, String name, String keyStroke) {
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        a.putValue("AcceleratorKey", ks);
        a.putValue("Name", name);
        ActionMap amap = editor.getActionMap();
        InputMap imap = editor.getInputMap(0);
        imap.put(ks, key);
        amap.put(key, a);
        JPopupMenu pmenu = editor.getComponentPopupMenu();
        JMenuItem findUsagesMenu = new JMenuItem(a);
        pmenu.add(findUsagesMenu);
    }

    public static void removeEditorAction(JEditorPane editor, String key) {
        Action a;
        ActionMap amap = editor.getActionMap();
        InputMap imap = editor.getInputMap(0);
        for (KeyStroke ks : imap.keys()) {
            if (!key.equals(imap.get(ks))) continue;
            imap.remove(ks);
            break;
        }
        if ((a = amap.get(key)) == null) {
            return;
        }
        amap.remove(key);
        JPopupMenu menu = editor.getComponentPopupMenu();
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            JMenuItem mi;
            Component c = menu.getComponent(i);
            if (!(c instanceof JMenuItem) || (mi = (JMenuItem)c).getAction() != a) continue;
            menu.remove(i);
            break;
        }
    }

    public static boolean navigateUrl(String url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = new URI(url);
                desktop.browse(uri);
                return true;
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public static JTable autoResizeColWidth(JTable table, TableModel model) {
        View.execInEventDispatch(() -> {
            table.setAutoResizeMode(0);
            table.setModel(model);
            int margin = 5;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                int vColIndex = i;
                DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
                TableColumn col = colModel.getColumn(vColIndex);
                TableCellRenderer renderer = col.getHeaderRenderer();
                if (renderer == null) {
                    renderer = table.getTableHeader().getDefaultRenderer();
                }
                Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                for (int r = 0; r < table.getRowCount(); ++r) {
                    renderer = table.getCellRenderer(r, vColIndex);
                    comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                col.setPreferredWidth(width += 2 * margin);
            }
            ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
            table.getTableHeader().setReorderingAllowed(false);
        });
        return table;
    }

    public static GraphicsEnvironment getEnv() {
        if (env == null) {
            env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        return env;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        if (conf == null) {
            conf = View.getEnv().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return conf;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (image.getColorModel().equals(View.getDefaultConfiguration().getColorModel())) {
            return image;
        }
        return View.getDefaultConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
    }

    public static VolatileImage createRenderImage(int width, int height, int transparency) {
        VolatileImage image = View.getDefaultConfiguration().createCompatibleVolatileImage(width, height, transparency);
        int valid = image.validate(View.getDefaultConfiguration());
        if (valid == 2) {
            image = View.createRenderImage(width, height, transparency);
            return image;
        }
        return image;
    }

    public static boolean isOceanic() {
        return SubstanceLookAndFeel.getCurrentSkin() instanceof OceanicSkin;
    }

    public static int textComponentViewToModel(JTextComponent editor, Point2D pt) {
        try {
            return (Integer)JTextComponent.class.getDeclaredMethod("viewToModel2D", Point2D.class).invoke((Object)editor, pt);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            Point p = new Point((int)Math.round(pt.getX()), (int)Math.round(pt.getY()));
            try {
                return (Integer)JTextComponent.class.getDeclaredMethod("viewToModel", Point.class).invoke((Object)editor, p);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
                return 0;
            }
        }
    }

    public static int textComponentViewToModel(JTextComponent editor, Point pt) {
        Point2D.Double p2d = new Point2D.Double(pt.x, pt.y);
        return View.textComponentViewToModel(editor, p2d);
    }

    public static Rectangle2D textComponentModelToView(JTextComponent editor, int pos) throws BadLocationException {
        try {
            return (Rectangle2D)JTextComponent.class.getDeclaredMethod("modelToView2D", Integer.TYPE).invoke((Object)editor, pos);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            try {
                return (Rectangle)JTextComponent.class.getDeclaredMethod("modelToView", Integer.TYPE).invoke((Object)editor, pos);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
    }

    public static Rectangle2D textUIModelToView(TextUI textUi, JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        try {
            return (Rectangle2D)TextUI.class.getDeclaredMethod("modelToView2D", JTextComponent.class, Integer.TYPE, Position.Bias.class).invoke((Object)textUi, t, pos, bias);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            try {
                return (Rectangle)TextUI.class.getDeclaredMethod("modelToView", JTextComponent.class, Integer.TYPE, Position.Bias.class).invoke((Object)textUi, t, pos, bias);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
    }

    public static Locale createLocale(String language, String country) {
        try {
            return (Locale)Locale.class.getDeclaredMethod("of", String.class, String.class).invoke(null, language, country);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            try {
                return (Locale)Locale.class.getDeclaredConstructor(String.class, String.class).newInstance(language, country);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex1) {
                Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex1);
                return null;
            }
        }
    }

    public static Locale createLocale(String language) {
        try {
            return (Locale)Locale.class.getDeclaredMethod("of", String.class).invoke(null, language);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            try {
                return (Locale)Locale.class.getDeclaredConstructor(String.class).newInstance(language);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex1) {
                Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex1);
                return null;
            }
        }
    }

    public static JFileChooser getFileChooserWithIcon(final String iconName) {
        return new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                View.setWindowIcon(dialog, iconName);
                dialog.getRootPane().setWindowDecorationStyle(1);
                return dialog;
            }
        };
    }

    static {
        transparentColor1 = new Color(153, 153, 153);
        transparentColor2 = new Color(102, 102, 102);
        transparentTexture = new BufferedImage(16, 16, 2);
        Graphics g = transparentTexture.getGraphics();
        g.setColor(transparentColor1);
        g.fillRect(0, 0, 16, 16);
        g.setColor(transparentColor2);
        g.fillRect(0, 0, 8, 8);
        g.fillRect(8, 8, 8, 8);
        transparentPaint = new TexturePaint(transparentTexture, new Rectangle(0, 0, transparentTexture.getWidth(), transparentTexture.getHeight()));
        escapeStroke = KeyStroke.getKeyStroke(27, 0);
    }
}

