/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.simple.ABCCleaner;
import com.jpexs.decompiler.flash.abc.usages.simple.ABCSimpleUsageDetector;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ABCExplorerDialog
extends AppDialog {
    private final List<ABC> abcs = new ArrayList<ABC>();
    private JComboBox<String> abcComboBox = null;
    private final JLabel tagInfoLabel;
    private final List<Integer> abcFrames = new ArrayList<Integer>();
    private final JTabbedPane mainTabbedPane;
    private final JTabbedPane cpTabbedPane;
    private MainPanel mainPanel;
    private Runnable packListener;
    private ABCSimpleUsageDetector usageDetector = null;
    private JButton cleanButton = new JButton(View.getIcon("clean16"));
    private JTable usagesTable = new JTable(new DefaultTableModel()){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };

    public ABCExplorerDialog(Window owner, MainPanel mainPanel, Openable openable, ABC abc) {
        super(owner);
        this.mainPanel = mainPanel;
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel topLeftPanel = new JPanel(new FlowLayout(0));
        topLeftPanel.add(new JLabel(this.translate("abc")));
        int selectedIndex = 0;
        int frame = 1;
        if (openable instanceof SWF) {
            SWF swf = (SWF)openable;
            ArrayList<ABCContainerTag> abcContainers = new ArrayList<ABCContainerTag>();
            for (Tag t : swf.getTags()) {
                if (t instanceof ShowFrameTag) {
                    ++frame;
                }
                if (!(t instanceof ABCContainerTag)) continue;
                ABCContainerTag abcCnt = (ABCContainerTag)t;
                if (abcCnt.getABC() == abc) {
                    selectedIndex = this.abcs.size();
                }
                abcContainers.add(abcCnt);
                this.abcs.add(abcCnt.getABC());
                this.abcFrames.add(frame);
            }
            String[] abcComboBoxData = new String[this.abcs.size()];
            for (int i = 0; i < abcContainers.size(); ++i) {
                abcComboBoxData[i] = "tag" + (i + 1);
                if (!(abcContainers.get(i) instanceof DoABC2Tag)) continue;
                DoABC2Tag doa2 = (DoABC2Tag)abcContainers.get(i);
                if (doa2.name == null || doa2.name.isEmpty()) continue;
                int n = i;
                abcComboBoxData[n] = abcComboBoxData[n] + " (\"" + Helper.escapePCodeString((String)doa2.name) + "\")";
            }
            this.abcComboBox = new JComboBox<String>(abcComboBoxData);
            Dimension abcComboBoxSize = new Dimension(500, this.abcComboBox.getPreferredSize().height);
            this.abcComboBox.setMinimumSize(abcComboBoxSize);
            this.abcComboBox.setPreferredSize(abcComboBoxSize);
            topLeftPanel.add(this.abcComboBox);
            this.abcComboBox.addActionListener(this::abcComboBoxActionPerformed);
        } else if (openable instanceof ABC) {
            this.abcs.add((ABC)openable);
            this.abcFrames.add(-1);
        }
        this.packListener = new Runnable(){

            @Override
            public void run() {
                int cpIndex = ABCExplorerDialog.this.cpTabbedPane.getSelectedIndex();
                int mainIndex = ABCExplorerDialog.this.mainTabbedPane.getSelectedIndex();
                ABCExplorerDialog.this.abcComboBoxActionPerformed(null);
                ABCExplorerDialog.this.cpTabbedPane.setSelectedIndex(cpIndex);
                ABCExplorerDialog.this.mainTabbedPane.setSelectedIndex(mainIndex);
                ABCExplorerDialog.this.refreshUsages();
            }
        };
        this.tagInfoLabel = new JLabel();
        topLeftPanel.add(this.tagInfoLabel);
        this.cleanButton.setToolTipText(this.translate("button.clean"));
        this.cleanButton.addActionListener(this::cleanActionPerformed);
        JPanel topRightPanel = new JPanel(new FlowLayout());
        topRightPanel.add(this.cleanButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)topLeftPanel, "West");
        topPanel.add((Component)topRightPanel, "East");
        this.mainTabbedPane = new JTabbedPane();
        this.cpTabbedPane = new JTabbedPane();
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.translate("usages").replace("%item%", "-"));
        this.usagesTable.setModel(model);
        this.usagesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int row = ABCExplorerDialog.this.usagesTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    String path = (String)ABCExplorerDialog.this.usagesTable.getModel().getValueAt(row, 0);
                    ABCExplorerDialog.this.selectPath(path);
                }
            }
        });
        this.usagesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = ABCExplorerDialog.this.usagesTable.rowAtPoint(e.getPoint());
                    int column = ABCExplorerDialog.this.usagesTable.columnAtPoint(e.getPoint());
                    if (!ABCExplorerDialog.this.usagesTable.isRowSelected(row)) {
                        ABCExplorerDialog.this.usagesTable.changeSelection(row, column, false, false);
                    }
                    JPopupMenu popupMenu = new JPopupMenu();
                    JMenuItem hilightMenuItem = new JMenuItem(ABCExplorerDialog.this.translate("hilight.usage"), View.getIcon("jumpto16"));
                    hilightMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int row = ABCExplorerDialog.this.usagesTable.getSelectedRow();
                            if (row == -1) {
                                return;
                            }
                            ABCExplorerDialog.this.selectPath((String)ABCExplorerDialog.this.usagesTable.getModel().getValueAt(row, 0));
                        }
                    });
                    JMenuItem copyMenuItem = new JMenuItem(ABCExplorerDialog.this.translate("copy.paths"), View.getIcon("copy16"));
                    copyMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int[] rows = ABCExplorerDialog.this.usagesTable.getSelectedRows();
                            ArrayList<String> values = new ArrayList<String>();
                            for (int row : rows) {
                                values.add((String)ABCExplorerDialog.this.usagesTable.getModel().getValueAt(row, 0));
                            }
                            ABCExplorerDialog.this.copyToClipboard(String.join((CharSequence)"\r\n", values));
                        }
                    });
                    JMenuItem copyAllMenuItem = new JMenuItem(ABCExplorerDialog.this.translate("copy.paths.all"), View.getIcon("copy16"));
                    copyAllMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (int row = 0; row < ABCExplorerDialog.this.usagesTable.getModel().getRowCount(); ++row) {
                                values.add((String)ABCExplorerDialog.this.usagesTable.getModel().getValueAt(row, 0));
                            }
                            ABCExplorerDialog.this.copyToClipboard(String.join((CharSequence)"\r\n", values));
                        }
                    });
                    popupMenu.add(hilightMenuItem);
                    popupMenu.add(copyMenuItem);
                    popupMenu.add(copyAllMenuItem);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel centralPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)new FasterScrollPane(this.usagesTable, 20, 30), "Center");
        JSplitPane splitPane = new JSplitPane(1, this.mainTabbedPane, rightPanel);
        splitPane.setDividerLocation(800);
        centralPanel.add(splitPane);
        cnt.add((Component)topPanel, "North");
        cnt.add((Component)centralPanel, "Center");
        if (!this.abcs.isEmpty()) {
            if (this.abcComboBox != null) {
                this.abcComboBox.setSelectedIndex(selectedIndex);
            } else {
                this.abcComboBoxActionPerformed(null);
            }
        }
        JRootPane rootPane = this.getRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(71, 128);
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(keyStroke, "ctrlGAction");
        actionMap.put("ctrlGAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = ViewMessages.showInputDialog(ABCExplorerDialog.this, ABCExplorerDialog.this.translate("goto.path.label"), ABCExplorerDialog.this.translate("goto.path"), "");
                if (path == null || path.isEmpty()) {
                    return;
                }
                ABCExplorerDialog.this.selectPath(path);
            }
        });
        this.setSize(1024, 600);
        this.setTitle(this.translate("title") + " - " + openable.getTitleOrShortFileName());
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage("abcexplorer16"));
        images.add(View.loadImage("abcexplorer32"));
        this.setIconImages(images);
        View.centerScreen(this);
    }

    public void selectAbc(ABC abc) {
        if (this.abcComboBox == null) {
            return;
        }
        if (abc == null && !this.abcs.isEmpty()) {
            this.abcComboBox.setSelectedIndex(0);
            return;
        }
        for (int i = 0; i < this.abcs.size(); ++i) {
            if (this.abcs.get(i) != abc) continue;
            this.abcComboBox.setSelectedIndex(i);
            break;
        }
    }

    private ABC getSelectedAbc() {
        if (this.abcs.isEmpty()) {
            return null;
        }
        if (this.abcComboBox == null) {
            return this.abcs.get(0);
        }
        return this.abcs.get(this.abcComboBox.getSelectedIndex());
    }

    private void abcComboBoxActionPerformed(ActionEvent e) {
        int index;
        this.usageDetector = null;
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.translate("usages").replace("%item%", "-"));
        this.usagesTable.setModel(model);
        int n = index = this.abcComboBox == null ? 0 : this.abcComboBox.getSelectedIndex();
        if (index == -1) {
            return;
        }
        if (this.abcs.isEmpty()) {
            return;
        }
        ABC abc = this.abcs.get(index);
        if (this.abcComboBox == null) {
            this.tagInfoLabel.setText(this.translate("abc.info.standalone").replace("%major%", "" + abc.version.major).replace("%minor%", "" + abc.version.minor).replace("%size%", Helper.formatFileSize((long)abc.getDataSize())));
        } else {
            this.tagInfoLabel.setText(this.translate("abc.info").replace("%index%", "" + (index + 1)).replace("%count%", "" + this.abcComboBox.getItemCount()).replace("%major%", "" + abc.version.major).replace("%minor%", "" + abc.version.minor).replace("%size%", Helper.formatFileSize((long)abc.getDataSize())).replace("%frame%", "" + this.abcFrames.get(index)));
        }
        this.cpTabbedPane.removeAll();
        this.cpTabbedPane.addTab("int (" + Math.max(0, abc.constants.getIntCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_INT.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_INT));
        this.cpTabbedPane.addTab("uint (" + Math.max(0, abc.constants.getUIntCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_UINT.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_UINT));
        this.cpTabbedPane.addTab("dbl (" + Math.max(0, abc.constants.getDoubleCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_DOUBLE.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_DOUBLE));
        if (abc.hasDecimalSupport()) {
            this.cpTabbedPane.addTab("dc (" + Math.max(0, abc.constants.getDecimalCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_DECIMAL.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_DECIMAL));
        }
        if (abc.hasFloatSupport()) {
            this.cpTabbedPane.addTab("fl (" + Math.max(0, abc.constants.getFloatCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_FLOAT.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_FLOAT));
        }
        if (abc.hasFloat4Support()) {
            this.cpTabbedPane.addTab("fl4 (" + Math.max(0, abc.constants.getFloat4Count() - 1) + ")", View.getIcon(TreeType.CONSTANT_FLOAT_4.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_FLOAT_4));
        }
        this.cpTabbedPane.addTab("str (" + Math.max(0, abc.constants.getStringCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_STRING.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_STRING));
        this.cpTabbedPane.addTab("ns (" + Math.max(0, abc.constants.getNamespaceCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_NAMESPACE.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_NAMESPACE));
        this.cpTabbedPane.addTab("nss (" + Math.max(0, abc.constants.getNamespaceSetCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_NAMESPACE_SET.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_NAMESPACE_SET));
        this.cpTabbedPane.addTab("mn (" + Math.max(0, abc.constants.getMultinameCount() - 1) + ")", View.getIcon(TreeType.CONSTANT_MULTINAME.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CONSTANT_MULTINAME));
        this.mainTabbedPane.removeAll();
        JPanel cpPanel = new JPanel(new BorderLayout());
        cpPanel.add((Component)this.cpTabbedPane, "Center");
        int cpCount = Math.max(0, abc.constants.getIntCount() - 1) + Math.max(0, abc.constants.getUIntCount() - 1) + Math.max(0, abc.constants.getDoubleCount() - 1) + Math.max(0, abc.constants.getStringCount() - 1) + Math.max(0, abc.constants.getNamespaceCount() - 1) + Math.max(0, abc.constants.getNamespaceSetCount() - 1) + Math.max(0, abc.constants.getMultinameCount() - 1) + (abc.hasDecimalSupport() ? Math.max(0, abc.constants.getDecimalCount() - 1) : 0) + (abc.hasFloatSupport() ? Math.max(0, abc.constants.getFloatCount() - 1) : 0) + (abc.hasFloat4Support() ? Math.max(0, abc.constants.getFloat4Count() - 1) : 0);
        this.mainTabbedPane.addTab("cp (" + cpCount + ")", View.getIcon("abcconstantpool16"), cpPanel);
        this.mainTabbedPane.addTab("mi (" + abc.method_info.size() + ")", View.getIcon(TreeType.METHOD_INFO.getIcon().getFile()), this.makeTreePanel(abc, TreeType.METHOD_INFO));
        this.mainTabbedPane.addTab("md (" + abc.metadata_info.size() + ")", View.getIcon(TreeType.METADATA_INFO.getIcon().getFile()), this.makeTreePanel(abc, TreeType.METADATA_INFO));
        this.mainTabbedPane.addTab("ii (" + abc.instance_info.size() + ")", View.getIcon(TreeType.INSTANCE_INFO.getIcon().getFile()), this.makeTreePanel(abc, TreeType.INSTANCE_INFO));
        this.mainTabbedPane.addTab("ci (" + abc.class_info.size() + ")", View.getIcon(TreeType.CLASS_INFO.getIcon().getFile()), this.makeTreePanel(abc, TreeType.CLASS_INFO));
        this.mainTabbedPane.addTab("si (" + abc.script_info.size() + ")", View.getIcon(TreeType.SCRIPT_INFO.getIcon().getFile()), this.makeTreePanel(abc, TreeType.SCRIPT_INFO));
        this.mainTabbedPane.addTab("mb (" + abc.bodies.size() + ")", View.getIcon(TreeType.METHOD_BODY.getIcon().getFile()), this.makeTreePanel(abc, TreeType.METHOD_BODY));
        abc.removeChangeListener(this.packListener);
        abc.addChangeListener(this.packListener);
        this.refreshUsages();
        this.repaint();
    }

    private void refreshUsages() {
        ABCSimpleUsageDetector newUsageDetector = new ABCSimpleUsageDetector(this.getSelectedAbc());
        newUsageDetector.detect();
        this.usageDetector = newUsageDetector;
        int zeroUsages = newUsageDetector.getZeroUsagesCount();
        this.cleanButton.setText("(" + zeroUsages + ")");
        this.cleanButton.setEnabled(zeroUsages > 0);
    }

    private JTree getCurrentTree() {
        JPanel pan = this.mainTabbedPane.getSelectedIndex() == 0 ? (JPanel)this.cpTabbedPane.getSelectedComponent() : (JPanel)this.mainTabbedPane.getSelectedComponent();
        FasterScrollPane fasterScrollPane = (FasterScrollPane)pan.getComponent(0);
        JTree tree = (JTree)fasterScrollPane.getViewport().getView();
        return tree;
    }

    private String getCurrentPath() {
        JTree tree = this.getCurrentTree();
        TreePath tp = tree.getSelectionPath();
        if (tp == null) {
            return "";
        }
        ArrayList<String> pathParts = new ArrayList<String>();
        Object[] path = tp.getPath();
        for (int i = 1; i < path.length; ++i) {
            HasIcon sv;
            String key;
            Object child = path[i];
            if (child instanceof ValueWithIndex) {
                ValueWithIndex vwi = (ValueWithIndex)child;
                key = !vwi.getTitle().isEmpty() ? vwi.getTitle() : vwi.getType().getAbbreviation() + vwi.getIndex();
            } else if (child instanceof SubValue) {
                sv = (SubValue)child;
                key = ((SubValue)sv).getTitle();
            } else {
                if (!(child instanceof SimpleValue)) break;
                sv = (SimpleValue)child;
                key = ((SimpleValue)sv).getTitle();
            }
            pathParts.add(key);
        }
        return String.join((CharSequence)"/", pathParts);
    }

    public void selectTrait(int scriptIndex, int classIndex, int traitIndex, int traitType) {
        this.selectScriptInfo(scriptIndex);
        JTree tree = this.getCurrentTree();
        Object selection = tree.getLastSelectedPathComponent();
        if (selection == null) {
            return;
        }
        int classTraitIndexInScript = -1;
        if (classIndex != -1 && (classTraitIndexInScript = this.findClassTraitIndexInScript(scriptIndex, classIndex)) == -1) {
            return;
        }
        if (traitIndex == -3) {
            this.selectPath(tree, "si" + scriptIndex + "/init");
        } else if (traitIndex == -2) {
            this.selectPath(tree, "si" + scriptIndex + "/traits/t" + classTraitIndexInScript + "/class_info/cinit");
        } else if (traitIndex == -1) {
            this.selectPath(tree, "si" + scriptIndex + "/traits/t" + classTraitIndexInScript + "/instance_info/iinit");
        } else if (traitType == -3) {
            this.selectPath(tree, "si" + scriptIndex + "/traits/t" + traitIndex);
        } else if (traitType == -2) {
            this.selectPath(tree, "si" + scriptIndex + "/traits/t" + classTraitIndexInScript + "/class_info/traits/t" + traitIndex);
        } else if (traitType == -1) {
            this.selectPath(tree, "si" + scriptIndex + "/traits/t" + classTraitIndexInScript + "/instance_info/traits/t" + traitIndex);
        }
    }

    private int findClassTraitIndexInScript(int scriptIndex, int classIndex) {
        ABC abc = this.getSelectedAbc();
        for (int i = 0; i < ((ScriptInfo)abc.script_info.get((int)scriptIndex)).traits.traits.size(); ++i) {
            Trait t = (Trait)((ScriptInfo)abc.script_info.get((int)scriptIndex)).traits.traits.get(i);
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            if (tc.class_info != classIndex) continue;
            return i;
        }
        return -1;
    }

    private void selectPath(String path) {
        String[] parts = path.split("/");
        String mainItem = parts[0];
        TreeType selectedType = null;
        for (TreeType type : TreeType.values()) {
            if (!mainItem.startsWith(type.getAbbreviation())) continue;
            selectedType = type;
        }
        if (selectedType == null) {
            return;
        }
        if (this.mainTabbedPane.getTabCount() == 0) {
            return;
        }
        int stringOffset = 0;
        if (this.getSelectedAbc().hasDecimalSupport()) {
            stringOffset = 1;
        }
        if (this.getSelectedAbc().hasFloatSupport()) {
            ++stringOffset;
        }
        if (this.getSelectedAbc().hasFloat4Support()) {
            ++stringOffset;
        }
        switch (selectedType.ordinal()) {
            case 0: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(2);
                break;
            }
            case 3: {
                if (!this.getSelectedAbc().hasDecimalSupport()) {
                    return;
                }
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(3);
                break;
            }
            case 4: {
                if (!this.getSelectedAbc().hasFloatSupport()) {
                    return;
                }
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(3);
                break;
            }
            case 5: {
                if (!this.getSelectedAbc().hasFloat4Support()) {
                    return;
                }
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(4);
                break;
            }
            case 6: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(3 + stringOffset);
                break;
            }
            case 7: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(4 + stringOffset);
                break;
            }
            case 8: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(5 + stringOffset);
                break;
            }
            case 9: {
                this.mainTabbedPane.setSelectedIndex(0);
                this.cpTabbedPane.setSelectedIndex(6 + stringOffset);
                break;
            }
            case 10: {
                this.mainTabbedPane.setSelectedIndex(1);
                break;
            }
            case 11: {
                this.mainTabbedPane.setSelectedIndex(2);
                break;
            }
            case 12: {
                this.mainTabbedPane.setSelectedIndex(3);
                break;
            }
            case 13: {
                this.mainTabbedPane.setSelectedIndex(4);
                break;
            }
            case 14: {
                this.mainTabbedPane.setSelectedIndex(5);
                break;
            }
            case 15: {
                this.mainTabbedPane.setSelectedIndex(6);
            }
        }
        this.selectPath(this.getCurrentTree(), path);
    }

    private void selectPath(JTree tree, String path) {
        Object root;
        String[] parts = path.split("/");
        TreeModel model = tree.getModel();
        Object parent = root = model.getRoot();
        ArrayList<Object> treePathObjectsList = new ArrayList<Object>();
        treePathObjectsList.add(root);
        block0: for (int p = 0; p < parts.length; ++p) {
            String part = parts[p];
            for (int i = 0; i < model.getChildCount(parent); ++i) {
                HasIcon sv;
                Object child = model.getChild(parent, i);
                String key = "";
                if (child instanceof ValueWithIndex) {
                    ValueWithIndex vwi = (ValueWithIndex)child;
                    key = !vwi.getTitle().isEmpty() ? vwi.getTitle() : vwi.getType().getAbbreviation() + vwi.getIndex();
                } else if (child instanceof SubValue) {
                    sv = (SubValue)child;
                    key = ((SubValue)sv).getTitle();
                } else if (child instanceof SimpleValue) {
                    sv = (SimpleValue)child;
                    key = ((SimpleValue)sv).getTitle();
                }
                if (!key.equals(part)) continue;
                treePathObjectsList.add(child);
                parent = child;
                continue block0;
            }
        }
        TreePath treePath = new TreePath(treePathObjectsList.toArray(new Object[treePathObjectsList.size()]));
        tree.setSelectionPath(treePath);
        tree.scrollPathToVisible(treePath);
    }

    public void selectScriptInfo(int scriptIndex) {
        if (this.mainTabbedPane.getTabCount() > 0) {
            this.mainTabbedPane.setSelectedIndex(5);
            JPanel pan = (JPanel)this.mainTabbedPane.getComponentAt(5);
            FasterScrollPane fasterScrollPane = (FasterScrollPane)pan.getComponent(0);
            JTree tree = (JTree)fasterScrollPane.getViewport().getView();
            TreeModel model = tree.getModel();
            if (scriptIndex >= model.getChildCount(model.getRoot())) {
                return;
            }
            Object scriptInfoNode = model.getChild(model.getRoot(), scriptIndex);
            TreePath path = new TreePath(new Object[]{model.getRoot(), scriptInfoNode});
            tree.setSelectionPath(path);
            tree.scrollPathToVisible(path);
        }
    }

    private JPanel makeTreePanel(ABC abc, TreeType type) {
        final JTree tree = new JTree(new ExplorerTreeModel(abc, type));
        if (View.isOceanic()) {
            tree.setBackground(Color.white);
        }
        tree.setCellRenderer(new ExplorerTreeCellRenderer(this));
        tree.setUI(new BasicTreeUI(){
            {
                if (View.isOceanic()) {
                    this.setHashColor(Color.gray);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){
            final /* synthetic */ ABCExplorerDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultTableModel model = new DefaultTableModel();
                if (tree.getSelectionCount() != 1 || this.this$0.usageDetector == null) {
                    model.addColumn(this.this$0.translate("usages").replace("%item%", "-"));
                    this.this$0.usagesTable.setModel(model);
                    return;
                }
                Object selection = tree.getLastSelectedPathComponent();
                if (selection instanceof ValueWithIndex) {
                    ValueWithIndex vwi = (ValueWithIndex)selection;
                    if (vwi.getType().getUsageKind() != null) {
                        List newUsages = this.this$0.usageDetector.getUsages(vwi.type.getUsageKind(), vwi.index);
                        model.addColumn(this.this$0.translate("usages").replace("%item%", vwi.type.getAbbreviation() + vwi.index + ": " + vwi.getDescription()));
                        for (String usage : newUsages) {
                            model.addRow(new Object[]{usage});
                        }
                        this.this$0.usagesTable.setModel(model);
                    } else {
                        model.addColumn(this.this$0.translate("usages").replace("%item%", "-"));
                    }
                } else {
                    model.addColumn(this.this$0.translate("usages").replace("%item%", "-"));
                }
                this.this$0.usagesTable.setModel(model);
            }
        });
        tree.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ABCExplorerDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int row = tree.getClosestRowForLocation(e.getX(), e.getY());
                    tree.setSelectionRow(row);
                    JPopupMenu popupMenu = this.this$0.createTreePopup(tree);
                    if (popupMenu == null) {
                        return;
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)new FasterScrollPane(tree), "Center");
        return treePanel;
    }

    private JPopupMenu createTreePopup(JTree tree) {
        JMenuItem copyTitleMenuItem;
        HasIcon sv;
        JMenuItem showInMainWindowMenuItem;
        ValueWithIndex vwi;
        JPopupMenu menu = new JPopupMenu();
        if (tree.getSelectionCount() != 1) {
            return null;
        }
        Object selection = tree.getLastSelectedPathComponent();
        if (selection instanceof ValueWithIndex) {
            vwi = (ValueWithIndex)selection;
            if (vwi.getType() == TreeType.SCRIPT_INFO) {
                showInMainWindowMenuItem = new JMenuItem(this.translate("show.script"), View.getIcon("show16"));
                showInMainWindowMenuItem.addActionListener(this::showInMainWindowActionPerformed);
                menu.add(showInMainWindowMenuItem);
            }
            if (vwi.getType() == TreeType.METHOD_INFO || vwi.getType() == TreeType.METHOD_BODY) {
                showInMainWindowMenuItem = new JMenuItem(this.translate("show.method"), View.getIcon("show16"));
                showInMainWindowMenuItem.addActionListener(this::showInMainWindowActionPerformed);
                menu.add(showInMainWindowMenuItem);
            }
            if (vwi.getType() == TreeType.INSTANCE_INFO || vwi.getType() == TreeType.CLASS_INFO) {
                showInMainWindowMenuItem = new JMenuItem(this.translate("show.class"), View.getIcon("show16"));
                showInMainWindowMenuItem.addActionListener(this::showInMainWindowActionPerformed);
                menu.add(showInMainWindowMenuItem);
            }
        }
        if (selection instanceof SubValue) {
            sv = (SubValue)selection;
            switch (((SubValue)sv).getIcon().ordinal()) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (((SubValue)sv).parentValue instanceof MethodBody) break;
                    showInMainWindowMenuItem = new JMenuItem(this.translate("show.trait"), View.getIcon("show16"));
                    showInMainWindowMenuItem.addActionListener(this::showInMainWindowActionPerformed);
                    menu.add(showInMainWindowMenuItem);
                }
            }
        }
        if (selection != null) {
            JMenuItem copyMenuItem = new JMenuItem(this.translate("copy.path"), View.getIcon("copy16"));
            copyMenuItem.addActionListener(this::copyPathActionPerformed);
            menu.add(copyMenuItem);
            JMenuItem copyRowMenuItem = new JMenuItem(this.translate("copy.row"), View.getIcon("copy16"));
            copyRowMenuItem.addActionListener(this::copyRowActionPerformed);
            menu.add(copyRowMenuItem);
        }
        if (selection instanceof ValueWithIndex) {
            vwi = (ValueWithIndex)selection;
            if (!vwi.getTitle().isEmpty()) {
                copyTitleMenuItem = new JMenuItem(this.translate("copy.title"), View.getIcon("copy16"));
                copyTitleMenuItem.addActionListener(this::copyTitleActionPerformed);
                menu.add(copyTitleMenuItem);
            }
            JMenuItem copyTypeIdMenuItem = new JMenuItem(this.translate("copy.typeid"), View.getIcon("copy16"));
            copyTypeIdMenuItem.addActionListener(this::copyTypeIdActionPerformed);
            menu.add(copyTypeIdMenuItem);
            if (!vwi.getDescription().isEmpty()) {
                JMenuItem copyValueMenuItem = new JMenuItem(this.translate("copy.value"), View.getIcon("copy16"));
                copyValueMenuItem.addActionListener(this::copyValueActionPerformed);
                menu.add(copyValueMenuItem);
            }
            if (vwi.getType() == TreeType.CONSTANT_STRING && vwi.getIndex() > 0) {
                JMenuItem copyRawStringValueMenuItem = new JMenuItem(this.translate("copy.rawstring"), View.getIcon("copy16"));
                copyRawStringValueMenuItem.addActionListener(this::copyRawStringValueActionPerformed);
                menu.add(copyRawStringValueMenuItem);
            }
        } else if (selection instanceof SubValue) {
            sv = (SubValue)selection;
            copyTitleMenuItem = new JMenuItem(this.translate("copy.title"), View.getIcon("copy16"));
            copyTitleMenuItem.addActionListener(this::copyTitleActionPerformed);
            menu.add(copyTitleMenuItem);
            if (!((SubValue)sv).getDescription().isEmpty()) {
                JMenuItem copyValueMenuItem = new JMenuItem(this.translate("copy.value"), View.getIcon("copy16"));
                copyValueMenuItem.addActionListener(this::copyValueActionPerformed);
                menu.add(copyValueMenuItem);
            }
        } else if (selection instanceof SimpleValue) {
            sv = (SimpleValue)selection;
            copyTitleMenuItem = new JMenuItem(this.translate("copy.title"), View.getIcon("copy16"));
            copyTitleMenuItem.addActionListener(this::copyTitleActionPerformed);
            menu.add(copyTitleMenuItem);
            if (!((SimpleValue)sv).getValue().isEmpty()) {
                JMenuItem copyValueMenuItem = new JMenuItem(this.translate("copy.value"), View.getIcon("copy16"));
                copyValueMenuItem.addActionListener(this::copyValueActionPerformed);
                menu.add(copyValueMenuItem);
            }
        } else {
            return null;
        }
        return menu;
    }

    private void copyPathActionPerformed(ActionEvent e) {
        this.copyToClipboard(this.getCurrentPath());
    }

    private void copyRowActionPerformed(ActionEvent e) {
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        if (selection != null) {
            this.copyToClipboard(selection.toString());
        }
    }

    private boolean showMethodInfoTraits(int round, int scriptIndex, int classIndex, int methodInfo, ABC abc, Traits traits, int traitsType, int scriptTraitIndex) {
        for (int j = 0; j < traits.traits.size(); ++j) {
            Trait t = (Trait)traits.traits.get(j);
            if (traitsType == -3) {
                scriptTraitIndex = j;
            }
            int globalTraitIndex = j;
            if (traitsType == -1) {
                globalTraitIndex += ((ClassInfo)abc.class_info.get((int)classIndex)).static_traits.traits.size();
            }
            if (t instanceof TraitClass) {
                TraitClass tc = (TraitClass)t;
                if (this.showMethodInfo(round, abc, ((ClassInfo)abc.class_info.get((int)tc.class_info)).cinit_index, methodInfo, scriptIndex, tc.class_info, -2, scriptTraitIndex)) {
                    return true;
                }
                if (this.showMethodInfo(round, abc, ((InstanceInfo)abc.instance_info.get((int)tc.class_info)).iinit_index, methodInfo, scriptIndex, tc.class_info, -1, scriptTraitIndex)) {
                    return true;
                }
                if (this.showMethodInfoTraits(round, scriptIndex, tc.class_info, methodInfo, abc, ((ClassInfo)abc.class_info.get((int)tc.class_info)).static_traits, -2, scriptTraitIndex)) {
                    return true;
                }
                if (this.showMethodInfoTraits(round, scriptIndex, tc.class_info, methodInfo, abc, ((InstanceInfo)abc.instance_info.get((int)tc.class_info)).instance_traits, -1, scriptTraitIndex)) {
                    return true;
                }
            }
            if (t instanceof TraitMethodGetterSetter) {
                TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
                if (this.showMethodInfo(round, abc, tmgs.method_info, methodInfo, scriptIndex, classIndex, globalTraitIndex, scriptTraitIndex)) {
                    return true;
                }
            }
            if (!(t instanceof TraitFunction)) continue;
            TraitFunction tf = (TraitFunction)t;
            if (!this.showMethodInfo(round, abc, tf.method_info, methodInfo, scriptIndex, classIndex, globalTraitIndex, scriptTraitIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean showMethodInfo(int round, ABC abc, int methodInfo, int searchMethodInfo, int scriptIndex, int classIndex, int globalTraitIndex, int scriptTraitIndex) {
        boolean found = false;
        if (methodInfo == searchMethodInfo) {
            found = true;
        } else if (round == 2) {
            ArrayDeque<Integer> methods = new ArrayDeque<Integer>();
            HashSet<Integer> visitedMethods = new HashSet<Integer>();
            methods.add(methodInfo);
            block0: while (!methods.isEmpty()) {
                methodInfo = (Integer)methods.poll();
                if (visitedMethods.contains(methodInfo)) continue;
                visitedMethods.add(methodInfo);
                MethodBody body = abc.findBody(methodInfo);
                if (body == null) continue;
                for (AVM2Instruction ins : body.getCode().code) {
                    if (!(ins.definition instanceof NewFunctionIns)) continue;
                    if (ins.operands[0] == searchMethodInfo) {
                        found = true;
                        break block0;
                    }
                    methods.add(ins.operands[0]);
                }
            }
        }
        if (found) {
            DottedChain scriptNameDc = ((ScriptInfo)abc.script_info.get(scriptIndex)).getSimplePackName(abc, new LinkedHashSet());
            if (scriptNameDc == null && scriptTraitIndex > -1) {
                scriptNameDc = ((Trait)((ScriptInfo)abc.script_info.get((int)scriptIndex)).traits.traits.get(scriptTraitIndex)).getName(abc).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, false);
            }
            String scriptName = scriptNameDc == null ? "script_" + scriptIndex : scriptNameDc.toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
            this.mainPanel.gotoScriptMethod(abc.getSwf(), scriptName, searchMethodInfo);
        }
        return found;
    }

    private void showMethodInfo(int methodInfo) {
        ABC abc = this.getSelectedAbc();
        for (int round = 1; round <= 2; ++round) {
            for (int i = 0; i < abc.script_info.size(); ++i) {
                if (this.showMethodInfo(round, abc, ((ScriptInfo)abc.script_info.get((int)i)).init_index, methodInfo, i, -1, -3, -1)) {
                    return;
                }
                if (!this.showMethodInfoTraits(round, i, -1, methodInfo, abc, ((ScriptInfo)abc.script_info.get((int)i)).traits, -3, -1)) continue;
                return;
            }
        }
    }

    private void showInMainWindowActionPerformed(ActionEvent e) {
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        ABC abc = this.getSelectedAbc();
        if (selection instanceof ValueWithIndex) {
            ValueWithIndex vwi = (ValueWithIndex)selection;
            int scriptIndex = -1;
            switch (vwi.type.ordinal()) {
                case 14: {
                    scriptIndex = vwi.getIndex();
                    DottedChain scriptNameDc = ((ScriptInfo)abc.script_info.get(scriptIndex)).getSimplePackName(abc, new LinkedHashSet());
                    String scriptName = scriptNameDc == null ? "script_" + scriptIndex : scriptNameDc.toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
                    this.mainPanel.gotoScriptName(abc.getSwf(), scriptName);
                    break;
                }
                case 15: {
                    MethodBody body = (MethodBody)vwi.getRawValue();
                    if (body == null) break;
                    this.showMethodInfo(body.method_info);
                    break;
                }
                case 10: {
                    this.showMethodInfo(vwi.getIndex());
                    break;
                }
                case 12: 
                case 13: {
                    int classIndex = vwi.getIndex();
                    int scriptTraitIndex = -1;
                    block9: for (int i = 0; i < abc.script_info.size(); ++i) {
                        for (int j = 0; j < ((ScriptInfo)abc.script_info.get((int)i)).traits.traits.size(); ++j) {
                            Trait t = (Trait)((ScriptInfo)abc.script_info.get((int)i)).traits.traits.get(j);
                            if (!(t instanceof TraitClass)) continue;
                            TraitClass tc = (TraitClass)t;
                            if (tc.class_info != classIndex) continue;
                            scriptIndex = i;
                            scriptTraitIndex = j;
                            break block9;
                        }
                    }
                    if (scriptIndex == -1) break;
                    DottedChain scriptNameDc2 = ((ScriptInfo)abc.script_info.get(scriptIndex)).getSimplePackName(abc, new LinkedHashSet());
                    if (scriptNameDc2 == null && scriptTraitIndex != -1) {
                        scriptNameDc2 = ((Trait)((ScriptInfo)abc.script_info.get((int)scriptIndex)).traits.traits.get(scriptTraitIndex)).getName(abc).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, false);
                    }
                    String scriptName2 = scriptNameDc2 == null ? "script_" + scriptIndex : scriptNameDc2.toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
                    this.mainPanel.gotoScriptTrait(abc.getSwf(), scriptName2, classIndex, -2);
                }
            }
        }
        if (selection instanceof SubValue) {
            SubValue sv = (SubValue)selection;
            switch (sv.getIcon().ordinal()) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    int traitIndex;
                    int globalTraitIndex = traitIndex = sv.getIndex();
                    SubValue sv1 = (SubValue)sv.getParent();
                    ValueWithIndex wvi = (ValueWithIndex)sv1.getParent();
                    int scriptIndex = -1;
                    int classIndex = -1;
                    int scriptTraitIndex = -1;
                    if (sv.getParentValue() instanceof ScriptInfo) {
                        scriptIndex = wvi.getIndex();
                        scriptTraitIndex = traitIndex;
                    } else {
                        classIndex = wvi.getIndex();
                        if (sv.getParentValue() instanceof InstanceInfo) {
                            globalTraitIndex += ((ClassInfo)abc.class_info.get((int)classIndex)).static_traits.traits.size();
                        }
                        block11: for (int i = 0; i < abc.script_info.size(); ++i) {
                            for (int j = 0; j < ((ScriptInfo)abc.script_info.get((int)i)).traits.traits.size(); ++j) {
                                Trait t = (Trait)((ScriptInfo)abc.script_info.get((int)i)).traits.traits.get(j);
                                if (!(t instanceof TraitClass)) continue;
                                TraitClass tc = (TraitClass)t;
                                if (tc.class_info != classIndex) continue;
                                scriptIndex = i;
                                scriptTraitIndex = j;
                                break block11;
                            }
                        }
                    }
                    if (scriptIndex == -1) break;
                    DottedChain scriptNameDc = ((ScriptInfo)abc.script_info.get(scriptIndex)).getSimplePackName(abc, new LinkedHashSet());
                    if (scriptNameDc == null && scriptTraitIndex != -1) {
                        scriptNameDc = ((Trait)((ScriptInfo)abc.script_info.get((int)scriptIndex)).traits.traits.get(scriptTraitIndex)).getName(abc).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, false);
                    }
                    String scriptName = scriptNameDc == null ? "script_" + scriptIndex : scriptNameDc.toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
                    this.mainPanel.gotoScriptTrait(abc.getSwf(), scriptName, classIndex, globalTraitIndex);
                }
            }
        }
    }

    private void copyTitleActionPerformed(ActionEvent e) {
        HasIcon sv;
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        if (selection instanceof SimpleValue) {
            sv = (SimpleValue)selection;
            this.copyToClipboard(((SimpleValue)sv).getTitle());
        }
        if (selection instanceof ValueWithIndex) {
            ValueWithIndex vwi = (ValueWithIndex)selection;
            this.copyToClipboard(vwi.getTitle());
        }
        if (selection instanceof SubValue) {
            sv = (SubValue)selection;
            this.copyToClipboard(((SubValue)sv).getTitle());
        }
    }

    private void copyValueActionPerformed(ActionEvent e) {
        HasIcon sv;
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        if (selection instanceof SimpleValue) {
            sv = (SimpleValue)selection;
            this.copyToClipboard(((SimpleValue)sv).getValue());
        }
        if (selection instanceof ValueWithIndex) {
            ValueWithIndex vwi = (ValueWithIndex)selection;
            this.copyToClipboard(vwi.getDescription());
        }
        if (selection instanceof SubValue) {
            sv = (SubValue)selection;
            this.copyToClipboard(((SubValue)sv).getDescription());
        }
    }

    private void copyRawStringValueActionPerformed(ActionEvent e) {
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        if (selection instanceof ValueWithIndex) {
            ValueWithIndex vwi = (ValueWithIndex)selection;
            this.copyToClipboard((String)vwi.getRawValue());
        }
    }

    private void copyTypeIdActionPerformed(ActionEvent e) {
        Object selection = this.getCurrentTree().getLastSelectedPathComponent();
        if (selection instanceof ValueWithIndex) {
            ValueWithIndex vwi = (ValueWithIndex)selection;
            this.copyToClipboard(vwi.getType().getAbbreviation() + vwi.getIndex());
        }
    }

    private void copyToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void cleanActionPerformed(ActionEvent e) {
        ABC abc = this.getSelectedAbc();
        if (abc != null) {
            if (ViewMessages.showConfirmDialog(this, AppStrings.translate("warning.cleanAbc"), AppStrings.translate("message.warning"), 2, 2, (ConfigurationItem<Boolean>)Configuration.warningAbcClean, 0) != 0) {
                return;
            }
            int mainIndex = this.mainTabbedPane.getSelectedIndex();
            int cpIndex = this.cpTabbedPane.getSelectedIndex();
            ABCCleaner cleaner = new ABCCleaner();
            cleaner.clean(abc);
            if (cpIndex > -1) {
                this.cpTabbedPane.setSelectedIndex(cpIndex);
            }
            if (mainIndex > -1) {
                this.mainTabbedPane.setSelectedIndex(mainIndex);
            }
            Main.getMainFrame().getPanel().refreshTree();
        }
    }

    private static enum TreeType {
        CONSTANT_INT("Integers", "int", TreeIcon.CONSTANT_INT, ABCSimpleUsageDetector.ItemKind.INT),
        CONSTANT_UINT("UnsignedIntegers", "uint", TreeIcon.CONSTANT_UINT, ABCSimpleUsageDetector.ItemKind.UINT),
        CONSTANT_DOUBLE("Doubles", "dbl", TreeIcon.CONSTANT_DOUBLE, ABCSimpleUsageDetector.ItemKind.DOUBLE),
        CONSTANT_DECIMAL("Decimals", "dc", TreeIcon.CONSTANT_DECIMAL, ABCSimpleUsageDetector.ItemKind.DECIMAL),
        CONSTANT_FLOAT("Floats", "fl", TreeIcon.CONSTANT_FLOAT, ABCSimpleUsageDetector.ItemKind.FLOAT),
        CONSTANT_FLOAT_4("Floats4", "fl4", TreeIcon.CONSTANT_FLOAT_4, ABCSimpleUsageDetector.ItemKind.FLOAT4),
        CONSTANT_STRING("Strings", "str", TreeIcon.CONSTANT_STRING, ABCSimpleUsageDetector.ItemKind.STRING),
        CONSTANT_NAMESPACE("Namespaces", "ns", TreeIcon.CONSTANT_NAMESPACE, ABCSimpleUsageDetector.ItemKind.NAMESPACE),
        CONSTANT_NAMESPACE_SET("NamespaceSets", "nss", TreeIcon.CONSTANT_NAMESPACE_SET, ABCSimpleUsageDetector.ItemKind.NAMESPACESET),
        CONSTANT_MULTINAME("Multinames", "mn", TreeIcon.CONSTANT_MULTINAME, ABCSimpleUsageDetector.ItemKind.MULTINAME),
        METHOD_INFO("MethodInfos", "mi", TreeIcon.METHOD_INFO, ABCSimpleUsageDetector.ItemKind.METHODINFO),
        METADATA_INFO("MetadataInfos", "md", TreeIcon.METADATA_INFO, ABCSimpleUsageDetector.ItemKind.METADATAINFO),
        INSTANCE_INFO("InstanceInfos", "ii", TreeIcon.INSTANCE_INFO, ABCSimpleUsageDetector.ItemKind.CLASS),
        CLASS_INFO("ClassInfos", "ci", TreeIcon.CLASS_INFO, ABCSimpleUsageDetector.ItemKind.CLASS),
        SCRIPT_INFO("ScriptInfos", "si", TreeIcon.SCRIPT_INFO, null),
        METHOD_BODY("MethodBodys", "mb", TreeIcon.METHOD_BODY, ABCSimpleUsageDetector.ItemKind.METHODBODY);

        private final String name;
        private final String abbreviation;
        private final TreeIcon icon;
        private final ABCSimpleUsageDetector.ItemKind usageKind;

        private TreeType(String name, String abbreviation, TreeIcon icon, ABCSimpleUsageDetector.ItemKind usageKind) {
            this.name = name;
            this.abbreviation = abbreviation;
            this.icon = icon;
            this.usageKind = usageKind;
        }

        public String getName() {
            return this.name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public TreeIcon getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.name;
        }

        public ABCSimpleUsageDetector.ItemKind getUsageKind() {
            return this.usageKind;
        }
    }

    private static enum TreeIcon {
        CONSTANT_INT("abcint16"),
        CONSTANT_UINT("abcuint16"),
        CONSTANT_DOUBLE("abcdouble16"),
        CONSTANT_DECIMAL("abcdecimal16"),
        CONSTANT_FLOAT("abcfloat16"),
        CONSTANT_FLOAT_4("abcfloat416"),
        CONSTANT_STRING("abcstring16"),
        CONSTANT_NAMESPACE("abcnamespace16"),
        CONSTANT_NAMESPACE_SET("abcnamespaceset16"),
        CONSTANT_MULTINAME("abcmultiname16"),
        METHOD_INFO("abcmethodinfo16"),
        METADATA_INFO("abcmetadata16"),
        INSTANCE_INFO("abcinstanceinfo16"),
        CLASS_INFO("abcclassinfo16"),
        SCRIPT_INFO("abcscriptinfo16"),
        METHOD_BODY("abcmethodbody16"),
        TRAIT_METADATA("folder16"),
        METADATA_PAIRS("folder16"),
        METADATA_PAIRS_SUB(""),
        TRAITS("abctraits16"),
        TRAITS_SUB(""),
        TRAIT_SLOT("variable"),
        TRAIT_CONST("constant"),
        TRAIT_CLASS("asclass16"),
        TRAIT_METHOD("function"),
        TRAIT_GETTER("function"),
        TRAIT_SETTER("function"),
        TRAIT_FUNCTION("function"),
        PARAM_TYPES(""),
        OPTIONAL("folder16"),
        OPTIONAL_SUB(""),
        PARAM_NAMES("folder16"),
        EXCEPTIONS("folder16"),
        EXCEPTIONS_SUB("abcexception16"),
        INTERFACES("asinterface16"),
        KIND("abcbulletblue16"),
        FLAGS("abcflags16"),
        SLOT_ID(""),
        VALUE_INDEX(""),
        VALUE_KIND(""),
        DISP_ID(""),
        MAX_STACK(""),
        MAX_REGS(""),
        INIT_SCOPE_DEPTH(""),
        MAX_SCOPE_DEPTH(""),
        CODE("abccode16"),
        EXCEPTION_START(""),
        EXCEPTION_END(""),
        EXCEPTION_TARGET("");

        private final String DEFAULT_FILE = "abcbulletgray16";
        private String file;

        private TreeIcon(String file) {
            this.file = file;
        }

        public String getFile() {
            if (this.file.isEmpty()) {
                return "abcbulletgray16";
            }
            return this.file;
        }
    }

    private class ValueWithIndex
    implements HasIcon {
        private final Object parent;
        private final int index;
        private final int currentLevelIndex;
        private final TreeType type;
        private final Object value;
        private final String description;
        private final String title;

        public ValueWithIndex(Object parent, int currentLevelIndex, int index, TreeType type, Object value, String description) {
            this.parent = parent;
            this.currentLevelIndex = currentLevelIndex;
            this.index = index;
            this.type = type;
            this.value = value;
            this.description = description;
            this.title = "";
        }

        public ValueWithIndex(Object parent, int currentLevelIndex, int index, TreeType type, Object value, String description, String title) {
            this.parent = parent;
            this.currentLevelIndex = currentLevelIndex;
            this.index = index;
            this.type = type;
            this.value = value;
            this.description = description;
            this.title = title;
        }

        public Object getRawValue() {
            return this.value;
        }

        public int getCurrentLevelIndex() {
            return this.currentLevelIndex;
        }

        public Object getParent() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        public TreeType getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            boolean implicit = false;
            if (this.index == 0) {
                switch (this.type.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        implicit = true;
                    }
                }
            }
            return (!this.title.isEmpty() ? this.title + ": " : "") + (implicit ? "[" : "") + this.type.getAbbreviation() + this.index + (implicit ? "]" : "") + ": " + this.description;
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + Objects.hashCode(this.parent);
            hash = 31 * hash + this.currentLevelIndex;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueWithIndex other = (ValueWithIndex)obj;
            if (this.currentLevelIndex != other.currentLevelIndex) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }

        @Override
        public TreeIcon getIcon() {
            return this.type.getIcon();
        }
    }

    private class SubValue
    implements HasIcon {
        private final int currentLevelIndex;
        private final Object parent;
        private final Object parentValue;
        private final String property;
        private final String title;
        private final int index;
        private final TreeIcon icon;
        private final String description;

        public SubValue(Object parent, int currentLevelIndex, Object parentValue, String property, String title, String description, TreeIcon icon) {
            this.currentLevelIndex = currentLevelIndex;
            this.parent = parent;
            this.parentValue = parentValue;
            this.property = property;
            this.title = title;
            this.index = -1;
            this.icon = icon;
            this.description = description;
        }

        public SubValue(Object parent, int currentLevelIndex, int index, Object parentValue, String property, String title, String description, TreeIcon icon) {
            this.currentLevelIndex = currentLevelIndex;
            this.index = index;
            this.parent = parent;
            this.parentValue = parentValue;
            this.property = property;
            this.title = title;
            this.icon = icon;
            this.description = description;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCurrentLevelIndex() {
            return this.currentLevelIndex;
        }

        public String toString() {
            return this.title + (!this.description.isEmpty() ? ": " + this.description : "");
        }

        public Object getParent() {
            return this.parent;
        }

        public Object getParentValue() {
            return this.parentValue;
        }

        public String getProperty() {
            return this.property;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.currentLevelIndex;
            hash = 41 * hash + Objects.hashCode(this.parent);
            hash = 41 * hash + Objects.hashCode(this.property);
            hash = 41 * hash + this.index;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubValue other = (SubValue)obj;
            if (this.currentLevelIndex != other.currentLevelIndex) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            if (!Objects.equals(this.property, other.property)) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }

        @Override
        public TreeIcon getIcon() {
            return this.icon;
        }
    }

    private class SimpleValue
    implements HasIcon {
        private final int currentLevelIndex;
        private final Object parent;
        private final String title;
        private final TreeIcon icon;
        private final String value;

        public SimpleValue(Object parent, int currentLevelIndex, String title, String value, TreeIcon icon) {
            this.currentLevelIndex = currentLevelIndex;
            this.parent = parent;
            this.title = title;
            this.icon = icon;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public TreeIcon getIcon() {
            return this.icon;
        }

        public int getCurrentLevelIndex() {
            return this.currentLevelIndex;
        }

        public Object getParent() {
            return this.parent;
        }

        public String toString() {
            return this.title + (!this.value.isEmpty() ? ": " + this.value : "");
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + this.currentLevelIndex;
            hash = 47 * hash + Objects.hashCode(this.parent);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleValue other = (SimpleValue)obj;
            if (this.currentLevelIndex != other.currentLevelIndex) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }
    }

    private class ExplorerTreeModel
    implements TreeModel {
        private TreeType type;
        private ABC abc;

        public ExplorerTreeModel(ABC abc, TreeType type) {
            this.type = type;
            this.abc = abc;
        }

        @Override
        public Object getRoot() {
            return this.type;
        }

        private ValueWithIndex createValueWithIndex(Object parent, int currentLevelIndex, int index, TreeType valueType, String title) {
            if (index == 0) {
                switch (valueType.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "null", title);
                    }
                }
            }
            switch (valueType.ordinal()) {
                case 0: {
                    if (index >= this.abc.constants.getIntCount()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getInt(index), "" + this.abc.constants.getInt(index), title);
                }
                case 1: {
                    if (index >= this.abc.constants.getUIntCount()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getUInt(index), "" + this.abc.constants.getUInt(index), title);
                }
                case 2: {
                    if (index >= this.abc.constants.getDoubleCount()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getDouble(index), EcmaScript.toString((Object)this.abc.constants.getDouble(index)), title);
                }
                case 3: {
                    if (index >= this.abc.constants.getDecimalCount()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getDecimal(index), "" + this.abc.constants.getDecimal(index), title);
                }
                case 4: {
                    if (index >= this.abc.constants.getFloatCount()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getFloat(index), EcmaScript.toString((Object)this.abc.constants.getFloat(index)), title);
                }
                case 5: {
                    if (index >= this.abc.constants.getFloat4Count()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    Float4 f4 = this.abc.constants.getFloat4(index);
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, f4, EcmaScript.toString((Object)Float.valueOf(f4.values[0])) + " " + EcmaScript.toString((Object)Float.valueOf(f4.values[1])) + " " + EcmaScript.toString((Object)Float.valueOf(f4.values[2])) + " " + EcmaScript.toString((Object)Float.valueOf(f4.values[3])), title);
                }
                case 6: {
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, index < this.abc.constants.getStringCount() ? this.abc.constants.getString(index) : null, this.formatString(index), title);
                }
                case 7: {
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, index < this.abc.constants.getNamespaceCount() ? this.abc.constants.getNamespace(index) : null, Multiname.namespaceToString((AVM2ConstantPool)this.abc.constants, (int)index), title);
                }
                case 8: {
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, this.abc.constants.getNamespaceSet(index), Multiname.namespaceSetToString((AVM2ConstantPool)this.abc.constants, (int)index), title);
                }
                case 9: {
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, index < this.abc.constants.getMultinameCount() ? this.abc.constants.getMultiname(index) : null, index < this.abc.constants.getMultinameCount() ? this.abc.constants.getMultiname(index).toString(this.abc.constants, new ArrayList()) : "Unknown(" + index + ")", title);
                }
                case 10: {
                    if (index >= this.abc.method_info.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    MethodInfo mi = (MethodInfo)this.abc.method_info.get(index);
                    StringBuilder miStrSb = new StringBuilder();
                    miStrSb.append("(");
                    StringBuilderTextWriter miParamStrSbW = new StringBuilderTextWriter(new CodeFormatting(), miStrSb);
                    mi.getParamStr((GraphTextWriter)miParamStrSbW, this.abc.constants, null, this.abc, new ArrayList(), new LinkedHashSet());
                    miStrSb.append("): ");
                    String miReturnType = mi.getReturnTypeRaw(this.abc, this.abc.constants, new ArrayList());
                    miStrSb.append(miReturnType);
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, mi, miStrSb.toString(), title);
                }
                case 15: {
                    if (index >= this.abc.bodies.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    MethodBody b = (MethodBody)this.abc.bodies.get(index);
                    String exceptionsAdd = "";
                    if (b.exceptions.length > 0) {
                        exceptionsAdd = ", " + b.exceptions.length + " exceptions";
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, valueType, b, "mi" + b.method_info + ", " + b.getCodeBytes().length + " bytes code" + exceptionsAdd, title);
                }
                case 12: {
                    if (index >= this.abc.instance_info.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    InstanceInfo ii = (InstanceInfo)this.abc.instance_info.get(index);
                    String iiName = ii.name_index >= this.abc.constants.getMultinameCount() || ii.getName((AVM2ConstantPool)this.abc.constants).namespace_index >= this.abc.constants.getNamespaceCount() ? "" : "\"" + Helper.escapePCodeString((String)ii.getName(this.abc.constants).getNameWithNamespace(new LinkedHashSet(), this.abc, this.abc.constants, false).toRawString()) + "\"";
                    return new ValueWithIndex(parent, currentLevelIndex, index, TreeType.INSTANCE_INFO, ii, iiName + (ii.instance_traits.traits.isEmpty() ? "" : ", " + ii.instance_traits.traits.size() + " traits"), title);
                }
                case 13: {
                    if (index >= this.abc.class_info.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    ClassInfo ci = (ClassInfo)this.abc.class_info.get(index);
                    return new ValueWithIndex(parent, currentLevelIndex, index, TreeType.CLASS_INFO, ci, "mi" + ci.cinit_index + (ci.static_traits.traits.isEmpty() ? "" : ", " + ci.static_traits.traits.size() + " traits"), title);
                }
                case 14: {
                    if (index >= this.abc.script_info.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    ScriptInfo si = (ScriptInfo)this.abc.script_info.get(index);
                    String siName = "";
                    try {
                        DottedChain simplePackName = si.getSimplePackName(this.abc, new LinkedHashSet());
                        if (simplePackName != null) {
                            siName = " (\"" + Helper.escapePCodeString((String)simplePackName.toRawString()) + "\")";
                        }
                    }
                    catch (IndexOutOfBoundsException simplePackName) {
                        // empty catch block
                    }
                    return new ValueWithIndex(parent, currentLevelIndex, index, TreeType.SCRIPT_INFO, si, "mi" + si.init_index + (si.traits.traits.isEmpty() ? "" : ", " + si.traits.traits.size() + " traits") + siName, title);
                }
                case 11: {
                    if (index >= this.abc.metadata_info.size()) {
                        return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "Unknown(" + index + ")", title);
                    }
                    MetadataInfo md = (MetadataInfo)this.abc.metadata_info.get(index);
                    String mdName = this.formatString(md.name_index);
                    mdName = mdName + " (" + md.values.length + " items)";
                    return new ValueWithIndex(parent, currentLevelIndex, index, TreeType.METADATA_INFO, md, mdName);
                }
            }
            return new ValueWithIndex(parent, currentLevelIndex, index, valueType, null, "", title);
        }

        private int handleGetChildCountTrait(SubValue sv, Traits traits) {
            if (sv.getIndex() > -1) {
                Trait t = (Trait)traits.traits.get(sv.getIndex());
                int count = 3;
                if ((t.kindFlags & 4) > 0) {
                    ++count;
                }
                if (t instanceof TraitSlotConst) {
                    TraitSlotConst tsc = (TraitSlotConst)t;
                    if (tsc.value_index == 0) {
                        return count + 3;
                    }
                    return count + 4;
                }
                if (t instanceof TraitMethodGetterSetter) {
                    return count + 2;
                }
                if (t instanceof TraitClass) {
                    return count + 3;
                }
                if (t instanceof TraitFunction) {
                    return count + 2;
                }
            }
            return traits.traits.size();
        }

        private Object handleGetChildTrait(Object parent, int index, Object parentValue, SubValue sv, Traits traits) {
            Trait t;
            if (sv.getIndex() > -1) {
                t = (Trait)traits.traits.get(sv.getIndex());
                int currentIndex = 0;
                switch (index) {
                    case 0: {
                        return this.createValueWithIndex(parent, index, t.name_index, TreeType.CONSTANT_MULTINAME, "name");
                    }
                    case 1: {
                        return new SimpleValue(parent, index, "kind", String.format("0x%02X", t.kindType) + " (" + t.getKindToStr() + ")", TreeIcon.KIND);
                    }
                    case 2: {
                        ArrayList<String> flagList = new ArrayList<String>();
                        if ((t.kindFlags & 1) > 0) {
                            flagList.add("FINAL");
                        }
                        if ((t.kindFlags & 2) > 0) {
                            flagList.add("OVERRIDE");
                        }
                        if ((t.kindFlags & 4) > 0) {
                            flagList.add("METADATA");
                        }
                        if ((t.kindFlags & 8) > 0) {
                            flagList.add("0x8");
                        }
                        return new SimpleValue(parent, index, "kind_flags", String.format("0x%02X", t.kindFlags) + (flagList.isEmpty() ? "" : " (" + String.join((CharSequence)", ", flagList) + ")"), TreeIcon.FLAGS);
                    }
                }
                if (t instanceof TraitSlotConst) {
                    TraitSlotConst tsc = (TraitSlotConst)t;
                    switch (index) {
                        case 3: {
                            return new SimpleValue(parent, index, "slot_id", "" + tsc.slot_id, TreeIcon.SLOT_ID);
                        }
                        case 4: {
                            return this.createValueWithIndex(parent, index, tsc.type_index, TreeType.CONSTANT_MULTINAME, "type");
                        }
                        case 5: {
                            if (tsc.value_index == 0) {
                                return new SimpleValue(parent, index, "value_index", "null", TreeIcon.VALUE_INDEX);
                            }
                            switch (tsc.value_kind) {
                                case 3: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_INT, "value_index");
                                }
                                case 4: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_UINT, "value_index");
                                }
                                case 6: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_DOUBLE, "value_index");
                                }
                                case 2: {
                                    if (this.abc.hasDecimalSupport()) {
                                        return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_DECIMAL, "value_index");
                                    }
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_FLOAT, "value_index");
                                }
                                case 30: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_FLOAT_4, "value_index");
                                }
                                case 1: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_STRING, "value_index");
                                }
                                case 0: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    return new SimpleValue(parent, index, "value_index", "" + tsc.value_index, TreeIcon.VALUE_INDEX);
                                }
                                case 5: 
                                case 8: 
                                case 23: 
                                case 24: 
                                case 25: 
                                case 26: {
                                    return this.createValueWithIndex(parent, index, tsc.value_index, TreeType.CONSTANT_NAMESPACE, "value_index");
                                }
                            }
                        }
                        case 6: {
                            switch (tsc.value_kind) {
                                case 3: {
                                    return new SimpleValue(parent, index, "value_kind", "Integer", TreeIcon.VALUE_KIND);
                                }
                                case 4: {
                                    return new SimpleValue(parent, index, "value_kind", "UInteger", TreeIcon.VALUE_KIND);
                                }
                                case 6: {
                                    return new SimpleValue(parent, index, "value_kind", "Double", TreeIcon.VALUE_KIND);
                                }
                                case 2: {
                                    if (this.abc.hasDecimalSupport()) {
                                        return new SimpleValue(parent, index, "value_kind", "Decimal", TreeIcon.VALUE_KIND);
                                    }
                                    return new SimpleValue(parent, index, "value_kind", "Float", TreeIcon.VALUE_KIND);
                                }
                                case 30: {
                                    return new SimpleValue(parent, index, "value_kind", "Float4", TreeIcon.VALUE_KIND);
                                }
                                case 1: {
                                    return new SimpleValue(parent, index, "value_kind", "String", TreeIcon.VALUE_KIND);
                                }
                                case 11: {
                                    return new SimpleValue(parent, index, "value_kind", "True", TreeIcon.VALUE_KIND);
                                }
                                case 10: {
                                    return new SimpleValue(parent, index, "value_kind", "False", TreeIcon.VALUE_KIND);
                                }
                                case 12: {
                                    return new SimpleValue(parent, index, "value_kind", "Null", TreeIcon.VALUE_KIND);
                                }
                                case 0: {
                                    return new SimpleValue(parent, index, "value_kind", "Undefined", TreeIcon.VALUE_KIND);
                                }
                                case 8: {
                                    return new SimpleValue(parent, index, "value_kind", "Namespace", TreeIcon.VALUE_KIND);
                                }
                                case 23: {
                                    return new SimpleValue(parent, index, "value_kind", "PackageInternalNs", TreeIcon.VALUE_KIND);
                                }
                                case 24: {
                                    return new SimpleValue(parent, index, "value_kind", "ProtectedNamespace", TreeIcon.VALUE_KIND);
                                }
                                case 25: {
                                    return new SimpleValue(parent, index, "value_kind", "ExplicitNamespace", TreeIcon.VALUE_KIND);
                                }
                                case 26: {
                                    return new SimpleValue(parent, index, "value_kind", "StaticProtectedNs", TreeIcon.VALUE_KIND);
                                }
                                case 5: {
                                    return new SimpleValue(parent, index, "value_kind", "PrivateNamespace", TreeIcon.VALUE_KIND);
                                }
                            }
                        }
                    }
                    currentIndex = 7;
                }
                if (t instanceof TraitMethodGetterSetter) {
                    TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
                    switch (index) {
                        case 3: {
                            return new SimpleValue(parent, index, "disp_id", "" + tmgs.disp_id, TreeIcon.DISP_ID);
                        }
                        case 4: {
                            return this.createValueWithIndex(parent, index, tmgs.method_info, TreeType.METHOD_INFO, "method_info");
                        }
                    }
                    currentIndex = 5;
                }
                if (t instanceof TraitClass) {
                    TraitClass tc = (TraitClass)t;
                    switch (index) {
                        case 3: {
                            return new SimpleValue(parent, index, "slot_id", "" + tc.slot_id, TreeIcon.SLOT_ID);
                        }
                        case 4: {
                            return this.createValueWithIndex(parent, index, tc.class_info, TreeType.INSTANCE_INFO, "instance_info");
                        }
                        case 5: {
                            return this.createValueWithIndex(parent, index, tc.class_info, TreeType.CLASS_INFO, "class_info");
                        }
                    }
                    currentIndex = 6;
                }
                if (t instanceof TraitFunction) {
                    TraitFunction tf = (TraitFunction)t;
                    switch (index) {
                        case 3: {
                            return new SimpleValue(parent, index, "slot_id", "" + tf.slot_id, TreeIcon.SLOT_ID);
                        }
                        case 4: {
                            return this.createValueWithIndex(parent, index, tf.method_info, TreeType.METHOD_INFO, "method_index");
                        }
                    }
                    currentIndex = 5;
                }
                if (index == currentIndex && (t.kindFlags & 4) > 0) {
                    return new SubValue(parent, currentIndex, t, "metadata", "metadata", "", TreeIcon.TRAIT_METADATA);
                }
            }
            t = (Trait)traits.traits.get(index);
            String traitName = this.formatString(t.getName((ABC)this.abc).name_index);
            TreeIcon icon = TreeIcon.TRAITS_SUB;
            switch (t.kindType) {
                case 4: {
                    icon = TreeIcon.TRAIT_CLASS;
                    break;
                }
                case 6: {
                    icon = TreeIcon.TRAIT_CONST;
                    break;
                }
                case 5: {
                    icon = TreeIcon.TRAIT_FUNCTION;
                    break;
                }
                case 2: {
                    icon = TreeIcon.TRAIT_GETTER;
                    break;
                }
                case 1: {
                    icon = TreeIcon.TRAIT_METHOD;
                    break;
                }
                case 3: {
                    icon = TreeIcon.TRAIT_SETTER;
                    break;
                }
                case 0: {
                    icon = TreeIcon.TRAIT_SLOT;
                }
            }
            return new SubValue(parent, index, index, parentValue, "traits", "t" + index, t.getKindToStr() + ": " + traitName, icon);
        }

        private String formatString(int index) {
            if (index == 0) {
                return "null";
            }
            if (index >= this.abc.constants.getStringCount()) {
                return "Unknown(" + index + ")";
            }
            return "\"" + Helper.escapePCodeString((String)this.abc.constants.getString(index)) + "\"";
        }

        @Override
        public Object getChild(Object parent, int index) {
            try {
                MetadataInfo md;
                ClassInfo ci;
                InstanceInfo ii;
                MethodBody body;
                MethodInfo mi;
                if (parent == this.type) {
                    return this.createValueWithIndex(parent, index, index, this.type, "");
                }
                if (parent instanceof ValueWithIndex) {
                    int currentIndex;
                    ValueWithIndex vwi = (ValueWithIndex)parent;
                    if (vwi.value instanceof NamespaceSet) {
                        NamespaceSet nss = (NamespaceSet)vwi.value;
                        int ns = nss.namespaces[index];
                        return new ValueWithIndex(parent, index, ns, TreeType.CONSTANT_NAMESPACE, this.abc.constants.getNamespace(ns), Multiname.namespaceToString((AVM2ConstantPool)this.abc.constants, (int)ns));
                    }
                    if (vwi.value instanceof Namespace) {
                        Namespace ns = (Namespace)vwi.value;
                        switch (index) {
                            case 0: {
                                return new SimpleValue(parent, index, "kind", Namespace.kindToStr((int)ns.kind), TreeIcon.KIND);
                            }
                            case 1: {
                                return this.createValueWithIndex(parent, index, ns.name_index, TreeType.CONSTANT_STRING, "name");
                            }
                        }
                    }
                    if (vwi.value instanceof Multiname) {
                        Multiname m = (Multiname)vwi.value;
                        if (index == 0) {
                            return new SimpleValue(parent, index, "kind", m.getKindStr(), TreeIcon.KIND);
                        }
                        int kind = m.kind;
                        if (kind == 7 || kind == 13) {
                            switch (index) {
                                case 1: {
                                    return this.createValueWithIndex(parent, index, m.namespace_index, TreeType.CONSTANT_NAMESPACE, "namespace");
                                }
                                case 2: {
                                    return this.createValueWithIndex(parent, index, m.name_index, TreeType.CONSTANT_STRING, "name");
                                }
                            }
                        } else if (kind == 15 || kind == 16) {
                            if (index == 1) {
                                return this.createValueWithIndex(parent, index, m.name_index, TreeType.CONSTANT_STRING, "name");
                            }
                        } else if (kind != 17 && kind != 18) {
                            if (kind == 9 || kind == 14) {
                                switch (index) {
                                    case 1: {
                                        return this.createValueWithIndex(parent, index, m.name_index, TreeType.CONSTANT_STRING, "name");
                                    }
                                    case 2: {
                                        return this.createValueWithIndex(parent, index, m.namespace_set_index, TreeType.CONSTANT_NAMESPACE_SET, "namespace_set");
                                    }
                                }
                            } else if (kind == 27 || kind == 28) {
                                if (index == 1) {
                                    return this.createValueWithIndex(parent, index, m.namespace_set_index, TreeType.CONSTANT_NAMESPACE_SET, "namespace_set");
                                }
                            } else if (kind == 29) {
                                if (index == 1) {
                                    return this.createValueWithIndex(parent, index, m.qname_index, TreeType.CONSTANT_MULTINAME, "qname");
                                }
                                if (index >= 2 && index - 2 < m.params.length) {
                                    return this.createValueWithIndex(parent, index, m.params[index - 2], TreeType.CONSTANT_MULTINAME, "param" + (index - 2));
                                }
                            }
                        }
                    }
                    if (vwi.value instanceof MethodInfo) {
                        int bodyIndex;
                        mi = (MethodInfo)vwi.value;
                        switch (index) {
                            case 0: {
                                return new SubValue(parent, index, mi, "param_types", "param_types", "", TreeIcon.PARAM_TYPES);
                            }
                            case 1: {
                                return this.createValueWithIndex(parent, index, mi.ret_type, TreeType.CONSTANT_MULTINAME, "return_type");
                            }
                            case 2: {
                                return this.createValueWithIndex(parent, index, mi.name_index, TreeType.CONSTANT_STRING, "name");
                            }
                            case 3: {
                                ArrayList<String> flagList = new ArrayList<String>();
                                if (mi.flagNative()) {
                                    flagList.add("NATIVE");
                                }
                                if (mi.flagHas_optional()) {
                                    flagList.add("HAS_OPTIONAL");
                                }
                                if (mi.flagHas_paramnames()) {
                                    flagList.add("HAS_PARAM_NAMES");
                                }
                                if (mi.flagIgnore_rest()) {
                                    flagList.add("IGNORE_REST");
                                }
                                if (mi.flagNeed_activation()) {
                                    flagList.add("NEED_ACTIVATION");
                                }
                                if (mi.flagNeed_arguments()) {
                                    flagList.add("NEED_ARGUMENTS");
                                }
                                if (mi.flagNeed_rest()) {
                                    flagList.add("NEED_REST");
                                }
                                if (mi.flagSetsdxns()) {
                                    flagList.add("SET_DXNS");
                                }
                                return new SimpleValue(parent, index, "flags", String.format("0x%02X", mi.flags) + (!flagList.isEmpty() ? " (" + String.join((CharSequence)", ", flagList) + ")" : ""), TreeIcon.FLAGS);
                            }
                        }
                        currentIndex = 4;
                        if (mi.flagHas_optional()) {
                            if (index == currentIndex) {
                                return new SubValue(parent, index, mi, "optional", "optional", "", TreeIcon.OPTIONAL);
                            }
                            ++currentIndex;
                        }
                        if (mi.flagHas_paramnames()) {
                            if (index == currentIndex) {
                                return new SubValue(parent, index, mi, "param_names", "param_names", "", TreeIcon.PARAM_NAMES);
                            }
                            ++currentIndex;
                        }
                        if (index == currentIndex && (bodyIndex = this.abc.findBodyIndex(vwi.getIndex())) != -1) {
                            return this.createValueWithIndex(parent, index, bodyIndex, TreeType.METHOD_BODY, "method_body");
                        }
                    }
                    if (vwi.value instanceof MethodBody) {
                        body = (MethodBody)vwi.value;
                        switch (index) {
                            case 0: {
                                return this.createValueWithIndex(parent, index, body.method_info, TreeType.METHOD_INFO, "method_info");
                            }
                            case 1: {
                                return new SimpleValue(parent, index, "max_stack", "" + body.max_stack, TreeIcon.MAX_STACK);
                            }
                            case 2: {
                                return new SimpleValue(parent, index, "max_regs", "" + body.max_regs, TreeIcon.MAX_REGS);
                            }
                            case 3: {
                                return new SimpleValue(parent, index, "init_scope_depth", "" + body.init_scope_depth, TreeIcon.INIT_SCOPE_DEPTH);
                            }
                            case 4: {
                                return new SimpleValue(parent, index, "max_scope_depth", "" + body.max_scope_depth, TreeIcon.MAX_SCOPE_DEPTH);
                            }
                            case 5: {
                                return new SimpleValue(parent, index, "code", "" + body.getCodeBytes().length + " bytes", TreeIcon.CODE);
                            }
                            case 6: {
                                return new SubValue(parent, index, body, "exceptions", "exceptions", "", TreeIcon.EXCEPTIONS);
                            }
                            case 7: {
                                return new SubValue(parent, index, body, "traits", "traits", "", TreeIcon.TRAITS);
                            }
                        }
                    }
                    if (vwi.value instanceof InstanceInfo) {
                        ii = (InstanceInfo)vwi.value;
                        switch (index) {
                            case 0: {
                                return this.createValueWithIndex(parent, index, ii.name_index, TreeType.CONSTANT_MULTINAME, "name");
                            }
                            case 1: {
                                return this.createValueWithIndex(parent, index, ii.super_index, TreeType.CONSTANT_MULTINAME, "super");
                            }
                            case 2: {
                                ArrayList<String> flagList = new ArrayList<String>();
                                if ((ii.flags & 1) == 1) {
                                    flagList.add("SEALED");
                                }
                                if ((ii.flags & 2) == 2) {
                                    flagList.add("FINAL");
                                }
                                if ((ii.flags & 4) == 4) {
                                    flagList.add("INTERFACE");
                                }
                                if ((ii.flags & 8) == 8) {
                                    flagList.add("PROTECTEDNS");
                                }
                                if ((ii.flags & 0x10) == 16) {
                                    flagList.add("NON_NULLABLE");
                                }
                                return new SimpleValue(parent, index, "flags", String.format("0x%02X", ii.flags) + (!flagList.isEmpty() ? " (" + String.join((CharSequence)", ", flagList) + ")" : ""), TreeIcon.FLAGS);
                            }
                        }
                        currentIndex = 3;
                        if ((ii.flags & 8) == 8) {
                            if (index == currentIndex) {
                                return this.createValueWithIndex(parent, index, ii.protectedNS, TreeType.CONSTANT_NAMESPACE, "protected_ns");
                            }
                            ++currentIndex;
                        }
                        if (index == currentIndex) {
                            return new SubValue(parent, index, ii, "interfaces", "interfaces", "", TreeIcon.INTERFACES);
                        }
                        if (index == ++currentIndex) {
                            return this.createValueWithIndex(parent, currentIndex, ii.iinit_index, TreeType.METHOD_INFO, "iinit");
                        }
                        if (index == ++currentIndex) {
                            return new SubValue(parent, index, ii, "traits", "traits", "", TreeIcon.TRAITS);
                        }
                    }
                    if (vwi.value instanceof ClassInfo) {
                        ci = (ClassInfo)vwi.value;
                        switch (index) {
                            case 0: {
                                return this.createValueWithIndex(parent, index, ci.cinit_index, TreeType.METHOD_INFO, "cinit");
                            }
                            case 1: {
                                return new SubValue(parent, index, ci, "traits", "traits", "", TreeIcon.TRAITS);
                            }
                        }
                    }
                    if (vwi.value instanceof ScriptInfo) {
                        ScriptInfo si = (ScriptInfo)vwi.value;
                        switch (index) {
                            case 0: {
                                return this.createValueWithIndex(parent, index, si.init_index, TreeType.METHOD_INFO, "init");
                            }
                            case 1: {
                                return new SubValue(parent, index, si, "traits", "traits", "", TreeIcon.TRAITS);
                            }
                        }
                    }
                    if (vwi.value instanceof MetadataInfo) {
                        md = (MetadataInfo)vwi.value;
                        switch (index) {
                            case 0: {
                                return this.createValueWithIndex(parent, index, md.name_index, TreeType.CONSTANT_STRING, "name");
                            }
                            case 1: {
                                return new SubValue(parent, index, md, "pairs", "pairs", "", TreeIcon.METADATA_PAIRS);
                            }
                        }
                    }
                }
                if (parent instanceof SubValue) {
                    SubValue sv = (SubValue)parent;
                    if (sv.getParentValue() instanceof MethodInfo) {
                        mi = (MethodInfo)sv.getParentValue();
                        block51 : switch (sv.getProperty()) {
                            case "param_types": {
                                return this.createValueWithIndex(parent, index, mi.param_types[index], TreeType.CONSTANT_MULTINAME, "pt" + index);
                            }
                            case "optional": {
                                if (sv.getIndex() > -1) {
                                    if (index == 0) {
                                        switch (mi.optional[sv.getIndex()].value_kind) {
                                            case 3: {
                                                return new SimpleValue(parent, index, "value_kind", "Integer", TreeIcon.VALUE_KIND);
                                            }
                                            case 4: {
                                                return new SimpleValue(parent, index, "value_kind", "UInteger", TreeIcon.VALUE_KIND);
                                            }
                                            case 6: {
                                                return new SimpleValue(parent, index, "value_kind", "Double", TreeIcon.VALUE_KIND);
                                            }
                                            case 2: {
                                                if (this.abc.hasDecimalSupport()) {
                                                    return new SimpleValue(parent, index, "value_kind", "Decimal", TreeIcon.VALUE_KIND);
                                                }
                                                return new SimpleValue(parent, index, "value_kind", "Float", TreeIcon.VALUE_KIND);
                                            }
                                            case 30: {
                                                return new SimpleValue(parent, index, "value_kind", "Float4", TreeIcon.VALUE_KIND);
                                            }
                                            case 1: {
                                                return new SimpleValue(parent, index, "value_kind", "String", TreeIcon.VALUE_KIND);
                                            }
                                            case 11: {
                                                return new SimpleValue(parent, index, "value_kind", "True", TreeIcon.VALUE_KIND);
                                            }
                                            case 10: {
                                                return new SimpleValue(parent, index, "value_kind", "False", TreeIcon.VALUE_KIND);
                                            }
                                            case 12: {
                                                return new SimpleValue(parent, index, "value_kind", "Null", TreeIcon.VALUE_KIND);
                                            }
                                            case 0: {
                                                return new SimpleValue(parent, index, "value_kind", "Undefined", TreeIcon.VALUE_KIND);
                                            }
                                            case 8: {
                                                return new SimpleValue(parent, index, "value_kind", "Namespace", TreeIcon.VALUE_KIND);
                                            }
                                            case 23: {
                                                return new SimpleValue(parent, index, "value_kind", "PackageInternalNs", TreeIcon.VALUE_KIND);
                                            }
                                            case 24: {
                                                return new SimpleValue(parent, index, "value_kind", "ProtectedNamespace", TreeIcon.VALUE_KIND);
                                            }
                                            case 25: {
                                                return new SimpleValue(parent, index, "value_kind", "ExplicitNamespace", TreeIcon.VALUE_KIND);
                                            }
                                            case 26: {
                                                return new SimpleValue(parent, index, "value_kind", "StaticProtectedNs", TreeIcon.VALUE_KIND);
                                            }
                                            case 5: {
                                                return new SimpleValue(parent, index, "value_kind", "PrivateNamespace", TreeIcon.VALUE_KIND);
                                            }
                                        }
                                    }
                                    if (index != 1) break;
                                    int value_index = mi.optional[sv.getIndex()].value_index;
                                    switch (mi.optional[sv.getIndex()].value_kind) {
                                        case 3: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_INT, "value_index");
                                        }
                                        case 4: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_UINT, "value_index");
                                        }
                                        case 6: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_DOUBLE, "value_index");
                                        }
                                        case 2: {
                                            if (this.abc.hasDecimalSupport()) {
                                                return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_DECIMAL, "value_index");
                                            }
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_FLOAT, "value_index");
                                        }
                                        case 30: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_FLOAT_4, "value_index");
                                        }
                                        case 1: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_STRING, "value_index");
                                        }
                                        case 11: {
                                            break block51;
                                        }
                                        case 10: {
                                            break block51;
                                        }
                                        case 12: {
                                            break block51;
                                        }
                                        case 0: {
                                            break block51;
                                        }
                                        case 5: 
                                        case 8: 
                                        case 23: 
                                        case 24: 
                                        case 25: 
                                        case 26: {
                                            return this.createValueWithIndex(parent, index, value_index, TreeType.CONSTANT_NAMESPACE, "value_index");
                                        }
                                    }
                                    break;
                                }
                                return new SubValue(parent, index, index, mi, "optional", "op" + index, mi.optional[index].toASMString(this.abc), TreeIcon.OPTIONAL_SUB);
                            }
                            case "param_names": {
                                return this.createValueWithIndex(parent, index, mi.paramNames[index], TreeType.CONSTANT_STRING, "pn" + index);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof MethodBody) {
                        body = (MethodBody)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "exceptions": {
                                if (sv.getIndex() > -1) {
                                    ABCException ex = body.exceptions[sv.getIndex()];
                                    switch (index) {
                                        case 0: {
                                            return new SimpleValue(parent, index, "start", "" + ex.start, TreeIcon.EXCEPTION_START);
                                        }
                                        case 1: {
                                            return new SimpleValue(parent, index, "end", "" + ex.end, TreeIcon.EXCEPTION_END);
                                        }
                                        case 2: {
                                            return new SimpleValue(parent, index, "target", "" + ex.target, TreeIcon.EXCEPTION_TARGET);
                                        }
                                        case 3: {
                                            return this.createValueWithIndex(parent, index, ex.name_index, TreeType.CONSTANT_MULTINAME, "name");
                                        }
                                        case 4: {
                                            return this.createValueWithIndex(parent, index, ex.type_index, TreeType.CONSTANT_MULTINAME, "type");
                                        }
                                    }
                                } else {
                                    return new SubValue(parent, index, index, body, "exceptions", "ex" + index, "", TreeIcon.EXCEPTIONS_SUB);
                                }
                            }
                            case "traits": {
                                return this.handleGetChildTrait(parent, index, body, sv, body.traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof InstanceInfo) {
                        ii = (InstanceInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "interfaces": {
                                return this.createValueWithIndex(parent, index, ii.interfaces[index], TreeType.CONSTANT_MULTINAME, "in" + index);
                            }
                            case "traits": {
                                return this.handleGetChildTrait(parent, index, ii, sv, ii.instance_traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof ClassInfo) {
                        ci = (ClassInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "traits": {
                                return this.handleGetChildTrait(parent, index, ci, sv, ci.static_traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof ScriptInfo) {
                        ci = (ScriptInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "traits": {
                                return this.handleGetChildTrait(parent, index, ci, sv, ci.traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof MetadataInfo) {
                        md = (MetadataInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "pairs": {
                                if (sv.getIndex() > -1) {
                                    switch (index) {
                                        case 0: {
                                            return this.createValueWithIndex(parent, index, md.keys[sv.getIndex()], TreeType.CONSTANT_STRING, "key");
                                        }
                                        case 1: {
                                            return this.createValueWithIndex(parent, index, md.values[sv.getIndex()], TreeType.CONSTANT_STRING, "value");
                                        }
                                    }
                                    return null;
                                }
                                String pairTitle = this.formatString(md.keys[index]) + " : " + this.formatString(md.values[index]);
                                return new SubValue(parent, index, index, md, "pairs", "p" + index, pairTitle, TreeIcon.METADATA_PAIRS_SUB);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof Trait) {
                        Trait t = (Trait)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "metadata": {
                                return this.createValueWithIndex(parent, index, t.metadata[index], TreeType.METADATA_INFO, "");
                            }
                        }
                    }
                }
                return null;
            }
            catch (IndexOutOfBoundsException iex) {
                return "";
            }
        }

        @Override
        public int getChildCount(Object parent) {
            try {
                MetadataInfo md;
                InstanceInfo ii;
                MethodInfo mi;
                if (parent == this.type) {
                    switch (this.type.ordinal()) {
                        case 0: {
                            return Math.max(1, this.abc.constants.getIntCount());
                        }
                        case 1: {
                            return Math.max(1, this.abc.constants.getUIntCount());
                        }
                        case 2: {
                            return Math.max(1, this.abc.constants.getDoubleCount());
                        }
                        case 3: {
                            return Math.max(1, this.abc.constants.getDecimalCount());
                        }
                        case 4: {
                            return Math.max(1, this.abc.constants.getFloatCount());
                        }
                        case 5: {
                            return Math.max(1, this.abc.constants.getFloat4Count());
                        }
                        case 6: {
                            return Math.max(1, this.abc.constants.getStringCount());
                        }
                        case 7: {
                            return Math.max(1, this.abc.constants.getNamespaceCount());
                        }
                        case 8: {
                            return this.abc.constants.getNamespaceSetCount();
                        }
                        case 9: {
                            return Math.max(1, this.abc.constants.getMultinameCount());
                        }
                        case 10: {
                            return this.abc.method_info.size();
                        }
                        case 11: {
                            return this.abc.metadata_info.size();
                        }
                        case 12: {
                            return this.abc.instance_info.size();
                        }
                        case 13: {
                            return this.abc.class_info.size();
                        }
                        case 14: {
                            return this.abc.script_info.size();
                        }
                        case 15: {
                            return this.abc.bodies.size();
                        }
                    }
                }
                if (parent instanceof ValueWithIndex) {
                    ValueWithIndex vwi = (ValueWithIndex)parent;
                    if (vwi.value instanceof NamespaceSet) {
                        NamespaceSet nss = (NamespaceSet)vwi.value;
                        return nss.namespaces.length;
                    }
                    if (vwi.value instanceof Namespace) {
                        return 2;
                    }
                    if (vwi.value instanceof Multiname) {
                        Multiname m = (Multiname)vwi.value;
                        int kind = m.kind;
                        if (kind == 7 || kind == 13) {
                            return 3;
                        }
                        if (kind == 15 || kind == 16) {
                            return 2;
                        }
                        if (kind == 17 || kind == 18) {
                            return 1;
                        }
                        if (kind == 9 || kind == 14) {
                            return 3;
                        }
                        if (kind == 27 || kind == 28) {
                            return 2;
                        }
                        if (kind == 29) {
                            return 2 + m.params.length;
                        }
                    }
                    if (vwi.value instanceof MethodInfo) {
                        int bodyIndex;
                        mi = (MethodInfo)vwi.value;
                        int count = 4;
                        if (mi.flagHas_optional()) {
                            ++count;
                        }
                        if (mi.flagHas_paramnames()) {
                            ++count;
                        }
                        if ((bodyIndex = this.abc.findBodyIndex(vwi.getIndex())) != -1) {
                            ++count;
                        }
                        return count;
                    }
                    if (vwi.value instanceof MethodBody) {
                        return 8;
                    }
                    if (vwi.value instanceof InstanceInfo) {
                        ii = (InstanceInfo)vwi.value;
                        if ((ii.flags & 8) == 8) {
                            return 7;
                        }
                        return 6;
                    }
                    if (vwi.value instanceof ClassInfo) {
                        return 2;
                    }
                    if (vwi.value instanceof ScriptInfo) {
                        return 2;
                    }
                    if (vwi.value instanceof MetadataInfo) {
                        md = (MetadataInfo)vwi.value;
                        return 2;
                    }
                }
                if (parent instanceof SubValue) {
                    ClassInfo ci;
                    SubValue sv = (SubValue)parent;
                    if (sv.getParentValue() instanceof MethodInfo) {
                        mi = (MethodInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "param_types": {
                                return mi.param_types.length;
                            }
                            case "optional": {
                                if (sv.getIndex() > -1) {
                                    int index = sv.getIndex();
                                    int value_index = mi.optional[index].value_index;
                                    switch (mi.optional[index].value_kind) {
                                        case 0: 
                                        case 10: 
                                        case 11: 
                                        case 12: {
                                            return 1;
                                        }
                                        case 1: 
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 8: 
                                        case 23: 
                                        case 24: 
                                        case 25: 
                                        case 26: 
                                        case 30: {
                                            return 2;
                                        }
                                    }
                                    return 0;
                                }
                                return mi.optional.length;
                            }
                            case "param_names": {
                                return mi.paramNames.length;
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof MethodBody) {
                        MethodBody body = (MethodBody)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "exceptions": {
                                if (sv.getIndex() > -1) {
                                    return 5;
                                }
                                return body.exceptions.length;
                            }
                            case "traits": {
                                return this.handleGetChildCountTrait(sv, body.traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof InstanceInfo) {
                        ii = (InstanceInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "interfaces": {
                                return ii.interfaces.length;
                            }
                            case "traits": {
                                return this.handleGetChildCountTrait(sv, ii.instance_traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof ClassInfo) {
                        ci = (ClassInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "traits": {
                                return this.handleGetChildCountTrait(sv, ci.static_traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof ScriptInfo) {
                        ci = (ScriptInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "traits": {
                                return this.handleGetChildCountTrait(sv, ci.traits);
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof MetadataInfo) {
                        md = (MetadataInfo)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "pairs": {
                                if (sv.getIndex() > -1) {
                                    return 2;
                                }
                                return md.keys.length;
                            }
                        }
                    }
                    if (sv.getParentValue() instanceof Trait) {
                        Trait t = (Trait)sv.getParentValue();
                        switch (sv.getProperty()) {
                            case "metadata": {
                                return t.metadata.length;
                            }
                        }
                    }
                }
                return 0;
            }
            catch (IndexOutOfBoundsException iex) {
                return 0;
            }
        }

        @Override
        public boolean isLeaf(Object node) {
            try {
                return this.getChildCount(node) == 0;
            }
            catch (IndexOutOfBoundsException iex) {
                return false;
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            HasIcon sv;
            ValueWithIndex vwi;
            if (child instanceof ValueWithIndex && (vwi = (ValueWithIndex)child).getParent() == parent) {
                return vwi.getCurrentLevelIndex();
            }
            if (child instanceof SubValue && ((SubValue)(sv = (SubValue)child)).parent == parent) {
                return ((SubValue)sv).getCurrentLevelIndex();
            }
            if (child instanceof SimpleValue && ((SimpleValue)(sv = (SimpleValue)child)).parent == parent) {
                return ((SimpleValue)sv).getCurrentLevelIndex();
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }

    public static class ExplorerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();
        boolean semiTransparent = false;
        private final ABCExplorerDialog dialog;

        public ExplorerTreeCellRenderer(ABCExplorerDialog dialog) {
            this.setUI(new BasicLabelUI());
            this.setOpaque(false);
            if (View.isOceanic()) {
                this.setBackgroundNonSelectionColor(Color.white);
            }
            this.dialog = dialog;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.semiTransparent && this.getIcon() != null) {
                Color color = this.getBackground();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 2));
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ValueWithIndex vwi;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (View.isOceanic()) {
                this.setForeground(Color.BLACK);
            }
            this.setToolTipText(null);
            if (value instanceof HasIcon) {
                HasIcon hi = (HasIcon)value;
                String iconFile = hi.getIcon().getFile();
                if (!iconFile.isEmpty()) {
                    ImageIcon icon;
                    if (this.iconCache.containsKey(iconFile)) {
                        icon = this.iconCache.get(iconFile);
                    } else {
                        icon = View.getIcon(iconFile);
                        this.iconCache.put(iconFile, icon);
                    }
                    this.setIcon(icon);
                }
            } else {
                this.setIcon(null);
            }
            this.semiTransparent = false;
            if (value instanceof ValueWithIndex && this.dialog.usageDetector != null && (vwi = (ValueWithIndex)value).getType().getUsageKind() != null) {
                List usages = this.dialog.usageDetector.getUsages(vwi.getType().getUsageKind(), vwi.getIndex());
                this.semiTransparent = usages.isEmpty();
            }
            return this;
        }
    }

    private static interface HasIcon {
        public TreeIcon getIcon();
    }
}

