/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ActionScript3SimpleParser;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.multinames.MultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.TraitMultinameUsage;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.decompiler.flash.action.parser.script.ParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.script.SymbolType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebugPanel;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.OpenableListLoaded;
import com.jpexs.decompiler.flash.gui.PopupButton;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.SearchPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.ABCExplorerDialog;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.DetailPanel;
import com.jpexs.decompiler.flash.gui.abc.LinkDialog;
import com.jpexs.decompiler.flash.gui.abc.NewTraitDialog;
import com.jpexs.decompiler.flash.gui.abc.TraitsList;
import com.jpexs.decompiler.flash.gui.abc.UsageFrame;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.editor.VariableMarker;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.importers.FFDecAs3ScriptReplacer;
import com.jpexs.decompiler.flash.search.ABCSearchResult;
import com.jpexs.decompiler.flash.search.ActionScriptSearch;
import com.jpexs.decompiler.flash.search.ScriptSearchListener;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import com.jpexs.decompiler.flash.simpleparser.LinkHandler;
import com.jpexs.decompiler.flash.simpleparser.LinkType;
import com.jpexs.decompiler.flash.simpleparser.Path;
import com.jpexs.decompiler.flash.simpleparser.SimpleParser;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import de.hameister.treetable.MyTreeTable;
import de.hameister.treetable.MyTreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class ABCPanel
extends JPanel
implements ItemListener,
SearchListener<ScriptSearchResult>,
TagEditorPanel {
    private As3ScriptReplacerInterface scriptReplacer = null;
    private ScriptPack pack = null;
    private final MainPanel mainPanel;
    public final TraitsList navigator;
    public ABC abc;
    private final JPanel toolbarPanel;
    private final JComboBox<String> libraryComboBox;
    public final DecompiledEditorPane decompiledTextArea;
    public final JScrollPane decompiledScrollPane;
    private final JPersistentSplitPane splitPane;
    public JComboBox<String> constantTypeList;
    public JLabel asmLabel = new HeaderLabel(AppStrings.translate("panel.disassembled"));
    public JLabel decLabel = new HeaderLabel(AppStrings.translate("panel.decompiled"));
    public final DetailPanel detailPanel;
    public final JPanel navigatorPanel;
    public final JPanel brokenHintPanel;
    public final SearchPanel<ScriptSearchResult> searchPanel;
    private NewTraitDialog newTraitDialog;
    public final JLabel scriptNameLabel;
    private final DebugPanel debugPanel;
    private final JLabel experimentalLabel = new JLabel(AppStrings.translate("action.edit.experimental"));
    private final JLabel flexLabel = new JLabel(AppStrings.translate("action.edit.flex"));
    private final JLabel infoNotEditableLabel;
    private final JButton editDecompiledButton = new JButton(AppStrings.translate("button.edit.script.decompiled"), View.getIcon("edit16"));
    private final JButton saveDecompiledButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    private final JButton cancelDecompiledButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    private String lastDecompiled = null;
    private JLabel linksLabel = new JLabel("");
    private boolean compound = false;

    public MainPanel getMainPanel() {
        View.checkAccess();
        return this.mainPanel;
    }

    public ScriptPack getPack() {
        return this.decompiledTextArea.getScriptLeaf();
    }

    public void setDecompiledEditEnabled(boolean value) {
        this.decompiledTextArea.setEnabled(value);
        this.editDecompiledButton.setEnabled(value && !this.compound);
        this.toolbarPanel.setEnabled(value);
    }

    public List<ABCSearchResult> search(Openable openable, final String txt, boolean ignoreCase, boolean regexp, boolean pcode, final CancellableWorker<Void> worker, List<ScriptPack> scope) {
        if (txt != null && !txt.isEmpty()) {
            this.searchPanel.setOptions(ignoreCase, regexp);
            final String workText = AppStrings.translate("work.searching");
            final String decAdd = AppStrings.translate("work.decompiling");
            return new ActionScriptSearch().searchAs3(openable, txt, ignoreCase, regexp, pcode, new ScriptSearchListener(){
                final /* synthetic */ ABCPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onDecompile(int pos, int total, String name) {
                    Main.startWork(workText + " \"" + txt + "\", " + decAdd + " - (" + pos + "/" + total + ") " + name + "... ", worker);
                }

                public void onSearch(int pos, int total, String name) {
                    Main.startWork(workText + " \"" + txt + "\" - (" + pos + "/" + total + ") " + name + "... ", worker);
                }
            }, scope);
        }
        return null;
    }

    public void setAbc(ABC abc) {
        View.checkAccess();
        if (abc == this.abc) {
            return;
        }
        this.abc = abc;
        if (Main.isSwfAir(abc.getOpenable())) {
            this.libraryComboBox.setSelectedIndex(0);
        } else {
            this.libraryComboBox.setSelectedIndex(1);
        }
        this.decompiledTextArea.setParser((SimpleParser)new ActionScript3SimpleParser(abc));
        this.setDecompiledEditMode(false);
        this.navigator.setAbc(abc);
        this.updateLinksLabel();
    }

    public SWF getSwf() {
        return this.abc == null ? null : this.abc.getSwf();
    }

    public Openable getOpenable() {
        return this.abc == null ? null : this.abc.getOpenable();
    }

    public List<ABCContainerTag> getAbcList() {
        SWF swf = this.getSwf();
        return swf == null ? null : swf.getAbcList();
    }

    public void clearSwf() {
        View.checkAccess();
        this.abc = null;
        this.navigator.clearAbc();
        this.decompiledTextArea.clearScript();
    }

    public static Long varToObjectId(Variable var) {
        if (var == null) {
            return 0L;
        }
        if (var.vType == 3) {
            return (Long)var.value;
        }
        if (var.vType == 5) {
            return (Long)var.value;
        }
        return 0L;
    }

    private void hilightScriptClassTrait(ABC newAbc, int scriptIndex, final int classIndex, final Integer traitIndex) {
        Runnable setTrait = new Runnable(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.decompiledTextArea.removeScriptListener(this);
                this.this$0.decompiledTextArea.setClassIndex(classIndex);
                if (traitIndex != null) {
                    this.this$0.decompiledTextArea.gotoTrait(traitIndex);
                } else {
                    this.this$0.decompiledTextArea.gotoClassHeader();
                }
                Timer tim = new Timer();
                tim.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Main.getMainFrame().getPanel().setLoadingScrollPosEnabled(true);
                    }
                }, 500L);
            }
        };
        Main.getMainFrame().getPanel().setLoadingScrollPosEnabled(false);
        if (this.decompiledTextArea.getScriptIndex() == scriptIndex && (this.decompiledTextArea.getClassIndex() == classIndex || classIndex == -1) && this.abc == newAbc) {
            setTrait.run();
        } else {
            this.decompiledTextArea.addScriptListener(setTrait);
            String scriptName = classIndex > -1 ? ((InstanceInfo)newAbc.instance_info.get(classIndex)).getName(newAbc.constants).getNameWithNamespace(new LinkedHashSet(), newAbc, newAbc.constants, true).toPrintableString(new LinkedHashSet(), newAbc.getSwf(), true) : (scriptIndex > -1 ? ((ScriptInfo)newAbc.script_info.get(classIndex)).getSimplePackName(newAbc, new LinkedHashSet()).toPrintableString(new LinkedHashSet(), newAbc.getSwf(), true) : "");
            this.hilightScript(newAbc.getOpenable(), scriptName);
        }
    }

    public ABCPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        this.decompiledTextArea = new DecompiledEditorPane(this);
        this.decompiledTextArea.addTextChangedListener(this::decompiledTextAreaTextChanged);
        this.decompiledTextArea.setLinkHandler(new LinkHandler(){

            public LinkType getClassLinkType(Path className) {
                AbcIndexing.ClassIndex ci = ABCPanel.this.abc.getSwf().getAbcIndex().findClass((GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, Integer.valueOf(ABCPanel.this.decompiledTextArea.getScriptIndex()));
                if (ci == null) {
                    AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findScriptProperty(DottedChain.parseNoSuffix((String)className.toString()));
                    if (ti == null) {
                        return LinkType.NO_LINK;
                    }
                    if (ti.abc.getSwf() == ABCPanel.this.abc.getSwf()) {
                        if (ti.abc == ABCPanel.this.abc && ti.scriptIndex == ABCPanel.this.decompiledTextArea.getScriptIndex()) {
                            return LinkType.LINK_THIS_SCRIPT;
                        }
                        return LinkType.LINK_OTHER_SCRIPT;
                    }
                    return LinkType.LINK_OTHER_FILE;
                }
                if (ci.abc.getSwf() == ABCPanel.this.abc.getSwf()) {
                    if (ci.abc == ABCPanel.this.abc && ci.scriptIndex != null && ci.scriptIndex.intValue() == ABCPanel.this.decompiledTextArea.getScriptIndex()) {
                        return LinkType.LINK_THIS_SCRIPT;
                    }
                    return LinkType.LINK_OTHER_SCRIPT;
                }
                return LinkType.LINK_OTHER_FILE;
            }

            public boolean traitExists(Path className, String traitName) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                return ti != null;
            }

            public void handleClassLink(Path scriptName) {
                Reference swfRef = new Reference(null);
                AbcIndexing.ClassIndex ci = ABCPanel.this.abc.getSwf().getAbcIndex().findClass((GraphTargetItem)new TypeItem(scriptName.toString()), ABCPanel.this.abc, Integer.valueOf(ABCPanel.this.decompiledTextArea.getScriptIndex()));
                if (ci == null) {
                    AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findScriptProperty(DottedChain.parseNoSuffix((String)scriptName.toString()));
                    if (ti == null) {
                        return;
                    }
                    swfRef.setVal((Object)ti.abc.getSwf());
                } else {
                    swfRef.setVal((Object)ci.abc.getSwf());
                }
                String scriptNamePrintable = DottedChain.parseWithSuffix((String)scriptName.toString()).toPrintableString(new LinkedHashSet(), ci.abc.getSwf(), true);
                if (swfRef.getVal() == ABCPanel.this.abc.getSwf()) {
                    ABCPanel.this.hilightScript(ABCPanel.this.getOpenable(), scriptNamePrintable);
                    return;
                }
                ABCPanel.this.hilightScript((Openable)swfRef.getVal(), scriptNamePrintable);
            }

            public void handleTraitLink(Path className, String traitName) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                if (ti.objType instanceof TypeItem) {
                    AbcIndexing.ClassIndex ci = ABCPanel.this.abc.getSwf().getAbcIndex().findClass(ti.objType, ABCPanel.this.abc, Integer.valueOf(ABCPanel.this.decompiledTextArea.getScriptIndex()));
                    int i = 0;
                    Integer traitIndex = null;
                    for (Trait t : ((ClassInfo)ci.abc.class_info.get((int)ci.index)).static_traits.traits) {
                        if (t == ti.trait) {
                            traitIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (traitIndex == null) {
                        for (Trait t : ((InstanceInfo)ci.abc.instance_info.get((int)ci.index)).instance_traits.traits) {
                            if (t == ti.trait) {
                                traitIndex = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (traitIndex != null) {
                        ABCPanel.this.hilightScriptClassTrait(ti.abc, ti.scriptIndex, ci.index, traitIndex);
                    }
                }
            }

            public Path getTraitType(Path className, String traitName) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                if (ti == null) {
                    return null;
                }
                if (ti.returnType instanceof ApplyTypeAVM2Item) {
                    ApplyTypeAVM2Item at = (ApplyTypeAVM2Item)ti.returnType;
                    return this.typeToPath(at.object);
                }
                return this.typeToPath(ti.returnType);
            }

            private Path typeToPath(GraphTargetItem type) {
                if (type instanceof TypeItem) {
                    TypeItem ti = (TypeItem)type;
                    return new Path(ti.fullTypeName.getStringParts());
                }
                return new Path(Helper.splitString((String)".", (String)type.toString()));
            }

            public Path getTraitSubType(Path className, String traitName, int level) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                if (ti == null) {
                    return null;
                }
                GraphTargetItem it = ti.returnType;
                for (int i = 0; i < level; ++i) {
                    if (!(it instanceof ApplyTypeAVM2Item)) {
                        return null;
                    }
                    it = (GraphTargetItem)((ApplyTypeAVM2Item)it).params.get(0);
                }
                return this.typeToPath(it);
            }

            public Path getTraitCallType(Path className, String traitName) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                if (ti == null) {
                    return null;
                }
                if (ti.callReturnType instanceof ApplyTypeAVM2Item) {
                    ApplyTypeAVM2Item at = (ApplyTypeAVM2Item)ti.callReturnType;
                    return this.typeToPath(at.object);
                }
                return this.typeToPath(ti.callReturnType);
            }

            public Path getTraitCallSubType(Path className, String traitName, int level) {
                Reference foundStatic = new Reference(null);
                AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(new AbcIndexing.PropertyDef(traitName, (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, -1), true, true, true, foundStatic);
                if (ti == null) {
                    return null;
                }
                GraphTargetItem it = ti.callReturnType;
                for (int i = 0; i < level; ++i) {
                    if (!(it instanceof ApplyTypeAVM2Item)) {
                        return null;
                    }
                    it = (GraphTargetItem)((ApplyTypeAVM2Item)it).params.get(0);
                }
                return this.typeToPath(it);
            }

            public List<com.jpexs.decompiler.flash.simpleparser.Variable> getClassTraits(Path className, boolean getStatic, boolean getInstance, boolean getInheritance) {
                ArrayList propertyDefList = new ArrayList();
                ArrayList isStaticList = new ArrayList();
                ABCPanel.this.abc.getSwf().getAbcIndex().getClassTraits(new LinkedHashSet(), (GraphTargetItem)new TypeItem(className.toString()), ABCPanel.this.abc, Integer.valueOf(ABCPanel.this.decompiledTextArea.getScriptIndex()), getStatic, getInstance, getInheritance, propertyDefList, isStaticList);
                ArrayList<com.jpexs.decompiler.flash.simpleparser.Variable> ret = new ArrayList<com.jpexs.decompiler.flash.simpleparser.Variable>();
                for (int i = 0; i < propertyDefList.size(); ++i) {
                    AbcIndexing.PropertyDef def = (AbcIndexing.PropertyDef)propertyDefList.get(i);
                    AbcIndexing.TraitIndex ti = ABCPanel.this.abc.getSwf().getAbcIndex().findProperty(def, getStatic, getInstance, false, new Reference(null));
                    Path type = null;
                    Path callType = null;
                    if (ti != null) {
                        type = this.typeToPath(ti.returnType);
                        callType = this.typeToPath(ti.callReturnType);
                    }
                    if (ti.trait instanceof TraitSlotConst) {
                        callType = null;
                    }
                    if (ti.trait instanceof TraitMethodGetterSetter) {
                        TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)ti.trait;
                        if (tmgs.kindType == 3) {
                            int[] paramTypes = ((MethodInfo)ti.abc.method_info.get((int)tmgs.method_info)).param_types;
                            if (paramTypes.length != 1) continue;
                            type = new Path(ti.abc.constants.getMultiname(paramTypes[0]).getNameWithNamespace(new LinkedHashSet(), ti.abc, ti.abc.constants, false).getStringParts());
                            callType = null;
                        }
                        if (tmgs.kindType == 2) {
                            type = callType;
                            callType = null;
                        }
                    }
                    ret.add(new com.jpexs.decompiler.flash.simpleparser.Variable(true, new Path(new String[]{def.getPropertyName()}), 0, (Boolean)isStaticList.get(i), type, callType));
                }
                return ret;
            }
        });
        this.decompiledTextArea.addScriptListener(new Runnable(){

            @Override
            public void run() {
                ABCPanel.this.lastDecompiled = ABCPanel.this.decompiledTextArea.getText();
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.decompiledTextArea);
        this.decompiledTextArea.addMouseListener(new MouseAdapter(){
            final int initialTimeout = ToolTipManager.sharedInstance().getInitialDelay();
            final int dismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(this.initialTimeout);
                ToolTipManager.sharedInstance().setDismissDelay(this.dismissTimeout);
            }
        });
        this.searchPanel = new SearchPanel<ScriptSearchResult>((LayoutManager)new FlowLayout(), this);
        this.brokenHintPanel = new JPanel(new BorderLayout(10, 10));
        this.brokenHintPanel.add((Component)new JLabel("<html>" + AppStrings.translate("script.seemsBroken") + "</html>"), "Center");
        this.brokenHintPanel.setBackground(new Color(253, 205, 137));
        this.brokenHintPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        this.decompiledScrollPane = new FasterScrollPane(this.decompiledTextArea);
        JPanel iconDecPanel = new JPanel();
        iconDecPanel.setLayout(new BorderLayout());
        JPanel iconsPanel = new JPanel(new FlowLayout());
        JButton newTraitButton = new JButton(View.getIcon("traitadd16"));
        newTraitButton.setMargin(new Insets(5, 5, 5, 5));
        newTraitButton.addActionListener(this::addTraitButtonActionPerformed);
        newTraitButton.setToolTipText(AppStrings.translate("button.addtrait"));
        iconsPanel.add(newTraitButton);
        JButton removeTraitButton = new JButton(View.getIcon("traitremove16"));
        removeTraitButton.setMargin(new Insets(5, 5, 5, 5));
        removeTraitButton.addActionListener(this::removeTraitButtonActionPerformed);
        removeTraitButton.setToolTipText(AppStrings.translate("button.removetrait"));
        iconsPanel.add(removeTraitButton);
        JButton abcExplorerButton = new JButton(View.getIcon("abcexplorer16"));
        abcExplorerButton.setMargin(new Insets(5, 5, 5, 5));
        abcExplorerButton.addActionListener(this::abcExplorerTraitButtonActionPerformed);
        abcExplorerButton.setToolTipText(AppStrings.translate("button.abcexploretrait"));
        iconsPanel.add(abcExplorerButton);
        final JToggleButton deobfuscateButton = new JToggleButton(View.getIcon("deobfuscate16"));
        deobfuscateButton.setMargin(new Insets(5, 5, 5, 5));
        deobfuscateButton.addActionListener(this::deobfuscateButtonActionPerformed);
        deobfuscateButton.setToolTipText(AppStrings.translate("button.deobfuscate"));
        deobfuscateButton.setSelected((Boolean)Configuration.autoDeobfuscate.get());
        Configuration.autoDeobfuscate.addListener((ConfigurationItemChangeListener)new ConfigurationItemChangeListener<Boolean>(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void configurationItemChanged(Boolean newValue) {
                deobfuscateButton.setSelected(newValue);
            }
        });
        PopupButton deobfuscateOptionsButton = new PopupButton((Icon)View.getIcon("medkit16")){

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu popupMenu = new JPopupMenu();
                JCheckBoxMenuItem deobfuscateIdentifiersMenuItem = new JCheckBoxMenuItem(AppStrings.translate("deobfuscate_options.deobfuscateIdentifiers"));
                deobfuscateIdentifiersMenuItem.setSelected((Boolean)Configuration.autoDeobfuscateIdentifiers.get());
                ABCPanel aBCPanel = ABCPanel.this;
                deobfuscateIdentifiersMenuItem.addActionListener(x$0 -> aBCPanel.autoDeobfuscateIdentifiersMenuItemActionPerformed(x$0));
                JCheckBoxMenuItem simplifyExpressionsMenuItem = new JCheckBoxMenuItem(AppStrings.translate("deobfuscate_options.simplify_expressions"));
                simplifyExpressionsMenuItem.setSelected((Boolean)Configuration.simplifyExpressions.get());
                ABCPanel aBCPanel2 = ABCPanel.this;
                simplifyExpressionsMenuItem.addActionListener(x$0 -> aBCPanel2.simplifyExpressionsMenuItemActionPerformed(x$0));
                JCheckBoxMenuItem disableDecompilationMenuItem = new JCheckBoxMenuItem(AppStrings.translate("menu.settings.disabledecompilation"));
                disableDecompilationMenuItem.setSelected((Boolean)Configuration.decompile.get() == false);
                ABCPanel aBCPanel3 = ABCPanel.this;
                disableDecompilationMenuItem.addActionListener(x$0 -> aBCPanel3.disableDecompilationMenuItemActionPerformed(x$0));
                popupMenu.add(deobfuscateIdentifiersMenuItem);
                popupMenu.add(simplifyExpressionsMenuItem);
                popupMenu.add(disableDecompilationMenuItem);
                return popupMenu;
            }
        };
        deobfuscateOptionsButton.setToolTipText(AppStrings.translate("button.deobfuscate_options"));
        deobfuscateOptionsButton.setMargin(new Insets(0, 0, 0, 0));
        deobfuscateOptionsButton.setPreferredSize(new Dimension(30, deobfuscateButton.getPreferredSize().height));
        iconsPanel.add(deobfuscateButton);
        iconsPanel.add(deobfuscateOptionsButton);
        JButton breakpointListButton = new JButton(View.getIcon("breakpointlist16"));
        breakpointListButton.setMargin(new Insets(5, 5, 5, 5));
        breakpointListButton.addActionListener(this::breakPointListButtonActionPerformed);
        breakpointListButton.setToolTipText(AppStrings.translate("button.breakpointList"));
        iconsPanel.add(breakpointListButton);
        this.scriptNameLabel = new JLabel("-");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.scriptNameLabel, "North");
        this.toolbarPanel = new JPanel(new BorderLayout());
        this.toolbarPanel.add((Component)iconsPanel, "West");
        JPanel libraryAndLinkPanel = new JPanel(new FlowLayout());
        final JToggleButton linkButton = new JToggleButton(View.getIcon("link16"));
        final LinkDialog linkDialog = new LinkDialog(mainPanel, linkButton);
        this.libraryComboBox = new JComboBox();
        this.libraryComboBox.addItem("AIR (airglobal.swc)");
        this.libraryComboBox.addItem("Flash (playerglobal.swc)");
        this.libraryComboBox.setSelectedIndex(1);
        this.libraryComboBox.addItemListener(new ItemListener(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                SWF swf = this.this$0.getSwf();
                if (swf == null) {
                    return;
                }
                SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
                conf.setCustomData("library", "" + this.this$0.libraryComboBox.getSelectedIndex());
                linkDialog.load(this.this$0.getSwf());
                linkDialog.save(this.this$0.getSwf(), true);
            }
        });
        libraryAndLinkPanel.add(new JLabel(AppStrings.translate("library")));
        libraryAndLinkPanel.add(this.libraryComboBox);
        libraryAndLinkPanel.add(this.linksLabel);
        linkButton.setToolTipText(AppStrings.translate("button.abc.linkedSwfs.hint"));
        linkDialog.addSaveListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ABCPanel.this.reload();
            }
        });
        linkButton.addActionListener(new ActionListener(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!linkButton.isSelected()) {
                    return;
                }
                linkDialog.setLocationRelativeTo(linkButton);
                Point loc = new Point(0, linkButton.getHeight());
                SwingUtilities.convertPointToScreen(loc, linkButton);
                linkDialog.setLocation(loc);
                linkDialog.show(this.this$0.getSwf());
            }
        });
        libraryAndLinkPanel.add(linkButton);
        this.toolbarPanel.add((Component)libraryAndLinkPanel, "East");
        topPanel.add((Component)this.toolbarPanel, "Center");
        iconDecPanel.add((Component)topPanel, "North");
        JPanel panelWithHint = new JPanel(new BorderLayout());
        panelWithHint.setAlignmentX(0.5f);
        panelWithHint.add((Component)this.brokenHintPanel, "North");
        panelWithHint.add((Component)this.decompiledScrollPane, "Center");
        this.brokenHintPanel.setVisible(false);
        this.infoNotEditableLabel = new JLabel(View.getIcon("information16"));
        this.infoNotEditableLabel.setToolTipText(AppStrings.translate("info.noteditable.compound"));
        iconDecPanel.add((Component)panelWithHint, "Center");
        final JPanel decButtonsPan = new JPanel(new FlowLayout());
        decButtonsPan.setBorder(new BevelBorder(0));
        decButtonsPan.add(this.editDecompiledButton);
        decButtonsPan.add(this.experimentalLabel);
        decButtonsPan.add(this.flexLabel);
        decButtonsPan.add(this.infoNotEditableLabel);
        decButtonsPan.add(this.saveDecompiledButton);
        decButtonsPan.add(this.cancelDecompiledButton);
        if (((Boolean)Configuration.useFlexAs3Compiler.get()).booleanValue()) {
            this.experimentalLabel.setVisible(false);
        } else {
            this.flexLabel.setVisible(false);
        }
        this.infoNotEditableLabel.setVisible(false);
        this.editDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.cancelDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveDecompiledButton.addActionListener(this::saveDecompiledButtonActionPerformed);
        this.editDecompiledButton.addActionListener(this::editDecompiledButtonActionPerformed);
        this.cancelDecompiledButton.addActionListener(this::cancelDecompiledButtonActionPerformed);
        this.saveDecompiledButton.setVisible(false);
        this.cancelDecompiledButton.setVisible(false);
        decButtonsPan.setAlignmentX(0.0f);
        JPanel decPanel = new JPanel(new BorderLayout());
        decPanel.add(this.searchPanel, "North");
        decPanel.add((Component)iconDecPanel, "Center");
        decPanel.add((Component)decButtonsPan, "South");
        this.detailPanel = new DetailPanel(this, mainPanel);
        JPanel panB = new JPanel();
        panB.setLayout(new BorderLayout());
        panB.add((Component)this.decLabel, "North");
        Main.getDebugHandler().addConnectionListener(new DebuggerHandler.ConnectionListener(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void connected() {
                decButtonsPan.setVisible(false);
            }

            @Override
            public void disconnected() {
                decButtonsPan.setVisible(true);
            }
        });
        this.debugPanel = new DebugPanel();
        JPersistentSplitPane sp2 = new JPersistentSplitPane(0, decPanel, (Component)this.debugPanel, (ConfigurationItem<Double>)Configuration.guiAvm2VarsSplitPaneDividerLocationPercent);
        panB.add((Component)sp2, "Center");
        sp2.setContinuousLayout(true);
        this.debugPanel.setVisible(false);
        this.decLabel.setHorizontalAlignment(0);
        this.decompiledTextArea.changeContentType("text/actionscript3");
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.decompiledTextArea.getEditorKit();
        kit.installComponent((JEditorPane)this.decompiledTextArea, VariableMarker.class.getName());
        this.decompiledTextArea.setFont(Configuration.getSourceFont());
        View.addEditorAction(this.decompiledTextArea, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Reference usedAbc = new Reference(null);
                int multinameIndex = ABCPanel.this.decompiledTextArea.getMultinameUnderCaret((Reference<ABC>)usedAbc);
                if (multinameIndex > -1) {
                    UsageFrame usageFrame = new UsageFrame((ABC)usedAbc.getVal(), multinameIndex, false, ABCPanel.this, false);
                    usageFrame.setVisible(true);
                }
            }
        }, "find-usages", AppStrings.translate("abc.action.find-usages"), "control U");
        CtrlClickHandler cch = new CtrlClickHandler();
        this.decompiledTextArea.addKeyListener(cch);
        this.decompiledTextArea.addMouseListener(cch);
        this.decompiledTextArea.addMouseMotionListener(cch);
        this.navigator = new TraitsList(this);
        this.navigatorPanel = new JPanel(new BorderLayout());
        JPanel navIconsPanel = new JPanel();
        navIconsPanel.setLayout(new BoxLayout(navIconsPanel, 0));
        final JToggleButton sortButton = new JToggleButton(View.getIcon("sort16"));
        sortButton.setMargin(new Insets(3, 3, 3, 3));
        navIconsPanel.add(sortButton);
        this.navigatorPanel.add((Component)navIconsPanel, "South");
        this.navigatorPanel.add((Component)new FasterScrollPane(this.navigator), "Center");
        sortButton.addActionListener(new ActionListener(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.navigator.setSorted(sortButton.isSelected());
                this.this$0.navigator.updateUI();
            }
        });
        if (((Boolean)Configuration.displayAs3PCodePanel.get()).booleanValue()) {
            this.splitPane = new JPersistentSplitPane(1, panB, (Component)this.detailPanel, (ConfigurationItem<Double>)Configuration.guiAvm2SplitPaneDividerLocationPercent);
            this.splitPane.setContinuousLayout(true);
            this.add((Component)this.splitPane, "Center");
        } else {
            this.splitPane = null;
            this.add((Component)panB, "Center");
        }
    }

    private void decompiledTextAreaTextChanged() {
        this.setModified(true);
    }

    private boolean isModified() {
        View.checkAccess();
        return this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    private void setModified(boolean value) {
        View.checkAccess();
        this.saveDecompiledButton.setEnabled(value);
        this.cancelDecompiledButton.setEnabled(value);
    }

    private LinkType hasDeclaration(Token t) {
        if (this.decompiledTextArea == null) {
            return LinkType.NO_LINK;
        }
        if (t == null || t.type != TokenType.IDENTIFIER && t.type != TokenType.KEYWORD && t.type != TokenType.REGEX) {
            return LinkType.NO_LINK;
        }
        int pos = t.start;
        Reference abcIndex = new Reference((Object)0);
        Reference classIndex = new Reference((Object)0);
        Reference traitIndex = new Reference((Object)0);
        Reference multinameIndexRef = new Reference((Object)0);
        Reference classTrait = new Reference((Object)false);
        Reference usedAbcRef = new Reference(null);
        Reference scriptIndexRef = new Reference((Object)-1);
        if (this.getSwf() == null) {
            return LinkType.NO_LINK;
        }
        LinkType propLinkType = this.decompiledTextArea.getPropertyTypeAtPos(this.getSwf().getAbcIndex(), pos, (Reference<Integer>)abcIndex, (Reference<Integer>)classIndex, (Reference<Integer>)traitIndex, (Reference<Boolean>)classTrait, (Reference<Integer>)multinameIndexRef, (Reference<ABC>)usedAbcRef, false, (Reference<Integer>)scriptIndexRef);
        if (propLinkType != LinkType.NO_LINK) {
            if (usedAbcRef.getVal() == this.abc && ((Integer)scriptIndexRef.getVal()).intValue() == this.decompiledTextArea.getScriptIndex()) {
                return LinkType.LINK_THIS_SCRIPT;
            }
            return propLinkType;
        }
        ABC usedAbc = (ABC)usedAbcRef.getVal();
        int multinameIndex = this.decompiledTextArea.getMultinameAtPos(pos, (Reference<ABC>)usedAbcRef);
        if (multinameIndex > -1) {
            if (multinameIndex == 0) {
                return LinkType.NO_LINK;
            }
            Multiname m = usedAbc.constants.getMultiname(multinameIndex);
            if (m == null) {
                return LinkType.NO_LINK;
            }
            if (m.kind == 29) {
                multinameIndex = m.params[0];
                m = usedAbc.constants.getMultiname(multinameIndex);
            }
            List usages = usedAbc.findMultinameDefinition(multinameIndex);
            if (m.getSingleNamespaceIndex(usedAbc.constants) > 0 && usedAbc.constants.getNamespace((int)m.getSingleNamespaceIndex((AVM2ConstantPool)usedAbc.constants)).kind != 5) {
                for (ABCContainerTag at : this.getAbcList()) {
                    ABC a = at.getABC();
                    if (a == usedAbc) continue;
                    List mids = a.constants.getMultinameIds(m, a, usedAbc, usedAbc.constants);
                    Iterator iterator = mids.iterator();
                    while (iterator.hasNext()) {
                        int mid = (Integer)iterator.next();
                        usages.addAll(a.findMultinameDefinition(mid));
                    }
                }
            }
            if (!usages.isEmpty()) {
                return LinkType.NO_LINK;
            }
        }
        Reference linkTypeRef = new Reference(null);
        this.decompiledTextArea.getLocalDeclarationOfPos(pos, (Reference<DottedChain>)new Reference(null), (Reference<LinkType>)linkTypeRef);
        return (LinkType)linkTypeRef.getVal();
    }

    private void gotoDeclaration(int pos) {
        int dpos;
        View.checkAccess();
        Reference abcIndex = new Reference((Object)0);
        Reference classIndex = new Reference((Object)0);
        Reference traitIndex = new Reference((Object)0);
        Reference classTrait = new Reference((Object)false);
        Reference multinameIndexRef = new Reference((Object)0);
        Reference scriptIndexRef = new Reference((Object)-1);
        Reference usedAbcRef = new Reference(null);
        if (this.decompiledTextArea.getPropertyTypeAtPos(this.getSwf().getAbcIndex(), pos, (Reference<Integer>)abcIndex, (Reference<Integer>)classIndex, (Reference<Integer>)traitIndex, (Reference<Boolean>)classTrait, (Reference<Integer>)multinameIndexRef, (Reference<ABC>)usedAbcRef, false, (Reference<Integer>)scriptIndexRef) != LinkType.NO_LINK) {
            UsageFrame.gotoUsage(this, (MultinameUsage)new TraitMultinameUsage((ABC)usedAbcRef.getVal(), (Integer)multinameIndexRef.getVal(), (Integer)scriptIndexRef.getVal(), (Integer)classIndex.getVal(), (Integer)traitIndex.getVal(), (Boolean)classTrait.getVal() != false ? 1 : 2, null, -1){});
            return;
        }
        int multinameIndex = this.decompiledTextArea.getMultinameAtPos(pos, (Reference<ABC>)usedAbcRef);
        ABC usedAbc = (ABC)usedAbcRef.getVal();
        if (multinameIndex > -1) {
            Multiname m = usedAbc.constants.getMultiname(multinameIndex);
            if (m.kind == 29) {
                multinameIndex = m.params[0];
                m = usedAbc.constants.getMultiname(multinameIndex);
            }
            List usages = usedAbc.findMultinameDefinition(multinameIndex);
            if (m.getSingleNamespaceIndex(usedAbc.constants) > 0 && m.getSingleNamespace((AVM2ConstantPool)usedAbc.constants).kind != 5) {
                for (ABCContainerTag at : this.getAbcList()) {
                    ABC a = at.getABC();
                    if (a == usedAbc) continue;
                    List mids = a.constants.getMultinameIds(m, a, usedAbc, usedAbc.constants);
                    Iterator iterator = mids.iterator();
                    while (iterator.hasNext()) {
                        int mid = (Integer)iterator.next();
                        usages.addAll(a.findMultinameDefinition(mid));
                    }
                }
            }
            if (usages.size() > 1) {
                UsageFrame usageFrame = new UsageFrame(usedAbc, multinameIndex, false, this, true);
                usageFrame.setVisible(true);
                return;
            }
            if (!usages.isEmpty()) {
                UsageFrame.gotoUsage(this, (MultinameUsage)usages.get(0));
                return;
            }
        }
        if ((dpos = this.decompiledTextArea.getLocalDeclarationOfPos(pos, (Reference<DottedChain>)new Reference(null), (Reference<LinkType>)new Reference(null))) > -1) {
            this.decompiledTextArea.setCaretPosition(dpos);
        }
    }

    public void reload() {
        View.checkAccess();
        this.lastDecompiled = "";
        SWF swf = this.getSwf();
        if (swf != null) {
            swf.clearScriptCache();
        }
        this.decompiledTextArea.reloadClass();
        this.detailPanel.methodTraitPanel.methodCodePanel.clear();
        this.updateLinksLabel();
    }

    public void updateLinksLabel() {
        SWF swf = this.getSwf();
        if (swf == null) {
            this.linksLabel.setText("");
        } else {
            int num = swf.getNumAbcIndexDependencies();
            if (num == 0) {
                this.linksLabel.setText("");
            } else {
                this.linksLabel.setText(AppStrings.translate(num == 1 ? "abc.linkedSwfs.one" : "abc.linkedSwfs.more").replace("%num%", "" + num));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int index;
        View.checkAccess();
        if (e.getSource() == this.constantTypeList && (index = ((JComboBox)e.getSource()).getSelectedIndex()) == -1) {
            return;
        }
    }

    public void display() {
        View.checkAccess();
        this.setVisible(true);
    }

    public void hilightScript(String nameIncludingSwfHash) {
        if (!nameIncludingSwfHash.contains(":")) {
            throw new RuntimeException("Script name should contain swfHash");
        }
        String swfHash = nameIncludingSwfHash.substring(nameIncludingSwfHash.indexOf(":"));
        String name = nameIncludingSwfHash.substring(nameIncludingSwfHash.indexOf(":") + 1);
        SWF openable = null;
        if (swfHash.equals("main")) {
            openable = Main.getRunningSWF();
        } else if (swfHash.startsWith("loaded_")) {
            String hashToSearch = swfHash.substring("loaded_".length());
            block0: for (OpenableList sl : Main.getMainFrame().getPanel().getSwfs()) {
                for (int s = 0; s < sl.size(); ++s) {
                    Openable op = sl.get(s);
                    String t = op.getTitleOrShortFileName();
                    if (t == null) {
                        t = "";
                    }
                    if (!t.endsWith(":" + hashToSearch)) continue;
                    openable = op;
                    break block0;
                }
            }
        }
        if (openable != null) {
            this.hilightScript((Openable)openable, name);
        }
    }

    public void hilightScript(Openable openable, final String name) {
        ABC scriptNode;
        block11: {
            scriptNode = null;
            if (openable instanceof SWF) {
                SWF swf = (SWF)openable;
                OpenableListLoaded afterOpen = new OpenableListLoaded(){
                    final /* synthetic */ ABCPanel this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void openableListLoaded(OpenableList openableList) {
                        for (Openable op : openableList.items) {
                            SWF swf;
                            if (!(op instanceof SWF) || !"library.swf".equals((swf = (SWF)op).getFileTitle())) continue;
                            this.this$0.hilightScript((Openable)swf, name);
                            return;
                        }
                    }
                };
                if (swf.getFile() == null && "__playerglobal".equals(swf.getFileTitle())) {
                    this.mainPanel.findOrLoadOpenableListByFilePath(Configuration.getPlayerSWC().getAbsolutePath(), afterOpen, false);
                    return;
                }
                if (swf.getFile() == null && "__airglobal".equals(swf.getFileTitle())) {
                    this.mainPanel.findOrLoadOpenableListByFilePath(Configuration.getAirSWC().getAbsolutePath(), afterOpen, false);
                    return;
                }
                if (this.mainPanel.getCurrentView() == 0) {
                    scriptNode = this.mainPanel.tagTree.getFullModel().getScriptsNode(swf);
                } else {
                    ArrayList<ABC> allAbcs = new ArrayList<ABC>();
                    for (ABCContainerTag container : swf.getAbcList()) {
                        allAbcs.add(container.getABC());
                    }
                    for (ABCContainerTag container : swf.getAbcList()) {
                        List packs = container.getABC().getScriptPacks(null, allAbcs);
                        for (ScriptPack pack : packs) {
                            ClassPath classPath = pack.getClassPath();
                            if (!name.endsWith(classPath.className + classPath.namespaceSuffix) || !classPath.toRawString().equals(name)) continue;
                            scriptNode = (Tag)container;
                            break block11;
                        }
                    }
                }
            } else if (openable instanceof ABC) {
                scriptNode = (ABC)openable;
            }
        }
        if (scriptNode != null) {
            this.hilightScript(openable, name, (TreeItem)scriptNode);
        }
    }

    public void hilightScript(Openable openable, String name, TreeItem scriptNode) {
        View.checkAccess();
        Object item = this.mainPanel.getCurrentView() == 0 && openable instanceof SWF ? this.mainPanel.tagTree.getFullModel().getScriptsNode((SWF)openable) : (openable instanceof ABC ? openable : scriptNode);
        AbstractTagTree tree = this.mainPanel.getCurrentTree();
        String pkg = name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : "";
        String[] parts = name.split("\\.");
        ArrayList<Object> rootNodes = new ArrayList<Object>();
        rootNodes.add(item);
        boolean found = false;
        List<? extends TreeItem> firstLevelNodes = tree.getFullModel().getAllChildren(item);
        for (TreeItem treeItem : firstLevelNodes) {
            if (!(treeItem instanceof AS3Package) || !((AS3Package)treeItem).isCompoundScript()) continue;
            rootNodes.add(treeItem);
            if (parts.length != 1 || !parts[0].equals("script_" + ((AS3Package)treeItem).getCompoundScriptIndex())) continue;
            found = true;
            item = treeItem;
            break;
        }
        if (!found) {
            block1: for (Object object : rootNodes) {
                item = object;
                for (int i = 0; i < parts.length; ++i) {
                    found = false;
                    for (TreeItem treeItem : tree.getFullModel().getAllChildren(item)) {
                        AS3ClassTreeItem cti;
                        if (treeItem instanceof AS3Package && ((AS3Package)treeItem).isFlat()) {
                            AS3Package pti = (AS3Package)treeItem;
                            if ((!pkg.isEmpty() || !pti.isDefaultPackage()) && (pti.isDefaultPackage() || !pkg.equals(pti.packageName))) continue;
                            item = pti;
                            i = parts.length - 1 - 1;
                            found = true;
                            break;
                        }
                        if (treeItem instanceof AS3Package && ((AS3Package)treeItem).isCompoundScript() || !(treeItem instanceof AS3ClassTreeItem) || !parts[i].equals((cti = (AS3ClassTreeItem)treeItem).getPrintableNameWithNamespaceSuffix())) continue;
                        item = treeItem;
                        found = true;
                        break;
                    }
                    if (!found) continue block1;
                }
            }
        }
        if (!found) {
            return;
        }
        this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), (TreeItem)item);
        this.mainPanel.reload(true);
    }

    public void hilightScript(ScriptPack pack) {
        View.checkAccess();
        AbstractTagTreeModel ttm = this.mainPanel.getCurrentTree().getFullModel();
        TreePath tp = ttm.getTreePath((TreeItem)pack);
        if (tp == null) {
            this.mainPanel.hideQuickTreeFind();
            tp = ttm.getTreePath((TreeItem)pack);
        }
        this.mainPanel.getCurrentTree().setSelectionPath(tp);
        this.mainPanel.getCurrentTree().scrollPathToVisible(tp);
    }

    @Override
    public void updateSearchPos(String searchedText, boolean ignoreCase, boolean regExp, ScriptSearchResult item) {
        View.checkAccess();
        if (!(item instanceof ABCSearchResult)) {
            return;
        }
        final ABCSearchResult result = (ABCSearchResult)item;
        this.searchPanel.setOptions(ignoreCase, regExp);
        this.searchPanel.setSearchText(searchedText);
        final ScriptPack pack = result.getScriptPack();
        this.setAbc(pack.abc);
        Runnable setScriptComplete = new Runnable(){
            final /* synthetic */ ABCPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.decompiledTextArea.removeScriptListener(this);
                this.this$0.hilightScript(pack);
                this.this$0.setAbc(pack.abc);
                boolean pcode = result.isPcode();
                if (pcode) {
                    this.this$0.decompiledTextArea.setClassIndex(result.getClassIndex());
                    this.this$0.decompiledTextArea.gotoTrait(result.getTraitId());
                } else {
                    this.this$0.decompiledTextArea.setCaretPosition(0);
                }
                this.this$0.decompiledTextArea.caretUpdate(null);
                if (pcode) {
                    this.this$0.searchPanel.showQuickFindDialog(this.this$0.detailPanel.methodTraitPanel.methodCodePanel.getSourceTextArea());
                } else {
                    this.this$0.searchPanel.showQuickFindDialog(this.this$0.decompiledTextArea);
                }
            }
        };
        this.decompiledTextArea.addScriptListener(setScriptComplete);
        this.decompiledTextArea.setScript(pack, false);
    }

    public boolean isDirectEditing() {
        View.checkAccess();
        return this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    public void setDecompiledEditMode(boolean val) {
        if (val) {
            this.lastDecompiled = this.decompiledTextArea.getText();
        } else {
            this.decompiledTextArea.setText(this.lastDecompiled);
        }
        this.decompiledTextArea.setEditable(val);
        this.saveDecompiledButton.setVisible(val);
        this.saveDecompiledButton.setEnabled(false);
        this.editDecompiledButton.setVisible(!val);
        boolean useFlex = (Boolean)Configuration.useFlexAs3Compiler.get();
        this.experimentalLabel.setVisible(!useFlex && !val);
        this.flexLabel.setVisible(useFlex && !val);
        this.cancelDecompiledButton.setVisible(val);
        this.decompiledTextArea.getCaret().setVisible(true);
        this.decLabel.setIcon(val ? View.getIcon("editing16") : null);
        this.detailPanel.setVisible(!val);
        this.decompiledTextArea.ignoreCaret = val;
        if (val) {
            this.decompiledTextArea.requestFocusInWindow();
        }
        this.toolbarPanel.setVisible(!val);
    }

    private void editDecompiledButtonActionPerformed(ActionEvent evt) {
        this.scriptReplacer = this.mainPanel.getAs3ScriptReplacer(Main.isSwfAir(this.getOpenable()));
        if (this.scriptReplacer == null) {
            return;
        }
        if (ViewMessages.showConfirmDialog(this, AppStrings.translate("message.confirm.experimental.function"), AppStrings.translate("message.warning"), 2, 2, (ConfigurationItem<Boolean>)Configuration.warningExperimentalAS3Edit, 0) == 0) {
            this.pack = this.decompiledTextArea.getScriptLeaf();
            this.setDecompiledEditMode(true);
            this.mainPanel.setEditingStatus();
            SwingWorker initReplaceWorker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    ABCPanel.this.scriptReplacer.initReplacement(ABCPanel.this.pack, Main.getDependencies(((ABCPanel)ABCPanel.this).pack.abc.getSwf()));
                    return null;
                }
            };
            initReplaceWorker.execute();
        }
    }

    private void cancelDecompiledButtonActionPerformed(ActionEvent evt) {
        this.setDecompiledEditMode(false);
        if (this.scriptReplacer != null) {
            this.scriptReplacer.deinitReplacement(this.pack);
        }
        this.mainPanel.clearEditingStatus();
    }

    public TreeItem getScriptNodeForPack(ScriptPack pack) {
        TreePath scriptsPath = this.mainPanel.getCurrentTree().getFullModel().getTreePath((TreeItem)pack);
        while (!(scriptsPath.getLastPathComponent() instanceof ClassesListTreeModel || scriptsPath.getLastPathComponent() instanceof ABC || scriptsPath.getLastPathComponent() instanceof ABCContainerTag)) {
            scriptsPath = scriptsPath.getParentPath();
        }
        return (TreeItem)scriptsPath.getLastPathComponent();
    }

    private void saveDecompiled(boolean refreshTree) {
        ABC localAbc = this.abc;
        int oldIndex = this.pack.scriptIndex;
        SWF.uncache((ScriptPack)this.pack);
        try {
            String oldSp = this.pack.getClassPath().toRawString();
            TreeItem scriptNode = this.getScriptNodeForPack(this.pack);
            String as = this.decompiledTextArea.getText();
            localAbc.replaceScriptPack(this.scriptReplacer, this.pack, as, Main.getDependencies(this.pack.abc.getSwf()));
            this.scriptReplacer.deinitReplacement(this.pack);
            this.lastDecompiled = as;
            this.setDecompiledEditMode(false);
            this.mainPanel.updateClassesList();
            if (oldSp != null) {
                this.hilightScript(localAbc.getOpenable(), oldSp, scriptNode);
                TreeItem sel = this.mainPanel.getCurrentTree().getCurrentTreeItem();
                if (sel instanceof ScriptPack && sel != this.pack) {
                    this.mainPanel.replaceItemPin((TreeItem)this.pack, sel);
                }
            }
            this.reload();
            this.mainPanel.clearEditingStatus();
            if (refreshTree) {
                ViewMessages.showMessageDialog(this, AppStrings.translate("message.action.saved"), AppStrings.translate("dialog.message.title"), 1, (ConfigurationItem<Boolean>)Configuration.showCodeSavedMessage);
            }
        }
        catch (As3ScriptReplaceException asre) {
            StringBuilder sb = new StringBuilder();
            int firstErrorLine = -1;
            int firstErrorCol = -1;
            String firstErrorText = null;
            ((ScriptInfo)this.abc.script_info.get(oldIndex)).delete(this.abc, false);
            for (As3ScriptReplaceExceptionItem item : asre.getExceptionItems()) {
                if (firstErrorLine == -1) {
                    firstErrorLine = item.getLine();
                    firstErrorCol = item.getCol();
                }
                if (firstErrorText == null) {
                    firstErrorText = item.getMessage();
                }
                sb.append(item.getFile()).append(":").append(item.getLine()).append(" (column ").append(item.getCol()).append(")").append(":").append("\n");
                sb.append("  ").append(item.getMessage());
                sb.append("\n");
                sb.append("\n");
            }
            if (firstErrorLine != -1) {
                if (firstErrorCol != -1) {
                    this.decompiledTextArea.gotoLineCol(firstErrorLine, firstErrorCol);
                } else {
                    this.decompiledTextArea.gotoLine(firstErrorLine);
                }
                this.decompiledTextArea.markError();
            }
            if (this.scriptReplacer instanceof FFDecAs3ScriptReplacer) {
                ViewMessages.showMessageDialog(this, AppStrings.translate("error.action.save").replace("%error%", firstErrorText).replace("%line%", Long.toString(firstErrorLine)), AppStrings.translate("error"), 0);
            } else {
                ViewMessages.showMessageDialog(this, sb.toString(), AppStrings.translate("error"), 0);
            }
            this.decompiledTextArea.requestFocus();
        }
        catch (Throwable ex) {
            Logger.getLogger(ABCPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void saveDecompiledButtonActionPerformed(ActionEvent evt) {
        this.saveDecompiled(true);
    }

    private void deobfuscateButtonActionPerformed(ActionEvent evt) {
        JToggleButton toggleButton = (JToggleButton)evt.getSource();
        boolean selected = toggleButton.isSelected();
        if (ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.confirm.autodeobfuscate") + "\r\n" + (selected ? AppStrings.translate("message.confirm.on") : AppStrings.translate("message.confirm.off")), AppStrings.translate("message.confirm"), 2, (ConfigurationItem<Boolean>)Configuration.warningDeobfuscation, 0) == 0) {
            Configuration.autoDeobfuscate.set((Object)selected);
            this.mainPanel.autoDeobfuscateChanged();
        } else {
            toggleButton.setSelected((Boolean)Configuration.autoDeobfuscate.get());
        }
    }

    private void simplifyExpressionsMenuItemActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
        Configuration.simplifyExpressions.set((Object)menuItem.isSelected());
        this.mainPanel.autoDeobfuscateChanged();
    }

    private void autoDeobfuscateIdentifiersMenuItemActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
        Configuration.autoDeobfuscateIdentifiers.set((Object)menuItem.isSelected());
        this.mainPanel.autoDeobfuscateChanged();
    }

    private void disableDecompilationMenuItemActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
        Configuration.decompile.set((Object)(!menuItem.isSelected() ? 1 : 0));
        this.mainPanel.disableDecompilationChanged();
    }

    private void abcExplorerTraitButtonActionPerformed(ActionEvent evt) {
        int traitType;
        int classIndex = this.decompiledTextArea.getClassIndex();
        int globalTraitIndex = this.decompiledTextArea.lastTraitIndex;
        if (globalTraitIndex == -3 || globalTraitIndex == -2 || globalTraitIndex == -1) {
            ABCExplorerDialog dialog = this.mainPanel.showAbcExplorer(this.abc.getOpenable(), this.abc);
            dialog.selectTrait(this.decompiledTextArea.getScriptLeaf().scriptIndex, classIndex, globalTraitIndex, globalTraitIndex);
            return;
        }
        int traitIndex = -1;
        if (globalTraitIndex == -4 && classIndex >= 0) {
            Traits traits = ((ScriptInfo)this.abc.script_info.get((int)this.decompiledTextArea.getScriptLeaf().scriptIndex)).traits;
            for (int i = 0; i < traits.traits.size(); ++i) {
                if (!(traits.traits.get(i) instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)traits.traits.get(i);
                if (tc.class_info != classIndex) continue;
                traitIndex = i;
                break;
            }
            traitType = -3;
        } else if (classIndex < 0) {
            traitIndex = globalTraitIndex;
            traitType = -3;
        } else {
            Traits staticTraits = ((ClassInfo)this.abc.class_info.get((int)classIndex)).static_traits;
            Traits instanceTraits = ((InstanceInfo)this.abc.instance_info.get((int)classIndex)).instance_traits;
            if (globalTraitIndex >= 0 && globalTraitIndex < ((ClassInfo)this.abc.class_info.get((int)classIndex)).static_traits.traits.size()) {
                traitIndex = globalTraitIndex;
                traitType = -2;
            } else if (globalTraitIndex >= 0 && globalTraitIndex < staticTraits.traits.size() + instanceTraits.traits.size()) {
                traitIndex = globalTraitIndex - staticTraits.traits.size();
                traitType = -1;
            } else {
                return;
            }
        }
        ABCExplorerDialog dialog = this.mainPanel.showAbcExplorer(this.abc.getOpenable(), this.abc);
        dialog.selectTrait(this.decompiledTextArea.getScriptLeaf().scriptIndex, classIndex, traitIndex, traitType);
    }

    private void removeTraitButtonActionPerformed(ActionEvent evt) {
        int classIndex = this.decompiledTextArea.getClassIndex();
        int traitId = this.decompiledTextArea.lastTraitIndex;
        if (traitId == -3 || traitId == -2 || traitId == -1) {
            return;
        }
        boolean scriptTraitsUsed = false;
        Traits traits = null;
        int traitIndex = -1;
        if (traitId == -4 && classIndex >= 0) {
            traits = ((ScriptInfo)this.abc.script_info.get((int)this.decompiledTextArea.getScriptLeaf().scriptIndex)).traits;
            for (int i = 0; i < traits.traits.size(); ++i) {
                if (!(traits.traits.get(i) instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)traits.traits.get(i);
                if (tc.class_info != classIndex) continue;
                traitIndex = i;
                break;
            }
            scriptTraitsUsed = true;
        } else if (classIndex < 0) {
            traits = ((ScriptInfo)this.abc.script_info.get((int)this.decompiledTextArea.getScriptLeaf().scriptIndex)).traits;
            traitIndex = traitId;
            scriptTraitsUsed = true;
        } else {
            Traits staticTraits = ((ClassInfo)this.abc.class_info.get((int)classIndex)).static_traits;
            Traits instanceTraits = ((InstanceInfo)this.abc.instance_info.get((int)classIndex)).instance_traits;
            if (traitId >= 0 && traitId < ((ClassInfo)this.abc.class_info.get((int)classIndex)).static_traits.traits.size()) {
                traitIndex = traitId;
                traits = staticTraits;
            } else if (traitId >= 0 && traitId < staticTraits.traits.size() + instanceTraits.traits.size()) {
                traitIndex = traitId - staticTraits.traits.size();
                traits = instanceTraits;
            } else {
                traits = null;
            }
        }
        if (traits == null || traitIndex < 0) {
            return;
        }
        if (ViewMessages.showConfirmDialog(this, AppStrings.translate("message.confirm.removetrait"), AppStrings.translate("message.warning"), 2, 2) == 0) {
            this.navigator.setModel(new DefaultListModel());
            if (scriptTraitsUsed) {
                final int fTraitIndex = traitIndex;
                final Traits fTraits = traits;
                Main.getMainFrame().getPanel().treeOperation(new Runnable(){
                    final /* synthetic */ ABCPanel this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        ((Tag)this.this$0.abc.parentTag).getSwf().clearScriptCache();
                        fTraits.traits.remove(fTraitIndex);
                        if (fTraits.traits.isEmpty()) {
                            ((ScriptInfo)this.this$0.abc.script_info.get(this.this$0.decompiledTextArea.getScriptLeaf().scriptIndex)).delete(this.this$0.abc, true);
                            this.this$0.abc.pack();
                        }
                        ((Tag)this.this$0.abc.parentTag).setModified(true);
                        this.this$0.abc.fireChanged();
                    }
                });
            } else {
                traits.traits.remove(traitIndex);
                ((Tag)this.abc.parentTag).setModified(true);
                this.reload();
                this.abc.fireChanged();
            }
        }
    }

    private void breakPointListButtonActionPerformed(ActionEvent evt) {
        Main.showBreakpointsList();
    }

    private void addTraitButtonActionPerformed(ActionEvent evt) {
        Multiname m;
        boolean isStatic;
        int kind;
        int class_index = this.decompiledTextArea.getClassIndex();
        if (class_index < 0) {
            return;
        }
        if (this.newTraitDialog == null) {
            this.newTraitDialog = new NewTraitDialog(Main.getDefaultDialogsOwner());
        }
        int void_type = this.abc.constants.getPublicQnameId("void", true);
        int int_type = this.abc.constants.getPublicQnameId("int", true);
        TraitSlotConst t = null;
        String name = null;
        boolean again = false;
        block4: do {
            if (again) {
                ViewMessages.showMessageDialog(this, AppStrings.translate("error.trait.exists").replace("%name%", name), AppStrings.translate("error"), 0);
            }
            again = false;
            if (this.newTraitDialog.showDialog() != 0) {
                return;
            }
            kind = this.newTraitDialog.getTraitType();
            int nskind = this.newTraitDialog.getNamespaceKind();
            name = this.newTraitDialog.getTraitName();
            isStatic = this.newTraitDialog.getStatic();
            m = Multiname.createQName((boolean)false, (int)this.abc.constants.getStringId(name, true), (int)this.abc.constants.getNamespaceId(nskind, "", 0, true));
            int mid = this.abc.constants.getMultinameId(m, false);
            if (mid <= 0) break;
            for (Trait tr : ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.traits) {
                if (tr.name_index != mid) continue;
                again = true;
                break;
            }
            for (Trait tr : ((InstanceInfo)this.abc.instance_info.get((int)class_index)).instance_traits.traits) {
                if (tr.name_index != mid) continue;
                again = true;
                continue block4;
            }
        } while (again);
        this.navigator.setModel(new DefaultListModel());
        switch (kind) {
            case 1: 
            case 2: 
            case 3: {
                int method_info;
                TraitMethodGetterSetter tm = new TraitMethodGetterSetter();
                MethodInfo mi = new MethodInfo(new int[0], void_type, this.abc.constants.getStringId(name, true), 0, new ValueKind[0], new int[0]);
                tm.method_info = method_info = this.abc.addMethodInfo(mi);
                MethodBody body = new MethodBody(this.abc, new Traits(), new byte[0], new ABCException[0]);
                body.method_info = method_info;
                body.init_scope_depth = 1;
                body.max_regs = 1;
                body.max_scope_depth = 1;
                body.max_stack = 1;
                body.exceptions = new ABCException[0];
                AVM2Code code = new AVM2Code();
                code.code.add(new AVM2Instruction(0L, 208, null));
                code.code.add(new AVM2Instruction(0L, 48, null));
                code.code.add(new AVM2Instruction(0L, 71, null));
                body.setCode(code);
                Traits traits = new Traits();
                traits.traits = new ArrayList();
                body.traits = traits;
                this.abc.addMethodBody(body);
                t = tm;
                break;
            }
            case 0: 
            case 6: {
                TraitSlotConst ts = new TraitSlotConst();
                ts.type_index = int_type;
                ts.value_kind = 3;
                ts.value_index = this.abc.constants.getIntId(0, true);
                t = ts;
            }
        }
        if (t != null) {
            t.kindType = kind;
            t.name_index = this.abc.constants.getMultinameId(m, true);
            final int traitId = isStatic ? ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.addTrait((Trait)t) : ((ClassInfo)this.abc.class_info.get((int)class_index)).static_traits.traits.size() + ((InstanceInfo)this.abc.instance_info.get((int)class_index)).instance_traits.addTrait((Trait)t);
            int scriptIndex = this.decompiledTextArea.getScriptLeaf().scriptIndex;
            if (scriptIndex >= 0 && scriptIndex < this.abc.script_info.size()) {
                ((ScriptInfo)this.abc.script_info.get(scriptIndex)).setModified(true);
            }
            ((Tag)this.abc.parentTag).setModified(true);
            this.decompiledTextArea.addScriptListener(new Runnable(){
                final /* synthetic */ ABCPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.decompiledTextArea.gotoTrait(traitId);
                    this.this$0.decompiledTextArea.removeScriptListener(this);
                }
            });
            this.reload();
            this.abc.fireChanged();
        }
    }

    @Override
    public boolean tryAutoSave() {
        View.checkAccess();
        boolean ok = true;
        if (this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled() && ((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            this.saveDecompiled(false);
            ok = ok && (!this.saveDecompiledButton.isVisible() || !this.saveDecompiledButton.isEnabled());
        }
        ok = ok && this.detailPanel.tryAutoSave();
        return ok;
    }

    @Override
    public boolean isEditing() {
        View.checkAccess();
        return this.detailPanel.saveButton.isVisible() && this.detailPanel.saveButton.isEnabled() || this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    public DebugPanel getDebugPanel() {
        return this.debugPanel;
    }

    public void setCompound(boolean value) {
        this.infoNotEditableLabel.setVisible(value);
        boolean useFlex = (Boolean)Configuration.useFlexAs3Compiler.get();
        this.experimentalLabel.setVisible(!useFlex && !value);
        this.flexLabel.setVisible(useFlex && !value);
        this.editDecompiledButton.setEnabled(!value);
        this.compound = value;
    }

    public void setScript(ScriptPack scriptPack) {
        this.setDecompiledEditMode(false);
        this.detailPanel.setEditMode(false);
        this.detailPanel.methodTraitPanel.methodCodePanel.clear();
        this.decompiledTextArea.setNoTrait();
        this.setAbc(scriptPack.abc);
        this.decompiledTextArea.setScript(scriptPack, true);
    }

    private class CtrlClickHandler
    extends KeyAdapter
    implements MouseListener,
    MouseMotionListener {
        private boolean ctrlDown = false;

        private CtrlClickHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 17 && !ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                this.ctrlDown = false;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.ctrlDown && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && !ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.ctrlDown = false;
            ABCPanel.this.decompiledTextArea.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.ctrlDown && ABCPanel.this.decompiledTextArea.isEditable()) {
                this.ctrlDown = false;
                ABCPanel.this.decompiledTextArea.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static class VariablesTableModel
    implements MyTreeTableModel {
        List<TableModelListener> tableListeners = new ArrayList<TableModelListener>();
        VariableNode root;
        private final Map<VariableNode, List<VariableNode>> nodeCache = new HashMap<VariableNode, List<VariableNode>>();
        protected EventListenerList listenerList = new EventListenerList();
        private static final int CHANGED = 0;
        private static final int INSERTED = 1;
        private static final int REMOVED = 2;
        private static final int STRUCTURE_CHANGED = 3;
        private final MyTreeTable ttable;
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_TRAIT = 1;
        private static final int COLUMN_SCOPE = 2;
        private static final int COLUMN_FLAGS = 3;
        private static final int COLUMN_TYPE = 4;
        private static final int COLUMN_VALUE = 5;

        public VariablesTableModel(MyTreeTable ttable, List<Variable> vars) {
            this.ttable = ttable;
            ArrayList<VariableNode> childs = new ArrayList<VariableNode>();
            for (int i = 0; i < vars.size(); ++i) {
                childs.add(new VariableNode(new ArrayList<VariableNode>(), 1, vars.get(i), 0L, null));
            }
            this.root = new VariableNode(new ArrayList<VariableNode>(), 0, null, 0L, null, childs);
        }

        public int getColumnCount() {
            return 6;
        }

        public Variable getVarAt(Object node) {
            if (node == this.root) {
                return null;
            }
            return ((VariableNode)node).var;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AppStrings.translate("variables.column.name");
                }
                case 2: {
                    return AppStrings.translate("variables.column.scope");
                }
                case 3: {
                    return AppStrings.translate("variables.column.flags");
                }
                case 4: {
                    return AppStrings.translate("variables.column.type");
                }
                case 5: {
                    return AppStrings.translate("variables.column.value");
                }
                case 1: {
                    return AppStrings.translate("variables.column.trait");
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return MyTreeTableModel.class;
            }
            return String.class;
        }

        private String flagsToScopeString(int flags) {
            int scope = flags & 0x3800000;
            switch (scope) {
                case 0x800000: {
                    return "private";
                }
                case 0x1000000: {
                    return "protected";
                }
                case 0: {
                    return "public";
                }
                case 0x2000000: {
                    return "namespace";
                }
                case 0x1800000: {
                    return "internal";
                }
            }
            return "?";
        }

        private String flagsToString(int flags) {
            Integer[] unknownFlags = new Integer[]{8, 16, 64, 512, 2048, 16384, 32768};
            ArrayList<String> flagsStr = new ArrayList<String>();
            if ((flags & 1) > 0) {
                flagsStr.add("dontEnumerate");
            }
            if ((flags & 2) > 0) {
                flagsStr.add("dontDelete");
            }
            if ((flags & 0x80) > 0) {
                flagsStr.add("onlySWF6Up");
            }
            if ((flags & 0x100) > 0) {
                flagsStr.add("ignoreSWF6");
            }
            if ((flags & 0x400) > 0) {
                flagsStr.add("onlySWF7Up");
            }
            if ((flags & 0x1000) > 0) {
                flagsStr.add("onlySWF8Up");
            }
            if ((flags & 0x2000) > 0) {
                flagsStr.add("onlySWF9Up");
            }
            if ((flags & 0x4000) > 0) {
                flagsStr.add("onlySWF10Up");
            }
            for (Integer f : unknownFlags) {
                if ((flags & f) <= 0) continue;
                flagsStr.add("unk" + f);
            }
            if ((flags & 0x80000) > 0) {
                flagsStr.add("get");
            }
            if ((flags & 0x100000) > 0) {
                flagsStr.add("set");
            }
            if ((flags & 4) > 0) {
                flagsStr.add("readonly");
            }
            if ((flags & 0x400000) > 0) {
                flagsStr.add("const");
            }
            if ((flags & 0x20000) > 0) {
                flagsStr.add("dynamic");
            }
            if ((flags & 0x4000000) > 0) {
                flagsStr.add("class");
            }
            if ((flags & 0x10000) > 0) {
                flagsStr.add("argument");
            }
            if ((flags & 0x40000) > 0) {
                flagsStr.add("exception");
            }
            if ((flags & 0x20) > 0) {
                flagsStr.add("local");
            }
            if ((flags & 0x200000) > 0) {
                flagsStr.add("static");
            }
            return String.join((CharSequence)", ", flagsStr);
        }

        public Object getValueAt(Object node, int columnIndex) {
            if (node == this.root) {
                if (columnIndex == 0) {
                    return "root";
                }
                return "";
            }
            Variable var = ((VariableNode)node).var;
            Variable var_getter = ((VariableNode)node).varInsideGetter;
            Variable trait = ((VariableNode)node).trait;
            boolean readOnly = (var.flags & 4) > 0;
            boolean hasGetter = (var.flags & 0x80000) > 0;
            boolean hasSetter = (var.flags & 0x100000) > 0;
            boolean onlySetter = hasSetter && !hasGetter;
            Variable val = var;
            if (var_getter != null) {
                val = var_getter;
            }
            switch (columnIndex) {
                case 0: {
                    return var.name;
                }
                case 2: {
                    return this.flagsToScopeString(var.flags);
                }
                case 3: {
                    return this.flagsToString(var.flags);
                }
                case 4: {
                    String typeStr = val.getTypeAsStr();
                    if ("Object".equals(typeStr)) {
                        typeStr = val.className;
                    }
                    if ("Object".equals(typeStr)) {
                        typeStr = val.typeName;
                    }
                    return typeStr;
                }
                case 5: {
                    switch (val.vType) {
                        case 3: 
                        case 4: 
                        case 5: {
                            return var.getTypeAsStr() + "(" + val.value + ")";
                        }
                        case 2: {
                            return "\"" + Helper.escapeActionScriptString((String)("" + val.value)) + "\"";
                        }
                    }
                    return EcmaScript.toString((Object)val.value);
                }
                case 1: {
                    if (trait != null) {
                        return trait.name;
                    }
                    return "";
                }
            }
            return null;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0 || column == 5 && node != this.root && ((VariableNode)node).var.isPrimitive;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            int valType;
            ParsedSymbol symb;
            ActionScriptLexer lexer = new ActionScriptLexer((Reader)new StringReader("" + aValue));
            try {
                symb = lexer.lex();
                ParsedSymbol f = lexer.yylex();
                if (f.type != SymbolType.EOF) {
                    return;
                }
            }
            catch (ActionParseException | IOException ex) {
                return;
            }
            switch (symb.type) {
                case DOUBLE: {
                    valType = 0;
                    break;
                }
                case INTEGER: {
                    valType = 0;
                    break;
                }
                case NULL: {
                    valType = 6;
                    break;
                }
                case STRING: {
                    valType = 2;
                    break;
                }
                case UNDEFINED: {
                    valType = 7;
                    break;
                }
                default: {
                    return;
                }
            }
            Main.getDebugHandler().setVariable(((VariableNode)node).parentObjectId, ((VariableNode)node).var.name, valType, symb.value);
            Object[] path = new Object[((VariableNode)node).path.size()];
            for (int i = 0; i < path.length; ++i) {
                path[i] = ((VariableNode)node).path.get(i);
            }
            this.valueForPathChanged(new TreePath(path), aValue);
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getChild(Object parent, int index) {
            return ((VariableNode)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            int cnt = ((VariableNode)parent).getChildCount();
            return cnt;
        }

        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            this.fireTreeNodesChanged(this.ttable, path.getParentPath().getPath(), new int[0], new Object[]{path.getLastPathComponent()});
        }

        public int getIndexOfChild(Object parent, Object child) {
            int cnt = this.getChildCount(parent);
            for (int i = 0; i < cnt; ++i) {
                if (this.getChild(parent, i) != child) continue;
                return i;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(0, source, path, childIndices, children);
        }

        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(1, source, path, childIndices, children);
        }

        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(2, source, path, childIndices, children);
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.fireTreeNode(3, source, path, childIndices, children);
        }

        private void fireTreeNode(int changeType, Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
            block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                switch (changeType) {
                    case 0: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
                        continue block6;
                    }
                    case 1: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
                        continue block6;
                    }
                    case 2: {
                        ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
                        continue block6;
                    }
                    case 3: {
                        ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
                        continue block6;
                    }
                }
            }
        }

        public String tryGetDebugHoverToolTipText(String varName) {
            String lowerName = varName.toLowerCase();
            StringBuilder builder = new StringBuilder();
            this.findVarAndAppendDataToString(this.root, lowerName, builder);
            String text = builder.toString();
            if (text == null || text.isEmpty()) {
                return null;
            }
            return "<html>" + text + "</html>";
        }

        private void findVarAndAppendDataToString(VariableNode node, String lowerVarName, StringBuilder builder) {
            if (node.var != null && node.var.name.toLowerCase().contains(lowerVarName)) {
                builder.append(node.var.name + ": " + node.var.getValueAsStr() + "<br>");
            }
            if (node.childs != null) {
                for (int i = 0; i < node.childs.size(); ++i) {
                    this.findVarAndAppendDataToString((VariableNode)node.childs.get(i), lowerVarName, builder);
                }
            }
        }
    }

    public static class VariableNode {
        public List<VariableNode> path = new ArrayList<VariableNode>();
        public Variable var;
        public Variable varInsideGetter;
        public Long parentObjectId;
        public int level;
        public Variable trait;
        public long traitId;
        private List<VariableNode> childs;
        public List<Variable> traits = new ArrayList<Variable>();
        public boolean loaded = false;

        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + Objects.hashCode(this.parentObjectId);
            hash = 53 * hash + (this.var == null ? 0 : Objects.hashCode(this.var.name));
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableNode other = (VariableNode)obj;
            if (!Objects.equals(this.parentObjectId, other.parentObjectId)) {
                return false;
            }
            if (this.var == null && other.var == null) {
                return true;
            }
            if (this.var == null) {
                return false;
            }
            if (other.var == null) {
                return false;
            }
            return Objects.equals(this.var.name, other.var.name);
        }

        private static boolean isTraits(Variable v) {
            return v.vType == 8 && "traits".equals(v.typeName);
        }

        public String toString() {
            if (this.level == 0) {
                return "root";
            }
            return this.var.name;
        }

        private void refresh() {
            if (this.path.size() > 1) {
                this.path.get(this.path.size() - 2).reloadChildren();
            }
        }

        private void reloadChildren() {
            this.childs = new ArrayList<VariableNode>();
            this.traits = new ArrayList<Variable>();
            if ("".equals(this.var.name)) {
                return;
            }
            Long objectId = ABCPanel.varToObjectId(this.var);
            boolean useGetter = (this.var.flags & 0x400000) == 0;
            boolean isAS3 = Main.getMainFrame().getPanel().getCurrentSwf().isAS3();
            InGetVariable igv = this.parentObjectId == 0L && objectId != 0L && isAS3 ? Main.getDebugHandler().getVariable(objectId, "", true, useGetter) : Main.getDebugHandler().getVariable(this.parentObjectId, this.var.name, true, useGetter);
            if ((this.var.flags & 0x80000) > 0) {
                this.varInsideGetter = igv.parent;
            }
            Variable curTrait = null;
            for (int i = 0; i < igv.childs.size(); ++i) {
                if (!((Boolean)Configuration.showVarsWithDontEnumerateFlag.get()).booleanValue() && (((Variable)igv.childs.get((int)i)).flags & 1) > 0) continue;
                if (!VariableNode.isTraits((Variable)igv.childs.get(i))) {
                    Long parentObjectId = ABCPanel.varToObjectId(this.varInsideGetter);
                    this.childs.add(new VariableNode(this.path, this.level + 1, (Variable)igv.childs.get(i), parentObjectId, curTrait));
                    continue;
                }
                curTrait = (Variable)igv.childs.get(i);
                this.traits.add(curTrait);
            }
        }

        private void ensureLoaded() {
            if (!this.loaded) {
                this.reloadChildren();
                this.loaded = true;
            }
        }

        public VariableNode getChildAt(int index) {
            this.ensureLoaded();
            return this.childs.get(index);
        }

        public int getChildCount() {
            this.ensureLoaded();
            return this.childs.size();
        }

        public VariableNode(List<VariableNode> parentPath, int level, Variable var, Long parentObjectId, Variable trait) {
            this.var = var;
            this.varInsideGetter = var;
            this.parentObjectId = parentObjectId;
            this.level = level;
            this.trait = trait;
            this.path.addAll(parentPath);
            this.path.add(this);
            this.loaded = false;
        }

        public VariableNode(List<VariableNode> parentPath, int level, Variable var, Long parentObjectId, Variable trait, List<VariableNode> subvars) {
            this.var = var;
            this.varInsideGetter = var;
            this.parentObjectId = parentObjectId;
            this.level = level;
            this.trait = trait;
            this.childs = subvars;
            this.path.addAll(parentPath);
            this.path.add(this);
            for (VariableNode vn : subvars) {
                vn.path.clear();
                vn.path.addAll(this.path);
                vn.path.add(vn);
            }
            this.loaded = true;
        }
    }
}

