/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.SelectTagOfTypeDialog;
import com.jpexs.decompiler.flash.gui.SelectTagPositionDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class As3ClassLinkageDialog
extends AppDialog {
    private final JButton proceedButton = new JButton(this.translate("button.proceed"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JTextField classNameTextField = new JTextField(30);
    private final JTextField parentClassNameTextField = new JTextField(30);
    private String selectedClass = null;
    private String selectedParentClass = null;
    private ABCContainerTag selectedAbcContainer;
    private SymbolClassTag selectedSymbolClassTag;
    private SymbolClassTag originalSymbolClassTag;
    private Tag selectedPosition;
    private Timelined selectedTimelined;
    private int result = -1;
    private final SWF swf;
    private final int characterId;
    private int characterFrame = -1;
    private int abcCount = 0;
    private int symbolClassCount = 0;
    private ABCContainerTag foundInAbcContainer = null;
    private final List<ABCContainerTag> abcContainers = new ArrayList<ABCContainerTag>();
    private int abcFrame = -1;
    private boolean createClass = false;
    private final JPanel classFoundOrNotOrErrorPanel;
    private final JLabel errorLabel = new JLabel();
    private final JRadioButton existingAbcTagRadioButton = new JRadioButton(this.translate("class.notfound.create.abc.where.existing"));
    private final JRadioButton newAbcTagRadioButton = new JRadioButton(this.translate("class.notfound.create.abc.where.new"));
    private final JRadioButton createClassRadioButton = new JRadioButton(this.translate("class.notfound.create"));
    private final JRadioButton onlySetClassNameRadioButton = new JRadioButton(this.translate("class.notfound.onlySetClassName"));
    private final JRadioButton existingSymbolClassTagRadioButton = new JRadioButton(this.translate("class.notfound.onlySetClassName.symbolClass.where.existing"));
    private final JRadioButton newSymbolClassTagRadioButton = new JRadioButton(this.translate("class.notfound.onlySetClassName.symbolClass.where.new"));
    private static final String CLASS_NOT_FOUND_CARD = "Class not found panel";
    private static final String CLASS_FOUND_CARD = "Class found panel";
    private static final String ERROR_CARD = "Error panel";
    private static final String CREATE_CLASS_CARD = "Create class panel";
    private static final String DO_NOT_CREATE_CLASS_CARD = "Do not create class panel";
    private static final Map<Class<?>, String> tagTypeToParentClass = new HashMap();

    public static String getParentClassFromCharacter(CharacterTag ch) {
        for (Class<?> cls : tagTypeToParentClass.keySet()) {
            if (!cls.isAssignableFrom(ch.getClass())) continue;
            return tagTypeToParentClass.get(cls);
        }
        return null;
    }

    public As3ClassLinkageDialog(Window owner, SWF swf, int characterId) {
        super(owner);
        this.swf = swf;
        this.characterId = characterId;
        CharacterTag ch = swf.getCharacter(characterId);
        if (ch == null) {
            throw new RuntimeException("Character " + characterId + " not found");
        }
        this.parentClassNameTextField.setText(As3ClassLinkageDialog.getParentClassFromCharacter(ch));
        int frame = 1;
        for (Tag t : swf.getTags()) {
            if (t == ch) {
                this.characterFrame = frame;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        frame = 1;
        for (Tag t : swf.getTags()) {
            if (frame >= this.characterFrame) {
                if (t instanceof ABCContainerTag) {
                    ++this.abcCount;
                    this.abcContainers.add((ABCContainerTag)t);
                }
                if (t instanceof SymbolClassTag) {
                    SymbolClassTag sc = (SymbolClassTag)t;
                    if (sc.tags.contains(characterId)) {
                        this.originalSymbolClassTag = sc;
                    }
                    ++this.symbolClassCount;
                }
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        LinkedHashSet classNames = ch.getClassNames();
        if (classNames.size() == 1) {
            this.classNameTextField.setText((String)classNames.iterator().next());
        }
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container cnt = this.getContentPane();
        cnt.setLayout(new BoxLayout(cnt, 1));
        JPanel classFoundPanel = new JPanel();
        classFoundPanel.setLayout(new BoxLayout(classFoundPanel, 1));
        JLabel classFoundLabel = new JLabel(this.translate("class.found"));
        classFoundPanel.add(classFoundLabel);
        JLabel symbolClassAppropriateLabel = new JLabel(this.translate("symbolClassAppropriate"));
        classFoundPanel.add(symbolClassAppropriateLabel);
        JPanel classNotFoundPanel = new JPanel();
        classNotFoundPanel.setLayout(new BoxLayout(classNotFoundPanel, 1));
        JLabel notFoundLabel = new JLabel(this.translate("class.notfound"));
        classNotFoundPanel.add(notFoundLabel);
        JLabel createAskLabel = new JLabel(this.translate("class.notfound.createAsk"));
        classNotFoundPanel.add(createAskLabel);
        ButtonGroup doCreateClassButtonGroup = new ButtonGroup();
        doCreateClassButtonGroup.add(this.createClassRadioButton);
        doCreateClassButtonGroup.add(this.onlySetClassNameRadioButton);
        JPanel createNewClassAsk = new JPanel(new FlowLayout());
        createNewClassAsk.add(this.createClassRadioButton);
        createNewClassAsk.add(this.onlySetClassNameRadioButton);
        this.createClassRadioButton.setSelected(true);
        classNotFoundPanel.add(createNewClassAsk);
        JPanel createNewClassPanel = new JPanel();
        createNewClassPanel.setLayout(new BoxLayout(createNewClassPanel, 1));
        JLabel parentClassNameLabel = new JLabel(this.translate("class.notfound.create.parentType"));
        createNewClassPanel.add(parentClassNameLabel);
        createNewClassPanel.add(this.parentClassNameTextField);
        JLabel abcWhereLabel = new JLabel(this.translate("class.notfound.create.abc.where"));
        createNewClassPanel.add(abcWhereLabel);
        ButtonGroup abcTargetButtonGroup = new ButtonGroup();
        abcTargetButtonGroup.add(this.existingAbcTagRadioButton);
        abcTargetButtonGroup.add(this.newAbcTagRadioButton);
        this.existingAbcTagRadioButton.setSelected(true);
        JPanel abcTargetPanel = new JPanel(new FlowLayout());
        abcTargetPanel.add(this.existingAbcTagRadioButton);
        abcTargetPanel.add(this.newAbcTagRadioButton);
        createNewClassPanel.add(abcTargetPanel);
        JLabel symbolClassAppropriate2Label = new JLabel(this.translate("symbolClassAppropriate"));
        classFoundPanel.add(symbolClassAppropriate2Label);
        createNewClassPanel.add(symbolClassAppropriate2Label);
        JPanel doNotCreateNewClassPanel = new JPanel();
        doNotCreateNewClassPanel.setLayout(new BoxLayout(doNotCreateNewClassPanel, 1));
        ButtonGroup whereToStoreMappingButtonGroup = new ButtonGroup();
        whereToStoreMappingButtonGroup.add(this.existingSymbolClassTagRadioButton);
        whereToStoreMappingButtonGroup.add(this.newSymbolClassTagRadioButton);
        if (this.originalSymbolClassTag == null) {
            doNotCreateNewClassPanel.add(new JLabel(this.translate("class.notfound.onlySetClassName.symbolClass.where")));
            JPanel whereToStoreMappingPanel = new JPanel(new FlowLayout());
            whereToStoreMappingPanel.add(this.existingSymbolClassTagRadioButton);
            whereToStoreMappingPanel.add(this.newSymbolClassTagRadioButton);
            doNotCreateNewClassPanel.add(whereToStoreMappingPanel);
        }
        this.existingSymbolClassTagRadioButton.setSelected(true);
        this.setCentralAlignment(doNotCreateNewClassPanel);
        this.setCentralAlignment(createNewClassPanel);
        final JPanel createNewClassAskCards = new JPanel(new CardLayout());
        createNewClassAskCards.add((Component)createNewClassPanel, CREATE_CLASS_CARD);
        createNewClassAskCards.add((Component)doNotCreateNewClassPanel, DO_NOT_CREATE_CLASS_CARD);
        classNotFoundPanel.add(createNewClassAskCards);
        ChangeListener createClassSwitched = new ChangeListener(){
            final /* synthetic */ As3ClassLinkageDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                CardLayout cl = (CardLayout)createNewClassAskCards.getLayout();
                if (this.this$0.createClassRadioButton.isSelected()) {
                    cl.show(createNewClassAskCards, As3ClassLinkageDialog.CREATE_CLASS_CARD);
                } else {
                    cl.show(createNewClassAskCards, As3ClassLinkageDialog.DO_NOT_CREATE_CLASS_CARD);
                }
                this.this$0.checkEnabled();
            }
        };
        this.createClassRadioButton.addChangeListener(createClassSwitched);
        this.onlySetClassNameRadioButton.addChangeListener(createClassSwitched);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.proceedButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(this.proceedButton);
        buttonsPanel.add(this.cancelButton);
        JLabel classNameLabel = new JLabel(this.translate("classname"));
        cnt.add(classNameLabel);
        cnt.add(this.classNameTextField);
        JPanel errorPanel = new JPanel(new FlowLayout());
        errorPanel.add(this.errorLabel);
        this.setCentralAlignment(classFoundPanel);
        this.setCentralAlignment(classNotFoundPanel);
        this.setCentralAlignment(errorPanel);
        this.classFoundOrNotOrErrorPanel = new JPanel(new CardLayout());
        this.classFoundOrNotOrErrorPanel.add((Component)classFoundPanel, CLASS_FOUND_CARD);
        this.classFoundOrNotOrErrorPanel.add((Component)classNotFoundPanel, CLASS_NOT_FOUND_CARD);
        this.classFoundOrNotOrErrorPanel.add((Component)errorPanel, ERROR_CARD);
        cnt.add(this.classFoundOrNotOrErrorPanel);
        cnt.add(buttonsPanel);
        this.setCentralAlignment((JComponent)cnt);
        if (this.abcCount == 0) {
            this.newAbcTagRadioButton.setSelected(true);
            this.newAbcTagRadioButton.setEnabled(false);
            this.existingAbcTagRadioButton.setEnabled(false);
        }
        if (this.symbolClassCount == 0) {
            this.newSymbolClassTagRadioButton.setSelected(true);
            this.newSymbolClassTagRadioButton.setEnabled(false);
            this.existingSymbolClassTagRadioButton.setEnabled(false);
        }
        this.existingSymbolClassTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }
        });
        this.newSymbolClassTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }
        });
        this.existingAbcTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }
        });
        this.newAbcTagRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }
        });
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                As3ClassLinkageDialog.this.checkEnabled();
            }
        });
        this.classNameTextField.addActionListener(this::okButtonActionPerformed);
        this.checkEnabled();
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        View.setWindowIcon(this);
        View.centerScreen(this);
    }

    private void setCentralAlignment(JComponent container) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setAlignmentX(0.5f);
        }
    }

    private void checkEnabled() {
        boolean ok = true;
        String newClassName = this.classNameTextField.getText();
        if (newClassName.endsWith(".")) {
            ok = false;
            this.errorLabel.setText("");
        }
        if (ok) {
            CharacterTag ch = this.swf.getCharacter(this.characterId);
            LinkedHashSet oldClassNames = ch.getClassNames();
            if (oldClassNames.size() > 1) {
                ok = false;
                this.errorLabel.setText(this.translate("error.multipleClasses"));
            } else if (oldClassNames.size() == 1 && newClassName.equals(oldClassNames.iterator().next())) {
                ok = false;
                this.errorLabel.setText(this.translate("error.needToModify"));
            } else if (!newClassName.isEmpty() && this.swf.getCharacterByClass(newClassName) != null) {
                ok = false;
                this.errorLabel.setText(this.translate("error.alreadyAssignedClass"));
            }
        }
        CardLayout cl = (CardLayout)this.classFoundOrNotOrErrorPanel.getLayout();
        if (ok) {
            if (newClassName.isEmpty()) {
                this.proceedButton.setText(this.translate("button.ok"));
                cl.show(this.classFoundOrNotOrErrorPanel, ERROR_CARD);
                this.errorLabel.setText("");
            } else {
                block22: {
                    ArrayList<String> classNames = new ArrayList<String>();
                    classNames.add(newClassName);
                    this.foundInAbcContainer = null;
                    try {
                        List scriptPacks = this.swf.getScriptPacksByClassNames(classNames);
                        if (scriptPacks.isEmpty()) break block22;
                        ABC foundInAbc = ((ScriptPack)scriptPacks.get((int)0)).abc;
                        boolean foundContainer = false;
                        for (ABCContainerTag cnt : this.abcContainers) {
                            if (cnt.getABC() != foundInAbc) continue;
                            this.foundInAbcContainer = cnt;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.foundInAbcContainer != null) {
                    cl.show(this.classFoundOrNotOrErrorPanel, CLASS_FOUND_CARD);
                } else {
                    cl.show(this.classFoundOrNotOrErrorPanel, CLASS_NOT_FOUND_CARD);
                    if (this.createClassRadioButton.isSelected()) {
                        if (this.existingAbcTagRadioButton.isSelected() && this.abcCount == 1) {
                            this.proceedButton.setText(this.translate("button.ok"));
                        } else {
                            this.proceedButton.setText(this.translate("button.proceed"));
                        }
                    } else if (this.originalSymbolClassTag != null || this.existingSymbolClassTagRadioButton.isSelected() && this.symbolClassCount == 1) {
                        this.proceedButton.setText(this.translate("button.ok"));
                    } else {
                        this.proceedButton.setText(this.translate("button.proceed"));
                    }
                }
            }
        } else {
            cl.show(this.classFoundOrNotOrErrorPanel, ERROR_CARD);
            this.proceedButton.setText(this.translate("button.ok"));
        }
        this.proceedButton.setEnabled(ok);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.proceedButton.isEnabled()) {
            return;
        }
        this.setVisible(false);
        boolean emptyClassName = this.classNameTextField.getText().isEmpty();
        if (emptyClassName) {
            this.selectedSymbolClassTag = this.originalSymbolClassTag;
        } else if (this.foundInAbcContainer == null) {
            SelectTagPositionDialog selectTagPositionDialog;
            if (this.createClassRadioButton.isSelected()) {
                if (this.existingAbcTagRadioButton.isSelected()) {
                    SelectTagOfTypeDialog selectDoABCDialog = new SelectTagOfTypeDialog(this.owner, this.swf, ABCContainerTag.class, "DoABC", this.characterFrame);
                    this.selectedAbcContainer = (ABCContainerTag)selectDoABCDialog.showDialog();
                    if (this.selectedAbcContainer == null) {
                        this.cancelButtonActionPerformed(evt);
                        return;
                    }
                }
                if (this.newAbcTagRadioButton.isSelected()) {
                    selectTagPositionDialog = new SelectTagPositionDialog(this.owner, this.swf, false, "DoABC", this.characterFrame);
                    if (selectTagPositionDialog.showDialog() != 0) {
                        this.cancelButtonActionPerformed(evt);
                        return;
                    }
                    this.selectedPosition = selectTagPositionDialog.getSelectedTag();
                    this.selectedTimelined = selectTagPositionDialog.getSelectedTimelined();
                }
            } else if (this.originalSymbolClassTag != null) {
                this.selectedSymbolClassTag = this.originalSymbolClassTag;
            } else {
                if (this.existingSymbolClassTagRadioButton.isSelected()) {
                    SelectTagOfTypeDialog selectSymbolClassDialog = new SelectTagOfTypeDialog(this.owner, this.swf, SymbolClassTag.class, "SymbolClass", this.characterFrame);
                    this.selectedSymbolClassTag = (SymbolClassTag)selectSymbolClassDialog.showDialog();
                    if (this.selectedSymbolClassTag == null) {
                        this.cancelButtonActionPerformed(evt);
                        return;
                    }
                }
                if (this.newSymbolClassTagRadioButton.isSelected()) {
                    selectTagPositionDialog = new SelectTagPositionDialog(this.owner, this.swf, false, "SymbolClass", this.characterFrame);
                    if (selectTagPositionDialog.showDialog() != 0) {
                        this.cancelButtonActionPerformed(evt);
                        return;
                    }
                    this.selectedPosition = selectTagPositionDialog.getSelectedTag();
                    this.selectedTimelined = selectTagPositionDialog.getSelectedTimelined();
                }
            }
        } else {
            this.selectedAbcContainer = this.foundInAbcContainer;
        }
        if (this.selectedAbcContainer != null) {
            int frame = 1;
            for (Tag t : this.swf.getTags()) {
                if (t == this.selectedAbcContainer) {
                    this.abcFrame = frame;
                    break;
                }
                if (!(t instanceof ShowFrameTag)) continue;
                ++frame;
            }
        }
        this.createClass = !emptyClassName && this.foundInAbcContainer == null && this.createClassRadioButton.isSelected();
        this.result = 0;
        this.selectedClass = this.classNameTextField.getText();
        this.selectedParentClass = this.parentClassNameTextField.getText();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedClass = null;
        this.selectedParentClass = null;
        this.selectedAbcContainer = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.selectedSymbolClassTag = null;
        this.foundInAbcContainer = null;
        this.createClass = false;
        this.abcFrame = -1;
        this.characterFrame = -1;
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.selectedClass = null;
        this.selectedParentClass = null;
        this.selectedAbcContainer = null;
        this.selectedPosition = null;
        this.selectedTimelined = null;
        this.selectedSymbolClassTag = null;
        this.foundInAbcContainer = null;
        this.createClass = false;
        this.abcFrame = -1;
        this.setVisible(true);
        return this.result;
    }

    public Tag getSelectedPosition() {
        return this.selectedPosition;
    }

    public String getSelectedClass() {
        return this.selectedClass;
    }

    public String getSelectedParentClass() {
        return this.selectedParentClass;
    }

    public SymbolClassTag getSelectedSymbolClassTag() {
        return this.selectedSymbolClassTag;
    }

    public Timelined getSelectedTimelined() {
        return this.selectedTimelined;
    }

    public ABCContainerTag getSelectedAbcContainer() {
        return this.selectedAbcContainer;
    }

    public boolean isClassFound() {
        return this.foundInAbcContainer != null;
    }

    public int getCharacterFrame() {
        return this.characterFrame;
    }

    public int getAbcFrame() {
        return this.abcFrame;
    }

    public boolean doCreateClass() {
        return this.createClass;
    }

    static {
        tagTypeToParentClass.put(SoundTag.class, "flash.media.Sound");
        tagTypeToParentClass.put(ImageTag.class, "flash.display.Bitmap");
        tagTypeToParentClass.put(FontTag.class, "flash.text.Font");
        tagTypeToParentClass.put(DefineFont4Tag.class, "flash.text.Font");
        tagTypeToParentClass.put(DefineBinaryDataTag.class, "flash.utils.ByteArray");
        tagTypeToParentClass.put(DefineSpriteTag.class, "flash.display.Sprite");
    }
}

