/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.ASM3Parser;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.abc.TraitDetail;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightingList;
import com.jpexs.decompiler.flash.tags.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ClassTraitDetailPanel
extends JPanel
implements TraitDetail {
    public LineMarkedEditorPane classEditor = new LineMarkedEditorPane();
    private ABC abc;
    private TraitClass trait;
    private HighlightingList specialHilights;
    private boolean ignoreCaret = false;
    private boolean active = false;

    public ClassTraitDetailPanel(final DecompiledEditorPane editor) {
        this.setLayout(new BorderLayout());
        this.add((Component)new FasterScrollPane(this.classEditor), "Center");
        this.classEditor.setFont(Configuration.getSourceFont());
        this.classEditor.changeContentType("text/flasm3");
        this.classEditor.addCaretListener(new CaretListener(){
            final /* synthetic */ ClassTraitDetailPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                if (this.this$0.ignoreCaret) {
                    return;
                }
                Highlighting spec = Highlighting.searchPos((HighlightingList)this.this$0.specialHilights, (long)this.this$0.classEditor.getCaretPosition());
                if (spec != null) {
                    editor.hilightSpecial(spec.getProperties().subtype, (int)spec.getProperties().index);
                    this.this$0.classEditor.getCaret().setVisible(true);
                }
            }
        });
    }

    public void hilightSpecial(Highlighting special) {
        Highlighting sel = null;
        for (Highlighting h : this.specialHilights) {
            if (!h.getProperties().subtype.equals((Object)special.getProperties().subtype) || h.getProperties().index != special.getProperties().index) continue;
            sel = h;
            break;
        }
        if (sel != null) {
            this.ignoreCaret = true;
            this.classEditor.setCaretPosition(sel.startPos);
            this.classEditor.getCaret().setVisible(true);
            this.ignoreCaret = false;
        }
    }

    public void load(TraitClass trait, ABC abc, boolean isStatic) {
        this.abc = abc;
        this.trait = trait;
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        trait.convertTraitHeader(abc, (GraphTextWriter)writer);
        if (((Boolean)Configuration.indentAs3PCode.get()).booleanValue()) {
            writer.unindent();
        }
        writer.appendNoHilight("end ; trait");
        writer.finishHilights();
        String s = writer.toString();
        this.specialHilights = writer.specialHilights;
        this.classEditor.setText(s);
    }

    @Override
    public boolean save() {
        try {
            if (!ASM3Parser.parseClass((ABC)this.abc, (Reader)new StringReader(this.classEditor.getText()), (AVM2ConstantPool)this.abc.constants, (TraitClass)this.trait)) {
                return false;
            }
        }
        catch (AVM2ParseException ex) {
            ViewMessages.showMessageDialog(this.classEditor, ex.text, AppStrings.translate("error.class"), 0);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(ClassTraitDetailPanel.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        this.abc.refreshMultinameNamespaceSuffixes();
        ((Tag)this.abc.parentTag).setModified(true);
        this.abc.fireChanged();
        return true;
    }

    @Override
    public void setEditMode(boolean val) {
        if (val && this.active) {
            ViewMessages.showMessageDialog(this, AppStrings.translate("warning.initializers.class"), AppStrings.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningInitializersClass);
        }
        this.classEditor.setEditable(val);
        if (val) {
            this.classEditor.requestFocusInWindow();
        }
    }

    @Override
    public void setActive(boolean val) {
        this.active = val;
    }
}

