/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ClassesListTreeModel
extends AS3ClassTreeItem
implements TreeModel {
    private final Openable targetItem;
    private List<ScriptPack> list;
    private final AS3Package root;
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private boolean flat = true;
    private SWF swf;

    public List<ScriptPack> getList() {
        return this.list;
    }

    public ClassesListTreeModel(SWF swf, boolean flat) {
        super(null, null, null);
        this.flat = flat;
        this.root = new AS3Package(null, (Openable)swf, flat, false, null, false, null);
        this.targetItem = swf;
        this.list = swf.getAS3Packs();
        this.swf = swf;
        this.setFilter(null);
    }

    public ClassesListTreeModel(ABC abc, boolean flat) {
        super(null, null, null);
        this.flat = flat;
        this.root = new AS3Package(null, abc.getOpenable(), flat, false, null, false, null);
        this.targetItem = abc;
        ArrayList<ABC> allAbcs = new ArrayList<ABC>();
        allAbcs.add(abc);
        this.list = abc.getScriptPacks(null, allAbcs);
        this.setFilter(null);
    }

    public Openable getOpenable() {
        return this.targetItem.getOpenable();
    }

    public final void update() {
        if (this.targetItem instanceof SWF) {
            this.list = ((SWF)this.targetItem).getAS3Packs();
        } else if (this.targetItem instanceof ABC) {
            ABC abc = (ABC)this.targetItem;
            ArrayList<ABC> allAbcs = new ArrayList<ABC>();
            allAbcs.add(abc);
            this.list = abc.getScriptPacks(null, allAbcs);
        }
        this.setFilter(null);
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.root));
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    public final void setFilter(String filter) {
        this.root.clear();
        ArrayList ignoredClasses = new ArrayList();
        ArrayList ignoredNss = new ArrayList();
        if (((Boolean)Configuration._ignoreAdditionalFlexClasses.get()).booleanValue() && this.targetItem instanceof SWF) {
            ((SWF)this.targetItem).getFlexMainClass(ignoredClasses, ignoredNss);
        }
        filter = filter == null || filter.isEmpty() ? null : filter.toLowerCase(Locale.ENGLISH);
        block0: for (ScriptPack item : this.list) {
            DottedChain packageStr;
            AS3Package pkg;
            if (filter != null && !item.getClassPath().toString().toLowerCase(Locale.ENGLISH).contains(filter) || !item.isSimple && ((Boolean)Configuration.ignoreCLikePackages.get()).booleanValue()) continue;
            if (((Boolean)Configuration._ignoreAdditionalFlexClasses.get()).booleanValue()) {
                String fullName = item.getClassPath().packageStr.add(item.getClassPath().className, item.getClassPath().namespaceSuffix).toRawString();
                if (ignoredClasses.contains(fullName)) continue;
                for (String ns : ignoredNss) {
                    if (!fullName.startsWith(ns + ".")) continue;
                    continue block0;
                }
            }
            if ((pkg = this.ensurePackage(packageStr = item.getClassPath().packageStr, item.abc, item.isSimple ? null : Integer.valueOf(item.scriptIndex), item)) == null) continue;
            pkg.addScriptPack(item);
        }
    }

    private AS3Package ensurePackage(DottedChain packageStr, ABC abc, Integer scriptIndex, ScriptPack pack) {
        AS3Package parent = this.root;
        if (scriptIndex != null) {
            String pathElement = "script_" + scriptIndex;
            AS3Package pkg = parent.getSubPackage(pathElement);
            if (pkg == null) {
                pkg = new AS3Package(pathElement, this.getOpenable(), false, false, abc, true, scriptIndex);
                parent.addSubPackage(pkg);
            }
            if (pack.traitIndices.isEmpty()) {
                pkg.setCompoundInitializerPack(pack);
                return null;
            }
            parent = pkg;
        }
        if (this.flat) {
            AS3Package pkg;
            String fullName = packageStr.toPrintableString(new LinkedHashSet(), this.getSwf(), true);
            boolean defaultPackage = false;
            if (fullName.length() == 0) {
                fullName = AppResources.translate((String)"package.default");
                defaultPackage = true;
            }
            if ((pkg = parent.getSubPackage(fullName)) == null) {
                pkg = new AS3Package(fullName, this.getOpenable(), true, defaultPackage, null, scriptIndex != null, null);
                parent.addSubPackage(pkg);
            }
            return pkg;
        }
        for (int i = 0; i < packageStr.size(); ++i) {
            String pathElement = IdentifiersDeobfuscation.printIdentifier((SWF)this.getSwf(), new LinkedHashSet(), (boolean)true, (String)packageStr.get(i), (String[])new String[0]);
            AS3Package pkg = parent.getSubPackage(pathElement);
            if (pkg == null) {
                pkg = new AS3Package(pathElement, this.getOpenable(), false, false, null, scriptIndex != null, null);
                parent.addSubPackage(pkg);
            }
            parent = pkg;
        }
        return parent;
    }

    public ScriptPack getElementByClassIndex(int classIndex) {
        return this.getElementByClassIndexRecursive(this.root, classIndex);
    }

    private ScriptPack getElementByClassIndexRecursive(AS3Package item, int classIndex) {
        for (AS3Package pkg : item.getSubPackages()) {
            ScriptPack result = this.getElementByClassIndexRecursive(pkg, classIndex);
            if (result == null) continue;
            return result;
        }
        for (ScriptPack sc : item.getScriptPacks()) {
            for (Trait t : ((ScriptInfo)sc.abc.script_info.get((int)sc.scriptIndex)).traits.traits) {
                if (!(t instanceof TraitClass) || ((TraitClass)t).class_info != classIndex) continue;
                return sc;
            }
        }
        return null;
    }

    public AS3ClassTreeItem getRoot() {
        return this.root;
    }

    public List<AS3ClassTreeItem> getAllChildren(Object parent) {
        AS3Package pkg = (AS3Package)parent;
        return pkg.getAllChildren();
    }

    public AS3ClassTreeItem getChild(Object parent, int index) {
        AS3Package pkg = (AS3Package)parent;
        return pkg.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        AS3ClassTreeItem parentItem = (AS3ClassTreeItem)parent;
        if (parentItem instanceof ScriptPack) {
            return 0;
        }
        AS3Package pkg = (AS3Package)parentItem;
        return pkg.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        AS3ClassTreeItem te = (AS3ClassTreeItem)node;
        return te instanceof ScriptPack;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        AS3Package pkg = (AS3Package)parent;
        return pkg.getIndexOfChild((AS3ClassTreeItem)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return AppStrings.translate("node.scripts");
    }

    public boolean isModified() {
        return this.root.isModified();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassesListTreeModel)) {
            return false;
        }
        return this.targetItem.equals((Object)((ClassesListTreeModel)obj).targetItem);
    }

    public int hashCode() {
        return ClassesListTreeModel.class.hashCode() ^ this.targetItem.hashCode();
    }

    protected SWF getSwf() {
        return this.swf;
    }
}

