/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.DeobfuscationLevel;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.DeobfuscationScope;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DeobfuscationDialog
extends AppDialog {
    private final JRadioButton removeDeadCodeRadioButton = new JRadioButton(this.translate("deobfuscation.removedeadcode"));
    private final JRadioButton removeTrapsRadioButton = new JRadioButton(this.translate("deobfuscation.removetraps"));
    private final JRadioButton methodScopeRadioButton = new JRadioButton(this.translate("deobfuscation.scope.method"));
    private final JRadioButton scriptScopeRadioButton = new JRadioButton(this.translate("deobfuscation.scope.script"));
    private final JRadioButton swfScopeRadioButton = new JRadioButton(this.translate("deobfuscation.scope.swf"));
    private int result = -1;

    public DeobfuscationDialog(Window owner) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JLabel processingLevelLabel = new JLabel(this.translate("deobfuscation.level"));
        processingLevelLabel.setAlignmentX(0.5f);
        contentPane.add(processingLevelLabel);
        JPanel processingLevelPanel = new JPanel(new FlowLayout());
        ButtonGroup levelGroup = new ButtonGroup();
        levelGroup.add(this.removeDeadCodeRadioButton);
        levelGroup.add(this.removeTrapsRadioButton);
        this.removeTrapsRadioButton.setSelected(true);
        processingLevelPanel.add(this.removeDeadCodeRadioButton);
        processingLevelPanel.add(this.removeTrapsRadioButton);
        processingLevelPanel.setAlignmentX(0.5f);
        this.removeTrapsRadioButton.setSelected(true);
        contentPane.add(processingLevelPanel);
        JLabel scopeLabel = new JLabel(this.translate("deobfuscation.scope"));
        scopeLabel.setAlignmentX(0.5f);
        contentPane.add(scopeLabel);
        ButtonGroup scopeGroup = new ButtonGroup();
        scopeGroup.add(this.methodScopeRadioButton);
        scopeGroup.add(this.scriptScopeRadioButton);
        scopeGroup.add(this.swfScopeRadioButton);
        JPanel scopePanel = new JPanel(new FlowLayout());
        scopePanel.add(this.methodScopeRadioButton);
        scopePanel.add(this.scriptScopeRadioButton);
        scopePanel.add(this.swfScopeRadioButton);
        this.swfScopeRadioButton.setSelected(true);
        scopePanel.setAlignmentX(0.5f);
        contentPane.add(scopePanel);
        JLabel warningLabel = new JLabel("<html><center>" + this.translate("warning.modify").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\r\n", "<br/>") + "</center></html>");
        warningLabel.setAlignmentX(0.5f);
        warningLabel.setFont(warningLabel.getFont().deriveFont(1));
        contentPane.add(warningLabel);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.setAlignmentX(0.5f);
        contentPane.add(buttonsPanel);
        this.setModal(true);
        this.pack();
        View.centerScreen(this);
        this.setIconImage(View.loadImage("deobfuscate16"));
    }

    public DeobfuscationLevel getDeobfuscationLevel() {
        if (this.removeTrapsRadioButton.isSelected()) {
            return DeobfuscationLevel.LEVEL_REMOVE_TRAPS;
        }
        return DeobfuscationLevel.LEVEL_REMOVE_DEAD_CODE;
    }

    public DeobfuscationScope getDeobfuscationScope() {
        if (this.methodScopeRadioButton.isSelected()) {
            return DeobfuscationScope.METHOD;
        }
        if (this.scriptScopeRadioButton.isSelected()) {
            return DeobfuscationScope.CLASS;
        }
        return DeobfuscationScope.SWF;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

