/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class LinkDialog
extends JDialog {
    private MainPanel mainPanel;
    private JList<LinkItem> linkList;
    private SWF swf;
    private boolean overLinkButton = false;
    private JLabel noOtherFilesLabel = new JLabel(AppStrings.translate("abc.link.dialog.noOtherFilesOpened"));
    private List<ActionListener> saveListeners = new ArrayList<ActionListener>();

    public void addSaveListener(ActionListener listener) {
        this.saveListeners.add(listener);
    }

    public void removeSaveListener(ActionListener listener) {
        this.saveListeners.remove(listener);
    }

    private void fireSave() {
        for (ActionListener listener : this.saveListeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "SAVE"));
        }
    }

    public LinkDialog(MainPanel mainPanel, final JToggleButton linkButton) {
        this.mainPanel = mainPanel;
        linkButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkDialog.this.overLinkButton = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkDialog.this.overLinkButton = false;
            }
        });
        this.setUndecorated(true);
        this.setResizable(false);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setSize(400, 300);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ LinkDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                this.this$0.save(this.this$0.swf, false);
                this.this$0.swf = null;
                if (!this.this$0.overLinkButton) {
                    linkButton.setSelected(false);
                }
                this.this$0.dispose();
            }
        });
        this.noOtherFilesLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel customLibraryPanel = new JPanel(new BorderLayout());
        this.linkList = new JList();
        this.linkList.setCellRenderer(new CustomLibraryListCellRenderer());
        this.linkList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    LinkItem item;
                    int index = LinkDialog.this.linkList.locationToIndex(e.getPoint());
                    item.setSelected(!(item = (LinkItem)LinkDialog.this.linkList.getModel().getElementAt(index)).isSelected());
                    LinkDialog.this.linkList.repaint(LinkDialog.this.linkList.getCellBounds(index, index));
                }
            }
        });
        customLibraryPanel.add(this.linkList, "Center");
        customLibraryPanel.add((Component)this.noOtherFilesLabel, "North");
        customLibraryPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.setContentPane(customLibraryPanel);
    }

    public void load(SWF swf) {
        List preselectedNames;
        this.swf = swf;
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
        List<SWF> selectedSWFs = new ArrayList<SWF>();
        if (conf != null && !(preselectedNames = conf.getCustomDataAsList("abcDependencies")).isEmpty()) {
            selectedSWFs = Main.namesToSwfs(preselectedNames);
        }
        this.populateSWFs(swf, selectedSWFs);
        this.noOtherFilesLabel.setVisible(selectedSWFs.isEmpty());
    }

    public void show(SWF swf) {
        this.load(swf);
        this.setVisible(true);
    }

    public void save(SWF swf, boolean force) {
        Map<String, SWF> map = this.getSelectedSwfs();
        SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
        List oldValue = conf.getCustomDataAsList("abcDependencies");
        ArrayList<String> newValue = new ArrayList<String>(map.keySet());
        conf.setCustomData("abcDependencies", newValue);
        ArrayList<SWF> swfs = new ArrayList<SWF>(map.values());
        if (!Objects.equals(oldValue, newValue) || force) {
            swf.setAbcIndexDependencies(swfs);
            this.fireSave();
        }
    }

    private Map<String, SWF> getSelectedSwfs() {
        ListModel<LinkItem> model = this.linkList.getModel();
        LinkedHashMap<String, SWF> ret = new LinkedHashMap<String, SWF>();
        for (int i = 0; i < model.getSize(); ++i) {
            LinkItem item = model.getElementAt(i);
            if (!item.isSelected()) continue;
            ret.put(item.getName(), item.getSwf());
        }
        return ret;
    }

    private void populateSWFs(SWF ignoreSWF, List<SWF> selectedSWFs) {
        LinkedHashMap<String, SWF> swfs = new LinkedHashMap<String, SWF>();
        Main.populateAllSWFs(swfs);
        DefaultListModel<LinkItem> listModel = new DefaultListModel<LinkItem>();
        for (String key : swfs.keySet()) {
            SWF swf = (SWF)swfs.get(key);
            if (swf == ignoreSWF) continue;
            boolean selected = false;
            for (SWF s : selectedSWFs) {
                if (s != swf) continue;
                selected = true;
            }
            listModel.addElement(new LinkItem(key, swf, selected));
        }
        this.linkList.setModel(listModel);
        this.pack();
    }

    class CustomLibraryListCellRenderer
    extends JCheckBox
    implements ListCellRenderer<LinkItem> {
        CustomLibraryListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LinkItem> list, LinkItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(value.isSelected());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(value.toString());
            return this;
        }
    }

    class LinkItem {
        private String name;
        private SWF swf;
        private boolean selected;

        public LinkItem(String name, SWF swf, boolean selected) {
            this.name = name;
            this.swf = swf;
            this.selected = selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String getName() {
            return this.name;
        }

        public SWF getSwf() {
            return this.swf;
        }

        public String toString() {
            return this.name;
        }
    }
}

