/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DocsPanel;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.abc.ASMSourceEditorPane;
import com.jpexs.decompiler.flash.gui.abc.DecompiledEditorPane;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.controls.NoneSelectedButtonGroup;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MethodCodePanel
extends JPanel {
    private final ASMSourceEditorPane sourceTextArea;
    private final FasterScrollPane sourceScrollPane;
    public JPanel detailButtonsPanel;
    private final JToggleButton hexButton;
    private final JToggleButton hexOnlyButton;
    private final JButton addFunctionButton;
    private final DocsPanel docsPanel;

    public ABC getABC() {
        return this.sourceTextArea.abc;
    }

    public FasterScrollPane getSourceScrollPane() {
        return this.sourceScrollPane;
    }

    public void refreshMarkers() {
        this.sourceTextArea.refreshMarkers();
    }

    public void clearDebuggerColors() {
        this.sourceTextArea.removeColorMarkerOnAllLines(DecompiledEditorPane.IP_MARKER);
    }

    public void gotoInstrLine(int line) {
        this.sourceTextArea.gotoInstrLine(line);
    }

    public void focusEditor() {
        this.sourceTextArea.requestFocusInWindow();
    }

    public int getScriptIndex() {
        return this.sourceTextArea.getScriptIndex();
    }

    public String getTraitName() {
        return this.sourceTextArea.getName();
    }

    public void setIgnoreCaret(boolean ignoreCaret) {
        this.sourceTextArea.setIgnoreCaret(ignoreCaret);
    }

    public void hilightOffset(long offset) {
        this.sourceTextArea.hilightOffset(offset);
    }

    public void hilighSpecial(HighlightSpecialType type, String specialValue) {
        this.sourceTextArea.hilighSpecial(type, specialValue);
    }

    public void setMethod(String scriptPathName, int methodIndex, int bodyIndex, ABC abc, Trait trait, int scriptIndex) {
        this.sourceTextArea.setMethod(scriptPathName, methodIndex, bodyIndex, abc, this.sourceTextArea.getName(), trait, scriptIndex);
    }

    public void setMethod(String scriptPathName, int methodIndex, int bodyIndex, ABC abc, String name, Trait trait, int scriptIndex) {
        this.sourceTextArea.setMethod(scriptPathName, methodIndex, bodyIndex, abc, name, trait, scriptIndex);
    }

    public int getBodyIndex() {
        return this.sourceTextArea.bodyIndex;
    }

    public int getMethodIndex() {
        return this.sourceTextArea.methodIndex;
    }

    public void clear() {
        this.sourceTextArea.clear();
    }

    public boolean save() {
        return this.sourceTextArea.save();
    }

    public MethodCodePanel(DecompiledEditorPane decompiledEditor) {
        this.sourceTextArea = new ASMSourceEditorPane(decompiledEditor);
        this.setLayout(new BorderLayout());
        this.docsPanel = new DocsPanel();
        this.sourceTextArea.addDocsListener(this.docsPanel);
        if (((Boolean)Configuration.displayAs3PCodeDocsPanel.get()).booleanValue()) {
            this.sourceScrollPane = new FasterScrollPane(this.sourceTextArea);
            this.add(new JPersistentSplitPane(0, this.sourceScrollPane, (Component)new FasterScrollPane(this.docsPanel), (ConfigurationItem<Double>)Configuration.guiAvm2DocsSplitPaneDividerLocationPercent));
        } else {
            this.sourceScrollPane = new FasterScrollPane(this.sourceTextArea);
            this.add(this.sourceScrollPane);
        }
        this.sourceTextArea.changeContentType("text/flasm3");
        this.sourceTextArea.setFont(Configuration.getSourceFont());
        this.detailButtonsPanel = new JPanel();
        this.detailButtonsPanel.setLayout(new BoxLayout(this.detailButtonsPanel, 0));
        JButton graphButton = new JButton(View.getIcon("graph16"));
        graphButton.addActionListener(this::graphButtonActionPerformed);
        graphButton.setToolTipText(AppStrings.translate("button.viewgraph"));
        graphButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexButton = new JToggleButton(View.getIcon("hexas16"));
        this.hexButton.addActionListener(this::hexButtonActionPerformed);
        this.hexButton.setToolTipText(AppStrings.translate("button.viewhexpcode"));
        this.hexButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexOnlyButton = new JToggleButton(View.getIcon("hex16"));
        this.hexOnlyButton.addActionListener(this::hexOnlyButtonActionPerformed);
        this.hexOnlyButton.setToolTipText(AppStrings.translate("button.viewhex"));
        this.hexOnlyButton.setMargin(new Insets(3, 3, 3, 3));
        this.addFunctionButton = new JButton(View.getIcon("addfunction16"));
        this.addFunctionButton.addActionListener(this::addFunctionButtonActionPerformed);
        this.addFunctionButton.setToolTipText(AppStrings.translate("button.addfunction"));
        this.addFunctionButton.setMargin(new Insets(3, 3, 3, 3));
        NoneSelectedButtonGroup exportModeButtonGroup = new NoneSelectedButtonGroup();
        exportModeButtonGroup.add(this.hexButton);
        exportModeButtonGroup.add(this.hexOnlyButton);
        this.detailButtonsPanel.add(graphButton);
        this.detailButtonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.detailButtonsPanel.add(this.hexButton);
        this.detailButtonsPanel.add(this.hexOnlyButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JPanel editVisibleButtonsPanel = new JPanel();
        editVisibleButtonsPanel.setLayout(new BoxLayout(editVisibleButtonsPanel, 0));
        editVisibleButtonsPanel.add(this.addFunctionButton);
        buttonsPanel.add(this.detailButtonsPanel);
        buttonsPanel.add(Box.createHorizontalStrut(5));
        buttonsPanel.add(editVisibleButtonsPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        this.add((Component)buttonsPanel, "North");
    }

    private void graphButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.graph();
    }

    private void hexButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.setHex(this.getExportMode(), false);
    }

    private void hexOnlyButtonActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        this.sourceTextArea.setHex(this.getExportMode(), false);
    }

    private void addFunctionButtonActionPerformed(ActionEvent evt) {
        if (ViewMessages.showConfirmDialog(this, AppStrings.translate("message.confirm.addfunction"), AppStrings.translate("message.warning"), 2, 2, (ConfigurationItem<Boolean>)Configuration.warningAddFunction, 0) != 0) {
            return;
        }
        MethodInfo methodInfoObj = new MethodInfo(new int[0], 0, 0, 0, null, null);
        ABC abc = this.getABC();
        int methodInfo = abc.addMethodInfo(methodInfoObj);
        MethodBody body = new MethodBody();
        List code = body.getCode().code;
        code.add(new AVM2Instruction(0L, 71, new int[0]));
        body.method_info = methodInfo;
        abc.addMethodBody(body);
        ((Tag)abc.parentTag).setModified(true);
        if (ViewMessages.showConfirmDialog(this, AppStrings.translate("addfunction.result").replace("%method_info_index%", "" + methodInfo), AppStrings.translate("addfunction.result.title"), 2) != 0) {
            return;
        }
        StringSelection stringSelection = new StringSelection("" + methodInfo);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public ASMSourceEditorPane getSourceTextArea() {
        return this.sourceTextArea;
    }

    private ScriptExportMode getExportMode() {
        ScriptExportMode exportMode = this.hexOnlyButton.isSelected() ? ScriptExportMode.HEX : (this.hexButton.isSelected() ? ScriptExportMode.PCODE_HEX : ScriptExportMode.PCODE);
        return exportMode;
    }

    public void setEditMode(boolean val) {
        ScriptExportMode exportMode = this.getExportMode();
        if (val) {
            this.sourceTextArea.setHex(exportMode == ScriptExportMode.HEX ? ScriptExportMode.HEX : ScriptExportMode.PCODE, false);
        } else if (exportMode != ScriptExportMode.PCODE) {
            this.sourceTextArea.setHex(exportMode, false);
        }
        this.sourceTextArea.setEditable(val);
        this.sourceTextArea.getCaret().setVisible(true);
        this.detailButtonsPanel.setVisible(!val);
    }
}

