/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.editor.UndoFixedEditorPane;
import com.jpexs.decompiler.flash.simpleparser.LinkHandler;
import com.jpexs.decompiler.flash.simpleparser.LinkType;
import com.jpexs.decompiler.flash.simpleparser.Path;
import com.jpexs.decompiler.flash.simpleparser.SimpleParser;
import com.jpexs.decompiler.flash.simpleparser.Variable;
import com.jpexs.helpers.Reference;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;

public class LineMarkedEditorPane
extends UndoFixedEditorPane
implements LinkHandler {
    private static final int truncateLimit = 0x200000;
    public static final Color BG_SELECTED_LINE = new Color(233, 239, 248);
    public static final Color BG_ERROR_LINE = new Color(255, 200, 200);
    private int lastLine = -1;
    private boolean error = false;
    private LinkHandler linkHandler = this;
    private SimpleParser parser;
    private Map<Integer, SortedSet<LineMarker>> lineMarkers = Collections.synchronizedMap(new HashMap());

    public LinkType getClassLinkType(Path className) {
        return LinkType.NO_LINK;
    }

    public boolean traitExists(Path className, String traitName) {
        return false;
    }

    public void handleClassLink(Path className) {
    }

    public void handleTraitLink(Path className, String traitName) {
    }

    public Path getTraitType(Path className, String traitName) {
        return new Path(new String[]{"*"});
    }

    public Path getTraitSubType(Path className, String traitName, int level) {
        return null;
    }

    public Path getTraitCallType(Path className, String traitName) {
        return null;
    }

    public Path getTraitCallSubType(Path className, String traitName, int level) {
        return null;
    }

    public List<Variable> getClassTraits(Path className, boolean getStatic, boolean getInstance, boolean getInheritance) {
        return new ArrayList<Variable>();
    }

    public SimpleParser getParser() {
        return this.parser;
    }

    public void setParser(SimpleParser parser) {
        this.parser = parser;
    }

    public void setLineMarkers(Map<Integer, SortedSet<LineMarker>> colorMarkers) {
        this.lineMarkers = colorMarkers;
    }

    public void clearLineColors() {
        this.lineMarkers.clear();
        this.repaint();
    }

    public boolean hasColorMarker(int line, LineMarker lm) {
        if (this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            return this.lineMarkers.get(line).contains(lm);
        }
        return false;
    }

    public void removeColorMarker(int line, LineMarker lm) {
        if (this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            this.lineMarkers.get(line).remove(lm);
        }
        this.getParent().repaint();
    }

    public void removeColorMarkerOnAllLines(LineMarker lm) {
        for (int line : this.lineMarkers.keySet()) {
            this.removeColorMarker(line += this.firstLineOffset(), lm);
        }
    }

    public int firstLineOffset() {
        return 0;
    }

    public void toggleColorMarker(int line, LineMarker lm) {
        if (!this.lineMarkers.containsKey(line - this.firstLineOffset())) {
            this.addColorMarker(line, lm);
        } else if (this.lineMarkers.get(line - this.firstLineOffset()).contains(lm)) {
            this.removeColorMarker(line, lm);
        } else {
            this.addColorMarker(line, lm);
        }
        this.getParent().repaint();
    }

    public void addColorMarker(int line, LineMarker lm) {
        if (!this.lineMarkers.containsKey(line -= this.firstLineOffset())) {
            this.lineMarkers.put(line, Collections.synchronizedSortedSet(new TreeSet()));
        }
        this.lineMarkers.get(line).add(lm);
        this.getParent().repaint();
    }

    public int getLine() {
        int caretPosition = this.getCaretPosition();
        Element root = this.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        return currentLine;
    }

    public void markError() {
        this.error = true;
    }

    public void gotoLine(int line) {
        final int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)line, (int)0);
        if (pos != -1) {
            this.setCaretPosition(pos);
            View.execInEventDispatchLater(new Runnable(){
                final /* synthetic */ LineMarkedEditorPane this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        Rectangle2D r = View.textComponentModelToView(this.this$0, pos);
                        Rectangle r2 = new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                        this.this$0.scrollRectToVisible(r2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void gotoLineCol(int line, int column) {
        int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)line, (int)column);
        if (pos != -1) {
            this.setCaretPosition(pos);
        }
    }

    public Point getLineLocation(int line) {
        int pos = ActionUtils.getDocumentPosition((JTextComponent)this, (int)(line + 1), (int)0);
        if (pos < 0) {
            return null;
        }
        try {
            Rectangle2D r = View.textComponentModelToView(this, pos);
            return new Point((int)r.getX(), (int)r.getY());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    private void getLineBounds(int line, Reference<Integer> lineStart, Reference<Integer> lineEnd) {
        Document d = this.getDocument();
        String text = "";
        try {
            text = d.getText(0, d.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int lineCnt = 0;
        int lineStartVal = 0;
        int lineEndVal = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            if (++lineCnt == line) {
                lineStartVal = i + 1;
            }
            if (lineCnt != line + 1) continue;
            lineEndVal = i;
        }
        if (lineCnt == 0) {
            lineEndVal = text.length() - 1;
            if (line > 0) {
                lineStartVal = text.length() - 1;
            }
        }
        lineEnd.setVal((Object)lineEndVal);
        lineStart.setVal((Object)lineStartVal);
    }

    public void selectLine(int line) {
        Reference lineStart = new Reference((Object)0);
        Reference lineEnd = new Reference((Object)0);
        this.getLineBounds(line, (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
        this.select((Integer)lineStart.getVal(), (Integer)lineEnd.getVal());
        this.requestFocus();
    }

    public String getCurrentLineText() {
        return this.getLineText(this.getLine());
    }

    public String getLineText(int line) {
        Reference lineStart = new Reference((Object)0);
        Reference lineEnd = new Reference((Object)0);
        this.getLineBounds(line, (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
        try {
            return this.getDocument().getText((Integer)lineStart.getVal(), (Integer)lineEnd.getVal() - (Integer)lineStart.getVal());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public LineMarkedEditorPane() {
        this.setOpaque(false);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int caretPosition = LineMarkedEditorPane.this.getCaretPosition();
                Element root = LineMarkedEditorPane.this.getDocument().getDefaultRootElement();
                int currentLine = root.getElementIndex(caretPosition);
                if (currentLine != LineMarkedEditorPane.this.lastLine) {
                    LineMarkedEditorPane.this.lastLine = currentLine;
                    LineMarkedEditorPane.this.error = false;
                    LineMarkedEditorPane.this.repaint();
                }
            }
        });
    }

    public Token tokenAtPos(Point lastPos) {
        Document d = this.getDocument();
        if (d instanceof SyntaxDocument) {
            Token tprev;
            SyntaxDocument sd = (SyntaxDocument)d;
            int pos = View.textComponentViewToModel((JTextComponent)this, lastPos);
            try {
                Rectangle2D r = View.textComponentModelToView(this, pos);
                if (r != null && (double)lastPos.x < r.getX()) {
                    --pos;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Token t = sd.getTokenAt(pos);
            if (pos > 0 && pos < d.getLength() - 1 && t != null && t.length == 1 && (tprev = sd.getTokenAt(pos - 1)) == t) {
                t = sd.getTokenAt(pos + 1);
            }
            return t;
        }
        return null;
    }

    public void setLinkHandler(LinkHandler linkHandler) {
        if (linkHandler == null) {
            linkHandler = this;
        }
        this.linkHandler = linkHandler;
    }

    public LinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    @Override
    public void setText(String t) {
        this.lineMarkers = new HashMap<Integer, SortedSet<LineMarker>>();
        this.lastLine = -1;
        this.error = false;
        if (((Boolean)Configuration._debugMode.get()).booleanValue() && t != null && t.length() > 0x200000) {
            t = t.substring(0, 0x200000) + "\r\n" + AppStrings.translate("editorTruncateWarning").replace("%chars%", Integer.toString(0x200000));
        }
        super.setText(t);
        this.setCaretPosition(0);
    }

    private int cut(double val) {
        int ival = (int)Math.round(val);
        if (ival < 0) {
            return 0;
        }
        if (ival > 255) {
            ival = 255;
        }
        return ival;
    }

    @Override
    public void paint(Graphics g) {
        SortedSet<LineMarker> cs;
        Color selColor;
        Color c;
        if (View.isOceanic()) {
            c = Color.white;
            g.setColor(c);
            selColor = BG_SELECTED_LINE;
        } else {
            c = UIManager.getColor("EditorPane.background");
            g.setColor(c);
            int light = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
            selColor = light > 128 ? new Color(this.cut((double)c.getRed() * 0.9), this.cut((double)c.getGreen() * 0.9), this.cut((double)c.getBlue() * 0.9)) : new Color(this.cut((double)c.getRed() * 1.1), this.cut((double)c.getGreen() * 1.1), this.cut((double)c.getBlue() * 1.1));
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        FontMetrics fontMetrics = g.getFontMetrics();
        int lh = fontMetrics.getHeight();
        int d = fontMetrics.getDescent();
        if (this.lastLine > -1) {
            if (this.error) {
                g.setColor(BG_ERROR_LINE);
            } else {
                g.setColor(selColor);
            }
            g.fillRect(0, d + lh * this.lastLine - 1, this.getWidth(), lh);
        }
        for (int line : this.lineMarkers.keySet()) {
            LineMarker lastMarker;
            cs = this.lineMarkers.get(line);
            if (cs.isEmpty() || (lastMarker = cs.first()).getBgColor() == null) continue;
            g.setColor(lastMarker.getBgColor());
            g.fillRect(0, d + lh * ((line += this.firstLineOffset()) - 1), this.getWidth(), lh);
        }
        try {
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int line : this.lineMarkers.keySet()) {
            cs = this.lineMarkers.get(line);
            if (cs.isEmpty()) continue;
            Reference lineStart = new Reference((Object)0);
            Reference lineEnd = new Reference((Object)0);
            this.getLineBounds(line += this.firstLineOffset(), (Reference<Integer>)lineStart, (Reference<Integer>)lineEnd);
            FgPainter fgp = cs.first().getForegroundPainter();
            if (fgp == null) continue;
            fgp.paint(g, (Integer)lineStart.getVal(), (Integer)lineEnd.getVal(), null, this);
        }
    }

    public static class LineMarker
    implements Comparable<LineMarker> {
        private final Color bgColor;
        private final Color color;
        private FgPainter fgPainter;
        private final int priority;

        public FgPainter getForegroundPainter() {
            return this.fgPainter;
        }

        public String toString() {
            return this.bgColor.toString() + " priority:" + this.priority;
        }

        public LineMarker(Color color, Color bgColor, int priority) {
            this.bgColor = bgColor;
            this.color = color;
            this.priority = priority;
            if (color != null) {
                this.fgPainter = new FgPainter(color, bgColor);
            }
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + Objects.hashCode(this.bgColor);
            hash = 17 * hash + Objects.hashCode(this.color);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineMarker other = (LineMarker)obj;
            if (!Objects.equals(this.bgColor, other.bgColor)) {
                return false;
            }
            return Objects.equals(this.color, other.color);
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(LineMarker o) {
            return this.priority - o.priority;
        }
    }

    public static class FgPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private final SyntaxStyle fgStyle;

        public FgPainter(Color color, Color bgColor) {
            super(bgColor);
            this.fgStyle = new SyntaxStyle(color, false, false);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                TextUI mapper = c.getUI();
                Segment seg = new Segment();
                ((SyntaxDocument)c.getDocument()).getText(offs0, offs1 - offs0, seg);
                Rectangle2D r = View.textUIModelToView(mapper, c, offs0, Position.Bias.Forward);
                FontMetrics fm = g.getFontMetrics();
                this.fgStyle.drawText(seg, (int)r.getX(), (int)r.getY() + fm.getAscent(), g, null, offs0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, javax.swing.text.View view) {
            Rectangle r;
            g.setColor(c.getSelectionColor());
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    r = null;
                }
            }
            if (r != null) {
                r.width = Math.max(r.width, 1);
                this.paint(g, offs0, offs1, r, c);
            }
            return r;
        }
    }
}

