/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FloatEditor
extends JPanel
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private String fieldName;
    private ValueNormalizer normalizer;
    private Field linkedField;
    private boolean linkEnabled;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JTextField textField;
    private JLabel linkLabel;
    private SWFType swfType;

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = 300;
        return ret;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    public FloatEditor(String fieldName, Object obj, Field field, int index, Class<?> type, SWFType swfType) {
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                for (ChangeListener l : FloatEditor.this.listeners) {
                    l.change(FloatEditor.this);
                }
            }
        });
        this.textField = new JTextField(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new FlowLayout(0, 0, 0));
        this.textField.setPreferredSize(new Dimension(50, this.textField.getPreferredSize().height));
        this.textField.setMaximumSize(this.textField.getPreferredSize());
        this.add(this.textField);
        this.linkLabel = new JLabel(View.getIcon("link16"));
        this.add(this.linkLabel);
        this.linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean newValue = !FloatEditor.this.linkEnabled;
                FloatEditor.this.setLinkEnabled(newValue);
                for (ChangeListener l : FloatEditor.this.listeners) {
                    l.linkChanged(newValue);
                }
                FloatEditor.this.repaint();
            }
        });
        this.linkLabel.setVisible(false);
        this.reset();
        this.swfType = swfType;
    }

    @Override
    public void reset() {
        try {
            Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (this.normalizer != null) {
                val = this.normalizer.toViewValue(val);
            }
            this.textField.setText(val == null ? "" : EcmaScript.toString((Object)val));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            String newValue;
            String oldValue;
            Object oldFieldValue = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (this.normalizer != null) {
                oldFieldValue = this.normalizer.toViewValue(oldFieldValue);
            }
            if (Objects.equals(oldValue = EcmaScript.toString((Object)oldFieldValue), newValue = this.textField.getText())) {
                return false;
            }
            Object val = this.type.equals(Double.TYPE) || this.type.equals(Double.class) ? (Number)Double.valueOf(this.textField.getText()) : (Number)Float.valueOf(this.textField.getText());
            if (this.normalizer != null) {
                val = this.normalizer.toFieldValue(val);
            }
            if (this.swfType != null) {
                switch (this.swfType.value()) {
                    case UFIXED8: {
                        if (((Float)val).floatValue() > 255.0f) {
                            val = Float.valueOf(255.0f);
                            break;
                        }
                        if (!(((Float)val).floatValue() < 0.0f)) break;
                        val = Float.valueOf(0.0f);
                        break;
                    }
                    case FIXED8: {
                        if (((Float)val).floatValue() > 127.0f) {
                            val = Float.valueOf(127.0f);
                            break;
                        }
                        if (!(((Float)val).floatValue() < -128.0f)) break;
                        val = Float.valueOf(-128.0f);
                        break;
                    }
                    case FIXED: {
                        if ((Double)val > 32767.0) {
                            val = 32767.0;
                            break;
                        }
                        if (!((Double)val < -32768.0)) break;
                        val = -32768.0;
                    }
                }
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)val);
            if (this.linkedField != null && this.linkEnabled) {
                Object linkedFieldValue = ReflectionTools.getValue((Object)this.obj, (Field)this.linkedField);
                Number newLinkedFieldValue = null;
                if (oldFieldValue instanceof Double) {
                    Double v = (Double)oldFieldValue;
                    Double v2 = (Double)val;
                    Double vL = (Double)linkedFieldValue;
                    newLinkedFieldValue = v == 0.0 ? v2 : v2 * vL / v;
                } else if (oldFieldValue instanceof Float) {
                    Float v = (Float)oldFieldValue;
                    Float v2 = (Float)val;
                    Float vL = (Float)linkedFieldValue;
                    newLinkedFieldValue = Float.valueOf(v.floatValue() == 0.0f ? v2.floatValue() : v2.floatValue() * vL.floatValue() / v.floatValue());
                }
                ReflectionTools.setValue((Object)this.obj, (Field)this.linkedField, (int)-1, newLinkedFieldValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getChangedValue() {
        return this.textField.getText();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return Helper.escapeHTML((String)this.getChangedValue().toString());
    }

    @Override
    public void added() {
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
        this.normalizer = normalizer;
        this.reset();
    }

    public void setLinkedField(Field linkedField) {
        this.linkedField = linkedField;
        this.linkLabel.setVisible(true);
    }

    public void setLinkEnabled(boolean enabled) {
        this.linkEnabled = enabled;
        this.linkLabel.setIcon(View.getIcon(enabled ? "link16" : "linkbreak16"));
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }
}

