/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

public class NumberEditor
extends JPanel
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final SWFType swfType;
    private String fieldName;
    private ValueNormalizer normalizer;
    private JSpinner spinner;

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    @Override
    public void added() {
    }

    public NumberEditor(String fieldName, Object obj, Field field, int index, Class<?> type, SWFType swfType) {
        this.setSize(100, this.getSize().height);
        this.setMaximumSize(this.getSize());
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.swfType = swfType;
        this.fieldName = fieldName;
        this.spinner = new JSpinner();
        this.setLayout(new BorderLayout());
        this.add((Component)this.spinner, "West");
        this.setOpaque(false);
        this.reset();
        ((JSpinner.NumberEditor)this.spinner.getEditor()).getFormat().setGroupingUsed(false);
        JFormattedTextField jtf = ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField();
        DefaultFormatter formatter = (DefaultFormatter)jtf.getFormatter();
        formatter.setCommitsOnValidEdit(true);
    }

    @Override
    public void reset() {
        Object value = this.loadValue();
        if (this.normalizer != null) {
            value = this.normalizer.toViewValue(value);
        }
        this.spinner.setModel(this.getModel(this.swfType, value));
    }

    @Override
    public boolean save() {
        Object newViewValue;
        Object oldValue;
        Object oldViewValue = oldValue = this.loadValue();
        if (this.normalizer != null) {
            oldViewValue = this.normalizer.toViewValue(oldValue);
        }
        if ((newViewValue = this.getChangedValue()) == null) {
            return false;
        }
        if (Objects.equals(oldViewValue, newViewValue)) {
            return false;
        }
        Object newValue = newViewValue;
        if (this.normalizer != null) {
            newValue = this.normalizer.toFieldValue(newViewValue);
        }
        this.saveValue(newValue);
        return true;
    }

    protected Object loadValue() {
        try {
            return ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    protected void saveValue(Object newValue) {
        try {
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private SpinnerModel getModel(SWFType swfType, Object value) {
        SpinnerNumberModel m = null;
        BasicType basicType = swfType == null ? BasicType.NONE : swfType.value();
        switch (basicType) {
            case UI8: {
                m = new SpinnerNumberModel(this.toInt(value), 0, 255, 1);
                break;
            }
            case UI16: {
                m = new SpinnerNumberModel(this.toInt(value), 0, 65535, 1);
                break;
            }
            case UB: {
                long max = 1L;
                max = swfType.count() > 0 ? (max <<= swfType.count()) : (max <<= 31);
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(0L), Long.valueOf(max - 1L), (Number)1L);
                break;
            }
            case UI32: 
            case EncodedU32: 
            case NONE: {
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(0L), Long.valueOf(0xFFFFFFFFL), (Number)1L);
                break;
            }
            case SI8: {
                m = new SpinnerNumberModel(this.toInt(value), -128, 127, 1);
                break;
            }
            case SI16: 
            case FLOAT16: {
                m = new SpinnerNumberModel(this.toInt(value), Short.MIN_VALUE, Short.MAX_VALUE, 1);
                break;
            }
            case SB: {
                long max = 1L;
                max = swfType.count() > 0 ? (max <<= swfType.count() - 1) : (max <<= 30);
                m = new SpinnerNumberModel((Number)this.toLong(value), Long.valueOf(-max), Long.valueOf(max - 1L), (Number)1L);
                break;
            }
            case SI32: {
                m = new SpinnerNumberModel(this.toDouble(value), -2.147483648E9, 2.147483647E9, 1.0);
            }
        }
        return m;
    }

    private double toDouble(Object value) {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    private int toInt(Object value) {
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private long toLong(Object value) {
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final NumberEditor t = this;
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ NumberEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getChangedValue() {
        Number value = null;
        if (this.type.equals(Integer.TYPE) || this.type.equals(Integer.class)) {
            value = Integer.parseInt(this.spinner.getValue().toString());
        } else if (this.type.equals(Short.TYPE) || this.type.equals(Short.class)) {
            value = Short.parseShort(this.spinner.getValue().toString());
        } else if (this.type.equals(Long.TYPE) || this.type.equals(Long.class)) {
            value = Long.parseLong(this.spinner.getValue().toString());
        } else if (this.type.equals(Double.TYPE) || this.type.equals(Double.class)) {
            value = Double.parseDouble(this.spinner.getValue().toString());
        } else if (this.type.equals(Float.TYPE) || this.type.equals(Float.class)) {
            value = Float.valueOf(Float.parseFloat(this.spinner.getValue().toString()));
        }
        return value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
        this.normalizer = normalizer;
    }
}

