/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.graph;

import com.jpexs.decompiler.flash.gui.graph.AbstractGraphPanel;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class GraphPanelSimple
extends AbstractGraphPanel {
    private static final int SPACE_VERTICAL = 16;
    private static final int SPACE_HORIZONTAL = 10;
    private static final int SPACE_BACKLINKS = 5;
    private static final int BLOCK_WIDTH = 200;
    private static final int BLOCK_HEIGHT = 20;
    private final HashMap<GraphPart, Point> partPos = new HashMap();
    private final Point size;
    private int backLinksLeft = 0;
    private int backLinksRight = 0;
    private final GraphPart head;

    public GraphPanelSimple(Graph graph) throws InterruptedException {
        super(graph);
        this.head = (GraphPart)graph.heads.get(0);
        this.size = this.getPartPositions(this.head, 42, this.getPartWidth((GraphPart)graph.heads.get(0), new HashSet<GraphPart>()) * 210 / 2 - 10, this.partPos, true);
        this.backLinksLeft = 1;
        this.backLinksRight = 1;
        for (GraphPart part : this.partPos.keySet()) {
            Point p = this.partPos.get(part);
            for (GraphPart n : part.nextParts) {
                Point npos = this.partPos.get(n);
                if (npos.y >= p.y) continue;
                if (p.x > this.size.x / 2) {
                    ++this.backLinksRight;
                    continue;
                }
                ++this.backLinksLeft;
            }
        }
        this.size.x += 10 + this.backLinksLeft * 5 + this.backLinksRight * 5;
        this.setPreferredSize(new Dimension(this.size.x, this.size.y));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int startX = 5 + this.backLinksLeft * 5;
        int blLeft = 0;
        int blRight = 0;
        for (GraphPart part : this.partPos.keySet()) {
            Point p = this.partPos.get(part);
            g2.setColor(Color.white);
            g2.fillRect(startX + p.x - 100, p.y - 10, 200, 20);
            g2.setColor(Color.black);
            g2.drawRect(startX + p.x - 100, p.y - 10, 200, 20);
            g2.drawString(part.toString(), startX + p.x - g2.getFontMetrics().stringWidth(part.toString()) / 2, p.y + g2.getFontMetrics().getHeight() / 2);
        }
        Point hp = this.partPos.get(this.head);
        this.drawArrow(g2, startX + hp.x, hp.y - 10 - 16, startX + hp.x, hp.y - 10);
        for (GraphPart part : this.partPos.keySet()) {
            Point p = this.partPos.get(part);
            for (int n = 0; n < part.nextParts.size(); ++n) {
                boolean isIf;
                boolean bl = isIf = part.nextParts.size() == 2;
                if (isIf) {
                    if (n == 0) {
                        g2.setColor(new Color(0, 128, 0));
                    } else {
                        g2.setColor(Color.red);
                    }
                } else {
                    g2.setColor(Color.black);
                }
                Point npos = this.partPos.get(part.nextParts.get(n));
                if (npos.y < p.y) {
                    int sidex = startX;
                    if (p.x > this.size.x / 2) {
                        sidex = this.size.x - this.backLinksRight * 5;
                        sidex += 5 + 5 * ++blRight;
                    } else {
                        sidex -= 5 + 5 * ++blLeft;
                    }
                    g2.drawLine(startX + p.x, p.y + 10, startX + p.x, p.y + 10 + 8);
                    g2.drawLine(startX + p.x, p.y + 10 + 8, sidex, p.y + 10 + 8);
                    g2.drawLine(sidex, npos.y - 10 - 8, sidex, p.y + 10 + 8);
                    this.drawArrow(g2, sidex, npos.y - 10 - 8, startX + npos.x, npos.y - 10 - 8);
                    g2.drawLine(startX + npos.x, npos.y - 10 - 8, startX + npos.x, npos.y - 10);
                    continue;
                }
                this.drawArrow(g2, startX + p.x, p.y + 10, startX + npos.x, npos.y - 10 - 8);
                g2.drawLine(startX + npos.x, npos.y - 10 - 8, startX + npos.x, npos.y - 10);
            }
        }
    }

    private Point getPartSubPositions(Point ret, int totalWidth, GraphPart part, int y, int x, HashMap<GraphPart, Point> used) {
        if (used.containsKey(part)) {
            Point p = used.get(part);
            return new Point(x, y);
        }
        used.put(part, new Point(x, y));
        if (part.nextParts.size() > 0) {
            HashSet<Object> k;
            int p;
            int cx = x - totalWidth / 2;
            for (p = 0; p < part.nextParts.size(); ++p) {
                k = new HashSet<GraphPart>();
                k.addAll(used.keySet());
                int partWidth = this.getPartWidth((GraphPart)part.nextParts.get(p), k);
                int cellWidth = partWidth * 210;
                Point pt = this.getPartPositions((GraphPart)part.nextParts.get(p), y + 20 + 16, cx + cellWidth / 2, used, false);
                if (pt.x > ret.x) {
                    ret.x = pt.x;
                }
                if (pt.y > ret.y) {
                    ret.y = pt.y;
                }
                cx += cellWidth;
            }
            cx = x - totalWidth / 2;
            for (p = 0; p < part.nextParts.size(); ++p) {
                k = new HashSet();
                k.addAll(used.keySet());
                int cellWidth = this.getPartWidth((GraphPart)part.nextParts.get(p), k) * 210;
                HashSet<GraphPart> hs = new HashSet<GraphPart>();
                hs.addAll(used.keySet());
                int totalWidthParts2 = this.getPartWidth((GraphPart)part.nextParts.get(p), hs);
                int totalWidth2 = totalWidthParts2 * 210;
                Point pt = this.getPartSubPositions(ret, totalWidth2, (GraphPart)part.nextParts.get(p), y + 20 + 16, cx + cellWidth / 2, used);
                if (pt.x > ret.x) {
                    ret.x = pt.x;
                }
                if (pt.y > ret.y) {
                    ret.y = pt.y;
                }
                cx += cellWidth;
            }
        }
        return ret;
    }

    private Point getPartPositions(GraphPart part, int y, int x, HashMap<GraphPart, Point> used, boolean goSub) {
        HashMap<GraphPart, Point> l = new HashMap<GraphPart, Point>();
        l.putAll(used);
        HashSet<GraphPart> hs = new HashSet<GraphPart>();
        hs.addAll(l.keySet());
        int totalWidthParts = this.getPartWidth(part, hs);
        int totalWidth = totalWidthParts * 210;
        if (used.containsKey(part)) {
            Point p = used.get(part);
            return new Point(x, y);
        }
        Point ret = new Point(x - 100 - 5 + 200, y + 20);
        if (goSub) {
            Point p2 = this.getPartSubPositions(ret, totalWidth, part, y, x, used);
            if (p2.x > ret.x) {
                ret.x = p2.x;
            }
            if (p2.y > ret.y) {
                ret.y = p2.y;
            }
        }
        return ret;
    }

    private int getPartHeight(GraphPart part, List<GraphPart> used) {
        if (used.contains(part)) {
            return 1;
        }
        used.add(part);
        int maxH = 0;
        for (int p = 0; p < part.nextParts.size(); ++p) {
            int h = this.getPartHeight((GraphPart)part.nextParts.get(p), used);
            if (h <= maxH) continue;
            maxH = h;
        }
        return 1 + maxH;
    }

    private int getPartWidth(GraphPart part, HashSet<GraphPart> used) {
        if (used.contains(part)) {
            return 1;
        }
        used.add(part);
        if (part.nextParts.isEmpty()) {
            return 1;
        }
        int w = 0;
        for (GraphPart subpart : part.nextParts) {
            w += this.getPartWidth(subpart, used);
        }
        return w;
    }

    private void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 0);
        arrowHead.addPoint(-3, -8);
        arrowHead.addPoint(3, -8);
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        AffineTransform tx = new AffineTransform();
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(line.x2, line.y2);
        tx.rotate(angle - 1.5707963267948966);
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldTransform = g2d.getTransform();
        g2d.draw(line);
        tx.preConcatenate(oldTransform);
        g2d.setTransform(tx);
        g2d.fill(arrowHead);
        g2d.setTransform(oldTransform);
    }
}

