/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.graph;

import com.jpexs.decompiler.flash.configuration.Configuration;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.imageio.ImageIO;

public class GraphVizDotCommands {
    public static boolean graphVizAvailable() {
        String dotPath = (String)Configuration.graphVizDotLocation.get();
        return !dotPath.isEmpty() && new File(dotPath).exists();
    }

    private static void runCommand(String[] command) {
        try {
            String s;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((s = reader.readLine()) != null) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean runDotCommand(String[] command) {
        String dotLocation = (String)Configuration.graphVizDotLocation.get();
        if (dotLocation.isEmpty() && !new File(dotLocation).exists()) {
            return false;
        }
        String[] commandPlusDot = new String[command.length + 1];
        commandPlusDot[0] = dotLocation;
        for (int i = 0; i < command.length; ++i) {
            commandPlusDot[1 + i] = command[i];
        }
        GraphVizDotCommands.runCommand(commandPlusDot);
        return true;
    }

    public BufferedImage dotToImage(String text) throws IOException {
        File gvFile = File.createTempFile("graphexport", ".gv");
        File pngFile = File.createTempFile("graphexport", ".png");
        PrintWriter pw = new PrintWriter(gvFile);
        pw.println(text);
        pw.close();
        if (!GraphVizDotCommands.runDotCommand(new String[]{"-Tpng", "-Nfontname=times-bold", "-Nfontsize=12", "-o", pngFile.getAbsolutePath(), gvFile.getAbsolutePath()})) {
            gvFile.delete();
            return null;
        }
        if (!pngFile.exists()) {
            throw new IOException("Dot did not produce any file");
        }
        BufferedImage ret = ImageIO.read(pngFile);
        gvFile.delete();
        pngFile.delete();
        return ret;
    }
}

