/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.hexview;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GotoAddressDialog
extends AppDialog {
    private final JTextField lineTextField;
    private Long value = null;
    private final JButton okButton;
    private final JCheckBox hexCheckBox;
    private boolean okPressed = false;

    public GotoAddressDialog(Window owner) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        this.lineTextField = new JTextField(10);
        this.lineTextField.setFont(new Font("Monospaced", 0, this.lineTextField.getFont().getSize()));
        this.lineTextField.addActionListener(this::okButtonActionPerformed);
        this.okButton = new JButton(this.translate("button.ok"));
        this.okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        Container cnt = this.getContentPane();
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(cancelButton);
        JPanel centerPanel = new JPanel(new FlowLayout());
        centerPanel.add(this.lineTextField);
        this.hexCheckBox = new JCheckBox(this.translate("hex"));
        this.hexCheckBox.setSelected(true);
        centerPanel.add(this.hexCheckBox);
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)buttonsPanel, "South");
        cnt.add((Component)centerPanel, "Center");
        this.hexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GotoAddressDialog.this.checkEnabled();
            }
        });
        this.lineTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GotoAddressDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GotoAddressDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GotoAddressDialog.this.checkEnabled();
            }
        });
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.setModal(true);
        this.checkEnabled();
    }

    private void checkEnabled() {
        try {
            if (this.lineTextField.getText().matches(".*[a-fA-F].*") && this.lineTextField.getText().matches("[a-fA-F0-9]")) {
                this.hexCheckBox.setSelected(true);
            }
            this.value = Long.parseLong(this.lineTextField.getText(), this.hexCheckBox.isSelected() ? 16 : 10);
            this.okButton.setEnabled(true);
        }
        catch (NumberFormatException nfe) {
            this.value = null;
            this.okButton.setEnabled(false);
        }
    }

    public void okButtonActionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.setVisible(false);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public Long showDialog() {
        this.setVisible(true);
        if (this.okPressed) {
            return this.value;
        }
        return null;
    }
}

