/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedAction;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedEvent;
import com.jpexs.decompiler.flash.gui.soleditor.Cookie;
import com.jpexs.decompiler.flash.gui.soleditor.SharedObjectsStorage;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeRoot;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeSwfInfo;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.Scene;
import com.jpexs.decompiler.flash.timeline.SceneFrame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TagTreeModel
extends AbstractTagTreeModel {
    public static final String FOLDER_COOKIES = "cookies";
    public static final String FOLDER_SHAPES = "shapes";
    public static final String FOLDER_MORPHSHAPES = "morphshapes";
    public static final String FOLDER_SPRITES = "sprites";
    public static final String FOLDER_TEXTS = "texts";
    public static final String FOLDER_IMAGES = "images";
    public static final String FOLDER_MOVIES = "movies";
    public static final String FOLDER_SOUNDS = "sounds";
    public static final String FOLDER_BUTTONS = "buttons";
    public static final String FOLDER_FONTS = "fonts";
    public static final String FOLDER_BINARY_DATA = "binaryData";
    public static final String FOLDER_FRAMES = "frames";
    public static final String FOLDER_OTHERS = "others";
    public static final String FOLDER_SCRIPTS = "scripts";
    public static final String FOLDER_SCENES = "scenes";
    public static final String FOLDER_UNKNOWN = "unknown";
    public static final String FOLDER_ERRORED = "errored";
    public static final List<String> FOLDERS_ORDER = Arrays.asList("header", "cookies", "shapes", "morphshapes", "sprites", "texts", "images", "movies", "sounds", "buttons", "fonts", "binaryData", "frames", "scenes", "others", "unknown", "errored", "scripts");
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final TagTreeRoot root = new TagTreeRoot();
    private final List<OpenableList> swfs;
    private final Map<SWF, TagTreeSwfInfo> swfInfos = new HashMap<SWF, TagTreeSwfInfo>();
    private final boolean addAllFolders;
    private final Map<TreeItem, TreePath> pathCache = new HashMap<TreeItem, TreePath>();
    private final Map<ABC, ClassesListTreeModel> abcClassesTree = new WeakHashMap<ABC, ClassesListTreeModel>();

    public TagTreeModel(List<OpenableList> swfs, boolean addAllFolders) {
        this.swfs = swfs;
        this.addAllFolders = addAllFolders;
    }

    private String translate(String key) {
        return AppStrings.translate(key);
    }

    @Override
    public void updateSwfs(CollectionChangedEvent e) {
        if (e.getAction() != CollectionChangedAction.ADD && e.getAction() != CollectionChangedAction.MOVE) {
            ArrayList<SWF> toRemove = new ArrayList<SWF>();
            for (SWF swf : this.swfInfos.keySet()) {
                SWF swf2 = swf.getRootSwf();
                if (swf2 == null || this.swfs.contains(swf2.openableList)) continue;
                toRemove.add(swf);
            }
            for (SWF swf : toRemove) {
                this.swfInfos.remove(swf);
                this.uncacheSwf(swf);
            }
        }
        switch (e.getAction()) {
            case ADD: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootPath, new int[]{e.getNewIndex()}, new Object[]{e.getNewItem()}));
                break;
            }
            case REMOVE: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootPath, new int[]{e.getOldIndex()}, new Object[]{e.getOldItem()}));
                break;
            }
            default: {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
            }
        }
        this.calculateCollisions();
    }

    @Override
    public void updateOpenable(Openable openable) {
        this.swfInfos.clear();
        this.abcClassesTree.clear();
        TreePath changedPath = this.getTreePath((TreeItem)(openable == null ? this.root : openable));
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath));
        this.calculateCollisions();
    }

    private void walkTimelinedTagList(Timelined timelined, Map<Integer, List<TreeItem>> mappedTags, List<TreeItem> shapes, List<TreeItem> morphShapes, List<TreeItem> sprites, List<TreeItem> buttons, List<TreeItem> images, List<TreeItem> fonts, List<TreeItem> texts, List<TreeItem> movies, List<TreeItem> sounds, List<TreeItem> binaryData, List<TreeItem> others, List<TreeItem> unknown, List<TreeItem> errored) {
        block15: for (Tag t : timelined.getTags()) {
            CharacterIdTag chit;
            SWF swf;
            TreeNodeType ttype = TagTree.getTreeNodeType((TreeItem)t);
            switch (ttype) {
                case SHAPE: {
                    shapes.add((TreeItem)t);
                    continue block15;
                }
                case MORPH_SHAPE: {
                    morphShapes.add((TreeItem)t);
                    continue block15;
                }
                case SPRITE: {
                    sprites.add((TreeItem)t);
                    this.walkTimelinedTagList((Timelined)((DefineSpriteTag)t), mappedTags, shapes, morphShapes, sprites, buttons, images, fonts, texts, movies, sounds, binaryData, others, unknown, errored);
                    continue block15;
                }
                case BUTTON: {
                    buttons.add((TreeItem)t);
                    continue block15;
                }
                case IMAGE: {
                    images.add((TreeItem)t);
                    continue block15;
                }
                case FONT: {
                    fonts.add((TreeItem)t);
                    continue block15;
                }
                case TEXT: {
                    texts.add((TreeItem)t);
                    continue block15;
                }
                case MOVIE: {
                    movies.add((TreeItem)t);
                    continue block15;
                }
                case SOUND: {
                    sounds.add((TreeItem)t);
                    continue block15;
                }
                case BINARY_DATA: {
                    binaryData.add((TreeItem)t);
                    continue block15;
                }
                case AS: 
                case AS_FRAME: {
                    continue block15;
                }
                case UNKNOWN: {
                    unknown.add((TreeItem)t);
                    continue block15;
                }
                case ERRORED: {
                    errored.add((TreeItem)t);
                    continue block15;
                }
            }
            if (t.getId() == 1 || ShowFrameTag.isNestedTagType((int)t.getId())) continue;
            boolean parentFound = false;
            if (t instanceof CharacterIdTag && !(t instanceof CharacterTag) && (swf = timelined instanceof SWF ? (SWF)timelined : ((DefineSpriteTag)timelined).getSwf()).getCharacter((chit = (CharacterIdTag)t).getCharacterId()) != null) {
                parentFound = true;
                if (!mappedTags.containsKey(chit.getCharacterId())) {
                    mappedTags.put(chit.getCharacterId(), new ArrayList());
                }
                mappedTags.get(chit.getCharacterId()).add((TreeItem)t);
            }
            if (parentFound) continue;
            others.add((TreeItem)t);
        }
    }

    private void createTagList(SWF swf) {
        Iterator<File> ranges;
        ArrayList<TreeItem> nodeList = new ArrayList<TreeItem>();
        ArrayList<TreeItem> frames = new ArrayList<TreeItem>();
        ArrayList<TreeItem> shapes = new ArrayList<TreeItem>();
        ArrayList<TreeItem> morphShapes = new ArrayList<TreeItem>();
        ArrayList<TreeItem> sprites = new ArrayList<TreeItem>();
        ArrayList<TreeItem> buttons = new ArrayList<TreeItem>();
        ArrayList<TreeItem> images = new ArrayList<TreeItem>();
        ArrayList<TreeItem> fonts = new ArrayList<TreeItem>();
        ArrayList<TreeItem> texts = new ArrayList<TreeItem>();
        ArrayList<TreeItem> movies = new ArrayList<TreeItem>();
        ArrayList<TreeItem> sounds = new ArrayList<TreeItem>();
        ArrayList<TreeItem> binaryData = new ArrayList<TreeItem>();
        ArrayList<TreeItem> others = new ArrayList<TreeItem>();
        ArrayList<TreeItem> unknown = new ArrayList<TreeItem>();
        ArrayList<TreeItem> errored = new ArrayList<TreeItem>();
        ArrayList<FolderItem> emptyFolders = new ArrayList<FolderItem>();
        HashMap<Integer, List<TreeItem>> mappedTags = new HashMap<Integer, List<TreeItem>>();
        this.walkTimelinedTagList((Timelined)swf, mappedTags, shapes, morphShapes, sprites, buttons, images, fonts, texts, movies, sounds, binaryData, others, unknown, errored);
        Timeline timeline = swf.getTimeline();
        int frameCount = timeline.getFrameCount();
        for (int i = 0; i < frameCount; ++i) {
            frames.add((TreeItem)timeline.getFrame(i));
        }
        ArrayList<TreeItem> scenes = new ArrayList<TreeItem>();
        List sceneList = timeline.getScenes();
        scenes.addAll(sceneList);
        for (int i = sounds.size() - 1; i >= 0; --i) {
            TreeItem sound = (TreeItem)sounds.get(i);
            if (!(sound instanceof SoundStreamHeadTypeTag) || (ranges = ((SoundStreamHeadTypeTag)sound).getRanges()) != null && !ranges.isEmpty()) continue;
            sounds.remove(i);
        }
        ArrayList<TreeItem> cookies = new ArrayList<TreeItem>();
        if (swf.getFile() != null) {
            List<File> solFiles = SharedObjectsStorage.getSolFilesForLocalFile(new File(swf.getFile()));
            for (File f : solFiles) {
                cookies.add(new Cookie(swf, f));
            }
        }
        HashMap<Tag, TagScript> currentTagScriptCache = new HashMap<Tag, TagScript>();
        ranges = FOLDERS_ORDER.iterator();
        while (ranges.hasNext()) {
            String key;
            switch (key = (String)((Object)ranges.next())) {
                case "header": {
                    nodeList.add((TreeItem)new HeaderItem(swf, this.translate("node.header")));
                    break;
                }
                case "cookies": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.cookies"), FOLDER_COOKIES, swf, cookies);
                    break;
                }
                case "shapes": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.shapes"), FOLDER_SHAPES, swf, shapes);
                    break;
                }
                case "morphshapes": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.morphshapes"), FOLDER_MORPHSHAPES, swf, morphShapes);
                    break;
                }
                case "sprites": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.sprites"), FOLDER_SPRITES, swf, sprites);
                    break;
                }
                case "texts": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.texts"), FOLDER_TEXTS, swf, texts);
                    break;
                }
                case "images": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.images"), FOLDER_IMAGES, swf, images);
                    break;
                }
                case "movies": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.movies"), FOLDER_MOVIES, swf, movies);
                    break;
                }
                case "sounds": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.sounds"), FOLDER_SOUNDS, swf, sounds);
                    break;
                }
                case "buttons": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.buttons"), FOLDER_BUTTONS, swf, buttons);
                    break;
                }
                case "fonts": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.fonts"), FOLDER_FONTS, swf, fonts);
                    break;
                }
                case "binaryData": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.binaryData"), FOLDER_BINARY_DATA, swf, binaryData);
                    break;
                }
                case "frames": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.frames"), FOLDER_FRAMES, swf, frames);
                    break;
                }
                case "scenes": {
                    this.addFolderItem(nodeList, emptyFolders, this.addAllFolders, this.translate("node.scenes"), FOLDER_SCENES, swf, scenes);
                    break;
                }
                case "others": {
                    this.addFolderItem(nodeList, emptyFolders, true, this.translate("node.others"), FOLDER_OTHERS, swf, others);
                    break;
                }
                case "unknown": {
                    this.addFolderItem(nodeList, emptyFolders, false, this.translate("node.unknown"), FOLDER_UNKNOWN, swf, unknown);
                    break;
                }
                case "errored": {
                    this.addFolderItem(nodeList, emptyFolders, false, this.translate("node.errored"), FOLDER_ERRORED, swf, errored);
                    break;
                }
                case "scripts": {
                    if (swf.isAS3()) {
                        if (swf.getAbcList().isEmpty()) break;
                        nodeList.add((TreeItem)new ClassesListTreeModel(swf, (boolean)((Boolean)Configuration.flattenASPackages.get())));
                        break;
                    }
                    List subNodes = swf.getFirstLevelASMNodes(currentTagScriptCache);
                    if (subNodes.size() <= 0) break;
                    FolderItem actionScriptNode = new FolderItem(this.translate("node.scripts"), FOLDER_SCRIPTS, swf, subNodes);
                    nodeList.add((TreeItem)actionScriptNode);
                }
            }
        }
        TagTreeSwfInfo swfInfo = new TagTreeSwfInfo();
        swfInfo.folders = nodeList;
        swfInfo.emptyFolders = emptyFolders;
        swfInfo.mappedTags = mappedTags;
        swfInfo.tagScriptCache = currentTagScriptCache;
        this.swfInfos.put(swf, swfInfo);
    }

    public List<String> getAvailableFolders() {
        LinkedHashSet<String> folderNames = new LinkedHashSet<String>();
        folderNames.add("header");
        for (TagTreeSwfInfo swfInfo : this.swfInfos.values()) {
            for (TreeItem item : swfInfo.folders) {
                if (item instanceof FolderItem) {
                    FolderItem f = (FolderItem)item;
                    folderNames.add(f.getName());
                }
                if (!(item instanceof ClassesListTreeModel)) continue;
                folderNames.add(FOLDER_SCRIPTS);
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String f : FOLDERS_ORDER) {
            if (!folderNames.contains(f)) continue;
            ret.add(f);
        }
        return ret;
    }

    private void addFolderItem(List<TreeItem> nodeList, List<FolderItem> emptyList, boolean addAllFolders, String title, String folderName, SWF swf, List<TreeItem> items) {
        FolderItem node = new FolderItem(title, folderName, swf, items);
        if (addAllFolders || !items.isEmpty()) {
            nodeList.add((TreeItem)node);
        }
        if (items.isEmpty()) {
            emptyList.add(node);
        }
    }

    public TreeItem getScriptsNode(SWF swf) {
        int childCount = this.getChildCount(swf);
        for (int i = 0; i < childCount; ++i) {
            FolderItem folder;
            TreeItem child = this.getChild(swf, i);
            if (child instanceof ClassesListTreeModel) {
                return child;
            }
            if (!(child instanceof FolderItem) || !(folder = (FolderItem)child).getName().equals(FOLDER_SCRIPTS)) continue;
            return folder;
        }
        return null;
    }

    public TreeItem getFolderNode(SWF swf, String folderType) {
        int childCount = this.getChildCount(swf);
        for (int i = 0; i < childCount; ++i) {
            FolderItem folder;
            TreeItem child = this.getChild(swf, i);
            if (!(child instanceof FolderItem) || !(folder = (FolderItem)child).getName().equals(folderType)) continue;
            return folder;
        }
        return null;
    }

    private Frame searchForFrame(Object parent, SWF swf, Timelined t, int frame) {
        int childCount = this.getChildCount(parent);
        Frame lastVisibleFrame = null;
        for (int i = 0; i < childCount; ++i) {
            Frame si;
            Frame si2;
            TreeItem child = this.getChild(parent, i);
            if (child instanceof DefineSpriteTag && child == t && (si2 = this.searchForFrame(child, swf, t, frame)) != null) {
                return si2;
            }
            if (child instanceof Frame) {
                Frame f = (Frame)child;
                if (f.frame <= frame) {
                    lastVisibleFrame = f;
                }
            }
            if (!(child instanceof FolderItem)) continue;
            FolderItem folder = (FolderItem)child;
            if (folder.getName().equals(FOLDER_FRAMES) && t == swf && (si = this.searchForFrame(folder, swf, t, frame)) != null) {
                return si;
            }
            if (!folder.getName().equals(FOLDER_SPRITES) || (si = this.searchForFrame(folder, swf, t, frame)) == null) continue;
            return si;
        }
        return lastVisibleFrame;
    }

    @Override
    public Frame getFrame(SWF swf, Timelined t, int frame) {
        return this.searchForFrame(swf, swf, t, frame);
    }

    @Override
    protected void searchTreeItemMulti(List<TreeItem> objs, TreeItem parent, List<TreeItem> path, Map<TreeItem, List<TreeItem>> result) {
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
            newPath.addAll(path);
            newPath.add(treeItem);
            for (TreeItem obj : objs) {
                if (!this.searchMatches(treeItem, obj)) continue;
                result.put(obj, newPath);
            }
            this.searchTreeItemMulti(objs, treeItem, newPath, result);
        }
    }

    @Override
    protected void searchTreeItemParentMulti(List<TreeItem> objs, TreeItem parent, Map<TreeItem, TreeItem> result) {
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            for (TreeItem obj : objs) {
                if (!this.searchMatches(treeItem, obj)) continue;
                result.put(obj, parent);
            }
            this.searchTreeItemParentMulti(objs, treeItem, result);
        }
    }

    private boolean searchMatches(TreeItem n, TreeItem obj) {
        SceneFrame objs;
        SceneFrame nds;
        AS3ClassTreeItem te;
        if (n instanceof AS3Package) {
            AS3Package pkg = (AS3Package)n;
            if (obj instanceof AS3Package) {
                AS3Package opkg = (AS3Package)obj;
                if (Objects.equals(pkg.packageName, opkg.packageName) && pkg.getAbc() == opkg.getAbc()) {
                    return true;
                }
            }
        }
        if (n instanceof AS3ClassTreeItem && obj == (te = (AS3ClassTreeItem)n)) {
            return true;
        }
        if (obj instanceof SceneFrame && n instanceof SceneFrame) {
            nds = (SceneFrame)n;
            objs = (SceneFrame)obj;
            if (objs.getFrame().frame == nds.getFrame().frame && objs.getOpenable() == nds.getOpenable()) {
                return true;
            }
        }
        if (obj instanceof FolderItem && n instanceof FolderItem) {
            nds = (FolderItem)n;
            objs = (FolderItem)obj;
            if (objs.getName().equals(nds.getName()) && objs.swf == nds.swf) {
                return true;
            }
        } else {
            TreeItem objNoTs = obj;
            if (obj instanceof TagScript) {
                objNoTs = ((TagScript)obj).getTag();
            }
            TreeItem nNoTs = n;
            if (n instanceof TagScript) {
                nNoTs = ((TagScript)n).getTag();
            }
            if (objNoTs == nNoTs) {
                return true;
            }
            TreeItem objNoFs = obj;
            if (obj instanceof FrameScript && ((FrameScript)obj).getSingleDoActionTag() != null) {
                objNoFs = ((FrameScript)obj).getSingleDoActionTag();
            }
            TreeItem nNoFs = n;
            if (n instanceof FrameScript && ((FrameScript)n).getSingleDoActionTag() != null) {
                nNoFs = ((FrameScript)n).getSingleDoActionTag();
            }
            if (objNoFs == nNoFs) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<TreeItem> searchTreeItem(TreeItem obj, TreeItem parent, List<TreeItem> path) {
        List<TreeItem> ret = null;
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
            newPath.addAll(path);
            newPath.add(treeItem);
            if (this.searchMatches(treeItem, obj)) {
                return newPath;
            }
            ret = this.searchTreeItem(obj, treeItem, newPath);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public TreeItem getRoot() {
        return this.root;
    }

    private TagTreeSwfInfo getSwfInfo(SWF swf) {
        TagTreeSwfInfo swfInfo = this.swfInfos.get(swf);
        if (swfInfo == null) {
            this.createTagList(swf);
            swfInfo = this.swfInfos.get(swf);
        }
        return swfInfo;
    }

    public List<FolderItem> getEmptyFolders(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.emptyFolders;
    }

    private List<TreeItem> getSwfFolders(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.folders;
    }

    private List<TreeItem> getMappedCharacters(SWF swf, CharacterTag tag) {
        if (swf == null) {
            return new ArrayList<TreeItem>();
        }
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        List<TreeItem> mapped = swfInfo.mappedTags.get(tag.getCharacterId());
        if (mapped == null) {
            mapped = new ArrayList<TreeItem>();
        }
        mapped = new ArrayList<TreeItem>(mapped);
        for (int i = 0; i < mapped.size(); ++i) {
            if (!(mapped.get(i) instanceof DoInitActionTag)) continue;
            mapped.remove(i);
            --i;
        }
        return mapped;
    }

    private Map<Tag, TagScript> getTagScriptCache(SWF swf) {
        TagTreeSwfInfo swfInfo = this.getSwfInfo(swf);
        return swfInfo.tagScriptCache;
    }

    @Override
    public List<? extends TreeItem> getAllChildren(Object parent) {
        List<? extends TreeItem> ret = this.getAllChildrenInternal(parent);
        for (TreeItem treeItem : ret) {
            this.itemToParentCache.put(treeItem, (TreeItem)parent);
        }
        return ret;
    }

    private List<? extends TreeItem> getAllChildrenInternal(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        ArrayList<Object> result = new ArrayList();
        if (parentNode instanceof CharacterTag) {
            result = new ArrayList<TreeItem>(this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode));
        }
        if (parentNode == this.root) {
            for (OpenableList swfList : this.swfs) {
                if (!swfList.isBundle()) {
                    result.add(swfList.get(0));
                    continue;
                }
                result.add(swfList);
            }
            return result;
        }
        if (parentNode instanceof OpenableList) {
            return ((OpenableList)parentNode).items;
        }
        if (parentNode instanceof SWF) {
            return this.getSwfFolders((SWF)parentNode);
        }
        if (parentNode instanceof Scene) {
            Scene scene = (Scene)parentNode;
            ArrayList<SceneFrame> sceneFrames = new ArrayList<SceneFrame>();
            for (int i = 0; i < scene.getSceneFrameCount(); ++i) {
                sceneFrames.add(scene.getSceneFrame(i));
            }
            return sceneFrames;
        }
        if (parentNode instanceof FolderItem) {
            return ((FolderItem)parentNode).subItems;
        }
        if (parentNode instanceof Frame) {
            return ((Frame)parentNode).innerTags;
        }
        if (parentNode instanceof DefineSpriteTag) {
            result.addAll(((DefineSpriteTag)parentNode).getTimeline().getFrames());
            return result;
        }
        if (parentNode instanceof BinaryDataInterface) {
            BinaryDataInterface binaryData = (BinaryDataInterface)parentNode;
            if (binaryData.getInnerSwf() != null) {
                result.add(binaryData.getInnerSwf());
                return result;
            }
            if (binaryData.getSub() != null) {
                result.add(binaryData.getSub());
                return result;
            }
            return new ArrayList(0);
        }
        if (parentNode instanceof AS2Package) {
            return ((AS2Package)parentNode).getAllChildren();
        }
        if (parentNode instanceof FrameScript) {
            if (((FrameScript)parentNode).getSingleDoActionTag() != null) {
                return new ArrayList();
            }
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            result.addAll(parentFrame.actionContainers);
            result.addAll(parentFrame.actions);
            for (int i = 0; i < result.size(); ++i) {
                TreeItem item = (TreeItem)result.get(i);
                if (!(item instanceof Tag)) continue;
                Tag resultTag = (Tag)item;
                Map<Tag, TagScript> currentTagScriptCache = this.getTagScriptCache((SWF)item.getOpenable());
                TagScript tagScript = currentTagScriptCache.get(resultTag);
                if (tagScript == null) {
                    ArrayList<ASMSource> subNodes = new ArrayList<ASMSource>();
                    if (item instanceof ASMSourceContainer) {
                        for (ASMSource item2 : ((ASMSourceContainer)item).getSubItems()) {
                            subNodes.add(item2);
                        }
                    }
                    tagScript = new TagScript((SWF)item.getOpenable(), resultTag, subNodes);
                    currentTagScriptCache.put(resultTag, tagScript);
                }
                result.set(i, tagScript);
            }
            return result;
        }
        if (parentNode instanceof TagScript) {
            return ((TagScript)parentNode).getFrames();
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return clt.getAllChildren(clt.getRoot());
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            if (parentNode instanceof AS3Package) {
                return ((AS3Package)parentNode).getAllChildren();
            }
            return new ArrayList();
        }
        if (parentNode instanceof ButtonTag) {
            return ((ButtonTag)parentNode).getRecords();
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesTreeModel.getAllChildren(classesTreeModel.getRoot());
        }
        if (parentNode instanceof SoundStreamHeadTypeTag) {
            SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)parentNode;
            return head.getRanges();
        }
        return result;
    }

    @Override
    public TreeItem getChild(Object parent, int index) {
        TreeItem result = this.getChildInternal(parent, index);
        if (result != null) {
            this.itemToParentCache.put(result, (TreeItem)parent);
        }
        return result;
    }

    private TreeItem getChildInternal(Object parent, int index) {
        if (this.getChildCount(parent) == 0) {
            return null;
        }
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode instanceof CharacterTag) {
            List<TreeItem> mapped = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode);
            if (index < mapped.size()) {
                return mapped.get(index);
            }
            index -= mapped.size();
        }
        if (parentNode == this.root) {
            OpenableList openableList = this.swfs.get(index);
            if (!openableList.isBundle()) {
                return openableList.get(0);
            }
            return openableList;
        }
        if (parentNode instanceof OpenableList) {
            return (TreeItem)((OpenableList)parentNode).items.get(index);
        }
        if (parentNode instanceof SWF) {
            return this.getSwfFolders((SWF)parentNode).get(index);
        }
        if (parentNode instanceof Scene) {
            return ((Scene)parentNode).getSceneFrame(index);
        }
        if (parentNode instanceof FolderItem) {
            return (TreeItem)((FolderItem)parentNode).subItems.get(index);
        }
        if (parentNode instanceof Frame) {
            return (TreeItem)((Frame)parentNode).innerTags.get(index);
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrame(index);
        }
        if (parentNode instanceof BinaryDataInterface) {
            BinaryDataInterface binaryData = (BinaryDataInterface)parentNode;
            if (binaryData.getInnerSwf() != null) {
                return binaryData.getInnerSwf();
            }
            return binaryData.getSub();
        }
        if (parentNode instanceof AS2Package) {
            return ((AS2Package)parentNode).getChild(index);
        }
        if (parentNode instanceof FrameScript) {
            if (((FrameScript)parentNode).getSingleDoActionTag() != null) {
                return null;
            }
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            TreeItem result = index < parentFrame.actionContainers.size() ? (TreeItem)parentFrame.actionContainers.get(index) : (TreeItem)parentFrame.actions.get(index -= parentFrame.actionContainers.size());
            if (result instanceof Tag) {
                Tag resultTag = (Tag)result;
                Map<Tag, TagScript> currentTagScriptCache = this.getTagScriptCache((SWF)result.getOpenable());
                TagScript tagScript = currentTagScriptCache.get(resultTag);
                if (tagScript == null) {
                    ArrayList<ASMSource> subNodes = new ArrayList<ASMSource>();
                    if (result instanceof ASMSourceContainer) {
                        for (ASMSource item : ((ASMSourceContainer)result).getSubItems()) {
                            subNodes.add(item);
                        }
                    }
                    tagScript = new TagScript((SWF)result.getOpenable(), resultTag, subNodes);
                    currentTagScriptCache.put(resultTag, tagScript);
                }
                result = tagScript;
            }
            return result;
        }
        if (parentNode instanceof TagScript) {
            return (TreeItem)((TagScript)parentNode).getFrames().get(index);
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return clt.getChild(clt.getRoot(), index);
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            return ((AS3Package)parentNode).getChild(index);
        }
        if (parentNode instanceof ButtonTag) {
            return (TreeItem)((ButtonTag)parentNode).getRecords().get(index);
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesTreeModel.getChild(classesTreeModel.getRoot(), index);
        }
        if (parentNode instanceof SoundStreamHeadTypeTag) {
            SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)parentNode;
            return (TreeItem)head.getRanges().get(index);
        }
        throw new Error("Unsupported parent type: " + parentNode.getClass().getName());
    }

    @Override
    public int getChildCount(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        int mappedSize = 0;
        if (parentNode instanceof CharacterTag) {
            mappedSize = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode).size();
        }
        if (parentNode == this.root) {
            return mappedSize + this.swfs.size();
        }
        if (parentNode instanceof OpenableList) {
            return mappedSize + ((OpenableList)parentNode).items.size();
        }
        if (parentNode instanceof SWF) {
            return mappedSize + this.getSwfFolders((SWF)parentNode).size();
        }
        if (parentNode instanceof Scene) {
            return mappedSize + ((Scene)parentNode).getSceneFrameCount();
        }
        if (parentNode instanceof HeaderItem) {
            return mappedSize + 0;
        }
        if (parentNode instanceof FolderItem) {
            return mappedSize + ((FolderItem)parentNode).subItems.size();
        }
        if (parentNode instanceof Frame) {
            return mappedSize + ((Frame)parentNode).innerTags.size();
        }
        if (parentNode instanceof DefineSpriteTag) {
            return mappedSize + ((DefineSpriteTag)parentNode).getTimeline().getFrameCount();
        }
        if (parentNode instanceof BinaryDataInterface) {
            BinaryDataInterface binary = (BinaryDataInterface)parentNode;
            if (binary.getInnerSwf() != null) {
                return mappedSize + 1;
            }
            return mappedSize + (binary.getSub() == null ? 0 : 1);
        }
        if (parentNode instanceof AS2Package) {
            return mappedSize + ((AS2Package)parentNode).getChildCount();
        }
        if (parentNode instanceof FrameScript) {
            if (((FrameScript)parentNode).getSingleDoActionTag() != null) {
                return 0;
            }
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            return mappedSize + parentFrame.actionContainers.size() + parentFrame.actions.size();
        }
        if (parentNode instanceof TagScript) {
            return mappedSize + ((TagScript)parentNode).getFrames().size();
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return mappedSize + clt.getChildCount(clt.getRoot());
        }
        if (parentNode instanceof AS3Package) {
            return mappedSize + ((AS3Package)parentNode).getChildCount();
        }
        if (parentNode instanceof ButtonTag) {
            return mappedSize + ((ButtonTag)parentNode).getRecords().size();
        }
        if (parentNode instanceof CharacterTag) {
            return mappedSize;
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesTreeModel.getChildCount(classesTreeModel.getRoot());
        }
        if (parentNode instanceof SoundStreamHeadTypeTag) {
            SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)parentNode;
            return head.getRanges().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    private int indexOfAdd(int prevSize, int index) {
        if (index == -1) {
            return -1;
        }
        return prevSize + index;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeItem parentNode = (TreeItem)parent;
        TreeItem childNode = (TreeItem)child;
        int baseIndex = 0;
        if (parentNode instanceof CharacterTag) {
            List<TreeItem> mapped = this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode);
            int mindex = mapped.indexOf(child);
            if (mindex > -1) {
                return mindex;
            }
            baseIndex = mapped.size();
        }
        if (parentNode == this.root) {
            OpenableList openableList = child instanceof OpenableList ? (OpenableList)child : ((Openable)child).getOpenableList();
            return this.indexOfAdd(baseIndex, this.swfs.indexOf(openableList));
        }
        if (parentNode instanceof OpenableList) {
            return this.indexOfAdd(baseIndex, ((OpenableList)parentNode).items.indexOf(childNode));
        }
        if (parentNode instanceof SWF) {
            return this.indexOfAdd(baseIndex, this.getSwfFolders((SWF)parentNode).indexOf(childNode));
        }
        if (parentNode instanceof Scene) {
            return this.getAllChildren(parentNode).indexOf(childNode);
        }
        if (parentNode instanceof FolderItem) {
            return this.indexOfAdd(baseIndex, ((FolderItem)parentNode).subItems.indexOf(childNode));
        }
        if (parentNode instanceof Frame) {
            return this.indexOfAdd(baseIndex, ((Frame)parentNode).innerTags.indexOf(childNode));
        }
        if (parentNode instanceof DefineSpriteTag) {
            return this.indexOfAdd(baseIndex, ((Frame)childNode).frame);
        }
        if (parentNode instanceof BinaryDataInterface) {
            return this.indexOfAdd(baseIndex, 0);
        }
        if (parentNode instanceof AS2Package) {
            return this.indexOfAdd(baseIndex, ((AS2Package)parentNode).getIndexOfChild(childNode));
        }
        if (parentNode instanceof FrameScript) {
            if (((FrameScript)parentNode).getSingleDoActionTag() != null) {
                return -1;
            }
            Frame parentFrame = ((FrameScript)parentNode).getFrame();
            if (childNode instanceof TagScript) {
                childNode = ((TagScript)childNode).getTag();
            }
            if (childNode instanceof ASMSourceContainer) {
                return this.indexOfAdd(baseIndex, parentFrame.actionContainers.indexOf(childNode));
            }
            return this.indexOfAdd(baseIndex, parentFrame.actionContainers.size() + parentFrame.actions.indexOf(childNode));
        }
        if (parentNode instanceof TagScript) {
            return this.indexOfAdd(baseIndex, ((TagScript)parentNode).getFrames().indexOf(childNode));
        }
        if (parentNode instanceof ClassesListTreeModel) {
            ClassesListTreeModel clt = (ClassesListTreeModel)parentNode;
            return this.indexOfAdd(baseIndex, clt.getIndexOfChild(clt.getRoot(), childNode));
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            return this.indexOfAdd(baseIndex, ((AS3Package)parentNode).getIndexOfChild((AS3ClassTreeItem)childNode));
        }
        if (parentNode instanceof ButtonTag) {
            return this.indexOfAdd(baseIndex, ((ButtonTag)parentNode).getRecords().indexOf(childNode));
        }
        if (parentNode instanceof CharacterTag) {
            return this.indexOfAdd(baseIndex, this.getMappedCharacters(((CharacterTag)parentNode).getSwf(), (CharacterTag)parentNode).indexOf(childNode));
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return this.indexOfAdd(baseIndex, classesTreeModel.getIndexOfChild(classesTreeModel.getRoot(), childNode));
        }
        if (parentNode instanceof SoundStreamHeadTypeTag) {
            SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)parentNode;
            return this.indexOfAdd(baseIndex, head.getRanges().indexOf(childNode));
        }
        return -1;
    }

    private ClassesListTreeModel getClassesListTreeModel(ABC abc) {
        if (this.abcClassesTree.containsKey(abc)) {
            return this.abcClassesTree.get(abc);
        }
        ClassesListTreeModel model = new ClassesListTreeModel(abc, (boolean)((Boolean)Configuration.flattenASPackages.get()));
        this.abcClassesTree.put(abc, model);
        return model;
    }
}

