/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.DebuggerMessage;
import com.jpexs.debugger.flash.Value;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InAskBreakpoints;
import com.jpexs.debugger.flash.messages.in.InBinaryOp;
import com.jpexs.debugger.flash.messages.in.InBreakAt;
import com.jpexs.debugger.flash.messages.in.InBreakAtExt;
import com.jpexs.debugger.flash.messages.in.InBreakReason;
import com.jpexs.debugger.flash.messages.in.InCallFunction;
import com.jpexs.debugger.flash.messages.in.InConstantPool;
import com.jpexs.debugger.flash.messages.in.InContinue;
import com.jpexs.debugger.flash.messages.in.InDeleteVariable;
import com.jpexs.debugger.flash.messages.in.InErrorConsole;
import com.jpexs.debugger.flash.messages.in.InErrorException;
import com.jpexs.debugger.flash.messages.in.InErrorExecLimit;
import com.jpexs.debugger.flash.messages.in.InErrorProtoLimit;
import com.jpexs.debugger.flash.messages.in.InErrorScriptStuck;
import com.jpexs.debugger.flash.messages.in.InErrorStackUnderflow;
import com.jpexs.debugger.flash.messages.in.InErrorTarget;
import com.jpexs.debugger.flash.messages.in.InErrorURLOpen;
import com.jpexs.debugger.flash.messages.in.InErrorWith;
import com.jpexs.debugger.flash.messages.in.InErrorZeroDivide;
import com.jpexs.debugger.flash.messages.in.InExit;
import com.jpexs.debugger.flash.messages.in.InFrame;
import com.jpexs.debugger.flash.messages.in.InGetActions;
import com.jpexs.debugger.flash.messages.in.InGetFncNames;
import com.jpexs.debugger.flash.messages.in.InGetSwd;
import com.jpexs.debugger.flash.messages.in.InGetSwf;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.debugger.flash.messages.in.InIsolate;
import com.jpexs.debugger.flash.messages.in.InIsolateCreate;
import com.jpexs.debugger.flash.messages.in.InIsolateEnumerate;
import com.jpexs.debugger.flash.messages.in.InIsolateExit;
import com.jpexs.debugger.flash.messages.in.InNewObject;
import com.jpexs.debugger.flash.messages.in.InNotSynced;
import com.jpexs.debugger.flash.messages.in.InNumScript;
import com.jpexs.debugger.flash.messages.in.InOption;
import com.jpexs.debugger.flash.messages.in.InParam;
import com.jpexs.debugger.flash.messages.in.InPassAllExceptionsToDebugger;
import com.jpexs.debugger.flash.messages.in.InPlaceObject;
import com.jpexs.debugger.flash.messages.in.InProcessTag;
import com.jpexs.debugger.flash.messages.in.InRemoveBreakpoint;
import com.jpexs.debugger.flash.messages.in.InRemoveExceptionBreakpoint;
import com.jpexs.debugger.flash.messages.in.InRemoveObject;
import com.jpexs.debugger.flash.messages.in.InRemoveScript;
import com.jpexs.debugger.flash.messages.in.InScript;
import com.jpexs.debugger.flash.messages.in.InSetActiveIsolate;
import com.jpexs.debugger.flash.messages.in.InSetBreakpoint;
import com.jpexs.debugger.flash.messages.in.InSetExceptionBreakpoint;
import com.jpexs.debugger.flash.messages.in.InSetLocalVariables;
import com.jpexs.debugger.flash.messages.in.InSetMenuState;
import com.jpexs.debugger.flash.messages.in.InSetProperty;
import com.jpexs.debugger.flash.messages.in.InSetVariable;
import com.jpexs.debugger.flash.messages.in.InSetVariable2;
import com.jpexs.debugger.flash.messages.in.InSquelch;
import com.jpexs.debugger.flash.messages.in.InSwfInfo;
import com.jpexs.debugger.flash.messages.in.InTrace;
import com.jpexs.debugger.flash.messages.in.InUnknown;
import com.jpexs.debugger.flash.messages.in.InVersion;
import com.jpexs.debugger.flash.messages.in.InWatch;
import com.jpexs.debugger.flash.messages.in.InWatch2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class InDebuggerMessage
extends DebuggerMessage {
    public int type;
    public byte[] data;
    public static final int DEFAULT_ISOLATE_ID = 1;
    protected int targetIsolate;
    private ByteArrayInputStream is;
    protected boolean wideLines = false;
    protected DebuggerConnection connection;

    protected InDebuggerMessage(DebuggerConnection c, int type, byte[] data) {
        this.data = data;
        this.is = new ByteArrayInputStream(data);
        this.connection = c;
        this.targetIsolate = c.activeIsolateId;
        this.wideLines = c.wideLines;
    }

    public static final InDebuggerMessage getInstance(DebuggerConnection c, int type, byte[] data) {
        switch (type) {
            case -1: {
                return new InUnknown(c, data);
            }
            case 0: {
                return new InSetMenuState(c, data);
            }
            case 1: {
                return new InSetProperty(c, data);
            }
            case 2: {
                return new InExit(c, data);
            }
            case 3: {
                return new InNewObject(c, data);
            }
            case 4: {
                return new InRemoveObject(c, data);
            }
            case 5: {
                return new InTrace(c, data);
            }
            case 6: {
                return new InErrorTarget(c, data);
            }
            case 7: {
                return new InErrorExecLimit(c, data);
            }
            case 8: {
                return new InErrorWith(c, data);
            }
            case 9: {
                return new InErrorProtoLimit(c, data);
            }
            case 10: {
                return new InSetVariable(c, data);
            }
            case 11: {
                return new InDeleteVariable(c, data);
            }
            case 12: {
                return new InParam(c, data);
            }
            case 13: {
                return new InPlaceObject(c, data);
            }
            case 14: {
                return new InScript(c, data);
            }
            case 15: {
                return new InAskBreakpoints(c, data);
            }
            case 16: {
                return new InBreakAt(c, data);
            }
            case 17: {
                return new InContinue(c, data);
            }
            case 18: {
                return new InSetLocalVariables(c, data);
            }
            case 19: {
                return new InSetBreakpoint(c, data);
            }
            case 20: {
                return new InNumScript(c, data);
            }
            case 21: {
                return new InRemoveScript(c, data);
            }
            case 22: {
                return new InRemoveBreakpoint(c, data);
            }
            case 23: {
                return new InNotSynced(c, data);
            }
            case 24: {
                return new InErrorURLOpen(c, data);
            }
            case 25: {
                return new InProcessTag(c, data);
            }
            case 26: {
                return new InVersion(c, data);
            }
            case 27: {
                return new InBreakAtExt(c, data);
            }
            case 28: {
                return new InSetVariable2(c, data);
            }
            case 29: {
                return new InSquelch(c, data);
            }
            case 30: {
                return new InGetVariable(c, data);
            }
            case 31: {
                return new InFrame(c, data);
            }
            case 32: {
                return new InOption(c, data);
            }
            case 33: {
                return new InWatch(c, data);
            }
            case 34: {
                return new InGetSwf(c, data);
            }
            case 35: {
                return new InGetSwd(c, data);
            }
            case 36: {
                return new InErrorException(c, data);
            }
            case 37: {
                return new InErrorStackUnderflow(c, data);
            }
            case 38: {
                return new InErrorZeroDivide(c, data);
            }
            case 39: {
                return new InErrorScriptStuck(c, data);
            }
            case 40: {
                return new InBreakReason(c, data);
            }
            case 41: {
                return new InGetActions(c, data);
            }
            case 42: {
                return new InSwfInfo(c, data);
            }
            case 43: {
                return new InConstantPool(c, data);
            }
            case 44: {
                return new InErrorConsole(c, data);
            }
            case 45: {
                return new InGetFncNames(c, data);
            }
            case 54: {
                return new InCallFunction(c, data);
            }
            case 55: {
                return new InWatch2(c, data);
            }
            case 56: {
                return new InPassAllExceptionsToDebugger(c, data);
            }
            case 57: {
                return new InBinaryOp(c, data);
            }
            case 58: {
                return new InIsolateCreate(c, data);
            }
            case 59: {
                return new InIsolateExit(c, data);
            }
            case 60: {
                return new InIsolateEnumerate(c, data);
            }
            case 61: {
                return new InSetActiveIsolate(c, data);
            }
            case 62: {
                return new InIsolate(c, data);
            }
            case 63: {
                return new InSetExceptionBreakpoint(c, data);
            }
            case 64: {
                return new InRemoveExceptionBreakpoint(c, data);
            }
        }
        return new InUnknown(c, data);
    }

    public void reset() {
        this.is = new ByteArrayInputStream(this.data);
    }

    public InDebuggerMessage(DebuggerConnection c, int type) {
        this(c, type, new byte[0]);
    }

    public long readDWord() {
        int b1 = this.is.read();
        int b2 = this.is.read();
        int b3 = this.is.read();
        int b4 = this.is.read();
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + b1;
    }

    public long readLong() {
        long dw1 = this.readDWord();
        long dw2 = this.readDWord();
        return (dw2 << 32) + dw1;
    }

    public int readByte() {
        return this.is.read();
    }

    public int readWord() {
        int b1 = this.is.read();
        int b2 = this.is.read();
        return (b2 << 8) + b1;
    }

    public byte[] readBytes(int cnt) {
        byte[] ret = new byte[cnt];
        try {
            this.is.read(ret);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public long readPtr(DebuggerConnection c) {
        if (c.sizeOfPtr == 4) {
            return this.readDWord();
        }
        if (c.sizeOfPtr == 8) {
            return this.readLong();
        }
        return 0L;
    }

    public String readString() {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = this.is.read()) > 0) {
            baos.write(c);
        }
        if (c == -1) {
            throw new ArrayIndexOutOfBoundsException("Unterminated string");
        }
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(baos.toByteArray());
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public int available() {
        return this.is.available();
    }

    public void exec() {
    }

    public Variable readVariable(DebuggerConnection c) {
        return this.readVariable(c, this.readString());
    }

    public Variable readRegister(DebuggerConnection c, int number) {
        int oType = this.readWord();
        return this.readAtom(c, "$" + number, oType, 0);
    }

    public Variable readVariable(DebuggerConnection c, String name) {
        int oType = this.readWord();
        int flags = (int)this.readDWord();
        return this.readAtom(c, name, oType, flags);
    }

    public Variable readAtom(DebuggerConnection c, String name, int oType, int flags) {
        int vType = 8;
        Object value = null;
        String typeName = "";
        String className = "";
        boolean isPrimitive = false;
        switch (oType) {
            case 0: {
                String s = this.readString();
                double dval = Double.NaN;
                try {
                    dval = Double.parseDouble(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                value = dval;
                isPrimitive = true;
                vType = 0;
                break;
            }
            case 1: {
                int bval = this.readByte();
                value = bval == 0;
                isPrimitive = true;
                vType = 1;
                break;
            }
            case 2: {
                String s = this.readString();
                value = s;
                isPrimitive = true;
                vType = 2;
                break;
            }
            case 3: 
            case 18: {
                long oid = this.readPtr(c);
                long cType = oid == -1L ? 0L : this.readDWord();
                int isFnc = oid == -1L ? 0 : this.readWord();
                int rsvd = oid == -1L ? 0 : this.readWord();
                String string = typeName = oid == -1L ? "" : this.readString();
                if (typeName.startsWith("<")) {
                    int atIndex = typeName.indexOf(64);
                    String dateVal = typeName;
                    if (atIndex > -1) {
                        dateVal = typeName.substring(0, atIndex);
                    }
                    SimpleDateFormat dFormat = new SimpleDateFormat("<EEE MMM d HH:mm:ss 'GMT'z yyyy>");
                    try {
                        Date dateObj = dFormat.parse(dateVal);
                        if (dateObj != null && dateObj.getTime() != 0L) {
                            oType = 11;
                            typeName = "Date" + typeName.substring(atIndex);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                className = InDebuggerMessage.classNameFor(cType, false);
                value = oid;
                vType = isFnc == 0 ? 3 : 4;
                break;
            }
            case 4: {
                long oid = this.readPtr(c);
                long cType = oid == -1L ? 0L : this.readDWord();
                long rsvd = oid == -1L ? 0L : this.readDWord();
                typeName = oid == -1L ? "" : this.readString();
                className = InDebuggerMessage.classNameFor(cType, true);
                value = oid;
                vType = 5;
                break;
            }
            case 5: {
                value = null;
                isPrimitive = true;
                vType = 6;
                break;
            }
            case 6: {
                value = Value.UNDEFINED;
                isPrimitive = true;
                vType = 7;
                break;
            }
            case 19: {
                vType = 8;
                typeName = "traits";
                break;
            }
        }
        return new Variable(name, vType, value, typeName, className, isPrimitive, flags);
    }

    public int getTargetIsolate() {
        return this.targetIsolate;
    }

    public static final int decodeFile(long id) {
        return (int)(id & 0xFFFFL);
    }

    public static final int decodeLine(long id) {
        return (int)(id >> 16 & 0xFFFFL);
    }

    protected boolean isTraits(Variable variable) {
        return variable.vType == 8 && "traits".equals(variable.typeName);
    }

    protected boolean showMember(Variable child) {
        return !this.isTraits(child);
    }
}

