/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.deobfuscation;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorSimpleOld;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.KillIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnValueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ReturnVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.ThrowIns;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AVM2DeobfuscatorRegistersOld
extends AVM2DeobfuscatorSimpleOld {
    private Set<Integer> getRegisters(AVM2Code code) {
        HashSet<Integer> regs = new HashSet<Integer>();
        for (AVM2Instruction ins : code.code) {
            int regId;
            InstructionDefinition def = ins.definition;
            if (def instanceof SetLocalTypeIns) {
                regId = ((SetLocalTypeIns)def).getRegisterId(ins);
                regs.add(regId);
                continue;
            }
            if (def instanceof GetLocalTypeIns) {
                regId = ((GetLocalTypeIns)def).getRegisterId(ins);
                regs.add(regId);
                continue;
            }
            for (int p = 0; p < ins.definition.operands.length; ++p) {
                int op = ins.definition.operands[p];
                if (op != 264) continue;
                int regId2 = ins.operands[p];
                regs.add(regId2);
            }
        }
        return regs;
    }

    @Override
    public void avm2CodeRemoveTraps(String path, int classIndex, boolean isStatic, int scriptIndex, ABC abc, Trait trait, int methodInfo, MethodBody body) throws InterruptedException {
        MethodBody originalBody = body;
        body.getCode().removeDeadCode(body);
        HashSet<Integer> ignoredRegs = new HashSet<Integer>();
        int localReservedCount = body.getLocalReservedCount();
        for (int i = 0; i < localReservedCount; ++i) {
            ignoredRegs.add(i);
        }
        int setReg = 0;
        ArrayList<Integer> listedRegs = new ArrayList<Integer>();
        ArrayList<MethodBody> listedLastBodies = new ArrayList<MethodBody>();
        HashSet<Integer> ignoredRegGets = new HashSet<Integer>();
        Reference<Object> assignmentRef = new Reference<Object>(null);
        while (setReg > -1) {
            if (CancellableWorker.isInterrupted()) {
                throw new InterruptedException();
            }
            MethodBody bodybefore = body;
            setReg = this.getFirstRegisterSetter(assignmentRef, classIndex, isStatic, scriptIndex, abc, body = bodybefore.clone(), ignoredRegs, ignoredRegGets);
            if (setReg < 0) break;
            if (listedRegs.contains(setReg)) {
                int lindex = listedRegs.indexOf(setReg);
                body = (MethodBody)listedLastBodies.get(lindex);
                ignoredRegs.add(setReg);
                for (int i = listedRegs.size() - 1; i >= lindex; --i) {
                    int r = (Integer)listedRegs.get(i);
                    listedRegs.remove(i);
                    listedLastBodies.remove(i);
                    ignoredRegGets.remove(r);
                }
                continue;
            }
            AVM2Instruction assignment = assignmentRef.getVal();
            InstructionDefinition def = assignment.definition;
            if (def instanceof SetLocalTypeIns || def instanceof GetLocalTypeIns) {
                super.removeObfuscationIfs(classIndex, isStatic, scriptIndex, abc, body, Arrays.asList(assignment));
            }
            if (def instanceof GetLocalTypeIns) {
                ignoredRegGets.add(setReg);
            }
            listedRegs.add(setReg);
            listedLastBodies.add(bodybefore);
        }
        body.getCode().removeDeadCode(body);
        originalBody.exceptions = body.exceptions;
        originalBody.setCode(body.getCode());
    }

    private int getFirstRegisterSetter(Reference<AVM2Instruction> assignment, int classIndex, boolean isStatic, int scriptIndex, ABC abc, MethodBody body, Set<Integer> ignoredRegisters, Set<Integer> ignoredGets) throws InterruptedException {
        AVM2Code code = body.getCode();
        if (code.code.isEmpty()) {
            return -1;
        }
        HashSet<Integer> visited = new HashSet<Integer>();
        return this.visitCode(assignment, visited, new TranslateStack("deo"), classIndex, isStatic, body, scriptIndex, abc, code, 0, code.code.size() - 1, ignoredRegisters, ignoredGets);
    }

    private int visitCode(Reference<AVM2Instruction> assignment, Set<Integer> visited, TranslateStack stack, int classIndex, boolean isStatic, MethodBody body, int scriptIndex, ABC abc, final AVM2Code code, int idx, int endIdx, Set<Integer> ignored, Set<Integer> ignoredGets) throws InterruptedException {
        HashMap exceptionStartToTargets = new HashMap();
        for (ABCException ex : body.exceptions) {
            int startIp = code.adr2pos(ex.start, true);
            int targetIp = code.adr2pos(ex.target);
            if (!exceptionStartToTargets.containsKey(startIp)) {
                exceptionStartToTargets.put(startIp, new ArrayList());
            }
            ((List)exceptionStartToTargets.get(startIp)).add(new ExceptionTargetIpPair(ex, targetIp));
        }
        ArrayList<GraphTargetItem> output = new ArrayList<GraphTargetItem>();
        AVM2LocalData localData = this.newLocalData(scriptIndex, abc, abc.constants, body, isStatic, classIndex);
        this.initLocalRegs(localData, body.getLocalReservedCount(), body.max_regs);
        localData.localRegs.put(0, new NullAVM2Item(null, null));
        ArrayList<Integer> toVisit = new ArrayList<Integer>();
        toVisit.add(idx);
        ArrayList<TranslateStack> toVisitStacks = new ArrayList<TranslateStack>();
        toVisitStacks.add(stack);
        block1: while (!toVisit.isEmpty()) {
            if (CancellableWorker.isInterrupted()) {
                throw new InterruptedException();
            }
            idx = (Integer)toVisit.remove(0);
            stack = (TranslateStack)toVisitStacks.remove(0);
            while (idx <= endIdx && !visited.contains(idx)) {
                long address;
                visited.add(idx);
                if (exceptionStartToTargets.containsKey(idx)) {
                    for (ExceptionTargetIpPair pair : (List)exceptionStartToTargets.get(idx)) {
                        toVisit.add(pair.targetIp);
                        TranslateStack targetStack = (TranslateStack)stack.clone();
                        targetStack.push(new ExceptionAVM2Item(pair.exception));
                        toVisitStacks.add(targetStack);
                    }
                }
                AVM2Instruction ins = code.code.get(idx);
                InstructionDefinition def = ins.definition;
                int requiredStackSize = ins.getStackPopCount(localData);
                if (stack.size() < requiredStackSize) continue block1;
                stack.setConnectedOutput(0, output, localData);
                ins.translate(localData, stack, output, 0, "");
                if (def instanceof SetLocalTypeIns) {
                    int regId = ((SetLocalTypeIns)def).getRegisterId(ins);
                    if (!ignored.contains(regId)) {
                        assignment.setVal(ins);
                        return regId;
                    }
                } else if (def instanceof GetLocalTypeIns) {
                    int regId = ((GetLocalTypeIns)def).getRegisterId(ins);
                    if (!ignored.contains(regId) && !ignoredGets.contains(regId)) {
                        assignment.setVal(ins);
                        return regId;
                    }
                } else if (!(def instanceof KillIns) && !(def instanceof DebugIns)) {
                    for (int p = 0; p < ins.definition.operands.length; ++p) {
                        int regId;
                        int op = ins.definition.operands[p];
                        if (op != 264 || ignored.contains(regId = ins.operands[p])) continue;
                        assignment.setVal(ins);
                        return regId;
                    }
                }
                ++idx;
                if (ins.definition instanceof JumpIns && (idx = code.adr2pos(address = ins.getTargetAddress())) == -1) {
                    throw new TranslateException("Jump target not found: " + address);
                }
                if (ins.isBranch()) {
                    List<Integer> branches = ins.getBranches(new GraphSource(this){
                        final /* synthetic */ AVM2DeobfuscatorRegistersOld this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public int size() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public GraphSourceItem get(int pos) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public boolean isEmpty() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void translatePart(List<GraphTargetItem> output, Graph graph, GraphPart part, BaseLocalData localData, TranslateStack stack, int start, int end, int staticOperation, String path) throws InterruptedException {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public int adr2pos(long adr) {
                            return code.adr2pos(adr);
                        }

                        @Override
                        public int adr2pos(long adr, boolean nearest) {
                            return code.adr2pos(adr, nearest);
                        }

                        @Override
                        public long pos2adr(int pos) {
                            return code.pos2adr(pos);
                        }

                        @Override
                        public Set<Long> getImportantAddresses() {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public String insToString(int pos) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                    });
                    idx = branches.get(0);
                    for (int n = 1; n < branches.size(); ++n) {
                        int nidx = branches.get(n);
                        if (visited.contains(nidx)) continue;
                        toVisit.add(nidx);
                        toVisitStacks.add((TranslateStack)stack.clone());
                    }
                }
                if (!(ins.definition instanceof ReturnValueIns) && !(ins.definition instanceof ThrowIns) && !(ins.definition instanceof ReturnVoidIns)) continue;
                continue block1;
            }
        }
        return -1;
    }

    private class ExceptionTargetIpPair {
        private final ABCException exception;
        private final int targetIp;

        public ExceptionTargetIpPair(ABCException exception, int targetIp) {
            this.exception = exception;
            this.targetIp = targetIp;
        }

        public ABCException getException() {
            return this.exception;
        }

        public int getTargetIp() {
            return this.targetIp;
        }
    }
}

