/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.fastavm2;

import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AVM2InstructionItem {
    public AVM2Instruction ins;
    public AVM2InstructionItem prev;
    public AVM2InstructionItem next;
    private AVM2InstructionItem jumpTarget;
    public Set<AVM2InstructionItem> jumpsHere;
    public Set<AVM2InstructionItem> lastInsOf;
    private List<AVM2InstructionItem> containerLastInstructions;
    int reachable;
    public boolean excluded;

    public AVM2InstructionItem(AVM2Instruction ins) {
        this.ins = ins;
    }

    public boolean isJumpTarget() {
        return this.jumpsHere != null && !this.jumpsHere.isEmpty();
    }

    public int jumpsHereSize() {
        return this.jumpsHere == null ? 0 : this.jumpsHere.size();
    }

    public boolean isContainerLastInstruction() {
        return this.lastInsOf != null && !this.lastInsOf.isEmpty();
    }

    public void removeJumpTarget() {
        if (this.jumpTarget == null) {
            return;
        }
        if (this.jumpTarget.jumpsHere != null) {
            this.jumpTarget.jumpsHere.remove(this);
        }
        this.jumpTarget = null;
    }

    public AVM2InstructionItem getJumpTarget() {
        return this.jumpTarget;
    }

    public AVM2Instruction getJumpTargetInstruction() {
        return this.jumpTarget == null ? null : this.jumpTarget.ins;
    }

    public void setJumpTarget(AVM2InstructionItem item) {
        this.removeJumpTarget();
        if (item == null) {
            return;
        }
        if (item.jumpsHere == null) {
            item.jumpsHere = new HashSet<AVM2InstructionItem>();
        }
        item.jumpsHere.add(this);
        this.jumpTarget = item;
    }

    public List<AVM2InstructionItem> getContainerLastInstructions() {
        return this.containerLastInstructions;
    }

    public void removeContainerLastInstructions() {
        if (this.containerLastInstructions == null) {
            return;
        }
        for (AVM2InstructionItem lastIns : this.containerLastInstructions) {
            if (lastIns.lastInsOf == null) continue;
            lastIns.lastInsOf.remove(this);
        }
        this.containerLastInstructions = null;
    }

    public void replaceContainerLastInstruction(AVM2InstructionItem oldItem, AVM2InstructionItem newItem) {
        if (this.containerLastInstructions == null) {
            return;
        }
        for (int i = 0; i < this.containerLastInstructions.size(); ++i) {
            if (this.containerLastInstructions.get(i) != oldItem) continue;
            this.containerLastInstructions.set(i, newItem);
            if (oldItem.lastInsOf != null) {
                oldItem.lastInsOf.remove(this);
            }
            newItem.ensureLastInstructionOf().add(this);
        }
    }

    public void setContainerLastInstructions(List<AVM2InstructionItem> lastInstructions) {
        this.removeContainerLastInstructions();
        for (AVM2InstructionItem lastIns : lastInstructions) {
            lastIns.ensureLastInstructionOf().add(this);
        }
        this.containerLastInstructions = lastInstructions;
    }

    private Set<AVM2InstructionItem> ensureLastInstructionOf() {
        if (this.lastInsOf == null) {
            this.lastInsOf = new HashSet<AVM2InstructionItem>();
        }
        return this.lastInsOf;
    }

    public boolean isExcluded() {
        return this.excluded;
    }
}

