/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2VerifyErrorException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.SetTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.SetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConstructAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GlobalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitVectorAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitWithSlot;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.DuplicateSourceItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import com.jpexs.decompiler.graph.model.TemporaryItem;
import com.jpexs.helpers.LinkedIdentityHashSet;
import com.jpexs.helpers.Reference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InstructionDefinition
implements Serializable {
    public static final long serialVersionUID = 1L;
    public int[] operands;
    public String instructionName = "";
    public int instructionCode = 0;
    public boolean canThrow;
    public AVM2InstructionFlag[] flags;

    public InstructionDefinition(int instructionCode, String instructionName, int[] operands, boolean canThrow, AVM2InstructionFlag ... flags) {
        this.instructionCode = instructionCode;
        this.instructionName = instructionName;
        this.operands = operands;
        this.canThrow = canThrow;
        this.flags = flags;
    }

    public boolean hasFlag(AVM2InstructionFlag flag) {
        for (AVM2InstructionFlag f : this.flags) {
            if (f != flag) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.instructionName);
        for (int i = 0; i < this.operands.length; ++i) {
            s.append(AVM2Code.operandTypeToString(this.operands[i], true));
        }
        return s.toString();
    }

    public void verify(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2VerifyErrorException {
        for (int i = 0; i < this.operands.length; ++i) {
            int idx;
            int operand = this.operands[i];
            if (operand == 257) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getMultinameCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getMultinameCount()});
            }
            if (operand == 272) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getDoubleCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getDoubleCount()});
            }
            if (operand == 270) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getIntCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getIntCount()});
            }
            if (operand == 271) {
                idx = ins.operands[i];
                if (idx > 0 && idx < constants.getUIntCount()) continue;
                throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getUIntCount()});
            }
            if (!(operand == 260 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getStringCount() : (operand == 279 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getNamespaceCount() : (operand == 277 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getFloatCount() : (operand == 278 ? (idx = ins.operands[i]) <= 0 || idx >= constants.getFloat4Count() : operand == 273 && ((idx = ins.operands[i]) <= 0 || idx >= constants.getDecimalCount())))))) continue;
            throw new AVM2VerifyErrorException(1032, lda.isDebug(), new Object[]{idx, constants.getStringCount()});
        }
    }

    public boolean isNotCompileTimeSupported() {
        return false;
    }

    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2ExecutionException {
        return false;
    }

    protected void illegalOpCode(LocalDataArea lda, AVM2Instruction ins) throws AVM2VerifyErrorException {
        throw new AVM2VerifyErrorException(1011, lda.isDebug(), new Object[]{lda.methodName, this.instructionCode, ins.getAddress()});
    }

    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) throws InterruptedException {
    }

    public void translate(Reference<Integer> maxTempIndex, Set<String> usedDeobfuscations, int swfVersion, Set<GraphPart> switchParts, List<MethodBody> callStack, AbcIndexing abcIndex, Map<Integer, Set<Integer>> setLocalPosToGetLocalPos, Reference<GraphSourceItem> lineStartItem, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, TranslateStack stack, ScopeStack scopeStack, ScopeStack localScopeStack, AVM2Instruction ins, List<GraphTargetItem> output, MethodBody body, ABC abc, HashMap<Integer, String> localRegNames, HashMap<Integer, GraphTargetItem> localRegTypes, List<DottedChain> fullyQualifiedNames, String path, HashMap<Integer, Integer> localRegsAssignmentIps, int ip, AVM2Code code, boolean thisHasDefaultToPrimitive, LinkedIdentityHashSet<SetLocalAVM2Item> bottomSetLocals) throws InterruptedException {
        AVM2LocalData localData = new AVM2LocalData();
        localData.allSwitchParts = switchParts;
        localData.isStatic = isStatic;
        localData.scriptIndex = scriptIndex;
        localData.classIndex = classIndex;
        localData.lineStartInstruction = lineStartItem.getVal();
        localData.localRegs = localRegs;
        localData.scopeStack = scopeStack;
        localData.localScopeStack = localScopeStack;
        localData.methodBody = body;
        localData.callStack = callStack;
        localData.abc = abc;
        localData.abcIndex = abcIndex;
        localData.localRegNames = localRegNames;
        localData.localRegTypes = localRegTypes;
        localData.fullyQualifiedNames = fullyQualifiedNames;
        localData.localRegAssignmentIps = localRegsAssignmentIps;
        localData.ip = ip;
        localData.code = code;
        localData.thisHasDefaultToPrimitive = thisHasDefaultToPrimitive;
        localData.setLocalPosToGetLocalPos = setLocalPosToGetLocalPos;
        localData.bottomSetLocals = bottomSetLocals;
        localData.swfVersion = swfVersion;
        localData.usedDeobfuscations = usedDeobfuscations;
        localData.maxTempIndex = maxTempIndex;
        this.translate(localData, stack, ins, output, path);
        lineStartItem.setVal(localData.lineStartInstruction);
    }

    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    protected void resolveMultiname(LocalDataArea localData, AVM2ConstantPool constants, int multinameIndex) {
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            Object object;
            Multiname multiname = constants.getMultiname(multinameIndex);
            if (multiname.needsName()) {
                object = localData.operandStack.pop();
            }
            if (multiname.needsNs()) {
                object = localData.operandStack.pop();
            }
        }
    }

    protected FullMultinameAVM2Item resolveMultiname(AVM2LocalData localData, boolean property, TranslateStack stack, AVM2ConstantPool constants, int multinameIndex, AVM2Instruction ins, List<GraphTargetItem> output) {
        stack.allowSwap(output);
        GraphTargetItem ns = null;
        GraphTargetItem name = null;
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            Multiname multiname = constants.getMultiname(multinameIndex);
            if (multiname.needsName()) {
                name = stack.pop();
            }
            if (multiname.needsNs()) {
                ns = stack.pop();
            }
        }
        return new FullMultinameAVM2Item(property, ins, localData.lineStartInstruction, multinameIndex, localData.abc.constants.getMultiname(multinameIndex).getName(localData.usedDeobfuscations, localData.abc, localData.getConstants(), new ArrayList<DottedChain>(), true, true), name, ns);
    }

    protected int getMultinameRequiredStackSize(AVM2ConstantPool constants, int multinameIndex) {
        int res = 0;
        if (multinameIndex > 0 && multinameIndex < constants.getMultinameCount()) {
            if (constants.getMultiname(multinameIndex).needsName()) {
                ++res;
            }
            if (constants.getMultiname(multinameIndex).needsNs()) {
                ++res;
            }
        }
        return res;
    }

    public int getStackDelta(AVM2Instruction ins, ABC abc) {
        return this.getStackPushCount(ins, abc) - this.getStackPopCount(ins, abc);
    }

    public int getScopeStackDelta(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    public boolean isExitInstruction() {
        return false;
    }

    public static int getItemIp(AVM2LocalData localData, GraphTargetItem item) {
        GraphSourceItem src = item.getSrc();
        if (src == null) {
            return -1;
        }
        return localData.code.adr2pos(src.getAddress());
    }

    protected static Multiname searchSlotName(int slotIndex, AVM2LocalData localData, GraphTargetItem obj, Reference<GraphTargetItem> realObj) {
        return InstructionDefinition.searchSlotName(slotIndex, localData, obj, -1, realObj);
    }

    private static Multiname searchSlotName(int slotIndex, AVM2LocalData localData, GraphTargetItem obj, int multiNameIndex, Reference<GraphTargetItem> realObj) {
        if (obj instanceof CommaExpressionItem) {
            CommaExpressionItem ce = (CommaExpressionItem)obj;
            if (!ce.commands.isEmpty()) {
                obj = ce.commands.get(ce.commands.size() - 1);
            }
        }
        if (obj instanceof ExceptionAVM2Item && (multiNameIndex == -1 || ((ExceptionAVM2Item)obj).exception.name_index == multiNameIndex)) {
            return localData.getConstants().getMultiname(((ExceptionAVM2Item)obj).exception.name_index);
        }
        if (obj instanceof FindPropertyAVM2Item) {
            FindPropertyAVM2Item findProp = (FindPropertyAVM2Item)obj;
            for (GraphTargetItem item : localData.localScopeStack) {
                Multiname ret = InstructionDefinition.searchSlotName(slotIndex, localData, item, ((FullMultinameAVM2Item)findProp.propertyName).multinameIndex, realObj);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
        Traits traits = null;
        if (obj instanceof NewActivationAVM2Item) {
            traits = localData.methodBody.traits;
        } else if (obj instanceof ThisAVM2Item && localData.classIndex > -1) {
            traits = localData.abc.instance_info.get((int)localData.classIndex.intValue()).instance_traits;
        } else if (obj instanceof ClassAVM2Item && localData.classIndex > -1) {
            traits = localData.abc.class_info.get((int)localData.classIndex.intValue()).static_traits;
        } else if (obj instanceof GlobalAVM2Item) {
            traits = localData.abc.script_info.get((int)localData.scriptIndex.intValue()).traits;
        }
        if (traits != null) {
            for (int t = 0; t < traits.traits.size(); ++t) {
                Trait trait = traits.traits.get(t);
                if (!(trait instanceof TraitWithSlot) || multiNameIndex != -1 && trait.name_index != multiNameIndex || ((TraitWithSlot)((Object)trait)).getSlotIndex() != slotIndex) continue;
                realObj.setVal(obj);
                return trait.getName(localData.abc);
            }
        }
        return null;
    }

    public void handleSetProperty(boolean init, AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        FullMultinameAVM2Item fm;
        FullMultinameAVM2Item fm2;
        GetLexAVM2Item getLex;
        boolean ok;
        SetTemporaryItem st;
        GetPropertyAVM2Item getProp;
        SetTemporaryItem st2;
        DuplicateItem d;
        GetPropertyAVM2Item getProp2;
        boolean isIncrement;
        stack.allowSwap(output);
        int multinameIndex = ins.operands[0];
        GraphTargetItem value = stack.pop();
        FullMultinameAVM2Item multiname = this.resolveMultiname(localData, true, stack, localData.getConstants(), multinameIndex, ins, output);
        GraphTargetItem obj = stack.pop();
        if (value instanceof IncrementAVM2Item || value instanceof DecrementAVM2Item) {
            isIncrement = value instanceof IncrementAVM2Item;
            if (value.value instanceof GetPropertyAVM2Item) {
                getProp2 = (GetPropertyAVM2Item)value.value;
                if (getProp2.object instanceof DuplicateItem && obj instanceof DuplicateSourceItem && getProp2.object.getThroughDuplicate() == obj.getThroughDuplicate()) {
                    d = (DuplicateItem)getProp2.object;
                    if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem) {
                        st2 = (SetTemporaryItem)output.get(output.size() - 1);
                        if (st2.tempIndex == d.tempIndex) {
                            output.remove(output.size() - 1);
                            getProp2.object = st2.value;
                            if (isIncrement) {
                                stack.addToOutput(new PreIncrementAVM2Item(value.getSrc(), value.lineStartItem, getProp2));
                            } else {
                                stack.addToOutput(new PreDecrementAVM2Item(value.getSrc(), value.lineStartItem, getProp2));
                            }
                            return;
                        }
                    }
                }
            }
        }
        if (value instanceof IncrementAVM2Item || value instanceof DecrementAVM2Item) {
            isIncrement = value instanceof IncrementAVM2Item;
            if (value.value instanceof ConvertAVM2Item && value.value.value instanceof GetPropertyAVM2Item) {
                getProp2 = (GetPropertyAVM2Item)value.value.value;
                if (getProp2.object instanceof DuplicateItem && obj instanceof DuplicateSourceItem && getProp2.object.getThroughDuplicate() == obj.getThroughDuplicate()) {
                    d = (DuplicateItem)getProp2.object;
                    if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem) {
                        st2 = (SetTemporaryItem)output.get(output.size() - 1);
                        if (st2.tempIndex == d.tempIndex) {
                            output.remove(output.size() - 1);
                            getProp2.object = st2.value;
                            if (isIncrement) {
                                stack.addToOutput(new PostIncrementAVM2Item(value.getSrc(), value.lineStartItem, getProp2));
                            } else {
                                stack.addToOutput(new PostDecrementAVM2Item(value.getSrc(), value.lineStartItem, getProp2));
                            }
                            return;
                        }
                    }
                }
            }
        }
        if (value instanceof LocalRegAVM2Item) {
            LocalRegAVM2Item valueLocalReg = (LocalRegAVM2Item)value;
            LocalRegAVM2Item nameLocalReg = null;
            if (multiname.name instanceof LocalRegAVM2Item) {
                nameLocalReg = (LocalRegAVM2Item)multiname.name;
            }
            if (obj instanceof LocalRegAVM2Item) {
                FullMultinameAVM2Item fm3;
                SetLocalAVM2Item setLocObj;
                GetPropertyAVM2Item getProp3;
                SetTemporaryItem st3;
                DuplicateSourceItem ds;
                DuplicateItem d2;
                SetLocalAVM2Item setLocName;
                FullMultinameAVM2Item fm4;
                SetLocalAVM2Item setLocObj2;
                boolean isIncrement2;
                SetLocalAVM2Item setLocValue;
                LocalRegAVM2Item objLocalReg = (LocalRegAVM2Item)obj;
                if (!stack.isEmpty() && stack.peek() instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)stack.peek();
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof GetPropertyAVM2Item) {
                            getProp = (GetPropertyAVM2Item)setLocValue.value.value;
                            if (getProp.object instanceof SetLocalAVM2Item) {
                                setLocObj2 = (SetLocalAVM2Item)getProp.object;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item) {
                                    fm4 = (FullMultinameAVM2Item)getProp.propertyName;
                                    if (fm4.name instanceof SetLocalAVM2Item) {
                                        setLocName = (SetLocalAVM2Item)fm4.name;
                                        if (valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj2.regIndex && nameLocalReg.regIndex == setLocName.regIndex) {
                                            getProp.object = setLocObj2.value;
                                            fm4.name = setLocName.value;
                                            stack.pop();
                                            if (isIncrement2) {
                                                stack.push(new PreIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            } else {
                                                stack.push(new PreDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof GetPropertyAVM2Item) {
                            getProp = (GetPropertyAVM2Item)setLocValue.value.value;
                            if (getProp.object instanceof SetLocalAVM2Item) {
                                setLocObj2 = (SetLocalAVM2Item)getProp.object;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item) {
                                    fm4 = (FullMultinameAVM2Item)getProp.propertyName;
                                    if (fm4.name instanceof SetLocalAVM2Item) {
                                        setLocName = (SetLocalAVM2Item)fm4.name;
                                        if (valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj2.regIndex && nameLocalReg.regIndex == setLocName.regIndex) {
                                            getProp.object = setLocObj2.value;
                                            fm4.name = setLocName.value;
                                            output.remove(output.size() - 1);
                                            if (isIncrement2) {
                                                stack.addToOutput(new PreIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            } else {
                                                stack.addToOutput(new PreDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof DuplicateItem) {
                            d2 = (DuplicateItem)setLocValue.value.value;
                            if (output.size() >= 2 && output.get(output.size() - 2) instanceof PushItem && output.get((int)(output.size() - 2)).value instanceof DuplicateSourceItem) {
                                ds = (DuplicateSourceItem)output.get((int)(output.size() - 2)).value;
                                if (ds.tempIndex == d2.tempIndex && output.size() >= 3 && output.get(output.size() - 3) instanceof SetTemporaryItem) {
                                    st3 = (SetTemporaryItem)output.get(output.size() - 3);
                                    if (st3.tempIndex == d2.tempIndex && st3.value instanceof ConvertAVM2Item && st3.value.value instanceof GetPropertyAVM2Item) {
                                        getProp3 = (GetPropertyAVM2Item)st3.value.value;
                                        if (getProp3.object instanceof SetLocalAVM2Item) {
                                            setLocObj = (SetLocalAVM2Item)getProp3.object;
                                            if (getProp3.propertyName instanceof FullMultinameAVM2Item) {
                                                fm3 = (FullMultinameAVM2Item)getProp3.propertyName;
                                                if (fm3.name instanceof SetLocalAVM2Item) {
                                                    SetLocalAVM2Item setLocName2 = (SetLocalAVM2Item)fm3.name;
                                                    if (valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj.regIndex && nameLocalReg.regIndex == setLocName2.regIndex) {
                                                        getProp3.object = setLocObj.value;
                                                        fm3.name = setLocName2.value;
                                                        output.remove(output.size() - 1);
                                                        output.remove(output.size() - 1);
                                                        output.remove(output.size() - 1);
                                                        stack.moveToStack(output);
                                                        if (isIncrement2) {
                                                            stack.push(new PostIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                        } else {
                                                            stack.push(new PostDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                        }
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof ConvertAVM2Item && setLocValue.value.value.value instanceof GetPropertyAVM2Item) {
                            getProp = (GetPropertyAVM2Item)setLocValue.value.value.value;
                            if (getProp.object instanceof SetLocalAVM2Item) {
                                setLocObj2 = (SetLocalAVM2Item)getProp.object;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item) {
                                    fm4 = (FullMultinameAVM2Item)getProp.propertyName;
                                    if (fm4.name instanceof SetLocalAVM2Item) {
                                        setLocName = (SetLocalAVM2Item)fm4.name;
                                        if (valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj2.regIndex && nameLocalReg.regIndex == setLocName.regIndex) {
                                            getProp.object = setLocObj2.value;
                                            fm4.name = setLocName.value;
                                            output.remove(output.size() - 1);
                                            stack.moveToStack(output);
                                            if (isIncrement2) {
                                                stack.addToOutput(new PostIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            } else {
                                                stack.addToOutput(new PostDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!stack.isEmpty() && stack.peek() instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)stack.peek();
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof GetPropertyAVM2Item) {
                            getProp = (GetPropertyAVM2Item)setLocValue.value.value;
                            if (getProp.object instanceof SetLocalAVM2Item) {
                                setLocObj2 = (SetLocalAVM2Item)getProp.object;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item && (fm4 = (FullMultinameAVM2Item)getProp.propertyName).compareSame(multiname) && valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj2.regIndex) {
                                    getProp.object = setLocObj2.value;
                                    stack.pop();
                                    if (isIncrement2) {
                                        stack.push(new PreIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                    } else {
                                        stack.push(new PreDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof GetPropertyAVM2Item) {
                            getProp = (GetPropertyAVM2Item)setLocValue.value.value;
                            if (getProp.object instanceof SetLocalAVM2Item) {
                                setLocObj2 = (SetLocalAVM2Item)getProp.object;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item && (fm4 = (FullMultinameAVM2Item)getProp.propertyName).compareSame(multiname) && valueLocalReg.regIndex == setLocValue.regIndex && objLocalReg.regIndex == setLocObj2.regIndex) {
                                    getProp.object = setLocObj2.value;
                                    output.remove(output.size() - 1);
                                    stack.moveToStack(output);
                                    if (isIncrement2) {
                                        stack.addToOutput(new PreIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                    } else {
                                        stack.addToOutput(new PreDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp));
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof DuplicateItem) {
                            d2 = (DuplicateItem)setLocValue.value.value;
                            if (output.size() >= 2 && output.get(output.size() - 2) instanceof PushItem && output.get((int)(output.size() - 2)).value instanceof DuplicateSourceItem) {
                                ds = (DuplicateSourceItem)output.get((int)(output.size() - 2)).value;
                                if (ds.tempIndex == d2.tempIndex && output.size() >= 3 && output.get(output.size() - 3) instanceof SetTemporaryItem) {
                                    st3 = (SetTemporaryItem)output.get(output.size() - 3);
                                    if (st3.tempIndex == d2.tempIndex && st3.value instanceof ConvertAVM2Item && st3.value.value instanceof GetPropertyAVM2Item) {
                                        getProp3 = (GetPropertyAVM2Item)st3.value.value;
                                        if (getProp3.object instanceof SetLocalAVM2Item) {
                                            setLocObj = (SetLocalAVM2Item)getProp3.object;
                                            if (getProp3.propertyName instanceof FullMultinameAVM2Item && (fm3 = (FullMultinameAVM2Item)getProp3.propertyName).compareSame(multiname) && objLocalReg.regIndex == setLocObj.regIndex && valueLocalReg.regIndex == setLocValue.regIndex) {
                                                getProp3.object = setLocObj.value;
                                                output.remove(output.size() - 1);
                                                output.remove(output.size() - 1);
                                                output.remove(output.size() - 1);
                                                stack.moveToStack(output);
                                                if (isIncrement2) {
                                                    stack.push(new PostIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                } else {
                                                    stack.push(new PostDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    setLocValue = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocValue.value instanceof IncrementAVM2Item || setLocValue.value instanceof DecrementAVM2Item) {
                        isIncrement2 = setLocValue.value instanceof IncrementAVM2Item;
                        if (setLocValue.value.value instanceof DuplicateItem) {
                            d2 = (DuplicateItem)setLocValue.value.value;
                            if (output.size() >= 2 && output.get(output.size() - 2) instanceof PushItem && output.get((int)(output.size() - 2)).value instanceof DuplicateSourceItem) {
                                ds = (DuplicateSourceItem)output.get((int)(output.size() - 2)).value;
                                if (ds.tempIndex == d2.tempIndex && output.size() >= 3 && output.get(output.size() - 3) instanceof SetTemporaryItem) {
                                    st3 = (SetTemporaryItem)output.get(output.size() - 3);
                                    if (st3.tempIndex == d2.tempIndex && st3.value instanceof GetPropertyAVM2Item) {
                                        getProp3 = (GetPropertyAVM2Item)st3.value;
                                        if (getProp3.object instanceof SetLocalAVM2Item) {
                                            setLocObj = (SetLocalAVM2Item)getProp3.object;
                                            if (getProp3.propertyName instanceof FullMultinameAVM2Item && (fm3 = (FullMultinameAVM2Item)getProp3.propertyName).compareSame(multiname) && objLocalReg.regIndex == setLocObj.regIndex && valueLocalReg.regIndex == setLocValue.regIndex) {
                                                getProp3.object = setLocObj.value;
                                                output.remove(output.size() - 1);
                                                output.remove(output.size() - 1);
                                                output.remove(output.size() - 1);
                                                stack.moveToStack(output);
                                                if (isIncrement2) {
                                                    stack.push(new PostIncrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                } else {
                                                    stack.push(new PostDecrementAVM2Item(setLocValue.value.getSrc(), setLocValue.value.getLineStartItem(), getProp3));
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (value instanceof DuplicateItem && !stack.isEmpty() && stack.peek() instanceof DuplicateSourceItem) {
            DuplicateItem d3 = (DuplicateItem)value;
            DuplicateSourceItem ds = (DuplicateSourceItem)stack.peek();
            if (d3.tempIndex == ds.tempIndex && !output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem) {
                st = (SetTemporaryItem)output.get(output.size() - 1);
                if (st.tempIndex == d3.tempIndex && (st.value instanceof IncrementAVM2Item || st.value instanceof DecrementAVM2Item)) {
                    boolean isIncrement3 = st.value instanceof IncrementAVM2Item;
                    ok = false;
                    if (st.value.value instanceof GetLexAVM2Item) {
                        getLex = (GetLexAVM2Item)st.value.value;
                        if (localData.abc.constants.getMultiname(multinameIndex).equals(getLex.propertyName)) {
                            ok = true;
                        }
                    } else if (st.value.value instanceof GetPropertyAVM2Item) {
                        getProp = (GetPropertyAVM2Item)st.value.value;
                        if (getProp.propertyName instanceof FullMultinameAVM2Item && (fm2 = (FullMultinameAVM2Item)getProp.propertyName).compareSame(multiname)) {
                            ok = true;
                        }
                    }
                    if (ok) {
                        output.remove(output.size() - 1);
                        stack.pop();
                        stack.moveToStack(output);
                        if (isIncrement3) {
                            stack.push(new PreIncrementAVM2Item(st.value.getSrc(), st.value.getLineStartItem(), st.value.value));
                        } else {
                            stack.push(new PreDecrementAVM2Item(st.value.getSrc(), st.value.getLineStartItem(), st.value.value));
                        }
                        return;
                    }
                }
            }
        }
        if (value instanceof IncrementAVM2Item || value instanceof DecrementAVM2Item) {
            boolean isIncrement4 = value instanceof IncrementAVM2Item;
            if (value.value instanceof GetPropertyAVM2Item) {
                getProp2 = (GetPropertyAVM2Item)value.value;
                if (getProp2.propertyName instanceof FullMultinameAVM2Item && (fm = (FullMultinameAVM2Item)getProp2.propertyName).compareSame(multiname)) {
                    if (isIncrement4) {
                        stack.addToOutput(new PreIncrementAVM2Item(value.getSrc(), value.getLineStartItem(), getProp2));
                    } else {
                        stack.addToOutput(new PreDecrementAVM2Item(value.getSrc(), value.getLineStartItem(), getProp2));
                    }
                    return;
                }
            }
        }
        if (value instanceof IncrementAVM2Item || value instanceof DecrementAVM2Item) {
            boolean isIncrement5 = value instanceof IncrementAVM2Item;
            if (value.value instanceof DuplicateItem) {
                DuplicateItem d4 = (DuplicateItem)value.value;
                if (!output.isEmpty() && output.get(output.size() - 1) instanceof PushItem && output.get((int)(output.size() - 1)).value instanceof DuplicateSourceItem) {
                    DuplicateSourceItem ds = (DuplicateSourceItem)output.get((int)(output.size() - 1)).value;
                    if (d4.tempIndex == ds.tempIndex && output.size() >= 2 && output.get(output.size() - 2) instanceof SetTemporaryItem) {
                        SetTemporaryItem st4 = (SetTemporaryItem)output.get(output.size() - 2);
                        if (st4.tempIndex == d4.tempIndex && st4.value instanceof ConvertAVM2Item) {
                            ok = false;
                            if (st4.value.value instanceof GetLexAVM2Item) {
                                getLex = (GetLexAVM2Item)st4.value.value;
                                if (localData.abc.constants.getMultiname(multinameIndex).equals(getLex.propertyName)) {
                                    ok = true;
                                }
                            } else if (st4.value.value instanceof GetPropertyAVM2Item) {
                                getProp = (GetPropertyAVM2Item)st4.value.value;
                                if (getProp.propertyName instanceof FullMultinameAVM2Item && (fm2 = (FullMultinameAVM2Item)getProp.propertyName).compareSame(multiname)) {
                                    ok = true;
                                }
                            }
                            if (ok) {
                                output.remove(output.size() - 1);
                                output.remove(output.size() - 1);
                                stack.moveToStack(output);
                                if (isIncrement5) {
                                    stack.push(new PostIncrementAVM2Item(value.getSrc(), value.getLineStartItem(), st4.value.value));
                                } else {
                                    stack.push(new PostDecrementAVM2Item(value.getSrc(), value.getLineStartItem(), st4.value.value));
                                }
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (value instanceof IncrementAVM2Item || value instanceof DecrementAVM2Item) {
            boolean isIncrement6 = value instanceof IncrementAVM2Item;
            if (value.value instanceof ConvertAVM2Item && value.value.value instanceof GetPropertyAVM2Item) {
                getProp2 = (GetPropertyAVM2Item)value.value.value;
                if (getProp2.propertyName instanceof FullMultinameAVM2Item && (fm = (FullMultinameAVM2Item)getProp2.propertyName).compareSame(multiname)) {
                    if (isIncrement6) {
                        stack.addToOutput(new PostIncrementAVM2Item(value.getSrc(), value.getLineStartItem(), getProp2));
                    } else {
                        stack.addToOutput(new PostDecrementAVM2Item(value.getSrc(), value.getLineStartItem(), getProp2));
                    }
                    return;
                }
            }
        }
        if (multiname.name instanceof CommaExpressionItem) {
            CommaExpressionItem ce = (CommaExpressionItem)multiname.name;
            if (ce.commands.size() == 2 && ce.commands.get(0) instanceof SetLocalAVM2Item && ce.commands.get(1) instanceof LocalRegAVM2Item) {
                GraphSourceItem src;
                SetLocalAVM2Item setLocal = (SetLocalAVM2Item)ce.commands.get(0);
                LocalRegAVM2Item localReg = (LocalRegAVM2Item)ce.commands.get(1);
                if (setLocal.regIndex == localReg.regIndex && (src = setLocal.getSrc()) != null && localData.getSetLocalUsages(localData.code.adr2pos(src.getAddress())).size() == 1) {
                    multiname.name = setLocal.value;
                }
            }
        }
        if (obj.getThroughDuplicate() instanceof ConstructAVM2Item) {
            ConstructAVM2Item c = (ConstructAVM2Item)obj.getThroughDuplicate();
            if (c.object instanceof ApplyTypeAVM2Item) {
                ApplyTypeAVM2Item at = (ApplyTypeAVM2Item)c.object;
                c.args.clear();
                ArrayList<GraphTargetItem> vals = new ArrayList<GraphTargetItem>();
                vals.add(value);
                c.object = new InitVectorAVM2Item((GraphSourceItem)c.getInstruction(), (GraphSourceItem)c.getLineStartIns(), at.params.get(0), vals);
                if (obj instanceof DuplicateItem && !stack.isEmpty() && stack.peek() instanceof DuplicateSourceItem && stack.peek().getThroughDuplicate() == obj.getThroughDuplicate()) {
                    if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem) {
                        SetTemporaryItem st5 = (SetTemporaryItem)output.get(output.size() - 1);
                        DuplicateSourceItem ds = (DuplicateSourceItem)stack.peek();
                        if (st5.tempIndex == ds.tempIndex) {
                            output.remove(output.size() - 1);
                            stack.moveToStack(output);
                        }
                    }
                    stack.push(stack.pop().value);
                }
                return;
            }
            if (c.object instanceof InitVectorAVM2Item) {
                InitVectorAVM2Item iv = (InitVectorAVM2Item)c.object;
                iv.arguments.add(value);
                if (obj instanceof DuplicateItem && !stack.isEmpty() && stack.peek() instanceof DuplicateSourceItem && stack.peek().getThroughDuplicate() == obj.getThroughDuplicate()) {
                    if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem) {
                        st = (SetTemporaryItem)output.get(output.size() - 1);
                        DuplicateSourceItem ds = (DuplicateSourceItem)stack.peek();
                        if (st.tempIndex == ds.tempIndex) {
                            output.remove(output.size() - 1);
                        }
                    }
                    stack.push(stack.pop().value);
                }
                return;
            }
        }
        if (obj instanceof TemporaryItem) {
            TemporaryItem temporaryItemObj = (TemporaryItem)obj;
            if (temporaryItemObj.value instanceof FindPropertyAVM2Item) {
                for (int i = output.size() - 1; i >= 0; --i) {
                    SetTemporaryItem setTemp;
                    if (!(output.get(i) instanceof SetTemporaryItem) || (setTemp = (SetTemporaryItem)output.get(i)).getTempIndex() != temporaryItemObj.getTempIndex()) continue;
                    output.remove(i);
                    obj = temporaryItemObj.value;
                    break;
                }
            }
        }
        Reference<Boolean> isStatic = new Reference<Boolean>(false);
        Reference<Object> type = new Reference<Object>(null);
        Reference<Object> callType = new Reference<Object>(null);
        GetPropertyIns.resolvePropertyType(localData, obj, multiname, isStatic, type, callType);
        AVM2Item result = init ? new InitPropertyAVM2Item(ins, localData.lineStartInstruction, obj, multiname, value, type.getVal(), callType.getVal(), isStatic.getVal()) : new SetPropertyAVM2Item(ins, localData.lineStartInstruction, obj, multiname, value, type.getVal(), callType.getVal(), isStatic.getVal());
        SetPropertyIns.handleCompound(localData, obj, multiname, value, output, stack, result);
        SetTypeIns.handleResult(value, stack, output, localData, result, -1, type.getVal());
    }

    private GraphTargetItem checkIncDec(boolean standalone, int multinameIndex, AVM2Instruction ins, AVM2LocalData localData, GraphTargetItem item, LocalRegAVM2Item valueLocalReg, LocalRegAVM2Item nameLocalReg, LocalRegAVM2Item objLocalReg) {
        if (item instanceof SetLocalAVM2Item) {
            SetLocalAVM2Item valueSetLocalReg = (SetLocalAVM2Item)item;
            if (valueSetLocalReg.value instanceof IncrementAVM2Item || valueSetLocalReg.value instanceof DecrementAVM2Item) {
                boolean isIncrement = valueSetLocalReg.value instanceof IncrementAVM2Item;
                boolean hasConvert = valueSetLocalReg.value.value instanceof ConvertAVM2Item;
                if (valueSetLocalReg.value.value.getNotCoercedNoDup() instanceof GetPropertyAVM2Item) {
                    GetPropertyAVM2Item getProperty = (GetPropertyAVM2Item)valueSetLocalReg.value.value.getNotCoercedNoDup();
                    FullMultinameAVM2Item propertyName = (FullMultinameAVM2Item)getProperty.propertyName;
                    SetLocalAVM2Item nameSetLocalReg = null;
                    if (propertyName.name instanceof SetLocalAVM2Item) {
                        nameSetLocalReg = (SetLocalAVM2Item)propertyName.name;
                    }
                    if (getProperty.object.getThroughDuplicate() instanceof SetLocalAVM2Item) {
                        SetLocalAVM2Item objSetLocalReg = (SetLocalAVM2Item)getProperty.object.getThroughDuplicate();
                        if (valueLocalReg.regIndex == valueSetLocalReg.regIndex && propertyName.multinameIndex == multinameIndex && (nameLocalReg == null && nameSetLocalReg == null || nameLocalReg != null && nameSetLocalReg != null && nameLocalReg.regIndex == nameSetLocalReg.regIndex) && objLocalReg.regIndex == objSetLocalReg.regIndex) {
                            if (nameSetLocalReg != null) {
                                propertyName.name = nameSetLocalReg.value;
                            }
                            getProperty.object = objSetLocalReg.value;
                            if (isIncrement) {
                                if (hasConvert && standalone) {
                                    return new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, getProperty);
                                }
                                return new PreIncrementAVM2Item(ins, localData.lineStartInstruction, getProperty);
                            }
                            if (hasConvert && standalone) {
                                return new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, getProperty);
                            }
                            return new PreDecrementAVM2Item(ins, localData.lineStartInstruction, getProperty);
                        }
                    }
                }
            }
        }
        return null;
    }
}

