/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.localregs;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.DuplicateSourceItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import java.util.List;

public abstract class GetLocalTypeIns
extends InstructionDefinition {
    public GetLocalTypeIns(int instructionCode, String instructionName, int[] operands, boolean canThrow) {
        super(instructionCode, instructionName, operands, canThrow, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        Object value = lda.localRegisters.get(this.getRegisterId(ins));
        lda.operandStack.push(value == null ? Undefined.INSTANCE : value);
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        DuplicateItem d;
        int regId = this.getRegisterId(ins);
        if (regId == 0) {
            if (localData.classIndex == -1) {
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, DottedChain.parseNoSuffix("global"), false, false));
                return;
            }
            if (localData.classIndex >= localData.getInstanceInfo().size()) {
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, DottedChain.OBJECT, false, false));
                return;
            }
            if (localData.isStatic.booleanValue()) {
                stack.push(new ClassAVM2Item(localData.getInstanceInfo().get(localData.classIndex).getName(localData.getConstants())));
            } else {
                List<Trait> ts = localData.getInstanceInfo().get((int)localData.classIndex.intValue()).instance_traits.traits;
                boolean isBasicObject = localData.thisHasDefaultToPrimitive;
                Multiname m = localData.getInstanceInfo().get(localData.classIndex).getName(localData.getConstants());
                stack.push(new ThisAVM2Item(ins, localData.lineStartInstruction, m.getNameWithNamespace(localData.usedDeobfuscations, localData.abc, localData.getConstants(), true), isBasicObject, false));
            }
            return;
        }
        GraphTargetItem computedValue = localData.localRegs.get(regId);
        int assignCount = 0;
        if (localData.localRegAssignmentIps.containsKey(regId)) {
            assignCount = localData.localRegAssignmentIps.get(regId);
        }
        if (assignCount > 5) {
            // empty if block
        }
        GraphTargetItem type = TypeItem.UNBOUNDED;
        if (localData.localRegTypes.containsKey(regId)) {
            type = localData.localRegTypes.get(regId);
        } else if (computedValue != null) {
            type = computedValue.returnType();
        }
        LocalRegAVM2Item result = new LocalRegAVM2Item(ins, localData.lineStartInstruction, regId, computedValue, type);
        stack.finishBlock(output);
        if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
            SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(output.size() - 1);
            if (setLocal.regIndex == regId && setLocal.getSrc() != null && localData.getSetLocalUsages(localData.code.adr2pos(setLocal.getSrc().getAddress())).size() == 1 && output.size() >= 2 && output.get(output.size() - 2) instanceof PushItem) {
                output.remove(output.size() - 1);
                stack.moveToStack(output);
                stack.push(setLocal.value);
                return;
            }
        }
        if (!output.isEmpty()) {
            GraphTargetItem lastOutput = output.get(output.size() - 1);
            if (lastOutput instanceof IncLocalAVM2Item) {
                IncLocalAVM2Item inc = (IncLocalAVM2Item)lastOutput;
                if (inc.regIndex == regId) {
                    output.remove(output.size() - 1);
                    stack.moveToStack(output);
                    stack.push(new PreIncrementAVM2Item(lastOutput.getSrc(), lastOutput.getLineStartItem(), result));
                    return;
                }
            }
            if (lastOutput instanceof DecLocalAVM2Item) {
                DecLocalAVM2Item dec = (DecLocalAVM2Item)lastOutput;
                if (dec.regIndex == regId) {
                    output.remove(output.size() - 1);
                    stack.moveToStack(output);
                    stack.push(new PreDecrementAVM2Item(lastOutput.getSrc(), lastOutput.getLineStartItem(), result));
                    return;
                }
            }
        }
        if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetPropertyAVM2Item) {
            SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)output.get(output.size() - 1);
            if (setProp.value instanceof IncrementAVM2Item || setProp.value instanceof DecrementAVM2Item) {
                boolean isIncrement = setProp.value instanceof IncrementAVM2Item;
                if (setProp.value.value instanceof SetLocalAVM2Item) {
                    AVM2Instruction src;
                    SetLocalAVM2Item setLoc = (SetLocalAVM2Item)setProp.value.value;
                    if (setLoc.regIndex == regId && setLoc.getSrc() instanceof AVM2Instruction && localData.getSetLocalUsages(localData.code.adr2pos((src = (AVM2Instruction)setLoc.getSrc()).getAddress())).size() == 1 && setLoc.value instanceof ConvertAVM2Item && setLoc.value.value instanceof GetPropertyAVM2Item) {
                        GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)setLoc.value.value;
                        if (setProp.object instanceof DuplicateSourceItem) {
                            DuplicateSourceItem ds = (DuplicateSourceItem)setProp.object;
                            if (getProp.object instanceof DuplicateItem) {
                                d = (DuplicateItem)getProp.object;
                                if (output.size() >= 2 && output.get(output.size() - 2) instanceof SetTemporaryItem) {
                                    SetTemporaryItem st = (SetTemporaryItem)output.get(output.size() - 2);
                                    if (st.tempIndex == d.tempIndex) {
                                        getProp.object = st.value;
                                        output.remove(output.size() - 1);
                                        output.remove(output.size() - 1);
                                        stack.moveToStack(output);
                                        if (isIncrement) {
                                            stack.push(new PostIncrementAVM2Item(setProp.value.getSrc(), setProp.value.getLineStartItem(), getProp));
                                        } else {
                                            stack.push(new PostDecrementAVM2Item(setProp.value.getSrc(), setProp.value.getLineStartItem(), getProp));
                                        }
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        stack.moveToStack(output);
        if (!output.isEmpty()) {
            if (output.get(output.size() - 1) instanceof SetTypeAVM2Item) {
                GraphTargetItem setItem = output.get(output.size() - 1);
                if (setItem.value.getNotCoercedNoDup() instanceof SetLocalAVM2Item) {
                    int setLocalIp;
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)setItem.value.getNotCoercedNoDup();
                    if (setLocal.regIndex == regId && localData.getSetLocalUsages(setLocalIp = localData.code.adr2pos(setLocal.getSrc().getAddress())).size() == 1) {
                        if (setItem instanceof SetPropertyAVM2Item && (setLocal.value instanceof IncrementAVM2Item || setLocal.value instanceof DecrementAVM2Item)) {
                            SetPropertyAVM2Item setProp = (SetPropertyAVM2Item)setItem;
                            boolean isIncrement = setLocal.value instanceof IncrementAVM2Item;
                            if (setLocal.value.value instanceof GetPropertyAVM2Item) {
                                GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)setLocal.value.value;
                                if (getProp.object instanceof DuplicateItem) {
                                    d = (DuplicateItem)getProp.object;
                                    if (setProp.object instanceof DuplicateSourceItem) {
                                        DuplicateSourceItem ds = (DuplicateSourceItem)setProp.object;
                                        if (ds.tempIndex == d.tempIndex && output.size() >= 2 && output.get(output.size() - 2) instanceof SetTemporaryItem) {
                                            SetTemporaryItem st = (SetTemporaryItem)output.get(output.size() - 2);
                                            if (st.tempIndex == d.tempIndex) {
                                                getProp.object = st.value;
                                                output.remove(output.size() - 1);
                                                output.remove(output.size() - 1);
                                                stack.moveToStack(output);
                                                if (isIncrement) {
                                                    stack.push(new PreIncrementAVM2Item(setLocal.value.getSrc(), setLocal.value.getLineStartItem(), getProp));
                                                } else {
                                                    stack.push(new PreDecrementAVM2Item(setLocal.value.getSrc(), setLocal.value.getLineStartItem(), getProp));
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (setItem.value instanceof CoerceAVM2Item || setItem.value instanceof ConvertAVM2Item) {
                            setItem.value.value = setLocal.value;
                        } else {
                            setItem.value = setLocal.value;
                        }
                        output.remove(output.size() - 1);
                        stack.moveToStack(output);
                        stack.push(setItem);
                        return;
                    }
                }
            }
            stack.finishBlock(output);
        }
        stack.moveToStack(output);
        stack.push(result);
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    public abstract int getRegisterId(AVM2Instruction var1);
}

