/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CallPropertyAVM2Item
extends AVM2Item {
    public GraphTargetItem receiver;
    public GraphTargetItem propertyName;
    public List<GraphTargetItem> arguments;
    public boolean isVoid;
    public GraphTargetItem type;
    public boolean isStatic;

    public CallPropertyAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, boolean isVoid, GraphTargetItem receiver, GraphTargetItem propertyName, List<GraphTargetItem> arguments, GraphTargetItem type, boolean isStatic) {
        super(instruction, lineStartIns, 0);
        this.receiver = receiver;
        this.propertyName = propertyName;
        this.arguments = arguments;
        this.isVoid = isVoid;
        this.type = type;
        this.isStatic = isStatic;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.receiver);
        visitor.visit(this.propertyName);
        visitor.visitAll(this.arguments);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.formatProperty(writer, this.receiver, this.propertyName, localData, this.isStatic, false);
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                writer.allowWrapHere().append(",");
            }
            this.arguments.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return CallPropertyAVM2Item.toSourceMerge(localData, generator, this.receiver, this.arguments, new AVM2Instruction(0L, 70, new int[]{((AVM2SourceGenerator)generator).propertyName(this.propertyName), this.arguments.size()}));
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.receiver);
        hash = 17 * hash + Objects.hashCode(this.propertyName);
        hash = 17 * hash + Objects.hashCode(this.arguments);
        hash = 17 * hash + (this.isVoid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallPropertyAVM2Item other = (CallPropertyAVM2Item)obj;
        if (this.isVoid != other.isVoid) {
            return false;
        }
        if (!Objects.equals(this.receiver, other.receiver)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

