/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.NumberValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FloatValueAVM2Item
extends NumberValueAVM2Item {
    public Float value;

    public FloatValueAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, Float value) {
        super(instruction, lineStartIns);
        this.value = value;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        writer.append(EcmaScript.toString(this.value));
        if (Float.isFinite(this.value.floatValue())) {
            writer.append("f");
        }
        return writer;
    }

    @Override
    public Object getResult() {
        return this.value;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return FloatValueAVM2Item.toSourceMerge(localData, generator, new AVM2Instruction(0L, 34, new int[]{((AVM2SourceGenerator)generator).abcIndex.getSelectedAbc().constants.getFloatId(this.value.floatValue(), true)}));
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem("float");
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatValueAVM2Item other = (FloatValueAVM2Item)obj;
        return Objects.equals(this.value, other.value);
    }
}

