/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewArrayAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GetPropertyAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public GraphTargetItem propertyName;
    public GraphTargetItem type;
    public GraphTargetItem callType;
    public boolean isStatic;
    public boolean nullCondition = false;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.propertyName);
    }

    @Override
    public boolean isConvertedCompileTime(Set<GraphTargetItem> dependencies) {
        if (this.object != null && this.object.isCompileTime() && this.propertyName instanceof FullMultinameAVM2Item && ((FullMultinameAVM2Item)this.propertyName).name != null && ((FullMultinameAVM2Item)this.propertyName).name.isCompileTime() && "constructor".equals(((FullMultinameAVM2Item)this.propertyName).name.getResult())) {
            Object obj = this.object.getResult();
            EcmaType t = EcmaScript.type(obj);
            if (t != EcmaType.OBJECT && t.getClassName() != null) {
                return true;
            }
            if (obj instanceof ObjectType) {
                return true;
            }
        }
        return this.isCompileTime(dependencies);
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (this.object instanceof SimpleValue && ((SimpleValue)((Object)this.object)).isSimpleValue()) {
            return true;
        }
        if (this.object instanceof NewArrayAVM2Item && ((NewArrayAVM2Item)this.object).values.isEmpty()) {
            return true;
        }
        return this.object instanceof NewObjectAVM2Item && ((NewObjectAVM2Item)this.object).pairs.isEmpty();
    }

    @Override
    public String getResultAsString() {
        if (this.object.isCompileTime() && this.propertyName instanceof FullMultinameAVM2Item && ((FullMultinameAVM2Item)this.propertyName).name != null && ((FullMultinameAVM2Item)this.propertyName).name.isCompileTime() && "constructor".equals(((FullMultinameAVM2Item)this.propertyName).name.getResult())) {
            Object obj = this.object.getResult();
            EcmaType t = EcmaScript.type(obj);
            if (t != EcmaType.OBJECT && t.getClassName() != null) {
                return "[class " + t.getClassName() + "]";
            }
            if (obj instanceof ObjectType) {
                return "[class " + ((ObjectType)obj).getTypeName() + "]";
            }
        }
        return super.getResultAsString();
    }

    @Override
    public Object getResult() {
        Object ores = this.object.getResult();
        EcmaType type = EcmaScript.type(ores);
        if (type != EcmaType.OBJECT && this.propertyName instanceof FullMultinameAVM2Item && ((FullMultinameAVM2Item)this.propertyName).resolvedMultinameName != null) {
            return type.getProperty(ores, ((FullMultinameAVM2Item)this.propertyName).resolvedMultinameName);
        }
        if (this.object instanceof NewArrayAVM2Item && ((NewArrayAVM2Item)this.object).values.isEmpty()) {
            return Undefined.INSTANCE;
        }
        if (this.object instanceof NewObjectAVM2Item && ((NewObjectAVM2Item)this.object).pairs.isEmpty()) {
            return Undefined.INSTANCE;
        }
        return null;
    }

    public GetPropertyAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem propertyName, GraphTargetItem type, GraphTargetItem callType, boolean isStatic) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.propertyName = propertyName;
        this.type = type;
        this.callType = callType;
        this.isStatic = isStatic;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.formatProperty(writer, this.object, this.propertyName, localData, this.isStatic, this.nullCondition);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return GetPropertyAVM2Item.toSourceMerge(localData, generator, this.object, new AVM2Instruction(0L, 102, new int[]{((AVM2SourceGenerator)generator).propertyName(this.propertyName)}));
    }

    @Override
    public GraphTargetItem returnType() {
        if (this.object instanceof FindPropertyAVM2Item) {
            FullMultinameAVM2Item fmul;
            FindPropertyAVM2Item fprop = (FindPropertyAVM2Item)this.object;
            if (fprop.propertyName instanceof FullMultinameAVM2Item && this.propertyName.equals(fmul = (FullMultinameAVM2Item)fprop.propertyName)) {
                switch (fmul.resolvedMultinameName) {
                    case "NaN": {
                        return TypeItem.NUMBER;
                    }
                    case "undefined": {
                        return TypeItem.UNDEFINED;
                    }
                }
            }
        }
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.object);
        hash = 97 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetPropertyAVM2Item other = (GetPropertyAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.propertyName, other.propertyName);
    }
}

