/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class HasNextAVM2Item
extends AVM2Item {
    public GraphTargetItem index;
    public GraphTargetItem obj;

    public HasNextAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem index, GraphTargetItem obj) {
        super(instruction, lineStartIns, 17);
        this.index = index;
        this.obj = obj;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.index);
        visitor.visit(this.obj);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (this.index instanceof LocalRegAVM2Item && this.obj instanceof LocalRegAVM2Item) {
            int indexReg = ((LocalRegAVM2Item)this.index).regIndex;
            int objectReg = ((LocalRegAVM2Item)this.obj).regIndex;
            return HasNextAVM2Item.toSourceMerge(localData, generator, HasNextAVM2Item.ins(50, objectReg, indexReg));
        }
        return HasNextAVM2Item.toSourceMerge(localData, generator, this.obj, this.index, HasNextAVM2Item.ins(31, new Integer[0]));
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("\u00a7\u00a7hasnext(");
        if (this.obj != null) {
            this.obj.appendTry(writer, localData);
        } else {
            writer.append("null");
        }
        writer.append(",");
        if (this.index != null) {
            this.index.appendTry(writer, localData);
        } else {
            writer.append("null");
        }
        writer.append(")");
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.index);
        hash = 29 * hash + Objects.hashCode(this.obj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HasNextAVM2Item other = (HasNextAVM2Item)obj;
        if (!Objects.equals(this.index, other.index)) {
            return false;
        }
        return Objects.equals(this.obj, other.obj);
    }
}

