/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NameValuePair;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NewObjectAVM2Item
extends AVM2Item {
    public List<NameValuePair> pairs;

    public NewObjectAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, List<NameValuePair> pairs) {
        super(instruction, lineStartIns, 0);
        this.pairs = pairs;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        for (NameValuePair p : this.pairs) {
            visitor.visit(p);
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean singleLine = this.pairs.size() < 2;
        writer.append("{");
        if (!singleLine) {
            writer.newLine();
            writer.indent();
        }
        for (int n = 0; n < this.pairs.size(); ++n) {
            if (n > 0) {
                writer.append(",").newLine();
            }
            this.pairs.get(n).toString(writer, localData);
        }
        if (!singleLine) {
            writer.newLine();
            writer.unindent();
        }
        writer.append("}");
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.OBJECT);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphTargetItem> args = new ArrayList<GraphTargetItem>();
        for (NameValuePair p : this.pairs) {
            args.add(p.name);
            args.add(p.value);
        }
        return NewObjectAVM2Item.toSourceMerge(localData, generator, args, new AVM2Instruction(0L, 85, new int[]{this.pairs.size()}));
    }

    @Override
    public Object getResult() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (NameValuePair v : this.pairs) {
            props.put(EcmaScript.toString(v.name.getResult()), v.value.getResult());
        }
        return new ObjectType(props);
    }

    @Override
    public GraphTargetItem simplify(String implicitCoerce) {
        if (implicitCoerce.isEmpty()) {
            return this;
        }
        return super.simplify(implicitCoerce);
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        for (NameValuePair v : this.pairs) {
            if (v.name.isCompileTime() && v.value.isCompileTime()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.pairs);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewObjectAVM2Item other = (NewObjectAVM2Item)obj;
        return Objects.equals(this.pairs, other.pairs);
    }

    @Override
    public boolean hasSideEffect() {
        for (NameValuePair p : this.pairs) {
            if (!p.hasSideEffect()) continue;
            return true;
        }
        return false;
    }
}

