/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.types.AssignedValue;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;

public class TraitSlotConstAVM2Item
extends AVM2Item {
    private final TraitSlotConst trait;
    private final GraphTargetItem assignedValue;
    private final boolean isStatic;
    private final int scriptIndex;
    private final int classIndex;
    private final int initializer;
    private final int methodIndex;
    private final int traitIndex;

    public TraitSlotConstAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, TraitSlotConst trait, GraphTargetItem assignedValue, boolean isStatic, int scriptIndex, int classIndex, int initializer, int methodIndex, int traitIndex) {
        super(instruction, lineStartIns, 0);
        this.trait = trait;
        this.assignedValue = assignedValue;
        this.isStatic = isStatic;
        this.scriptIndex = scriptIndex;
        this.classIndex = classIndex;
        this.initializer = initializer;
        this.methodIndex = methodIndex;
        this.traitIndex = traitIndex;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.endMethod();
        writer.endTrait();
        int h = this.traitIndex;
        if (this.initializer != -3) {
            h = localData.abc.getGlobalTraitId(TraitType.METHOD, this.isStatic, this.classIndex, this.traitIndex);
        }
        writer.startTrait(h);
        ConvertData cd = new ConvertData();
        cd.assignedValues.put(this.trait, new AssignedValue(null, this.assignedValue, this.initializer, this.methodIndex));
        boolean insideInterface = this.classIndex > -1 ? localData.abc.instance_info.get(this.classIndex).isInterface() : false;
        this.trait.toString(localData.usedDeobfuscations, localData.swfVersion, localData.abcIndex, DottedChain.EMPTY, null, cd, "trait " + this.trait.getName(localData.abc), localData.abc, this.isStatic, localData.exportMode, this.scriptIndex, this.classIndex, writer, localData.fullyQualifiedNames, false, insideInterface);
        writer.endTrait();
        writer.startTrait(this.initializer);
        writer.startMethod(this.methodIndex, null);
        return writer;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return null;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public boolean hasSingleNewLineAround() {
        return true;
    }

    @Override
    public boolean handlesNewLine() {
        return true;
    }

    public TraitSlotConst getTrait() {
        return this.trait;
    }
}

