/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.KillIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PopScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.BooleanAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DecimalValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.DoubleValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.Float4ValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FloatValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetDescendantsAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NameValuePair;
import com.jpexs.decompiler.flash.abc.avm2.model.NanAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullCoalesceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ReturnValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ReturnVoidAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThrowAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.UndefinedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.WithAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.WithObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForEachInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.TryAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.IfCondition;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AssignableAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.BreakJumpIns;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ClassAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ConstAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ContinueJumpIns;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ExceptionMarkAVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.FinallyJumpIns;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.FunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.GetterAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ImportedSlotConstItem;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.InterfaceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.MethodAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.NamespaceItem;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.PropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.SetterAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.SlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.UnresolvedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.XMLFilterAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.DoWhileItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.ForItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.SwapItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.helpers.Reference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AVM2SourceGenerator
implements SourceGenerator {
    public final AbcIndexing abcIndex;
    public static final int MARK_E_START = 0;
    public static final int MARK_E_END = 1;
    public static final int MARK_E_TARGET = 2;
    public static final int MARK_E_FINALLYPART = 3;
    private static int currentFinId = 1;
    private long uniqLast = 0L;

    private static int finId() {
        return currentFinId++;
    }

    public String uniqId() {
        ++this.uniqLast;
        return "" + this.uniqLast;
    }

    public static int resolveType(SourceGeneratorLocalData localData, GraphTargetItem item, AbcIndexing abcIndex) throws CompilationException {
        Object m;
        String fullClass;
        int name_index = 0;
        GraphTargetItem typeItem = null;
        if (item instanceof UnresolvedAVM2Item) {
            fullClass = localData.getFullClass();
            item = ((UnresolvedAVM2Item)item).resolve(localData, fullClass, new TypeItem(fullClass), new ArrayList<GraphTargetItem>(), new ArrayList<String>(), abcIndex, new ArrayList<MethodBody>(), new ArrayList<AssignableAVM2Item>());
        }
        if (item instanceof TypeItem) {
            typeItem = item;
        } else if (item instanceof ApplyTypeAVM2Item) {
            typeItem = ((ApplyTypeAVM2Item)item).object;
        } else if (item instanceof ImportedSlotConstItem) {
            typeItem = ((ImportedSlotConstItem)item).type;
        } else {
            throw new CompilationException("Invalid type:" + item + " (" + item.getClass().getName() + ")", 0);
        }
        if (typeItem instanceof UnresolvedAVM2Item) {
            fullClass = localData.getFullClass();
            typeItem = ((UnresolvedAVM2Item)typeItem).resolve(localData, fullClass, new TypeItem(fullClass), new ArrayList<GraphTargetItem>(), new ArrayList<String>(), abcIndex, new ArrayList<MethodBody>(), new ArrayList<AssignableAVM2Item>());
        }
        if (!(typeItem instanceof TypeItem)) {
            throw new CompilationException("Invalid type", 0);
        }
        TypeItem type = (TypeItem)typeItem;
        DottedChain dname = type.fullTypeName;
        DottedChain pkg = dname.getWithoutLast();
        String name = dname.getLast();
        ABC abc = abcIndex.getSelectedAbc();
        AVM2ConstantPool constants = abc.constants;
        AbcIndexing.ClassIndex ci = abcIndex.findClass(new TypeItem(dname), abc, localData != null ? localData.scriptIndex : null);
        if (ci != null && (m = ci.abc.instance_info.get(ci.index).getName(ci.abc.constants)) != null) {
            Namespace ns = ci.abc.instance_info.get(ci.index).getName(ci.abc.constants).getNamespace(ci.abc.constants);
            String n = ((Multiname)m).getName(new LinkedHashSet<String>(), ci.abc, ci.abc.constants, new ArrayList<DottedChain>(), true, true);
            String nsn = ns == null ? null : ns.getRawName(ci.abc.constants);
            name_index = constants.getQnameId(n, ns == null ? 22 : ns.kind, nsn, true);
        }
        if (name_index == 0) {
            if (pkg.isEmpty() && localData.currentScript != null) {
                for (Trait t : localData.currentScript.traits.traits) {
                    if (!t.getName(abc).getName(new LinkedHashSet<String>(), abc, constants, null, true, true).equals(name)) continue;
                    name_index = t.name_index;
                    break;
                }
            }
            if (name_index == 0) {
                name_index = constants.getMultinameId(Multiname.createQName(false, constants.getStringId(name, true), constants.getNamespaceId(22, pkg, 0, true)), true);
            }
        }
        if (item instanceof ApplyTypeAVM2Item) {
            ApplyTypeAVM2Item atype = (ApplyTypeAVM2Item)item;
            int[] params = new int[atype.params.size()];
            int i = 0;
            for (GraphTargetItem s : atype.params) {
                params[i++] = s instanceof NullAVM2Item ? 0 : AVM2SourceGenerator.resolveType(localData, s, abcIndex);
            }
            return constants.getMultinameId(Multiname.createTypeName(name_index, params), true);
        }
        return name_index;
    }

    @Override
    public List<GraphSourceItem> generateDiscardValue(SourceGeneratorLocalData localData, GraphTargetItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>(item.toSource(localData, this));
        ret.add(this.ins(41, new int[0]));
        return ret;
    }

    private AVM2Instruction ins(int instructionCode, int ... operands) {
        return new AVM2Instruction(0L, instructionCode, operands);
    }

    private AVM2Instruction ins(InstructionDefinition def, int ... operands) {
        return new AVM2Instruction(0L, def, operands);
    }

    private byte[] insToBytes(List<AVM2Instruction> code) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (AVM2Instruction instruction : code) {
                baos.write(instruction.getBytes());
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(AVM2SourceGenerator.class.getName()).log(Level.SEVERE, null, ex);
            return SWFInputStream.BYTE_ARRAY_EMPTY;
        }
    }

    public ArrayList<AVM2Instruction> toInsList(List<GraphSourceItem> items) {
        ArrayList<AVM2Instruction> ret = new ArrayList<AVM2Instruction>();
        for (GraphSourceItem s : items) {
            if (!(s instanceof AVM2Instruction)) continue;
            ret.add((AVM2Instruction)s);
        }
        return ret;
    }

    private List<AVM2Instruction> nonempty(List<AVM2Instruction> list) {
        if (list == null) {
            return new ArrayList<AVM2Instruction>();
        }
        return list;
    }

    private List<GraphSourceItem> condition(SourceGeneratorLocalData localData, GraphTargetItem t, int offset) throws CompilationException {
        if (t instanceof IfCondition) {
            IfCondition ic = (IfCondition)((Object)t);
            return GraphTargetItem.toSourceMerge(localData, this, ic.getLeftSide(), ic.getRightSide(), this.ins(ic.getIfDefinition(), offset));
        }
        return GraphTargetItem.toSourceMerge(localData, this, t, this.ins(17, offset));
    }

    private List<GraphSourceItem> notCondition(SourceGeneratorLocalData localData, GraphTargetItem t, int offset) throws CompilationException {
        if (t instanceof IfCondition) {
            IfCondition ic = (IfCondition)((Object)t);
            return GraphTargetItem.toSourceMerge(localData, this, ic.getLeftSide(), ic.getRightSide(), this.ins(ic.getIfNotDefinition(), offset));
        }
        return GraphTargetItem.toSourceMerge(localData, this, t, this.ins(18, offset));
    }

    private List<GraphSourceItem> generateIf(SourceGeneratorLocalData localData, GraphTargetItem expression, List<GraphTargetItem> onTrueCmds, List<GraphTargetItem> onFalseCmds, boolean ternar) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        List<AVM2Instruction> onFalse = null;
        List<AVM2Instruction> onTrue = ternar ? this.toInsList(onTrueCmds.get(0).toSource(localData, this)) : this.generateToInsList(localData, onTrueCmds);
        if (onFalseCmds != null && !onFalseCmds.isEmpty()) {
            onFalse = ternar ? this.toInsList(onFalseCmds.get(0).toSource(localData, this)) : this.generateToInsList(localData, onFalseCmds);
        }
        AVM2Instruction ajmp = null;
        if (onFalse != null && (onTrueCmds.isEmpty() || !(onTrueCmds.get(onTrueCmds.size() - 1) instanceof ContinueItem) && !(onTrueCmds.get(onTrueCmds.size() - 1) instanceof BreakItem))) {
            ajmp = this.ins(16, 0);
            onTrue.add(ajmp);
        }
        byte[] onTrueBytes = this.insToBytes(onTrue);
        int onTrueLen = onTrueBytes.length;
        ret.addAll(this.notCondition(localData, expression, onTrueLen));
        ret.addAll(onTrue);
        if (onFalse != null) {
            byte[] onFalseBytes = this.insToBytes(onFalse);
            int onFalseLen = onFalseBytes.length;
            if (ajmp != null) {
                ajmp.operands[0] = onFalseLen;
            }
            ret.addAll(onFalse);
        }
        return ret;
    }

    private void fixSwitch(List<AVM2Instruction> code, int breakOffset, long loopId) {
        this.fixLoop(code, breakOffset, Integer.MAX_VALUE, loopId);
    }

    private void fixLoop(List<AVM2Instruction> code, int breakOffset, int continueOffset, long loopId) {
        int pos = 0;
        for (int a = 0; a < code.size(); ++a) {
            BreakJumpIns bji;
            ContinueJumpIns cji;
            AVM2Instruction ins = code.get(a);
            pos += ins.getBytesLength();
            if (!(ins.definition instanceof JumpIns)) continue;
            if (ins.definition instanceof ContinueJumpIns && (cji = (ContinueJumpIns)ins.definition).getLoopId() == loopId && continueOffset != Integer.MAX_VALUE) {
                ins.operands[0] = -pos + continueOffset;
                ins.definition = AVM2Code.instructionSet[16];
            }
            if (!(ins.definition instanceof BreakJumpIns) || (bji = (BreakJumpIns)ins.definition).getLoopId() != loopId) continue;
            ins.operands[0] = -pos + breakOffset;
            ins.definition = AVM2Code.instructionSet[16];
        }
    }

    public List<GraphSourceItem> generateForIn(SourceGeneratorLocalData localData, Loop loop, GraphTargetItem collection, AssignableAVM2Item assignable, List<GraphTargetItem> commands, final boolean each) throws CompilationException {
        localData.openedLoops.add(loop.id);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        final Reference<Integer> counterReg = new Reference<Integer>(0);
        final Reference<Integer> collectionReg = new Reference<Integer>(0);
        if (assignable instanceof UnresolvedAVM2Item) {
            assignable = (AssignableAVM2Item)((UnresolvedAVM2Item)assignable).resolved;
        }
        ret.addAll(GraphTargetItem.toSourceMerge(localData, this, this.ins(36, 0), AssignableAVM2Item.setTemp(localData, this, counterReg), collection, NameAVM2Item.generateCoerce(localData, this, TypeItem.UNBOUNDED), AssignableAVM2Item.setTemp(localData, this, collectionReg)));
        GraphTargetItem assigned = new GraphTargetItem(this, AVM2GraphTargetDialect.INSTANCE){
            final /* synthetic */ AVM2SourceGenerator this$0;
            {
                this.this$0 = this$0;
                super(dialect);
            }

            @Override
            public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
                return null;
            }

            @Override
            public boolean hasReturnValue() {
                return true;
            }

            @Override
            public GraphTargetItem returnType() {
                return TypeItem.UNBOUNDED;
            }

            @Override
            public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
                return 1.toSourceMerge(localData, generator, AssignableAVM2Item.getTemp(localData, generator, collectionReg), AssignableAVM2Item.getTemp(localData, generator, counterReg), this.this$0.ins(each ? 35 : 30, new int[0]));
            }
        };
        assignable.setAssignedValue(assigned);
        ArrayList<AVM2Instruction> forBody = this.toInsList(GraphTargetItem.toSourceMerge(localData, this, this.ins(9, new int[0]), assignable.toSourceIgnoreReturnValue(localData, this)));
        forBody.addAll(this.generateToInsList(localData, commands));
        int forBodyLen = this.insToBytes(forBody).length;
        AVM2Instruction forwardJump = this.ins(16, forBodyLen);
        ret.add(forwardJump);
        ArrayList<AVM2Instruction> expr = new ArrayList<AVM2Instruction>();
        expr.add(this.ins(50, collectionReg.getVal(), counterReg.getVal()));
        AVM2Instruction backIf = this.ins(17, 0);
        expr.add(backIf);
        int exprLen = this.insToBytes(expr).length;
        backIf.operands[0] = -(exprLen + forBodyLen);
        this.fixLoop(forBody, forBodyLen + exprLen, forBodyLen, loop.id);
        ret.addAll(forBody);
        ret.addAll(expr);
        ret.addAll(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(collectionReg, counterReg)));
        return ret;
    }

    private List<AVM2Instruction> generateToInsList(SourceGeneratorLocalData localData, List<GraphTargetItem> commands) throws CompilationException {
        return this.toInsList(this.generate(localData, commands));
    }

    private List<AVM2Instruction> generateToActionList(SourceGeneratorLocalData localData, GraphTargetItem command) throws CompilationException {
        return this.toInsList(command.toSource(localData, this));
    }

    public HashMap<String, Integer> getRegisterVars(SourceGeneratorLocalData localData) {
        return localData.registerVars;
    }

    public void setRegisterVars(SourceGeneratorLocalData localData, HashMap<String, Integer> value) {
        localData.registerVars = value;
    }

    public void setInFunction(SourceGeneratorLocalData localData, int value) {
        localData.inFunction = value;
    }

    public int isInFunction(SourceGeneratorLocalData localData) {
        return localData.inFunction;
    }

    public boolean isInMethod(SourceGeneratorLocalData localData) {
        return localData.inMethod;
    }

    public void setInMethod(SourceGeneratorLocalData localData, boolean value) {
        localData.inMethod = value;
    }

    public int getForInLevel(SourceGeneratorLocalData localData) {
        return localData.forInLevel;
    }

    public void setForInLevel(SourceGeneratorLocalData localData, int value) {
        localData.forInLevel = value;
    }

    public int getTempRegister(SourceGeneratorLocalData localData) {
        HashMap<String, Integer> registerVars = this.getRegisterVars(localData);
        int tmpReg = 0;
        for (int i = 0; i < 256; ++i) {
            if (registerVars.containsValue(i)) continue;
            tmpReg = i;
            break;
        }
        return tmpReg;
    }

    public AVM2SourceGenerator(AbcIndexing abc) {
        this.abcIndex = abc;
    }

    /*
     * WARNING - void declaration
     */
    public void generateClass(List<DottedChain> importedClasses, List<AssignableAVM2Item> cinitVariables, boolean cinitNeedsActivation, List<GraphTargetItem> cinit, List<NamespaceItem> openedNamespaces, int namespace, int initScope, DottedChain pkg, ClassInfo classInfo, InstanceInfo instanceInfo, SourceGeneratorLocalData localData, boolean isInterface, String baseClassName, String superName, GraphTargetItem extendsVal, List<GraphTargetItem> implementsStr, GraphTargetItem iinit, List<AssignableAVM2Item> iinitVariables, boolean iinitNeedsActivation, List<GraphTargetItem> commands, Reference<Integer> class_index) throws AVM2ParseException, CompilationException {
        int init;
        ArrayList<GraphTargetItem> traitItems = new ArrayList<GraphTargetItem>();
        for (GraphTargetItem graphTargetItem : commands) {
            if (!(graphTargetItem instanceof SlotAVM2Item) && !(graphTargetItem instanceof ConstAVM2Item) && !(graphTargetItem instanceof ClassAVM2Item) && !(graphTargetItem instanceof InterfaceAVM2Item) && !(graphTargetItem instanceof MethodAVM2Item) && !(graphTargetItem instanceof GetterAVM2Item) && !(graphTargetItem instanceof SetterAVM2Item)) continue;
            traitItems.add(graphTargetItem);
        }
        localData.currentClassBaseName = baseClassName;
        localData.pkg = pkg;
        localData.privateNs = this.abcIndex.getSelectedAbc().constants.getNamespaceId(5, pkg.toRawString().isEmpty() ? baseClassName : pkg.toRawString() + ":" + baseClassName, 0, true);
        localData.protectedNs = this.abcIndex.getSelectedAbc().constants.getNamespaceId(24, pkg.toRawString().isEmpty() ? baseClassName : pkg.toRawString() + ":" + baseClassName, 0, true);
        if (extendsVal == null && !isInterface) {
            extendsVal = new TypeItem(DottedChain.OBJECT);
        }
        Object s = null;
        if (Configuration.handleSkinPartsAutomatically.get().booleanValue()) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (GraphTargetItem t : traitItems) {
                String tname = null;
                List<Map.Entry<String, Map<String, String>>> tmetadata = null;
                if (t instanceof MethodAVM2Item) {
                    tname = ((MethodAVM2Item)t).functionName;
                    tmetadata = ((MethodAVM2Item)t).metadata;
                } else if (t instanceof SlotAVM2Item) {
                    tname = ((SlotAVM2Item)t).var;
                    tmetadata = ((SlotAVM2Item)t).metadata;
                } else if (t instanceof ConstAVM2Item) {
                    tname = ((ConstAVM2Item)t).var;
                    tmetadata = ((ConstAVM2Item)t).metadata;
                }
                if (tname == null || tmetadata == null) continue;
                for (Map.Entry<String, Map<String, String>> en : tmetadata) {
                    if (!"SkinPart".equals(en.getKey())) continue;
                    boolean req = false;
                    if (en.getValue().containsKey("required") && "true".equals(en.getValue().get("required"))) {
                        req = true;
                    }
                    hashMap.put(tname, req);
                }
            }
            if (!hashMap.isEmpty()) {
                AbcIndexing.ClassIndex ci;
                GraphTargetItem parent = extendsVal;
                if (parent instanceof UnresolvedAVM2Item) {
                    parent = ((UnresolvedAVM2Item)parent).resolved;
                }
                if (parent instanceof TypeItem && (ci = this.abcIndex.findClass(parent, this.abcIndex.getSelectedAbc(), localData != null ? localData.scriptIndex : null)) != null) {
                    int mi = ci.abc.class_info.get((int)ci.index).cinit_index;
                    MethodBody pcinit = ci.abc.findBody(mi);
                    ConvertData d = new ConvertData();
                    ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                    callStack.add(pcinit);
                    try {
                        pcinit.convert(-1, callStack, null, d, "-", ScriptExportMode.AS, true, mi, -1, ci.index, ci.abc, null, new ScopeStack(), -2, new NulWriter(), new ArrayList<DottedChain>(), ci.abc.class_info.get((int)ci.index).static_traits, false, new HashSet<Integer>(), new ArrayList<Integer>(), new LinkedHashSet<String>());
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(AVM2SourceGenerator.class.getName()).log(Level.SEVERE, "Getting parent skinparts interrupted", ex);
                    }
                    for (Trait trait : ci.abc.class_info.get((int)ci.index).static_traits.traits) {
                        if (!(trait instanceof TraitSlotConst)) continue;
                        TraitSlotConst tsc = (TraitSlotConst)trait;
                        if (tsc.kindType != 0 || !"_skinParts".equals(tsc.getName(ci.abc).getName(new LinkedHashSet<String>(), ci.abc, ci.abc.constants, new ArrayList<DottedChain>(), true, true)) || !d.assignedValues.containsKey(tsc) || !(d.assignedValues.get((Object)tsc).value instanceof NewObjectAVM2Item)) continue;
                        NewObjectAVM2Item no = (NewObjectAVM2Item)d.assignedValues.get((Object)tsc).value;
                        for (NameValuePair nvp : no.pairs) {
                            hashMap.put(EcmaScript.toString(nvp.name.getResult()), EcmaScript.toBoolean(nvp.value.getResult()));
                        }
                    }
                }
                ArrayList<GraphTargetItem> getterBody = new ArrayList<GraphTargetItem>();
                UnresolvedAVM2Item sp = new UnresolvedAVM2Item(new ArrayList<GraphTargetItem>(), importedClasses, false, TypeItem.UNBOUNDED, 0, new DottedChain(new String[]{"_skinParts"}), null, openedNamespaces, this.abcIndex);
                getterBody.add(new ReturnValueAVM2Item(null, null, sp));
                ArrayList<AssignableAVM2Item> subvars = new ArrayList<AssignableAVM2Item>();
                subvars.add(sp);
                ArrayList<List<NamespaceItem>> allopns = new ArrayList<List<NamespaceItem>>();
                allopns.add(openedNamespaces);
                GetterAVM2Item getter = new GetterAVM2Item(allopns, false, false, new ArrayList<Map.Entry<String, Map<String, String>>>(), new NamespaceItem(pkg.isEmpty() ? baseClassName : pkg.toRawString() + ":" + baseClassName, 24), isInterface, false, null, false, false, 0, true, false, false, "skinParts", new ArrayList<GraphTargetItem>(), new ArrayList<String>(), new ArrayList<GraphTargetItem>(), getterBody, subvars, new TypeItem("Object"));
                ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
                for (String tname : hashMap.keySet()) {
                    pairs.add(new NameValuePair(new StringAVM2Item(null, null, tname), (Boolean)hashMap.get(tname) != false ? new TrueItem(AVM2GraphTargetDialect.INSTANCE, null, null) : new FalseItem(AVM2GraphTargetDialect.INSTANCE, null, null)));
                }
                NewObjectAVM2Item newObjectAVM2Item = new NewObjectAVM2Item(null, null, pairs);
                SlotAVM2Item slt = new SlotAVM2Item(new ArrayList<Map.Entry<String, Map<String, String>>>(), new NamespaceItem(pkg.isEmpty() ? baseClassName : pkg.toRawString() + ":" + baseClassName, 5), null, true, "_skinParts", new TypeItem("Object"), newObjectAVM2Item, 0);
                traitItems.add(0, slt);
                traitItems.add(getter);
            }
        }
        Trait[] traitArray = this.generateTraitsPhase1(importedClasses, openedNamespaces, baseClassName, superName, false, localData, traitItems, instanceInfo.instance_traits, class_index, false);
        Trait[] st = this.generateTraitsPhase1(importedClasses, openedNamespaces, baseClassName, superName, true, localData, traitItems, classInfo.static_traits, class_index, false);
        this.generateTraitsPhase2(importedClasses, pkg, traitItems, traitArray, openedNamespaces, localData);
        this.generateTraitsPhase2(importedClasses, pkg, traitItems, st, openedNamespaces, localData);
        this.abcIndex.refreshSelected();
        this.generateTraitsPhase4(importedClasses, openedNamespaces, initScope, isInterface, baseClassName, superName, false, localData, traitItems, instanceInfo.instance_traits, traitArray, new HashMap<Trait, Integer>(), class_index, false);
        this.generateTraitsPhase4(importedClasses, openedNamespaces, initScope, isInterface, baseClassName, superName, true, localData, traitItems, classInfo.static_traits, st, new HashMap<Trait, Integer>(), class_index, false);
        if (iinit == null || isInterface) {
            instanceInfo.iinit_index = init = this.method(null, false, 0, false, isInterface, false, new ArrayList<MethodBody>(), pkg, false, new ArrayList<AssignableAVM2Item>(), initScope + 1, false, 0, isInterface ? null : baseClassName, extendsVal != null ? extendsVal.toString() : null, true, localData, new ArrayList<GraphTargetItem>(), new ArrayList<String>(), new ArrayList<GraphTargetItem>(), new ArrayList<GraphTargetItem>(), TypeItem.UNBOUNDED);
        } else {
            MethodAVM2Item m = (MethodAVM2Item)iinit;
            ArrayList<AssignableAVM2Item> allIinitVariables = new ArrayList<AssignableAVM2Item>();
            allIinitVariables.addAll(iinitVariables);
            allIinitVariables.addAll(m.subvariables);
            instanceInfo.iinit_index = init = this.method(null, false, pkg.toRawString().isEmpty() ? this.str(baseClassName + "/" + baseClassName) : this.str(pkg.toRawString() + ":" + baseClassName + "/" + baseClassName), false, false, false, new ArrayList<MethodBody>(), pkg, m.needsActivation, allIinitVariables, initScope + 1, m.hasRest, m.line, baseClassName, extendsVal != null ? extendsVal.toString() : null, true, localData, m.paramTypes, m.paramNames, m.paramValues, m.body, TypeItem.UNBOUNDED);
        }
        int cinit_index = this.method(null, true, this.str(""), false, false, false, new ArrayList<MethodBody>(), pkg, cinitNeedsActivation, cinitVariables, initScope + (implementsStr.isEmpty() ? 0 : 1), false, 0, isInterface ? null : baseClassName, superName, false, localData, new ArrayList<GraphTargetItem>(), new ArrayList<String>(), new ArrayList<GraphTargetItem>(), commands, TypeItem.UNBOUNDED);
        MethodBody cinitBody = this.abcIndex.getSelectedAbc().findBody(cinit_index);
        for (int i = 0; i < cinitVariables.size(); ++i) {
            AssignableAVM2Item an = cinitVariables.get(i);
            if (!(an instanceof UnresolvedAVM2Item)) continue;
            UnresolvedAVM2Item n = (UnresolvedAVM2Item)an;
            if (n.resolved != null) continue;
            String string = localData.getFullClass();
            ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
            callStack.add(cinitBody);
            GraphTargetItem res = n.resolve(localData, string, new TypeItem(string), new ArrayList<GraphTargetItem>(), new ArrayList<String>(), this.abcIndex, callStack, cinitVariables);
            if (res instanceof AssignableAVM2Item) {
                cinitVariables.set(i, (AssignableAVM2Item)res);
                continue;
            }
            cinitVariables.remove(i);
            --i;
        }
        ArrayList<AVM2Instruction> initcode = new ArrayList<AVM2Instruction>();
        for (GraphTargetItem ti : commands) {
            void var32_58;
            if (!(ti instanceof SlotAVM2Item) && !(ti instanceof ConstAVM2Item)) continue;
            Object var32_54 = null;
            boolean isStatic = false;
            int ns = -1;
            String tname = null;
            boolean isConst = false;
            GraphTargetItem type = null;
            if (ti instanceof SlotAVM2Item) {
                GraphTargetItem graphTargetItem = ((SlotAVM2Item)ti).value;
                isStatic = ((SlotAVM2Item)ti).isStatic();
                ns = this.genNs(importedClasses, pkg, ((SlotAVM2Item)ti).pkg, openedNamespaces, localData, ((SlotAVM2Item)ti).line);
                tname = ((SlotAVM2Item)ti).var;
                type = ((SlotAVM2Item)ti).type;
            }
            if (ti instanceof ConstAVM2Item) {
                GraphTargetItem graphTargetItem = ((ConstAVM2Item)ti).value;
                isStatic = ((ConstAVM2Item)ti).isStatic();
                ns = this.genNs(importedClasses, pkg, ((ConstAVM2Item)ti).pkg, openedNamespaces, localData, ((ConstAVM2Item)ti).line);
                tname = ((ConstAVM2Item)ti).var;
                isConst = true;
                type = ((ConstAVM2Item)ti).type;
                if (((ConstAVM2Item)ti).type.toString().equals("Namespace")) continue;
            }
            if (isStatic || var32_58 == null || var32_58 instanceof IntegerValueAVM2Item || var32_58 instanceof DoubleValueAVM2Item || var32_58 instanceof StringAVM2Item || var32_58 instanceof BooleanAVM2Item || var32_58 instanceof NullAVM2Item || var32_58 instanceof UndefinedAVM2Item) continue;
            GraphTargetItem graphTargetItem = AVM2SourceGenerator.handleAndOrCoerce((GraphTargetItem)var32_58, type);
            initcode.add(this.ins(208, new int[0]));
            localData.isStatic = false;
            initcode.addAll(this.toInsList(graphTargetItem.toSource(localData, this)));
            initcode.add(this.ins(isConst ? 104 : 97, this.traitName(ns, tname)));
        }
        MethodBody initBody = null;
        if (!isInterface) {
            initBody = this.abcIndex.getSelectedAbc().findBody(init);
            int len = 0;
            for (AVM2Instruction ins : initcode) {
                len += ins.getBytesLength();
            }
            initBody.getCode().code.addAll(iinit == null ? 0 : 2, initcode);
            for (ABCException ex : initBody.exceptions) {
                ex.start += len;
                ex.end += len;
                ex.target += len;
            }
        }
        cinitBody.markOffsets();
        cinitBody.autoFillStats(this.abcIndex.getSelectedAbc(), initScope + (implementsStr.isEmpty() ? 0 : 1), true);
        classInfo.cinit_index = cinit_index;
        if (initBody != null) {
            initBody.markOffsets();
            initBody.autoFillStats(this.abcIndex.getSelectedAbc(), initScope + 1, true);
        }
        instanceInfo.interfaces = new int[implementsStr.size()];
        for (int i = 0; i < implementsStr.size(); ++i) {
            instanceInfo.interfaces[i] = this.superIntName(localData, implementsStr.get(i));
        }
    }

    public int generateClass(int namespace, ClassInfo ci, InstanceInfo ii, int initScope, DottedChain pkg, SourceGeneratorLocalData localData, AVM2Item cls, Reference<Integer> class_index) throws AVM2ParseException, CompilationException {
        if (cls instanceof ClassAVM2Item) {
            ClassAVM2Item cai = (ClassAVM2Item)cls;
            this.generateClass(cai.importedClasses, cai.cinitVariables, cai.cinitActivation, cai.staticInit, cai.openedNamespaces, namespace, initScope, pkg, ci, ii, localData, false, cai.classBaseName, cai.extendsOp == null ? "Object" : cai.extendsOp.toString(), cai.extendsOp, cai.implementsOp, cai.iinit, cai.iinitVariables, cai.iinitActivation, cai.traits, class_index);
            if (!cai.isDynamic) {
                ii.flags |= 1;
            }
            if (cai.isFinal) {
                ii.flags |= 2;
            }
            if (!cai.isNullable) {
                ii.flags |= 0x10;
            }
            ii.flags |= 8;
            ii.protectedNS = this.abcIndex.getSelectedAbc().constants.getNamespaceId(24, pkg.toRawString().isEmpty() ? cai.classBaseName : pkg.toRawString() + ":" + cai.classBaseName, 0, true);
        }
        if (cls instanceof InterfaceAVM2Item) {
            InterfaceAVM2Item iai = (InterfaceAVM2Item)cls;
            ii.flags |= 4;
            ii.flags |= 1;
            if (!iai.isNullable) {
                ii.flags |= 0x10;
            }
            this.generateClass(iai.importedClasses, new ArrayList<AssignableAVM2Item>(), false, new ArrayList<GraphTargetItem>(), iai.openedNamespaces, namespace, initScope, pkg, ci, ii, localData, true, iai.baseName, null, null, iai.superInterfaces, null, null, false, iai.methods, class_index);
        }
        return this.abcIndex.getSelectedAbc().instance_info.size() - 1;
    }

    public int traitName(int namespace, String var) {
        return this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.str(var), namespace), true);
    }

    public int typeName(SourceGeneratorLocalData localData, GraphTargetItem type) throws CompilationException {
        if (type.equals(TypeItem.UNBOUNDED)) {
            return 0;
        }
        if (("" + type).equals("*")) {
            return 0;
        }
        return AVM2SourceGenerator.resolveType(localData, type, this.abcIndex);
    }

    public int ident(GraphTargetItem name) {
        if (name instanceof NameAVM2Item) {
            return this.str(((NameAVM2Item)name).getVariableName());
        }
        throw new RuntimeException("no ident");
    }

    public int namespace(int nsKind, String name) {
        return this.abcIndex.getSelectedAbc().constants.getNamespaceId(nsKind, this.str(name), 0, true);
    }

    public int str(String name) {
        return this.abcIndex.getSelectedAbc().constants.getStringId(name, true);
    }

    public int propertyName(GraphTargetItem name) {
        if (name instanceof NameAVM2Item) {
            NameAVM2Item va = (NameAVM2Item)name;
            return this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.str(va.getVariableName()), this.namespace(22, "")), true);
        }
        throw new RuntimeException("no prop");
    }

    public int getFreeRegister(SourceGeneratorLocalData localData) {
        int i = 0;
        while (true) {
            if (!localData.registerVars.containsValue(i)) {
                localData.registerVars.put("__TEMP__" + i, i);
                return i;
            }
            ++i;
        }
    }

    public boolean killRegister(SourceGeneratorLocalData localData, int i) {
        String key = null;
        for (String k : localData.registerVars.keySet()) {
            if (localData.registerVars.get(k) != i) continue;
            key = k;
            break;
        }
        if (key != null) {
            localData.registerVars.remove(key);
            return true;
        }
        return false;
    }

    public int methodHeader(boolean isStatic, int name_index, boolean subMethod, boolean isInterface, boolean isNative, List<MethodBody> callStack, DottedChain pkg, boolean needsActivation, List<AssignableAVM2Item> subvariables, int initScope, boolean hasRest, int line, String classBaseName, String superType, boolean constructor, SourceGeneratorLocalData localData, List<GraphTargetItem> paramTypes, List<String> paramNames, List<GraphTargetItem> paramValues, List<GraphTargetItem> body, GraphTargetItem retType) throws CompilationException {
        int i;
        SourceGeneratorLocalData newlocalData = new SourceGeneratorLocalData(new HashMap<String, Integer>(), 1, true, 0);
        newlocalData.currentClassBaseName = classBaseName;
        newlocalData.pkg = localData.pkg;
        newlocalData.callStack.addAll(localData.callStack);
        newlocalData.traitUsages = localData.traitUsages;
        newlocalData.currentScript = localData.currentScript;
        newlocalData.scriptIndex = localData.scriptIndex;
        newlocalData.documentClass = localData.documentClass;
        newlocalData.privateNs = localData.privateNs;
        newlocalData.protectedNs = localData.protectedNs;
        newlocalData.isStatic = isStatic;
        newlocalData.subMethod = subMethod;
        newlocalData.numberContext = localData.numberContext;
        newlocalData.returnType = retType;
        localData = newlocalData;
        localData.activationReg = 0;
        int[] param_types = new int[paramTypes.size()];
        ValueKind[] optional = new ValueKind[paramValues.size()];
        for (i = 0; i < paramTypes.size(); ++i) {
            param_types[i] = this.typeName(localData, paramTypes.get(i));
        }
        for (i = 0; i < paramValues.size(); ++i) {
            optional[i] = this.getValueKind(8, paramTypes.get(paramTypes.size() - paramValues.size() + i), paramValues.get(i), false);
            if (optional[i] != null) continue;
            throw new CompilationException("Default value must be compiletime constant", line);
        }
        MethodInfo mi = new MethodInfo(param_types, constructor ? 0 : this.typeName(localData, retType), name_index, 0, optional, new int[0]);
        return this.abcIndex.getSelectedAbc().addMethodInfo(mi);
    }

    public int method(Integer replaceMethodIndex, boolean isStatic, int name_index, boolean subMethod, boolean isInterface, boolean isNative, List<MethodBody> callStack, DottedChain pkg, boolean needsActivation, List<AssignableAVM2Item> subvariables, int initScope, boolean hasRest, int line, String classBaseName, String superType, boolean constructor, SourceGeneratorLocalData localData, List<GraphTargetItem> paramTypes, List<String> paramNames, List<GraphTargetItem> paramValues, List<GraphTargetItem> body, GraphTargetItem retType) throws CompilationException {
        int mindex;
        int i;
        int j;
        NameAVM2Item n;
        GraphTargetItem res;
        String fullClass;
        GraphTargetItem an;
        SourceGeneratorLocalData newlocalData = new SourceGeneratorLocalData(new HashMap<String, Integer>(), 1, true, 0);
        newlocalData.currentClassBaseName = classBaseName;
        newlocalData.pkg = localData.pkg;
        newlocalData.callStack.addAll(localData.callStack);
        newlocalData.traitUsages = localData.traitUsages;
        newlocalData.currentScript = localData.currentScript;
        newlocalData.scriptIndex = localData.scriptIndex;
        newlocalData.documentClass = localData.documentClass;
        newlocalData.privateNs = localData.privateNs;
        newlocalData.protectedNs = localData.protectedNs;
        newlocalData.isStatic = isStatic;
        newlocalData.subMethod = subMethod;
        newlocalData.numberContext = localData.numberContext;
        newlocalData.returnType = retType;
        localData = newlocalData;
        localData.activationReg = 0;
        for (int i2 = 0; i2 < subvariables.size(); ++i2) {
            an = subvariables.get(i2);
            if (!(an instanceof UnresolvedAVM2Item)) continue;
            UnresolvedAVM2Item n2 = (UnresolvedAVM2Item)an;
            if (n2.resolved != null) continue;
            fullClass = localData.getFullClass();
            res = n2.resolve(localData, fullClass, new TypeItem(fullClass), paramTypes, paramNames, this.abcIndex, callStack, subvariables);
            if (res instanceof AssignableAVM2Item) {
                subvariables.set(i2, (AssignableAVM2Item)res);
                continue;
            }
            subvariables.remove(i2);
            --i2;
        }
        for (int t = 0; t < paramTypes.size(); ++t) {
            an = paramTypes.get(t);
            if (!(an instanceof UnresolvedAVM2Item)) continue;
            UnresolvedAVM2Item n2 = (UnresolvedAVM2Item)an;
            if (n2.resolved != null) continue;
            fullClass = localData.getFullClass();
            res = n2.resolve(localData, fullClass, new TypeItem(fullClass), paramTypes, paramNames, this.abcIndex, callStack, subvariables);
            paramTypes.set(t, res);
        }
        boolean hasArguments = false;
        ArrayList<String> slotNames = new ArrayList<String>();
        ArrayList<GraphTargetItem> slotTypes = new ArrayList<GraphTargetItem>();
        slotNames.add("--first");
        slotTypes.add(TypeItem.UNBOUNDED);
        int paramLine = 0;
        ArrayList<Object> registerNames = new ArrayList<Object>();
        ArrayList<Integer> registerLines = new ArrayList<Integer>();
        ArrayList<GraphTargetItem> registerTypes = new ArrayList<GraphTargetItem>();
        if (classBaseName != null && !subMethod) {
            String fullClassName = pkg.addWithSuffix(classBaseName).toRawString();
            registerTypes.add(new TypeItem(fullClassName));
            localData.scopeStack.add(new LocalRegAVM2Item(null, null, registerNames.size(), null, (GraphTargetItem)new TypeItem(fullClassName)));
            registerNames.add("this");
            registerLines.add(0);
        } else {
            registerTypes.add(new TypeItem("global"));
            registerNames.add("this");
            registerLines.add(0);
        }
        for (GraphTargetItem t : paramTypes) {
            registerTypes.add(t);
            slotTypes.add(t);
        }
        for (int i3 = 0; i3 < paramNames.size(); ++i3) {
            registerLines.add(paramLine);
        }
        registerNames.addAll(paramNames);
        slotNames.addAll(paramNames);
        if (hasRest) {
            registerTypes.add(TypeItem.ARRAY);
            slotTypes.add(TypeItem.ARRAY);
        }
        localData.registerVars.clear();
        for (AssignableAVM2Item an2 : subvariables) {
            NameAVM2Item n3;
            if (!(an2 instanceof NameAVM2Item) || !((n3 = (NameAVM2Item)an2).getVariableName().equals("arguments") & !n3.isDefinition())) continue;
            registerNames.add("arguments");
            registerTypes.add(new TypeItem("Array"));
            registerLines.add(0);
            slotNames.add(n3.getVariableName());
            slotTypes.add(new TypeItem("Array"));
            hasArguments = true;
            break;
        }
        int paramRegCount = registerNames.size();
        if (needsActivation) {
            registerNames.add("+$activation");
            registerLines.add(0);
            localData.activationReg = registerNames.size() - 1;
            registerTypes.add(new TypeItem("Object"));
            localData.scopeStack.add(new LocalRegAVM2Item(null, null, localData.activationReg, null, (GraphTargetItem)new TypeItem("Object")));
        }
        String mask = Configuration.registerNameFormat.get();
        String maskRegexp = mask.replace("%d", "([0-9]+)");
        Pattern pat = Pattern.compile(maskRegexp);
        String UNUSED = "~~unused";
        for (int round = 1; round <= 2; ++round) {
            for (AssignableAVM2Item assignableAVM2Item : subvariables) {
                if (!(assignableAVM2Item instanceof NameAVM2Item) || !(n = (NameAVM2Item)assignableAVM2Item).isDefinition() || registerNames.contains(n.getVariableName())) continue;
                String varName = n.getVariableName();
                if (!needsActivation) {
                    Matcher m = pat.matcher(varName);
                    boolean addNew = false;
                    if (round == 1 && m.matches()) {
                        boolean alreadyExistsWithDifferentName;
                        String regIndexStr = m.group(1);
                        int regIndex = Integer.parseInt(regIndexStr);
                        boolean bl = alreadyExistsWithDifferentName = regIndex < registerNames.size() && !((String)registerNames.get(regIndex)).equals("~~unused") && !((String)registerNames.get(regIndex)).equals(varName);
                        if (alreadyExistsWithDifferentName) {
                            addNew = true;
                        } else {
                            while (registerNames.size() <= regIndex) {
                                registerNames.add("~~unused");
                                registerTypes.add(TypeItem.UNBOUNDED);
                                registerLines.add(paramLine);
                            }
                            registerNames.set(regIndex, varName);
                            registerTypes.set(regIndex, n.type);
                            registerLines.set(regIndex, n.line);
                        }
                    } else if (round == 2 && !m.matches()) {
                        addNew = true;
                    }
                    if (!addNew) continue;
                    int newRegIndex = -1;
                    for (int j2 = 0; j2 < registerNames.size(); ++j2) {
                        if (!"~~unused".equals(registerNames.get(j2))) continue;
                        newRegIndex = j2;
                        break;
                    }
                    if (newRegIndex == -1) {
                        newRegIndex = registerNames.size();
                        registerNames.add("~~unused");
                        registerTypes.add(TypeItem.UNBOUNDED);
                        registerLines.add(paramLine);
                    }
                    registerNames.set(newRegIndex, n.getVariableName());
                    registerTypes.set(newRegIndex, n.type);
                    registerLines.set(newRegIndex, n.line);
                    continue;
                }
                if (round != 1 || slotNames.contains(varName)) continue;
                slotNames.add(varName);
                slotTypes.add(n.type);
            }
        }
        for (j = registerNames.size() - 1; j >= 0; --j) {
            if (!"~~unused".equals(registerNames.get(j))) continue;
            registerNames.remove(j);
            registerTypes.remove(j);
            registerLines.remove(j);
        }
        for (j = 0; j < registerNames.size(); ++j) {
            if (!"~~unused".equals(registerNames.get(j))) continue;
            String standardName = String.format(mask, j);
            registerNames.set(j, standardName);
        }
        int slotScope = subMethod ? 0 : 1;
        for (AssignableAVM2Item assignableAVM2Item : subvariables) {
            boolean isThisOrSuper;
            String variableName;
            if (!(assignableAVM2Item instanceof NameAVM2Item) || (variableName = (n = (NameAVM2Item)assignableAVM2Item).getVariableName()) == null) continue;
            boolean bl = isThisOrSuper = variableName.equals("this") || variableName.equals("super");
            if (!isThisOrSuper && needsActivation) {
                if (n.getSlotNumber() > 0) continue;
                n.setSlotNumber(slotNames.indexOf(variableName));
                n.setSlotScope(slotScope);
                continue;
            }
            if (isThisOrSuper) {
                n.setRegNumber(0);
                continue;
            }
            n.setRegNumber(registerNames.indexOf(variableName));
        }
        for (int i4 = 0; !(i4 >= registerNames.size() || needsActivation && i4 > localData.activationReg); ++i4) {
            localData.registerVars.put((String)registerNames.get(i4), i4);
        }
        ArrayList<NameAVM2Item> declarations = new ArrayList<NameAVM2Item>();
        block18: for (AssignableAVM2Item an4 : subvariables) {
            String variableName;
            if (!(an4 instanceof NameAVM2Item)) continue;
            NameAVM2Item n4 = (NameAVM2Item)an4;
            if (needsActivation && (n4.getSlotScope() != slotScope || n4.getSlotNumber() < paramRegCount)) continue;
            for (NameAVM2Item d2 : declarations) {
                if (n4.getVariableName() == null || !n4.getVariableName().equals(d2.getVariableName())) continue;
                continue block18;
            }
            for (GraphTargetItem it : body) {
                if (!(it instanceof NameAVM2Item)) continue;
                NameAVM2Item n22 = (NameAVM2Item)it;
                if (n22.isDefinition() && n22.getAssignedValue() != null && n22.getVariableName().equals(n4.getVariableName())) continue block18;
                if (n22.isDefinition() || n22.getVariableName() == null || !n22.getVariableName().equals(n4.getVariableName())) continue;
                break;
            }
            if (n4.unresolved || n4.redirect != null || n4.getNs() != null || "this".equals(variableName = n4.getVariableName()) || "super".equals(variableName) || paramNames.contains(variableName) || "arguments".equals(variableName)) continue;
            NameAVM2Item d = new NameAVM2Item(n4.type, n4.line, n4.isAttribute(), n4.getVariableName(), n4.getNamespaceSuffix(), null, true, n4.openedNamespaces, this.abcIndex, n4.isConst());
            if (needsActivation) {
                if (d.getSlotNumber() <= 0) {
                    d.setSlotNumber(n4.getSlotNumber());
                    d.setSlotScope(n4.getSlotScope());
                }
            } else {
                d.setRegNumber(n4.getRegNumber());
            }
            declarations.add(d);
        }
        int[] nArray = new int[paramTypes.size()];
        ValueKind[] optional = new ValueKind[paramValues.size()];
        for (i = 0; i < paramTypes.size(); ++i) {
            nArray[i] = this.typeName(localData, paramTypes.get(i));
        }
        for (i = 0; i < paramValues.size(); ++i) {
            optional[i] = this.getValueKind(8, paramTypes.get(paramTypes.size() - paramValues.size() + i), paramValues.get(i), false);
            if (optional[i] != null) continue;
            throw new CompilationException("Default value must be compiletime constant", line);
        }
        MethodInfo mi = new MethodInfo(nArray, constructor ? 0 : this.typeName(localData, retType), name_index, 0, optional, new int[0]);
        if (replaceMethodIndex != null) {
            mi = this.abcIndex.getSelectedAbc().method_info.get(replaceMethodIndex);
        }
        if (hasArguments) {
            mi.setFlagNeed_Arguments();
        }
        if (!paramValues.isEmpty()) {
            mi.setFlagHas_optional();
        }
        if (hasRest) {
            mi.setFlagNeed_rest();
        }
        if (isNative) {
            mi.setFlagNative();
        }
        if (!isInterface && !isNative) {
            MethodBody mbody = new MethodBody(this.abcIndex.getSelectedAbc(), new Traits(), new byte[0], new ABCException[0]);
            if (needsActivation) {
                int slotId = 1;
                for (int i5 = 1; i5 < slotNames.size(); ++i5) {
                    TraitSlotConst tsc = new TraitSlotConst();
                    tsc.slot_id = slotId++;
                    tsc.name_index = this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.abcIndex.getSelectedAbc().constants.getStringId((String)slotNames.get(i5), true), this.abcIndex.getSelectedAbc().constants.getNamespaceId(23, pkg, 0, true)), true);
                    tsc.type_index = this.typeName(localData, (GraphTargetItem)slotTypes.get(i5));
                    mbody.traits.traits.add(tsc);
                }
                for (int i2 = 1; i2 < paramRegCount; ++i2) {
                    NameAVM2Item param = new NameAVM2Item((GraphTargetItem)registerTypes.get(i2), 0, false, (String)registerNames.get(i2), "", null, false, new ArrayList<NamespaceItem>(), this.abcIndex, false);
                    param.setRegNumber(i2);
                    NameAVM2Item d = new NameAVM2Item((GraphTargetItem)registerTypes.get(i2), 0, false, (String)registerNames.get(i2), "", param, true, new ArrayList<NamespaceItem>(), this.abcIndex, false);
                    d.setSlotScope(slotScope);
                    d.setSlotNumber(slotNames.indexOf(registerNames.get(i2)));
                    declarations.add(d);
                }
            }
            boolean addRet = false;
            if (body != null) {
                body.addAll(0, declarations);
                if (body.isEmpty() || !(body.get(body.size() - 1) instanceof ReturnValueAVM2Item) && !(body.get(body.size() - 1) instanceof ReturnVoidAVM2Item)) {
                    addRet = true;
                }
            }
            localData.exceptions = new ArrayList<ABCException>();
            localData.callStack.add(mbody);
            ArrayList<GraphSourceItem> src = body == null ? new ArrayList() : this.generate(localData, body);
            mbody.method_info = replaceMethodIndex != null ? replaceMethodIndex.intValue() : this.abcIndex.getSelectedAbc().addMethodInfo(mi);
            ArrayList<AVM2Instruction> mbodyCode = this.toInsList(src);
            mbody.setCode(new AVM2Code(mbodyCode));
            if (needsActivation) {
                ArrayList<AVM2Instruction> acts = new ArrayList<AVM2Instruction>();
                acts.add(this.ins(87, new int[0]));
                acts.add(this.ins(42, new int[0]));
                acts.add(AssignableAVM2Item.generateSetLoc(localData.activationReg));
                acts.add(this.ins(48, new int[0]));
                mbodyCode.addAll(0, acts);
            }
            if (constructor) {
                int parentConstMinAC = 0;
                AbcIndexing.ClassIndex ci = this.abcIndex.findClass(new TypeItem(superType), this.abcIndex.getSelectedAbc(), localData.scriptIndex);
                if (ci != null) {
                    MethodInfo pmi = ci.abc.method_info.get(ci.abc.instance_info.get((int)ci.index).iinit_index);
                    parentConstMinAC = pmi.param_types.length;
                    if (pmi.flagHas_optional()) {
                        parentConstMinAC -= pmi.optional.length;
                    }
                }
                int ac = -1;
                for (AVM2Instruction ins : mbodyCode) {
                    if (!(ins.definition instanceof ConstructSuperIns) || parentConstMinAC <= (ac = ins.operands[0])) continue;
                    throw new CompilationException("Parent constructor call requires different number of arguments", line);
                }
                if (ac == -1) {
                    if (parentConstMinAC == 0) {
                        mbodyCode.add(0, new AVM2Instruction(0L, 208, null));
                        mbodyCode.add(1, new AVM2Instruction(0L, 73, new int[]{0}));
                    } else {
                        throw new CompilationException("Parent constructor must be called", line);
                    }
                }
            }
            for (int i6 = 1; i6 < registerNames.size(); ++i6) {
                mbodyCode.add(i6 - 1, this.ins(239, 1, this.str((String)registerNames.get(i6)), i6 - 1, (Integer)registerLines.get(i6)));
            }
            if (!subMethod) {
                mbodyCode.add(0, new AVM2Instruction(0L, 208, null));
                mbodyCode.add(1, new AVM2Instruction(0L, 48, null));
            }
            if (addRet) {
                if (retType.toString().equals("*") || retType.toString().equals("void") || constructor) {
                    mbodyCode.add(new AVM2Instruction(0L, 71, null));
                } else {
                    mbodyCode.add(new AVM2Instruction(0L, 33, null));
                    mbodyCode.add(new AVM2Instruction(0L, 72, null));
                }
            }
            mbody.exceptions = localData.exceptions.toArray(new ABCException[localData.exceptions.size()]);
            int offset = 0;
            for (int i7 = 0; i7 < mbodyCode.size(); ++i7) {
                AVM2Instruction ins = mbodyCode.get(i7);
                if (ins instanceof ExceptionMarkAVM2Instruction) {
                    ExceptionMarkAVM2Instruction m = (ExceptionMarkAVM2Instruction)ins;
                    switch (m.markType) {
                        case 0: {
                            mbody.exceptions[m.exceptionId].start = offset;
                            break;
                        }
                        case 1: {
                            mbody.exceptions[m.exceptionId].end = offset;
                            break;
                        }
                        case 2: {
                            mbody.exceptions[m.exceptionId].target = offset;
                        }
                    }
                    mbodyCode.remove(i7);
                    --i7;
                    continue;
                }
                offset += ins.getBytesLength();
            }
            mbody.markOffsets();
            mbody.autoFillStats(this.abcIndex.getSelectedAbc(), initScope, classBaseName != null);
            this.abcIndex.getSelectedAbc().addMethodBody(mbody);
            mindex = mbody.method_info;
        } else {
            mindex = replaceMethodIndex != null ? replaceMethodIndex.intValue() : this.abcIndex.getSelectedAbc().addMethodInfo(mi);
        }
        return mindex;
    }

    public ValueKind getValueKind(int ns, GraphTargetItem type, GraphTargetItem val, boolean generatedNs) {
        if (val instanceof BooleanAVM2Item) {
            BooleanAVM2Item bi = (BooleanAVM2Item)val;
            if (bi.value.booleanValue()) {
                return new ValueKind(11, 11);
            }
            return new ValueKind(10, 10);
        }
        boolean isNs = false;
        if (type instanceof NameAVM2Item && ((NameAVM2Item)type).getVariableName().equals("namespace")) {
            isNs = true;
        }
        if (type instanceof TypeItem && ((TypeItem)type).fullTypeName.equals(DottedChain.NAMESPACE)) {
            isNs = true;
        }
        if (val instanceof StringAVM2Item) {
            StringAVM2Item sval = (StringAVM2Item)val;
            if (isNs) {
                return new ValueKind(this.namespace(generatedNs ? 23 : 8, sval.getValue()), 8);
            }
            return new ValueKind(this.str(sval.getValue()), 1);
        }
        if (val instanceof IntegerValueAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getIntId(((IntegerValueAVM2Item)val).value, true), 3);
        }
        if (val instanceof DoubleValueAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getDoubleId(((DoubleValueAVM2Item)val).value, true), 6);
        }
        if (val instanceof DecimalValueAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getDecimalId(((DecimalValueAVM2Item)val).value, true), 2);
        }
        if (val instanceof FloatValueAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getFloatId(((FloatValueAVM2Item)val).value.floatValue(), true), 2);
        }
        if (val instanceof Float4ValueAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getFloat4Id(((Float4ValueAVM2Item)val).value, true), 30);
        }
        if (val instanceof NanAVM2Item) {
            return new ValueKind(this.abcIndex.getSelectedAbc().constants.getDoubleId(Double.NaN, true), 6);
        }
        if (val instanceof NullAVM2Item) {
            return new ValueKind(12, 12);
        }
        if (val instanceof UndefinedAVM2Item) {
            return new ValueKind(0, 0);
        }
        return null;
    }

    public int genNs(List<DottedChain> importedClasses, DottedChain pkg, NamespaceItem ns, List<NamespaceItem> openedNamespaces, SourceGeneratorLocalData localData, int line) throws CompilationException {
        ns.resolveCustomNs(this.abcIndex, importedClasses, pkg, openedNamespaces, localData);
        return ns.getCpoolIndex(this.abcIndex);
    }

    public void generateTraitsPhase2(List<DottedChain> importedClasses, DottedChain pkg, List<GraphTargetItem> items, Trait[] traits, List<NamespaceItem> openedNamespaces, SourceGeneratorLocalData localData) throws CompilationException {
        GraphTargetItem item;
        int k;
        for (k = 0; k < items.size(); ++k) {
            item = items.get(k);
            if (traits[k] == null) continue;
            if (item instanceof InterfaceAVM2Item) {
                traits[k].name_index = this.traitName(((InterfaceAVM2Item)item).pkg == null ? 0 : ((InterfaceAVM2Item)item).pkg.getCpoolIndex(this.abcIndex), ((InterfaceAVM2Item)item).baseName);
                continue;
            }
            if (item instanceof ClassAVM2Item) {
                traits[k].name_index = this.traitName(((ClassAVM2Item)item).pkg == null ? 0 : ((ClassAVM2Item)item).pkg.getCpoolIndex(this.abcIndex), ((ClassAVM2Item)item).classBaseName);
                continue;
            }
            if (item instanceof MethodAVM2Item || item instanceof GetterAVM2Item || item instanceof SetterAVM2Item) {
                traits[k].name_index = this.traitName(this.genNs(importedClasses, pkg, ((MethodAVM2Item)item).pkg, openedNamespaces, localData, ((MethodAVM2Item)item).line), ((MethodAVM2Item)item).functionName);
                continue;
            }
            if (item instanceof FunctionAVM2Item) {
                traits[k].name_index = this.traitName(((FunctionAVM2Item)item).pkg == null ? 0 : ((FunctionAVM2Item)item).pkg.getCpoolIndex(this.abcIndex), ((FunctionAVM2Item)item).functionName);
                continue;
            }
            if (item instanceof ConstAVM2Item) {
                traits[k].name_index = this.traitName(this.genNs(importedClasses, pkg, ((ConstAVM2Item)item).pkg, openedNamespaces, localData, ((ConstAVM2Item)item).line), ((ConstAVM2Item)item).var);
                continue;
            }
            if (!(item instanceof SlotAVM2Item)) continue;
            traits[k].name_index = this.traitName(this.genNs(importedClasses, pkg, ((SlotAVM2Item)item).pkg, openedNamespaces, localData, ((SlotAVM2Item)item).line), ((SlotAVM2Item)item).var);
        }
        for (k = 0; k < items.size(); ++k) {
            item = items.get(k);
            if (traits[k] == null) continue;
            if (item instanceof ClassAVM2Item) {
                localData.currentClassBaseName = ((ClassAVM2Item)item).classBaseName;
                InstanceInfo instanceInfo = this.abcIndex.getSelectedAbc().instance_info.get(((TraitClass)traits[k]).class_info);
                instanceInfo.name_index = this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.abcIndex.getSelectedAbc().constants.getStringId(((ClassAVM2Item)item).classBaseName, true), ((ClassAVM2Item)item).pkg.getCpoolIndex(this.abcIndex)), true);
                localData.currentClassBaseName = null;
            }
            if (!(item instanceof InterfaceAVM2Item)) continue;
            localData.currentClassBaseName = ((InterfaceAVM2Item)item).baseName;
            ABC abc = this.abcIndex.getSelectedAbc();
            AVM2ConstantPool constants = abc.constants;
            InstanceInfo instanceInfo = abc.instance_info.get(((TraitClass)traits[k]).class_info);
            instanceInfo.name_index = constants.getMultinameId(Multiname.createQName(false, constants.getStringId(((InterfaceAVM2Item)item).baseName, true), ((InterfaceAVM2Item)item).pkg.getCpoolIndex(this.abcIndex)), true);
            localData.currentClassBaseName = null;
        }
    }

    public void generateTraitsPhase3(List<GraphTargetItem> items, Trait[] traits, SourceGeneratorLocalData localData) throws CompilationException {
        for (int k = 0; k < items.size(); ++k) {
            int oldClassIndex;
            int i;
            int minClassIndex;
            GraphTargetItem item = items.get(k);
            if (traits[k] == null) continue;
            if (item instanceof ClassAVM2Item) {
                int foundClass;
                minClassIndex = -1;
                localData.currentClassBaseName = ((ClassAVM2Item)item).classBaseName;
                InstanceInfo instanceInfo = this.abcIndex.getSelectedAbc().instance_info.get(((TraitClass)traits[k]).class_info);
                ABC abc = this.abcIndex.getSelectedAbc();
                instanceInfo.super_index = ((ClassAVM2Item)item).extendsOp != null ? this.typeName(localData, ((ClassAVM2Item)item).extendsOp) : this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.str("Object"), this.namespace(22, "")), true);
                if (instanceInfo.super_index != 0 && (foundClass = abc.findClassByName(abc.constants.getMultiname(instanceInfo.super_index).getNameWithNamespace(new LinkedHashSet<String>(), abc, abc.constants, true))) > -1 && foundClass > minClassIndex) {
                    minClassIndex = foundClass;
                }
                instanceInfo.interfaces = new int[((ClassAVM2Item)item).implementsOp.size()];
                for (i = 0; i < ((ClassAVM2Item)item).implementsOp.size(); ++i) {
                    instanceInfo.interfaces[i] = this.superIntName(localData, ((ClassAVM2Item)item).implementsOp.get(i));
                    int foundIface = abc.findClassByName(abc.constants.getMultiname(instanceInfo.interfaces[i]).getNameWithNamespace(new LinkedHashSet<String>(), abc, abc.constants, true));
                    if (foundIface <= -1 || foundIface <= minClassIndex) continue;
                    minClassIndex = foundIface;
                }
                oldClassIndex = ((TraitClass)traits[k]).class_info;
                if (oldClassIndex <= minClassIndex) {
                    abc.moveClass(oldClassIndex, minClassIndex + 1);
                }
                localData.currentClassBaseName = null;
            }
            if (!(item instanceof InterfaceAVM2Item)) continue;
            minClassIndex = -1;
            localData.currentClassBaseName = ((InterfaceAVM2Item)item).baseName;
            ABC abc = this.abcIndex.getSelectedAbc();
            InstanceInfo instanceInfo = abc.instance_info.get(((TraitClass)traits[k]).class_info);
            instanceInfo.interfaces = new int[((InterfaceAVM2Item)item).superInterfaces.size()];
            for (i = 0; i < ((InterfaceAVM2Item)item).superInterfaces.size(); ++i) {
                GraphTargetItem un = ((InterfaceAVM2Item)item).superInterfaces.get(i);
                instanceInfo.interfaces[i] = this.superIntName(localData, un);
                int foundIface = abc.findClassByName(abc.constants.getMultiname(instanceInfo.interfaces[i]).getNameWithNamespace(new LinkedHashSet<String>(), abc, abc.constants, true));
                if (foundIface <= -1 || foundIface <= minClassIndex) continue;
                minClassIndex = foundIface;
            }
            oldClassIndex = ((TraitClass)traits[k]).class_info;
            if (oldClassIndex <= minClassIndex) {
                abc.moveClass(oldClassIndex, minClassIndex + 1);
            }
            localData.currentClassBaseName = null;
        }
    }

    public int superIntName(SourceGeneratorLocalData localData, GraphTargetItem un) throws CompilationException {
        if (un instanceof UnresolvedAVM2Item) {
            ((UnresolvedAVM2Item)un).resolve(localData, localData.getFullClass(), null, new ArrayList<GraphTargetItem>(), new ArrayList<String>(), this.abcIndex, new ArrayList<MethodBody>(), new ArrayList<AssignableAVM2Item>());
            un = ((UnresolvedAVM2Item)un).resolved;
        }
        if (!(un instanceof TypeItem)) {
            throw new CompilationException("Invalid type", 0);
        }
        TypeItem sup = (TypeItem)un;
        int propId = AVM2SourceGenerator.resolveType(localData, sup, this.abcIndex);
        int[] nss = new int[]{this.abcIndex.getSelectedAbc().constants.getMultiname((int)propId).namespace_index};
        return this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createMultiname(false, this.abcIndex.getSelectedAbc().constants.getMultiname((int)propId).name_index, this.abcIndex.getSelectedAbc().constants.getNamespaceSetId(nss, true)), true);
    }

    public int[] generateMetadata(List<Map.Entry<String, Map<String, String>>> metadata, ABC abc) {
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (int i = 0; i < metadata.size(); ++i) {
            Map.Entry<String, Map<String, String>> en = metadata.get(i);
            if ("API".equals(en.getKey()) && abc.isApiVersioned()) continue;
            int[] keys = new int[en.getValue().size()];
            int[] values = new int[en.getValue().size()];
            int j = 0;
            for (String key : en.getValue().keySet()) {
                keys[j] = this.abcIndex.getSelectedAbc().constants.getStringId(key, true);
                values[j] = this.abcIndex.getSelectedAbc().constants.getStringId(en.getValue().get(key), true);
                ++j;
            }
            MetadataInfo mi = new MetadataInfo(this.abcIndex.getSelectedAbc().constants.getStringId(en.getKey(), true), keys, values);
            retList.add(this.abcIndex.getSelectedAbc().metadata_info.size());
            this.abcIndex.getSelectedAbc().metadata_info.add(mi);
        }
        int[] ret = new int[retList.size()];
        for (int i = 0; i < retList.size(); ++i) {
            ret[i] = (Integer)retList.get(i);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public void generateTraitsPhase4(List<DottedChain> importedClasses, List<NamespaceItem> openedNamespaces, int methodInitScope, boolean isInterface, String className, String superName, boolean generateStatic, SourceGeneratorLocalData localData, List<GraphTargetItem> items, Traits ts, Trait[] traits, Map<Trait, Integer> initScopes, Reference<Integer> class_index, boolean isScriptTraits) throws AVM2ParseException, CompilationException {
        FunctionAVM2Item fai;
        Object suffix;
        MethodAVM2Item mai;
        GraphTargetItem item;
        int k;
        for (k = 0; k < items.size(); ++k) {
            Object trait;
            ABC abc;
            item = items.get(k);
            if (traits[k] == null) continue;
            if (item instanceof SlotAVM2Item || item instanceof ConstAVM2Item) {
                void var19_24;
                TraitSlotConst tsc = (TraitSlotConst)traits[k];
                GraphTargetItem val = null;
                Object var19_20 = null;
                boolean isNamespace = false;
                int namespace = 0;
                boolean isStatic = false;
                int[] metadata = new int[]{};
                if (item instanceof SlotAVM2Item) {
                    SlotAVM2Item sai = (SlotAVM2Item)item;
                    if (!isScriptTraits && sai.isStatic() != generateStatic) continue;
                    val = sai.value;
                    GraphTargetItem graphTargetItem = sai.type;
                    isStatic = sai.isStatic();
                    if (sai.pkg != null) {
                        sai.pkg.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, openedNamespaces, localData);
                    }
                    namespace = sai.pkg == null ? 0 : sai.pkg.getCpoolIndex(this.abcIndex);
                }
                boolean generatedNs = false;
                if (item instanceof ConstAVM2Item) {
                    ConstAVM2Item cai = (ConstAVM2Item)item;
                    generatedNs = cai.generatedNs;
                    if (!isScriptTraits && cai.isStatic() != generateStatic) continue;
                    val = cai.value;
                    GraphTargetItem graphTargetItem = cai.type;
                    if (cai.pkg != null) {
                        cai.pkg.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, openedNamespaces, localData);
                    }
                    namespace = cai.pkg == null ? 0 : cai.pkg.getCpoolIndex(this.abcIndex);
                    isNamespace = cai.ns;
                    isStatic = cai.isStatic();
                }
                tsc.type_index = isNamespace ? 0 : (var19_24 == null ? 0 : this.typeName(localData, (GraphTargetItem)var19_24));
                ValueKind vk = this.getValueKind(namespace, (GraphTargetItem)var19_24, val, generatedNs);
                if (vk == null) {
                    tsc.value_index = 0;
                    tsc.value_kind = 0;
                } else {
                    tsc.value_kind = vk.value_kind;
                    tsc.value_index = vk.value_index;
                }
            }
            if (item instanceof InterfaceAVM2Item) {
                abc = this.abcIndex.getSelectedAbc();
                trait = (TraitClass)traits[k];
                InterfaceAVM2Item interfaceAVM2Item = (InterfaceAVM2Item)item;
                this.generateClass(interfaceAVM2Item.pkg.getCpoolIndex(this.abcIndex), abc.class_info.get(((TraitClass)trait).class_info), abc.instance_info.get(((TraitClass)trait).class_info), initScopes.get(trait), interfaceAVM2Item.pkg.name, localData, interfaceAVM2Item, class_index);
            }
            if (item instanceof ClassAVM2Item) {
                abc = this.abcIndex.getSelectedAbc();
                trait = (TraitClass)traits[k];
                ClassAVM2Item classAVM2Item = (ClassAVM2Item)item;
                this.generateClass(classAVM2Item.pkg.getCpoolIndex(this.abcIndex), abc.class_info.get(((TraitClass)trait).class_info), abc.instance_info.get(((TraitClass)trait).class_info), initScopes.get(trait), classAVM2Item.pkg.name, localData, classAVM2Item, class_index);
            }
            if (item instanceof MethodAVM2Item || item instanceof GetterAVM2Item || item instanceof SetterAVM2Item) {
                mai = (MethodAVM2Item)item;
                if (!isScriptTraits && mai.isStatic() != generateStatic) continue;
                for (List list : mai.allOpenedNamespaces) {
                    for (NamespaceItem n : list) {
                        n.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, list, localData);
                    }
                }
                suffix = null;
                if (item instanceof GetterAVM2Item) {
                    suffix = "get";
                }
                if (item instanceof SetterAVM2Item) {
                    suffix = "set";
                }
                ((TraitMethodGetterSetter)traits[k]).method_info = this.methodHeader(mai.isStatic(), this.methodName(mai.outsidePackage, localData.pkg, mai.functionName, mai.pkg, className, mai.customNamespace, (String)suffix), false, isInterface, mai.isNative, new ArrayList<MethodBody>(), localData.pkg, mai.needsActivation, mai.subvariables, methodInitScope + (mai.isStatic() ? 0 : 1), mai.hasRest, mai.line, className, superName, false, localData, mai.paramTypes, mai.paramNames, mai.paramValues, mai.body, mai.retType);
                continue;
            }
            if (!(item instanceof FunctionAVM2Item)) continue;
            fai = (FunctionAVM2Item)item;
            ((TraitFunction)traits[k]).method_info = this.methodHeader(false, this.methodName(false, localData.pkg, fai.functionName, fai.pkg, null, null, ""), false, isInterface, fai.isNative, new ArrayList<MethodBody>(), localData.pkg, fai.needsActivation, fai.subvariables, methodInitScope, fai.hasRest, fai.line, className, superName, false, localData, fai.paramTypes, fai.paramNames, fai.paramValues, fai.body, fai.retType);
        }
        this.abcIndex.refreshSelected();
        for (k = 0; k < items.size(); ++k) {
            item = items.get(k);
            if (traits[k] == null) continue;
            if (item instanceof MethodAVM2Item || item instanceof GetterAVM2Item || item instanceof SetterAVM2Item) {
                mai = (MethodAVM2Item)item;
                if (!isScriptTraits && mai.isStatic() != generateStatic) continue;
                for (List<NamespaceItem> list : mai.allOpenedNamespaces) {
                    for (NamespaceItem n : list) {
                        n.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, list, localData);
                    }
                }
                suffix = null;
                if (item instanceof GetterAVM2Item) {
                    suffix = "get";
                }
                if (item instanceof SetterAVM2Item) {
                    suffix = "set";
                }
                ((TraitMethodGetterSetter)traits[k]).method_info = this.method(((TraitMethodGetterSetter)traits[k]).method_info, mai.isStatic(), this.methodName(mai.outsidePackage, localData.pkg, mai.functionName, mai.pkg, className, mai.customNamespace, (String)suffix), false, isInterface, mai.isNative, new ArrayList<MethodBody>(), localData.pkg, mai.needsActivation, mai.subvariables, methodInitScope + (mai.isStatic() ? 0 : 1), mai.hasRest, mai.line, className, superName, false, localData, mai.paramTypes, mai.paramNames, mai.paramValues, mai.body, mai.retType);
                continue;
            }
            if (!(item instanceof FunctionAVM2Item)) continue;
            fai = (FunctionAVM2Item)item;
            ((TraitFunction)traits[k]).method_info = this.method(((TraitFunction)traits[k]).method_info, false, this.methodName(false, localData.pkg, fai.functionName, fai.pkg, null, null, ""), false, isInterface, fai.isNative, new ArrayList<MethodBody>(), localData.pkg, fai.needsActivation, fai.subvariables, methodInitScope, fai.hasRest, fai.line, className, superName, false, localData, fai.paramTypes, fai.paramNames, fai.paramValues, fai.body, fai.retType);
        }
    }

    private int methodName(boolean outsidePkg, DottedChain pkg, String methodName, NamespaceItem ns, String className, String customNs, String typeSuffix) {
        StringBuilder sb = new StringBuilder();
        if (className != null) {
            if (pkg != null && !pkg.isEmpty() && !pkg.isTopLevel()) {
                sb.append(pkg.toRawString());
                sb.append(":");
            }
            sb.append(className);
        }
        if (customNs != null) {
            sb.append(customNs);
        } else if (ns != null) {
            switch (ns.kind) {
                case 23: {
                    sb.append(pkg == null ? "" : pkg.toRawString());
                    break;
                }
                case 5: {
                    if (outsidePkg) break;
                    sb.append("/private");
                    break;
                }
                case 24: 
                case 26: {
                    sb.append("/protected");
                }
            }
        }
        sb.append("/");
        sb.append(methodName);
        if (typeSuffix != null && !typeSuffix.isEmpty()) {
            sb.append("/");
            sb.append(typeSuffix);
        }
        return this.abcIndex.getSelectedAbc().constants.getStringId(sb.toString(), true);
    }

    public Trait[] generateTraitsPhase1(List<DottedChain> importedClasses, List<NamespaceItem> openedNamespaces, String className, String superName, boolean generateStatic, SourceGeneratorLocalData localData, List<GraphTargetItem> items, Traits ts, Reference<Integer> classIndex, boolean isScriptTraits) throws AVM2ParseException, CompilationException {
        Trait[] traits = new Trait[items.size()];
        int slot_id = 1;
        int disp_id = 3;
        for (int k = 0; k < items.size(); ++k) {
            InstanceInfo ii;
            ClassInfo ci;
            TraitClass tc;
            GraphTargetItem item = items.get(k);
            if (item instanceof InterfaceAVM2Item) {
                tc = new TraitClass();
                ci = new ClassInfo();
                ii = new InstanceInfo();
                tc.class_info = classIndex.getVal();
                this.abcIndex.getSelectedAbc().addClass(ci, ii, classIndex.getVal());
                classIndex.setVal(classIndex.getVal() + 1);
                ii.flags |= 4;
                tc.kindType = 4;
                tc.slot_id = 0;
                ts.traits.add(tc);
                traits[k] = tc;
                traits[k].metadata = this.generateMetadata(((InterfaceAVM2Item)item).metadata, this.abcIndex.getSelectedAbc());
                if (traits[k].metadata.length > 0) {
                    traits[k].kindFlags |= 4;
                }
            }
            if (item instanceof ClassAVM2Item) {
                tc = new TraitClass();
                ci = new ClassInfo();
                ii = new InstanceInfo();
                tc.class_info = classIndex.getVal();
                this.abcIndex.getSelectedAbc().addClass(ci, ii, classIndex.getVal());
                classIndex.setVal(classIndex.getVal() + 1);
                tc.kindType = 4;
                tc.slot_id = slot_id++;
                ts.traits.add(tc);
                traits[k] = tc;
                traits[k].metadata = this.generateMetadata(((ClassAVM2Item)item).metadata, this.abcIndex.getSelectedAbc());
                if (traits[k].metadata.length > 0) {
                    traits[k].kindFlags |= 4;
                }
            }
            if (item instanceof SlotAVM2Item || item instanceof ConstAVM2Item) {
                TraitSlotConst tsc = new TraitSlotConst();
                tsc.kindType = item instanceof SlotAVM2Item ? 0 : 6;
                String var = null;
                GraphTargetItem type = null;
                boolean isNamespace = false;
                int namespace = 0;
                boolean isStatic = false;
                int[] metadata = new int[]{};
                if (item instanceof SlotAVM2Item) {
                    SlotAVM2Item sai = (SlotAVM2Item)item;
                    if (!isScriptTraits && sai.isStatic() != generateStatic) continue;
                    var = sai.var;
                    type = sai.type;
                    isStatic = sai.isStatic();
                    if (sai.pkg != null) {
                        sai.pkg.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, openedNamespaces, localData);
                    }
                    namespace = sai.pkg == null ? 0 : sai.pkg.getCpoolIndex(this.abcIndex);
                    metadata = this.generateMetadata(((SlotAVM2Item)item).metadata, this.abcIndex.getSelectedAbc());
                }
                boolean generatedNs = false;
                if (item instanceof ConstAVM2Item) {
                    ConstAVM2Item cai = (ConstAVM2Item)item;
                    generatedNs = cai.generatedNs;
                    if (!isScriptTraits && cai.isStatic() != generateStatic) continue;
                    var = cai.var;
                    type = cai.type;
                    if (cai.pkg != null) {
                        cai.pkg.resolveCustomNs(this.abcIndex, importedClasses, localData.pkg, openedNamespaces, localData);
                    }
                    namespace = cai.pkg == null ? 0 : cai.pkg.getCpoolIndex(this.abcIndex);
                    isNamespace = type.toString().equals("Namespace");
                    isStatic = cai.isStatic();
                    metadata = this.generateMetadata(((ConstAVM2Item)item).metadata, this.abcIndex.getSelectedAbc());
                }
                if (isNamespace) {
                    tsc.name_index = this.traitName(namespace, var);
                }
                tsc.slot_id = !isScriptTraits && isStatic ? slot_id++ : 0;
                ts.traits.add(tsc);
                traits[k] = tsc;
                traits[k].metadata = metadata;
                if (traits[k].metadata.length > 0) {
                    traits[k].kindFlags |= 4;
                }
            }
            if (!(item instanceof MethodAVM2Item) && !(item instanceof GetterAVM2Item) && !(item instanceof SetterAVM2Item)) continue;
            MethodAVM2Item mai = (MethodAVM2Item)item;
            if (!isScriptTraits && mai.isStatic() != generateStatic) continue;
            TraitMethodGetterSetter tmgs = new TraitMethodGetterSetter();
            tmgs.kindType = item instanceof GetterAVM2Item ? 2 : (item instanceof SetterAVM2Item ? 3 : 1);
            int n = tmgs.disp_id = mai.isStatic() ? disp_id++ : 0;
            if (mai.isFinal() || className != null && mai.isStatic()) {
                tmgs.kindFlags |= 1;
            }
            if (mai.isOverride()) {
                tmgs.kindFlags |= 2;
            }
            ts.traits.add(tmgs);
            traits[k] = tmgs;
            traits[k].metadata = this.generateMetadata(((MethodAVM2Item)item).metadata, this.abcIndex.getSelectedAbc());
            if (traits[k].metadata.length <= 0) continue;
            traits[k].kindFlags |= 4;
        }
        return traits;
    }

    public void generateScriptInfo(List<AssignableAVM2Item> sinitVariables, boolean sinitNeedsActivation, List<DottedChain> importedClasses, List<NamespaceItem> openedNamespaces, int scriptIndex, ScriptInfo scriptInfo, List<List<NamespaceItem>> allOpenedNamespaces, SourceGeneratorLocalData localData, List<GraphTargetItem> commands, int classPos) throws AVM2ParseException, CompilationException {
        ArrayList<GraphTargetItem> traitsList = new ArrayList<GraphTargetItem>();
        for (GraphTargetItem it : commands) {
            if (!(it instanceof SlotAVM2Item) && !(it instanceof ConstAVM2Item) && !(it instanceof ClassAVM2Item) && !(it instanceof InterfaceAVM2Item) && !(it instanceof MethodAVM2Item) && !(it instanceof GetterAVM2Item) && !(it instanceof SetterAVM2Item)) continue;
            traitsList.add(it);
        }
        Reference<Integer> class_index = new Reference<Integer>(classPos);
        localData.currentScript = scriptInfo;
        localData.scriptIndex = scriptIndex;
        Trait[] traitArr = this.generateTraitsPhase1(new ArrayList<DottedChain>(), new ArrayList<NamespaceItem>(), null, null, true, localData, traitsList, scriptInfo.traits, class_index, true);
        this.generateTraitsPhase2(new ArrayList<DottedChain>(), null, traitsList, traitArr, new ArrayList<NamespaceItem>(), localData);
        this.abcIndex.refreshSelected();
        this.generateTraitsPhase3(traitsList, traitArr, localData);
        this.abcIndex.refreshSelected();
        ABC abc = this.abcIndex.getSelectedAbc();
        AVM2ConstantPool constants = abc.constants;
        MethodInfo mi = new MethodInfo(new int[0], 0, constants.getStringId("", true), 0, new ValueKind[0], new int[0]);
        localData.importedClasses = importedClasses;
        localData.openedNamespaces = openedNamespaces;
        int sinit_index = this.method(null, true, this.str(""), false, false, false, new ArrayList<MethodBody>(), null, sinitNeedsActivation, sinitVariables, 0, false, 0, null, null, false, localData, new ArrayList<GraphTargetItem>(), new ArrayList<String>(), new ArrayList<GraphTargetItem>(), commands, TypeItem.UNBOUNDED);
        MethodBody mb = this.abcIndex.getSelectedAbc().findBody(sinit_index);
        List<AVM2Instruction> mbCode = mb.getCode().code;
        int traitScope = 1;
        String documentClassStr = localData.documentClass;
        DottedChain documentClass = null;
        if (documentClassStr != null && !documentClassStr.isEmpty()) {
            documentClass = DottedChain.parseNoSuffix(documentClassStr);
        }
        HashMap<Trait, Integer> initScopes = new HashMap<Trait, Integer>();
        ArrayList<AVM2Instruction> sinitcode = new ArrayList<AVM2Instruction>();
        for (Trait t : scriptInfo.traits.traits) {
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            DottedChain className = tc.getName(abc).getNameWithNamespace(new LinkedHashSet<String>(), abc, abc.constants, true);
            ArrayList<Integer> parents = new ArrayList<Integer>();
            if (documentClass != null && documentClass.equals(className)) {
                sinitcode.add(this.ins(101, 0));
            } else {
                int[] nsset = new int[]{constants.getMultiname((int)tc.name_index).namespace_index};
                sinitcode.add(this.ins(93, constants.getMultinameId(Multiname.createMultiname(false, constants.getMultiname((int)tc.name_index).name_index, constants.getNamespaceSetId(nsset, true)), true)));
            }
            ++traitScope;
            if (abc.instance_info.get(tc.class_info).isInterface()) {
                sinitcode.add(this.ins(32, new int[0]));
            } else {
                AbcIndexing.ClassIndex ci = this.abcIndex.findClass(AbcIndexing.multinameToType(new LinkedHashSet<String>(), abc.instance_info.get((int)tc.class_info).name_index, abc, constants), abc, scriptIndex);
                while (ci != null && ci.parent != null) {
                    ci = ci.parent;
                    Multiname origM = ci.abc.constants.getMultiname(ci.abc.instance_info.get((int)ci.index).name_index);
                    Namespace origNs = ci.abc.constants.getNamespace(origM.namespace_index);
                    if (origM.kind != 7 && origM.kind != 13) continue;
                    parents.add(constants.getMultinameId(Multiname.createQName(origM.kind == 13, constants.getStringId(ci.abc.constants.getString(origM.name_index), true), constants.getNamespaceId(origNs.kind, ci.abc.constants.getString(origNs.name_index), 0, true)), true));
                }
                for (int i = parents.size() - 1; i >= 0; --i) {
                    sinitcode.add(this.ins(96, (Integer)parents.get(i)));
                    sinitcode.add(this.ins(48, new int[0]));
                    ++traitScope;
                }
                if (!parents.isEmpty()) {
                    sinitcode.add(this.ins(96, (Integer)parents.get(0)));
                }
            }
            sinitcode.add(this.ins(88, tc.class_info));
            for (int i = 0; i < parents.size(); ++i) {
                sinitcode.add(this.ins(29, new int[0]));
            }
            sinitcode.add(this.ins(104, tc.name_index));
            initScopes.put(t, traitScope);
            traitScope = 1;
        }
        mbCode.addAll(2, sinitcode);
        scriptInfo.init_index = mb.method_info;
        localData.pkg = DottedChain.EMPTY;
        this.generateTraitsPhase4(new ArrayList<DottedChain>(), new ArrayList<NamespaceItem>(), 1, false, null, null, true, localData, traitsList, scriptInfo.traits, traitArr, initScopes, class_index, true);
        mb.markOffsets();
        mb.autoFillStats(abc, 1, false);
    }

    public static void parentNamesAddNames(AbcIndexing abc, Integer scriptIndex, int name_index, List<Integer> indices, List<String> names, List<String> namespaces) {
        ArrayList<Integer> cindices = new ArrayList<Integer>();
        ArrayList<ABC> outABCs = new ArrayList<ABC>();
        AVM2SourceGenerator.parentNames(abc, scriptIndex, name_index, cindices, names, namespaces, outABCs);
        for (int i = 0; i < cindices.size(); ++i) {
            ABC a = (ABC)outABCs.get(i);
            int m = (Integer)cindices.get(i);
            if (a == abc.getSelectedAbc()) {
                indices.add(m);
                continue;
            }
            Multiname superName = a.constants.getMultiname(m);
            indices.add(abc.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, abc.getSelectedAbc().constants.getStringId(superName.getName(new LinkedHashSet<String>(), a, a.constants, null, true, true), true), abc.getSelectedAbc().constants.getNamespaceId(superName.getNamespace((AVM2ConstantPool)a.constants).kind, superName.getNamespace(a.constants).getName(a.constants), 0, true)), true));
        }
    }

    public static GraphTargetItem getTraitReturnType(AbcIndexing abc, Trait t) {
        if (t instanceof TraitSlotConst) {
            TraitSlotConst tsc = (TraitSlotConst)t;
            if (tsc.type_index == 0) {
                return TypeItem.UNBOUNDED;
            }
            return AbcIndexing.multinameToType(new LinkedHashSet<String>(), tsc.type_index, abc.getSelectedAbc(), abc.getSelectedAbc().constants);
        }
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
            if (tmgs.kindType == 2) {
                return AbcIndexing.multinameToType(new LinkedHashSet<String>(), abc.getSelectedAbc().method_info.get((int)tmgs.method_info).ret_type, abc.getSelectedAbc(), abc.getSelectedAbc().constants);
            }
            if (tmgs.kindType == 3) {
                if (abc.getSelectedAbc().method_info.get((int)tmgs.method_info).param_types.length > 0) {
                    return AbcIndexing.multinameToType(new LinkedHashSet<String>(), abc.getSelectedAbc().method_info.get((int)tmgs.method_info).param_types[0], abc.getSelectedAbc(), abc.getSelectedAbc().constants);
                }
                return TypeItem.UNBOUNDED;
            }
        }
        if (t instanceof TraitFunction) {
            return new TypeItem(DottedChain.FUNCTION);
        }
        return TypeItem.UNBOUNDED;
    }

    public static boolean searchPrototypeChain(Integer namespaceSuffix, List<Integer> otherNs, int privateNs, int protectedNs, boolean instanceOnly, AbcIndexing abc, DottedChain pkg, String obj, String propertyName, Reference<String> outName, Reference<DottedChain> outNs, Reference<DottedChain> outPropNs, Reference<Integer> outPropNsKind, Reference<Integer> outPropNsIndex, Reference<GraphTargetItem> outPropType, Reference<ValueKind> outPropValue, Reference<ABC> outPropValueAbc, Reference<Boolean> isType, Reference<Trait> outPropTrait) {
        if (namespaceSuffix != null && AVM2SourceGenerator.searchPrototypeChain(namespaceSuffix, instanceOnly, abc, pkg, obj, propertyName, outName, outNs, outPropNs, outPropNsKind, outPropNsIndex, outPropType, outPropValue, outPropValueAbc, isType, outPropTrait)) {
            return true;
        }
        if (AVM2SourceGenerator.searchPrototypeChain(privateNs, instanceOnly, abc, pkg, obj, propertyName, outName, outNs, outPropNs, outPropNsKind, outPropNsIndex, outPropType, outPropValue, outPropValueAbc, isType, outPropTrait)) {
            return true;
        }
        if (AVM2SourceGenerator.searchPrototypeChain(protectedNs, instanceOnly, abc, pkg, obj, propertyName, outName, outNs, outPropNs, outPropNsKind, outPropNsIndex, outPropType, outPropValue, outPropValueAbc, isType, outPropTrait)) {
            return true;
        }
        for (int ns : otherNs) {
            if (!AVM2SourceGenerator.searchPrototypeChain(ns, instanceOnly, abc, pkg, obj, propertyName, outName, outNs, outPropNs, outPropNsKind, outPropNsIndex, outPropType, outPropValue, outPropValueAbc, isType, outPropTrait)) continue;
            return true;
        }
        return AVM2SourceGenerator.searchPrototypeChain(0, instanceOnly, abc, pkg, obj, propertyName, outName, outNs, outPropNs, outPropNsKind, outPropNsIndex, outPropType, outPropValue, outPropValueAbc, isType, outPropTrait);
    }

    private static boolean searchPrototypeChain(int selectedNs, boolean instanceOnly, AbcIndexing abc, DottedChain pkg, String obj, String propertyName, Reference<String> outName, Reference<DottedChain> outNs, Reference<DottedChain> outPropNs, Reference<Integer> outPropNsKind, Reference<Integer> outPropNsIndex, Reference<GraphTargetItem> outPropType, Reference<ValueKind> outPropValue, Reference<ABC> outPropValueAbc, Reference<Boolean> isType, Reference<Trait> outPropTrait) {
        isType.setVal(false);
        AbcIndexing.TraitIndex sp = abc.findScriptProperty(pkg.addWithSuffix(propertyName));
        if (sp == null) {
            Reference<Object> foundStatic = new Reference<Object>(null);
            sp = abc.findProperty(new AbcIndexing.PropertyDef(propertyName, new TypeItem(pkg.addWithSuffix(obj)), abc.getSelectedAbc(), selectedNs), !instanceOnly, true, true, foundStatic);
        }
        if (sp != null) {
            if (sp.trait instanceof TraitClass) {
                isType.setVal(true);
            }
            if (sp.objType instanceof TypeItem) {
                outName.setVal(((TypeItem)sp.objType).fullTypeName.getLast());
                outNs.setVal(((TypeItem)sp.objType).fullTypeName.getWithoutLast());
            }
            outPropNs.setVal(sp.trait.getName(sp.abc).getNamespace(sp.abc.constants).getName(sp.abc.constants));
            outPropNsKind.setVal(sp.trait.getName((ABC)sp.abc).getNamespace((AVM2ConstantPool)sp.abc.constants).kind);
            int nsi = sp.trait.getName((ABC)sp.abc).namespace_index;
            outPropNsIndex.setVal(sp.abc == abc.getSelectedAbc() ? sp.abc.constants.getNamespaceSubIndex(nsi) : 0);
            outPropType.setVal(sp.returnType);
            outPropValue.setVal(sp.value);
            outPropValueAbc.setVal(sp.abc);
            outPropTrait.setVal(sp.trait);
            return true;
        }
        return false;
    }

    public static void parentNames(AbcIndexing abc, Integer scriptIndex, int name_index, List<Integer> indices, List<String> names, List<String> namespaces, List<ABC> outABCs) {
        AbcIndexing.ClassIndex ci = abc.findClass(new TypeItem(abc.getSelectedAbc().constants.getMultiname(name_index).getNameWithNamespace(new LinkedHashSet<String>(), abc.getSelectedAbc(), abc.getSelectedAbc().constants, true)), abc.getSelectedAbc(), scriptIndex);
        while (ci != null) {
            int ni = ci.abc.instance_info.get((int)ci.index).name_index;
            indices.add(ni);
            outABCs.add(ci.abc);
            names.add(ci.abc.constants.getMultiname(ni).getName(new LinkedHashSet<String>(), ci.abc, ci.abc.constants, null, true, true));
            namespaces.add(ci.abc.constants.getMultiname(ni).getNamespace(ci.abc.constants).getName(ci.abc.constants).toRawString());
            ci = ci.parent;
        }
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, FalseItem item) throws CompilationException {
        return GraphTargetItem.toSourceMerge(localData, this, this.ins(39, new int[0]));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TrueItem item) throws CompilationException {
        return GraphTargetItem.toSourceMerge(localData, this, this.ins(38, new int[0]));
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, GetDescendantsAVM2Item item) throws CompilationException {
        AVM2ConstantPool constants = this.abcIndex.getSelectedAbc().constants;
        int[] nssa = new int[item.openedNamespaces.size()];
        for (int i = 0; i < item.openedNamespaces.size(); ++i) {
            nssa[i] = item.openedNamespaces.get(i).getCpoolIndex(this.abcIndex);
        }
        int nsset = constants.getNamespaceSetId(nssa, true);
        return GraphTargetItem.toSourceMerge(localData, this, item.object, this.ins(89, constants.getMultinameId(Multiname.createMultiname(false, constants.getStringId(item.nameStr, true), nsset), true)));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, AndItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generateToActionList(localData, item.leftSide));
        ret.add(this.ins(42, new int[0]));
        if (!("" + item.leftSide.returnType()).equals("Boolean")) {
            ret.add(this.ins(118, new int[0]));
        }
        List<AVM2Instruction> andExpr = this.generateToActionList(localData, item.rightSide);
        andExpr.add(0, this.ins(41, new int[0]));
        int andExprLen = this.insToBytes(andExpr).length;
        ret.add(this.ins(18, andExprLen));
        ret.addAll(andExpr);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, OrItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generateToActionList(localData, item.leftSide));
        ret.add(this.ins(42, new int[0]));
        if (!("" + item.leftSide.returnType()).equals("Boolean")) {
            ret.add(this.ins(118, new int[0]));
        }
        List<AVM2Instruction> orExpr = this.generateToActionList(localData, item.rightSide);
        orExpr.add(0, this.ins(41, new int[0]));
        int orExprLen = this.insToBytes(orExpr).length;
        ret.add(this.ins(17, orExprLen));
        ret.addAll(orExpr);
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, XMLFilterAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        Reference<Integer> counterReg = new Reference<Integer>(0);
        Reference<Integer> collectionReg = new Reference<Integer>(0);
        Reference<Integer> xmlListReg = new Reference<Integer>(0);
        List<GraphSourceItem> xmlListSetTemp = AssignableAVM2Item.setTemp(localData, this, xmlListReg);
        AVM2ConstantPool constants = this.abcIndex.getSelectedAbc().constants;
        ret.addAll(GraphTargetItem.toSourceMerge(localData, this, this.ins(36, 0), AssignableAVM2Item.setTemp(localData, this, counterReg), item.object, this.ins(120, new int[0]), NameAVM2Item.generateCoerce(localData, this, TypeItem.UNBOUNDED), AssignableAVM2Item.setTemp(localData, this, collectionReg), this.ins(96, constants.getMultinameId(Multiname.createQName(false, constants.getStringId("XMLList", true), constants.getNamespaceId(22, "", 0, true)), true)), this.ins(44, constants.getStringId("", true)), this.ins(66, 1), xmlListSetTemp));
        Reference<Integer> tempVal1 = new Reference<Integer>(0);
        Reference<Integer> tempVal2 = new Reference<Integer>(0);
        ArrayList<AVM2Instruction> forBody = this.toInsList(GraphTargetItem.toSourceMerge(localData, this, this.ins(9, new int[0]), AssignableAVM2Item.getTemp(localData, this, collectionReg), AssignableAVM2Item.getTemp(localData, this, counterReg), this.ins(35, new int[0]), AssignableAVM2Item.dupSetTemp(localData, this, tempVal1), AssignableAVM2Item.dupSetTemp(localData, this, tempVal2), this.ins(28, new int[0])));
        localData.scopeStack.add(new LocalRegAVM2Item(null, null, tempVal2.getVal(), null, (GraphTargetItem)new TypeItem("Object")));
        forBody.addAll(this.toInsList(item.value.toSource(localData, this)));
        ArrayList<AVM2Instruction> trueBody = new ArrayList<AVM2Instruction>();
        trueBody.addAll(this.toInsList(AssignableAVM2Item.getTemp(localData, this, xmlListReg)));
        trueBody.addAll(this.toInsList(AssignableAVM2Item.getTemp(localData, this, counterReg)));
        trueBody.addAll(this.toInsList(AssignableAVM2Item.getTemp(localData, this, tempVal1)));
        trueBody.add(this.ins(97, constants.getMultinameId(Multiname.createMultinameL(false, NamespaceItem.getCpoolSetIndex(this.abcIndex, item.openedNamespaces)), true)));
        forBody.add(this.ins(18, this.insToBytes(trueBody).length));
        forBody.addAll(trueBody);
        forBody.add(this.ins(29, new int[0]));
        localData.scopeStack.remove(localData.scopeStack.size() - 1);
        forBody.addAll(this.toInsList(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(tempVal2, tempVal1))));
        int forBodyLen = this.insToBytes(forBody).length;
        AVM2Instruction forwardJump = this.ins(16, forBodyLen);
        ret.add(forwardJump);
        ArrayList<AVM2Instruction> expr = new ArrayList<AVM2Instruction>();
        expr.add(this.ins(50, collectionReg.getVal(), counterReg.getVal()));
        AVM2Instruction backIf = this.ins(17, 0);
        expr.add(backIf);
        int exprLen = this.insToBytes(expr).length;
        backIf.operands[0] = -(exprLen + forBodyLen);
        ret.addAll(forBody);
        ret.addAll(expr);
        ret.addAll(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(collectionReg, counterReg)));
        ret.addAll(AssignableAVM2Item.getTemp(localData, this, xmlListReg));
        ret.addAll(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(xmlListReg)));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, IfItem item) throws CompilationException {
        return this.generateIf(localData, item.expression, item.onTrue, item.onFalse, false);
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, NullCoalesceAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(GraphTargetItem.toSourceMerge(localData, this, item.leftSide));
        ret.add(this.ins(32, new int[0]));
        AVM2Instruction ifEq = this.ins(19, 0);
        ret.add(ifEq);
        List<GraphSourceItem> onNotNull = GraphTargetItem.toSourceMerge(localData, this, item.leftSide);
        AVM2Instruction jump = this.ins(16, 0);
        onNotNull.add(jump);
        ifEq.operands[0] = this.insToBytes(this.toInsList(onNotNull)).length;
        List<GraphSourceItem> onNull = GraphTargetItem.toSourceMerge(localData, this, item.rightSide);
        jump.operands[0] = this.insToBytes(this.toInsList(onNull)).length;
        ret.addAll(onNotNull);
        ret.addAll(onNull);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TernarOpItem item) throws CompilationException {
        ArrayList<GraphTargetItem> onTrue = new ArrayList<GraphTargetItem>();
        onTrue.add(item.onTrue);
        ArrayList<GraphTargetItem> onFalse = new ArrayList<GraphTargetItem>();
        onFalse.add(item.onFalse);
        return this.generateIf(localData, item.expression, onTrue, onFalse, true);
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, WhileItem item) throws CompilationException {
        int whileBodyLen;
        localData.openedLoops.add(item.loop.id);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ArrayList<AVM2Instruction> whileExpr = new ArrayList<AVM2Instruction>();
        ArrayList<GraphTargetItem> ex = new ArrayList<GraphTargetItem>(item.expression);
        GraphTargetItem lastItem = null;
        if (!ex.isEmpty()) {
            lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            while (lastItem instanceof CommaExpressionItem) {
                CommaExpressionItem cei = (CommaExpressionItem)lastItem;
                ex.addAll(cei.commands);
                lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            }
            whileExpr.addAll(this.generateToInsList(localData, ex));
        }
        List<AVM2Instruction> whileBody = this.generateToInsList(localData, item.commands);
        AVM2Instruction forwardJump = this.ins(16, 0);
        ret.add(forwardJump);
        whileBody.add(0, this.ins(9, new int[0]));
        ret.addAll(whileBody);
        forwardJump.operands[0] = whileBodyLen = this.insToBytes(whileBody).length;
        whileExpr.addAll(this.toInsList(this.condition(localData, lastItem, 0)));
        int whileExprLen = this.insToBytes(whileExpr).length;
        ((AVM2Instruction)whileExpr.get((int)(whileExpr.size() - 1))).operands[0] = -(whileExprLen + whileBodyLen);
        ret.addAll(whileExpr);
        this.fixLoop(whileBody, whileBodyLen + whileExprLen, whileBodyLen, item.loop.id);
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ForEachInAVM2Item item) throws CompilationException {
        return this.generateForIn(localData, item.loop, item.expression.collection, (AssignableAVM2Item)item.expression.object, item.commands, true);
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ForInAVM2Item item) throws CompilationException {
        return this.generateForIn(localData, item.loop, item.expression.collection, (AssignableAVM2Item)item.expression.object, item.commands, false);
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, DoWhileItem item) throws CompilationException {
        localData.openedLoops.add(item.loop.id);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ArrayList<AVM2Instruction> whileExpr = new ArrayList<AVM2Instruction>();
        ArrayList<GraphTargetItem> ex = new ArrayList<GraphTargetItem>(item.expression);
        GraphTargetItem lastItem = null;
        if (!ex.isEmpty()) {
            lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            while (lastItem instanceof CommaExpressionItem) {
                CommaExpressionItem cei = (CommaExpressionItem)lastItem;
                ex.addAll(cei.commands);
                lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            }
            whileExpr.addAll(this.generateToInsList(localData, ex));
        }
        List<AVM2Instruction> dowhileBody = this.generateToInsList(localData, item.commands);
        ArrayList<AVM2Instruction> labelBody = new ArrayList<AVM2Instruction>();
        labelBody.add(this.ins(9, new int[0]));
        int labelBodyLen = this.insToBytes(labelBody).length;
        AVM2Instruction forwardJump = this.ins(16, labelBodyLen);
        ret.add(forwardJump);
        ret.addAll(labelBody);
        ret.addAll(dowhileBody);
        int dowhileBodyLen = this.insToBytes(dowhileBody).length;
        whileExpr.addAll(this.toInsList(this.condition(localData, lastItem, 0)));
        int dowhileExprLen = this.insToBytes(whileExpr).length;
        ((AVM2Instruction)whileExpr.get((int)(whileExpr.size() - 1))).operands[0] = -(dowhileExprLen + dowhileBodyLen + labelBodyLen);
        ret.addAll(whileExpr);
        this.fixLoop(dowhileBody, dowhileBodyLen + dowhileExprLen, dowhileBodyLen, item.loop.id);
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, WithAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(item.scope.toSource(localData, this));
        Reference<Integer> tempReg = new Reference<Integer>(0);
        ret.addAll(AssignableAVM2Item.dupSetTemp(localData, this, tempReg));
        localData.scopeStack.add(new WithObjectAVM2Item(null, null, new LocalRegAVM2Item(null, null, tempReg.getVal(), null, (GraphTargetItem)new TypeItem("Object"))));
        ret.add(this.ins(28, new int[0]));
        ret.addAll(this.generate(localData, item.items));
        ret.add(this.ins(29, new int[0]));
        ret.addAll(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(tempReg)));
        localData.scopeStack.remove(localData.scopeStack.size() - 1);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ForItem item) throws CompilationException {
        localData.openedLoops.add(item.loop.id);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ArrayList<AVM2Instruction> forExpr = new ArrayList<AVM2Instruction>();
        ArrayList<GraphTargetItem> ex = new ArrayList<GraphTargetItem>();
        if (item.expression != null) {
            ex.add(item.expression);
        } else {
            ex.add(new BooleanAVM2Item(null, null, true));
        }
        GraphTargetItem lastItem = null;
        if (!ex.isEmpty()) {
            lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            while (lastItem instanceof CommaExpressionItem) {
                CommaExpressionItem cei = (CommaExpressionItem)lastItem;
                ex.addAll(cei.commands);
                lastItem = (GraphTargetItem)ex.remove(ex.size() - 1);
            }
            forExpr.addAll(this.generateToInsList(localData, ex));
        }
        List<AVM2Instruction> forBody = this.generateToInsList(localData, item.commands);
        List<AVM2Instruction> forFinalCommands = this.generateToInsList(localData, item.finalCommands);
        ret.addAll(this.generateToInsList(localData, item.firstCommands));
        AVM2Instruction forwardJump = this.ins(16, 0);
        ret.add(forwardJump);
        forBody.add(0, this.ins(9, new int[0]));
        ret.addAll(forBody);
        ret.addAll(forFinalCommands);
        int forBodyLen = this.insToBytes(forBody).length;
        int forFinalCLen = this.insToBytes(forFinalCommands).length;
        forwardJump.operands[0] = forBodyLen + forFinalCLen;
        forExpr.addAll(this.toInsList(this.condition(localData, lastItem, 0)));
        int forExprLen = this.insToBytes(forExpr).length;
        ((AVM2Instruction)forExpr.get((int)(forExpr.size() - 1))).operands[0] = -(forExprLen + forBodyLen + forFinalCLen);
        ret.addAll(forExpr);
        this.fixLoop(forBody, forBodyLen + forFinalCLen + forExprLen, forBodyLen, item.loop.id);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, SwitchItem item) throws CompilationException {
        int i;
        localData.openedLoops.add(item.loop.id);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        Reference<Integer> switchedReg = new Reference<Integer>(0);
        AVM2Instruction forwardJump = this.ins(16, 0);
        ret.add(forwardJump);
        int defIndex = item.caseValues.size();
        boolean hasDefault = false;
        for (int i2 = item.caseValues.size() - 1; i2 >= 0; --i2) {
            if (!(item.caseValues.get(i2) instanceof DefaultItem)) continue;
            hasDefault = true;
            defIndex = i2;
            break;
        }
        int realCasesCount = item.caseValues.size() + (hasDefault ? -1 : 0);
        ArrayList<AVM2Instruction> cases = new ArrayList<AVM2Instruction>();
        cases.addAll(0, this.toInsList(new IntegerValueAVM2Item(null, null, (Integer)-1).toSource(localData, this)));
        ArrayList<AVM2Instruction> preCases = new ArrayList<AVM2Instruction>();
        preCases.addAll(this.toInsList(item.switchedObject.toSource(localData, this)));
        preCases.addAll(this.toInsList(AssignableAVM2Item.setTemp(localData, this, switchedReg)));
        int pos = realCasesCount - 1;
        for (int i3 = item.caseValues.size() - 1; i3 >= 0; --i3) {
            if (item.caseValues.get(i3) instanceof DefaultItem) continue;
            ArrayList<AVM2Instruction> sub = new ArrayList<AVM2Instruction>();
            sub.addAll(this.toInsList(new IntegerValueAVM2Item(null, null, (Integer)pos--).toSource(localData, this)));
            sub.add(this.ins(16, this.insToBytes(cases).length));
            int subLen = this.insToBytes(sub).length;
            cases.addAll(0, sub);
            cases.add(0, this.ins(26, subLen));
            cases.addAll(0, this.toInsList(AssignableAVM2Item.getTemp(localData, this, switchedReg)));
            cases.addAll(0, this.toInsList(item.caseValues.get(i3).toSource(localData, this)));
        }
        cases.addAll(0, preCases);
        AVM2Instruction lookupOp = new AVM2Instruction(0L, 27, new int[2 + realCasesCount]);
        cases.addAll(this.toInsList(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(switchedReg))));
        ArrayList<AVM2Instruction> bodies = new ArrayList<AVM2Instruction>();
        ArrayList<Integer> bodiesOffsets = new ArrayList<Integer>();
        int casesLen = this.insToBytes(cases).length;
        bodies.add(0, this.ins(9, new int[0]));
        bodies.add(this.ins(new BreakJumpIns(item.loop.id), 0));
        int defOffset = -(this.insToBytes(bodies).length + casesLen);
        for (i = item.caseCommands.size() - 1; i >= 0; --i) {
            bodies.addAll(0, this.generateToInsList(localData, item.caseCommands.get(i)));
            bodies.add(0, this.ins(9, new int[0]));
            bodiesOffsets.add(0, -(this.insToBytes(bodies).length + casesLen));
        }
        if (hasDefault) {
            defOffset = (Integer)bodiesOffsets.get(item.valuesMapping.get(defIndex));
        }
        lookupOp.operands[0] = defOffset;
        lookupOp.operands[1] = realCasesCount - 1;
        pos = 0;
        for (i = 0; i < item.valuesMapping.size(); ++i) {
            if (item.caseValues.get(i) instanceof DefaultItem) continue;
            lookupOp.operands[2 + pos++] = (Integer)bodiesOffsets.get(item.valuesMapping.get(i));
        }
        forwardJump.operands[0] = this.insToBytes(bodies).length;
        ret.addAll(bodies);
        ret.addAll(cases);
        ret.add(lookupOp);
        this.fixSwitch(this.toInsList(ret), this.insToBytes(this.toInsList(ret)).length, item.loop.id);
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, NotItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(item.getOriginal().toSource(localData, this));
        ret.add(this.ins(150, new int[0]));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, DuplicateItem item) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(this.ins(42, new int[0]));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, BreakItem item) throws CompilationException {
        int i;
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        if (!localData.finallyCatches.isEmpty()) {
            for (i = localData.finallyCatches.size() - 1; i >= 0; --i) {
                int clauseId;
                Integer cnt;
                if (!localData.finallyOpenedLoops.get(i).contains(item.loopId)) continue;
                if (i < localData.finallyCatches.size() - 1) {
                    ret.add(this.ins(9, new int[0]));
                }
                if ((cnt = localData.finallyCounter.get(clauseId = localData.finallyCatches.get(i).intValue())) == null) {
                    cnt = -1;
                }
                Integer n = cnt;
                cnt = cnt + 1;
                localData.finallyCounter.put(clauseId, cnt);
                ret.addAll(new IntegerValueAVM2Item(null, null, cnt).toSource(localData, this));
                ret.add(this.ins(new FinallyJumpIns(clauseId), 0));
                ret.add(this.ins(9, new int[0]));
                ret.add(this.ins(41, new int[0]));
            }
            ret.add(this.ins(9, new int[0]));
        }
        for (i = 0; i < localData.catchesOpenedLoops.size(); ++i) {
            List<Long> openedLoops = localData.catchesOpenedLoops.get(i);
            if (openedLoops.contains(item.loopId)) {
                ret.add(this.ins(new PopScopeIns(), new int[0]));
            }
            ret.add(this.ins(new KillIns(), localData.catchesTempRegs.get(i)));
        }
        AVM2Instruction abreak = this.ins(new BreakJumpIns(item.loopId), 0);
        ret.add(abreak);
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, FunctionAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        int scope = 0;
        if (!item.functionName.isEmpty()) {
            ret.add(this.ins(85, 0));
            ret.add(this.ins(28, new int[0]));
            scope = localData.scopeStack.size();
            localData.scopeStack.add(new PropertyAVM2Item(null, false, item.functionName, "", this.abcIndex, new ArrayList<NamespaceItem>(), localData.callStack, false));
        }
        AVM2ConstantPool constants = this.abcIndex.getSelectedAbc().constants;
        ret.add(this.ins(64, this.method(null, false, constants.getStringId(item.functionName, true), true, false, false, localData.callStack, localData.pkg, item.needsActivation, item.subvariables, 0, item.hasRest, item.line, localData.currentClassBaseName, null, false, localData, item.paramTypes, item.paramNames, item.paramValues, item.body, item.retType)));
        if (!item.functionName.isEmpty()) {
            ret.add(this.ins(42, new int[0]));
            ret.add(this.ins(101, scope));
            ret.add(this.ins(43, new int[0]));
            ret.add(this.ins(97, constants.getMultinameId(Multiname.createQName(false, constants.getStringId(item.functionName, true), constants.getNamespaceId(22, localData.pkg, 0, true)), true)));
            ret.add(this.ins(29, new int[0]));
            localData.scopeStack.remove(localData.scopeStack.size() - 1);
        }
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TryAVM2Item item) throws CompilationException {
        int n;
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        boolean newFinallyReg = false;
        ArrayList<ABCException> newex = new ArrayList<ABCException>();
        int aloneFinallyEx = -1;
        int finallyEx = -1;
        for (NameAVM2Item e : item.catchExceptions2) {
            ABCException aex = new ABCException();
            aex.name_index = this.abcIndex.getSelectedAbc().constants.getMultinameId(Multiname.createQName(false, this.abcIndex.getSelectedAbc().constants.getStringId(e.getVariableName(), true), this.abcIndex.getSelectedAbc().constants.getNamespaceId(22, "", 0, true)), true);
            aex.type_index = this.typeName(localData, e.type);
            newex.add(aex);
        }
        int finId = 0;
        if (item.finallyCommands != null) {
            ABCException aex;
            if (item.catchExceptions2.isEmpty()) {
                aex = new ABCException();
                aex.name_index = 0;
                aex.type_index = 0;
                newex.add(aex);
                aloneFinallyEx = newex.size() - 1;
            }
            aex = new ABCException();
            aex.name_index = 0;
            aex.type_index = 0;
            newex.add(aex);
            finallyEx = newex.size() - 1;
            if (localData.finallyRegister == -1) {
                localData.finallyRegister = this.getFreeRegister(localData);
                this.killRegister(localData, localData.finallyRegister);
                newFinallyReg = true;
            }
            finId = AVM2SourceGenerator.finId();
        }
        if (finallyEx > -1) {
            localData.finallyCatches.add(finId);
            localData.finallyOpenedLoops.add(new ArrayList<Long>(localData.openedLoops));
        }
        List<AVM2Instruction> tryCmds = this.generateToInsList(localData, item.tryCommands);
        ArrayList<AVM2Instruction> catches = new ArrayList<AVM2Instruction>();
        Reference<Integer> tempReg = new Reference<Integer>(0);
        ArrayList<Integer> currentExceptionIds = new ArrayList<Integer>();
        ArrayList<Object> catchCmds = new ArrayList<Object>();
        for (int c = 0; c < item.catchCommands.size(); ++c) {
            int i = localData.exceptions.size();
            localData.exceptions.add((ABCException)newex.get(c));
            currentExceptionIds.add(i);
            ArrayList catchCmd = new ArrayList();
            catchCmd.add(this.ins(90, i));
            catchCmd.addAll(this.toInsList(AssignableAVM2Item.dupSetTemp(localData, this, tempReg)));
            catchCmd.add(this.ins(42, new int[0]));
            catchCmd.add(this.ins(48, new int[0]));
            catchCmd.add(this.ins(43, new int[0]));
            catchCmd.add(this.ins(109, 1));
            for (AssignableAVM2Item assignableAVM2Item : item.catchVariables.get(c)) {
                GraphTargetItem r = assignableAVM2Item;
                if (r instanceof UnresolvedAVM2Item) {
                    r = ((UnresolvedAVM2Item)r).resolvedRoot;
                }
                if (!(r instanceof NameAVM2Item)) continue;
                NameAVM2Item n2 = (NameAVM2Item)r;
                if (!item.catchExceptions2.get(c).getVariableName().equals(n2.getVariableName())) continue;
                n2.setSlotScope(localData.scopeStack.size());
            }
            localData.catchesTempRegs.add(tempReg.getVal());
            localData.scopeStack.add(new LocalRegAVM2Item(null, null, tempReg.getVal(), null, (GraphTargetItem)new TypeItem("Object")));
            localData.catchesOpenedLoops.add(new ArrayList<Long>(localData.openedLoops));
            catchCmd.addAll(this.generateToInsList(localData, item.catchCommands.get(c)));
            localData.catchesOpenedLoops.remove(localData.catchesOpenedLoops.size() - 1);
            localData.scopeStack.remove(localData.scopeStack.size() - 1);
            localData.catchesTempRegs.remove(localData.catchesTempRegs.size() - 1);
            if (!item.catchCommands.get(c).isEmpty() && (item.catchCommands.get(c).get(item.catchCommands.get(c).size() - 1) instanceof ContinueItem || item.catchCommands.get(c).get(item.catchCommands.get(c).size() - 1) instanceof BreakItem)) {
                AssignableAVM2Item.killRegister(localData, this, tempReg.getVal());
            } else {
                catchCmd.add(this.ins(29, new int[0]));
                catchCmd.addAll(this.toInsList(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(tempReg))));
            }
            catchCmds.add(catchCmd);
        }
        for (int c2 = item.catchCommands.size() - 1; c2 >= 0; --c2) {
            ArrayList<AVM2Instruction> preCatches = new ArrayList<AVM2Instruction>();
            for (GraphTargetItem s : localData.scopeStack) {
                preCatches.addAll(this.toInsList(s.toSource(localData, this)));
                if (s instanceof WithObjectAVM2Item) {
                    preCatches.add(this.ins(28, new int[0]));
                    continue;
                }
                preCatches.add(this.ins(48, new int[0]));
            }
            preCatches.addAll((Collection)catchCmds.get(c2));
            catches.addAll(0, preCatches);
            catches.add(0, new ExceptionMarkAVM2Instruction((Integer)currentExceptionIds.get(c2), 2));
            catches.add(0, this.ins(16, this.insToBytes(catches).length));
        }
        if (aloneFinallyEx > -1) {
            localData.exceptions.add((ABCException)newex.get(aloneFinallyEx));
            aloneFinallyEx = localData.exceptions.size() - 1;
        }
        if (finallyEx > -1) {
            localData.exceptions.add((ABCException)newex.get(finallyEx));
            finallyEx = localData.exceptions.size() - 1;
        }
        Iterator c2 = currentExceptionIds.iterator();
        while (c2.hasNext()) {
            int i = (Integer)c2.next();
            ret.add(new ExceptionMarkAVM2Instruction(i, 0));
        }
        if (aloneFinallyEx > -1) {
            ret.add(new ExceptionMarkAVM2Instruction(aloneFinallyEx, 0));
        }
        if (finallyEx > -1) {
            ret.add(new ExceptionMarkAVM2Instruction(finallyEx, 0));
        }
        ret.addAll(tryCmds);
        c2 = currentExceptionIds.iterator();
        while (c2.hasNext()) {
            int i = (Integer)c2.next();
            ret.add(new ExceptionMarkAVM2Instruction(i, 1));
        }
        if (aloneFinallyEx > -1) {
            ret.add(new ExceptionMarkAVM2Instruction(aloneFinallyEx, 1));
        }
        if (aloneFinallyEx > -1) {
            ArrayList<AVM2Instruction> preCatches = new ArrayList<AVM2Instruction>();
            for (GraphTargetItem s : localData.scopeStack) {
                preCatches.addAll(this.toInsList(s.toSource(localData, this)));
                if (s instanceof WithObjectAVM2Item) {
                    preCatches.add(this.ins(28, new int[0]));
                    continue;
                }
                preCatches.add(this.ins(48, new int[0]));
            }
            preCatches.add(this.ins(90, aloneFinallyEx));
            preCatches.addAll(this.toInsList(AssignableAVM2Item.dupSetTemp(localData, this, tempReg)));
            preCatches.add(this.ins(48, new int[0]));
            preCatches.add(this.ins(3, new int[0]));
            preCatches.add(this.ins(29, new int[0]));
            preCatches.addAll(this.toInsList(AssignableAVM2Item.killTemp(localData, this, Arrays.asList(tempReg))));
            catches.add(this.ins(16, this.insToBytes(preCatches).length));
            catches.add(new ExceptionMarkAVM2Instruction(aloneFinallyEx, 2));
            catches.addAll(preCatches);
        }
        AVM2Instruction finSwitch = null;
        AVM2Instruction pushDefIns = this.ins(36, 0);
        int defPos = 0;
        if (finallyEx > -1) {
            ArrayList<AVM2Instruction> preCatches = new ArrayList<AVM2Instruction>();
            preCatches.add(0, new ExceptionMarkAVM2Instruction(finallyEx, 2));
            for (GraphTargetItem s : localData.scopeStack) {
                preCatches.addAll(this.toInsList(s.toSource(localData, this)));
                if (s instanceof WithObjectAVM2Item) {
                    preCatches.add(this.ins(28, new int[0]));
                    continue;
                }
                preCatches.add(this.ins(48, new int[0]));
            }
            preCatches.add(this.ins(90, finallyEx));
            preCatches.addAll(this.toInsList(AssignableAVM2Item.dupSetTemp(localData, this, tempReg)));
            preCatches.add(this.ins(48, new int[0]));
            preCatches.add(this.ins(29, new int[0]));
            Reference<Integer> reference = new Reference<Integer>(0);
            preCatches.add(this.ins(8, tempReg.getVal()));
            preCatches.add(this.ins(130, new int[0]));
            preCatches.addAll(this.toInsList(AssignableAVM2Item.setTemp(localData, this, reference)));
            preCatches.add(pushDefIns);
            ArrayList<AVM2Instruction> finallySwitchCmds = new ArrayList<AVM2Instruction>();
            finSwitch = new AVM2Instruction(0L, 27, new int[3]);
            finSwitch.operands[0] = finSwitch.getBytesLength();
            finSwitch.operands[1] = 0;
            ArrayList<AVM2Instruction> preFinallySwitch = new ArrayList<AVM2Instruction>();
            preFinallySwitch.add(this.ins(9, new int[0]));
            preFinallySwitch.add(this.ins(41, new int[0]));
            int preFinallySwitchLen = this.insToBytes(preFinallySwitch).length;
            finallySwitchCmds.add(this.ins(9, new int[0]));
            finallySwitchCmds.addAll(this.toInsList(AssignableAVM2Item.getTemp(localData, this, reference)));
            finallySwitchCmds.add(this.ins(8, reference.getVal()));
            finallySwitchCmds.add(this.ins(3, new int[0]));
            int finSwitchLen = this.insToBytes(finallySwitchCmds).length;
            preCatches.add(this.ins(16, preFinallySwitchLen + finSwitchLen));
            AVM2Instruction fjump = this.ins(16, 0);
            fjump.operands[0] = this.insToBytes(preCatches).length + preFinallySwitchLen + finSwitchLen;
            preCatches.add(0, fjump);
            preCatches.add(0, new ExceptionMarkAVM2Instruction(finallyEx, 1));
            preCatches.add(0, this.ins(36, -1));
            finallySwitchCmds.add(new ExceptionMarkAVM2Instruction(finallyEx, 3));
            int oldReg = localData.finallyRegister;
            localData.finallyRegister = this.getFreeRegister(localData);
            Integer cnt = localData.finallyCounter.get(finId);
            if (cnt == null) {
                cnt = -1;
            }
            defPos = cnt;
            Integer n3 = cnt;
            cnt = cnt + 1;
            localData.finallyCounter.put(finId, cnt);
            finallySwitchCmds.addAll(this.generateToInsList(localData, item.finallyCommands));
            this.killRegister(localData, localData.finallyRegister);
            localData.finallyRegister = oldReg;
            finSwitchLen = this.insToBytes(finallySwitchCmds).length;
            finSwitch.operands[2] = -finSwitchLen;
            preCatches.addAll(preFinallySwitch);
            preCatches.addAll(finallySwitchCmds);
            preCatches.add(finSwitch);
            catches.addAll(preCatches);
            AssignableAVM2Item.killTemp(localData, this, Arrays.asList(tempReg, reference));
        }
        ret.addAll(catches);
        if (finallyEx > -1) {
            localData.finallyCatches.remove(localData.finallyCatches.size() - 1);
            localData.finallyOpenedLoops.remove(localData.finallyOpenedLoops.size() - 1);
        }
        if (newFinallyReg) {
            localData.finallyRegister = -1;
            this.killRegister(localData, localData.finallyRegister);
        }
        int pos = 0;
        boolean bl = false;
        int switchPos = 0;
        for (int s = 0; s < ret.size(); ++s) {
            GraphSourceItem src = (GraphSourceItem)ret.get(s);
            if (src == finSwitch) {
                switchPos = pos;
            }
            if (!(src instanceof AVM2Instruction)) continue;
            AVM2Instruction ins = (AVM2Instruction)src;
            if (ins instanceof ExceptionMarkAVM2Instruction) {
                ExceptionMarkAVM2Instruction em = (ExceptionMarkAVM2Instruction)ins;
                if (em.exceptionId == finallyEx && em.markType == 3) {
                    n = pos;
                    ret.remove(s);
                    --s;
                    continue;
                }
            }
            pos += ins.getBytesLength();
        }
        if (finSwitch != null) {
            int afterLoc;
            pos = 0;
            int defLoc = finSwitch.operands[2];
            ArrayList<Integer> switchLoc = new ArrayList<Integer>();
            boolean wasDef = false;
            for (int s = 0; s < ret.size(); ++s) {
                GraphSourceItem src = (GraphSourceItem)ret.get(s);
                if (src instanceof AVM2Instruction) {
                    FinallyJumpIns fji;
                    AVM2Instruction ins = (AVM2Instruction)src;
                    if (ins.definition instanceof FinallyJumpIns && (fji = (FinallyJumpIns)ins.definition).getClauseId() == (long)finId) {
                        ArrayList<AVM2Instruction> bet = new ArrayList<AVM2Instruction>();
                        bet.add(this.ins(9, new int[0]));
                        bet.add(this.ins(41, new int[0]));
                        int betLen = this.insToBytes(bet).length;
                        ins.operands[0] = wasDef ? 0 : n - (pos + ins.getBytesLength());
                        ins.definition = AVM2Code.instructionSet[16];
                        switchLoc.add(pos + ins.getBytesLength() + betLen - switchPos);
                    }
                    pos += ins.getBytesLength();
                }
                if (defPos != switchLoc.size() - 1) continue;
                switchLoc.add(defLoc);
                wasDef = true;
            }
            finSwitch.operands = new int[2 + switchLoc.size()];
            pushDefIns.operands[0] = defPos + 1;
            finSwitch.operands[0] = afterLoc = finSwitch.getBytesLength();
            finSwitch.operands[1] = switchLoc.size() - 1;
            for (int j = 0; j < switchLoc.size(); ++j) {
                finSwitch.operands[2 + j] = (Integer)switchLoc.get(j);
            }
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ContinueItem item) throws CompilationException {
        int i;
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        if (!localData.finallyCatches.isEmpty()) {
            for (i = localData.finallyCatches.size() - 1; i >= 0; --i) {
                int clauseId;
                Integer cnt;
                if (!localData.finallyOpenedLoops.get(i).contains(item.loopId)) continue;
                if (i < localData.finallyCatches.size() - 1) {
                    ret.add(this.ins(9, new int[0]));
                }
                if ((cnt = localData.finallyCounter.get(clauseId = localData.finallyCatches.get(i).intValue())) == null) {
                    cnt = -1;
                }
                Integer n = cnt;
                cnt = cnt + 1;
                localData.finallyCounter.put(clauseId, cnt);
                ret.addAll(new IntegerValueAVM2Item(null, null, cnt).toSource(localData, this));
                ret.add(this.ins(new FinallyJumpIns(clauseId), 0));
                ret.add(this.ins(9, new int[0]));
                ret.add(this.ins(41, new int[0]));
            }
            ret.add(this.ins(9, new int[0]));
        }
        for (i = 0; i < localData.catchesOpenedLoops.size(); ++i) {
            List<Long> openedLoops = localData.catchesOpenedLoops.get(i);
            if (openedLoops.contains(item.loopId)) {
                ret.add(this.ins(new PopScopeIns(), new int[0]));
            }
            ret.add(this.ins(new KillIns(), localData.catchesTempRegs.get(i)));
        }
        AVM2Instruction acontinue = this.ins(new ContinueJumpIns(item.loopId), 0);
        ret.add(acontinue);
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ReturnValueAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        GraphTargetItem value = item.value;
        value = AVM2SourceGenerator.handleAndOrCoerce(value, localData.returnType);
        ret.addAll(value.toSource(localData, this));
        if (!localData.finallyCatches.isEmpty()) {
            ret.add(this.ins(130, new int[0]));
            ret.add(AssignableAVM2Item.generateSetLoc(localData.finallyRegister));
            for (int i = localData.finallyCatches.size() - 1; i >= 0; --i) {
                int clauseId;
                Integer cnt;
                if (i < localData.finallyCatches.size() - 1) {
                    ret.add(this.ins(9, new int[0]));
                }
                if ((cnt = localData.finallyCounter.get(clauseId = localData.finallyCatches.get(i).intValue())) == null) {
                    cnt = -1;
                }
                Integer n = cnt;
                cnt = cnt + 1;
                localData.finallyCounter.put(clauseId, cnt);
                ret.addAll(new IntegerValueAVM2Item(null, null, cnt).toSource(localData, this));
                ret.add(this.ins(new FinallyJumpIns(clauseId), 0));
                ret.add(this.ins(9, new int[0]));
                ret.add(this.ins(41, new int[0]));
            }
            ret.add(this.ins(9, new int[0]));
            ret.add(AssignableAVM2Item.generateGetLoc(localData.finallyRegister));
            ret.add(this.ins(8, localData.finallyRegister));
        }
        ret.add(this.ins(72, new int[0]));
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ReturnVoidAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        if (!localData.finallyCatches.isEmpty()) {
            for (int i = 0; i < localData.finallyCatches.size(); ++i) {
                int clauseId;
                Integer cnt;
                if (i > 0) {
                    ret.add(this.ins(9, new int[0]));
                }
                if ((cnt = localData.finallyCounter.get(clauseId = localData.finallyCatches.get(i).intValue())) == null) {
                    cnt = -1;
                }
                Integer n = cnt;
                cnt = cnt + 1;
                localData.finallyCounter.put(clauseId, cnt);
                ret.addAll(new IntegerValueAVM2Item(null, null, cnt).toSource(localData, this));
                ret.add(this.ins(new FinallyJumpIns(clauseId), 0));
                ret.add(this.ins(9, new int[0]));
                ret.add(this.ins(41, new int[0]));
            }
            ret.add(this.ins(9, new int[0]));
        }
        ret.add(this.ins(71, new int[0]));
        return ret;
    }

    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, ThrowAVM2Item item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(item.value.toSource(localData, this));
        ret.add(this.ins(3, new int[0]));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, List<GraphTargetItem> commands) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        for (GraphTargetItem item : commands) {
            ret.addAll(item.toSourceIgnoreReturnValue(localData, this));
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, CommaExpressionItem item, boolean withReturnValue) throws CompilationException {
        if (item.commands.isEmpty()) {
            return new ArrayList<GraphSourceItem>();
        }
        ArrayList<GraphTargetItem> cmds = new ArrayList<GraphTargetItem>(item.commands);
        GraphTargetItem lastExpr = (GraphTargetItem)cmds.remove(cmds.size() - 1);
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.addAll(this.generate(localData, cmds));
        ret.addAll(withReturnValue ? lastExpr.toSource(localData, this) : lastExpr.toSourceIgnoreReturnValue(localData, this));
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, TypeItem item) throws CompilationException {
        String currentFullClassName = localData.getFullClass();
        int globalSlotId = 0;
        if (item.fullTypeName.size() == 1 && item.toString().equals(currentFullClassName)) {
            int c = this.abcIndex.getSelectedAbc().findClassByName(currentFullClassName);
            for (Trait t : localData.currentScript.traits.traits) {
                if (!(t instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)t;
                if (tc.class_info != c) continue;
                globalSlotId = tc.slot_id;
                break;
            }
        }
        if (localData.isStatic && item.toString().equals(currentFullClassName)) {
            return Arrays.asList(this.ins(208, new int[0]));
        }
        if (globalSlotId > 0) {
            return GraphTargetItem.toSourceMerge(localData, this, this.ins(100, new int[0]), this.ins(108, globalSlotId));
        }
        return GraphTargetItem.toSourceMerge(localData, this, this.ins(96, AVM2SourceGenerator.resolveType(localData, item, this.abcIndex)));
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, PushItem item) throws CompilationException {
        return item.value.toSource(localData, this);
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, PopItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        return ret;
    }

    @Override
    public List<GraphSourceItem> generate(SourceGeneratorLocalData localData, SwapItem item) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(this.ins(43, new int[0]));
        return ret;
    }

    public static GraphTargetItem handleAndOrCoerce(GraphTargetItem item, GraphTargetItem type) {
        if (type == null) {
            return item;
        }
        if (item instanceof OrItem || item instanceof AndItem) {
            BinaryOpItem bo = (BinaryOpItem)item;
            bo.leftSide = bo.leftSide instanceof OrItem || bo.leftSide instanceof AndItem ? AVM2SourceGenerator.handleAndOrCoerce(bo.leftSide, type) : new CoerceAVM2Item(null, null, bo.leftSide, type);
            bo.rightSide = bo.rightSide instanceof OrItem || bo.rightSide instanceof AndItem ? AVM2SourceGenerator.handleAndOrCoerce(bo.rightSide, type) : new CoerceAVM2Item(null, null, bo.rightSide, type);
        }
        return item;
    }
}

