/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.ConvertException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class ABCException
implements Serializable,
Cloneable {
    public int start;
    public int end;
    public int target;
    public int type_index;
    public int name_index;
    public static final String DEFAULT_EXCEPTION_NAME = "_loc_e_";

    public String toString() {
        return "Exception: startServer=" + Helper.formatAddress(this.start) + " end=" + Helper.formatAddress(this.end) + " target=" + this.target + " type_index=" + this.type_index + " name_index=" + this.name_index;
    }

    public String toString(Set<String> usedDeobfuscations, ABC abc, AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        return "Exception: startServer=" + Helper.formatAddress(this.start) + " end=" + Helper.formatAddress(this.end) + " target=" + this.target + " type=\"" + this.getTypeName(usedDeobfuscations, abc, constants, fullyQualifiedNames) + "\" name=\"" + this.getVarName(usedDeobfuscations, abc, constants, fullyQualifiedNames) + "\"";
    }

    public String toString(Set<String> usedDeobfuscations, ABC abc, AVM2ConstantPool constants, AVM2Code code, List<DottedChain> fullyQualifiedNames) {
        try {
            return "Exception: startServer=" + code.adr2pos(this.start) + ":" + code.code.get(code.adr2pos(this.start)).toStringNoAddress(constants, fullyQualifiedNames) + " end=" + code.adr2pos(this.end) + ":" + code.code.get(code.adr2pos(this.end)).toStringNoAddress(constants, fullyQualifiedNames) + " target=" + code.adr2pos(this.target) + ":" + code.code.get(code.adr2pos(this.target)).toStringNoAddress(constants, fullyQualifiedNames) + " type=\"" + this.getTypeName(usedDeobfuscations, abc, constants, fullyQualifiedNames) + "\" name=\"" + this.getVarName(usedDeobfuscations, abc, constants, fullyQualifiedNames) + "\"";
        }
        catch (ConvertException ex) {
            return "";
        }
    }

    public boolean isFinally() {
        return this.name_index == 0 && this.type_index == 0;
    }

    public String getVarName(Set<String> usedDeobfuscations, ABC abc, AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        if (this.name_index == 0) {
            return DEFAULT_EXCEPTION_NAME;
        }
        return constants.getMultiname(this.name_index).getName(usedDeobfuscations, abc, constants, fullyQualifiedNames, false, true);
    }

    public String getTypeName(Set<String> usedDeobfuscations, ABC abc, AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        if (this.type_index == 0) {
            return "*";
        }
        return constants.getMultiname(this.type_index).getName(usedDeobfuscations, abc, constants, fullyQualifiedNames, false, true);
    }

    public ABCException clone() {
        try {
            ABCException ret = (ABCException)super.clone();
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }
}

