/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ScriptInfo {
    @Internal
    private boolean modified = true;
    @Internal
    public boolean deleted;
    public int init_index;
    public Traits traits;
    private List<ScriptPack> cachedPacks;

    public ScriptInfo() {
        this.traits = new Traits();
    }

    public ScriptInfo(Traits traits) {
        this.traits = traits;
    }

    public void clearPacksCache() {
        this.cachedPacks = null;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public DottedChain getSimplePackName(ABC abc, Set<String> usedDeobfuscations) {
        ArrayList<Integer> packageTraits = new ArrayList<Integer>();
        for (int j = 0; j < this.traits.traits.size(); ++j) {
            Multiname name;
            int nskind;
            Trait t = this.traits.traits.get(j);
            if (t.name_index >= abc.constants.getMultinameCount() || (nskind = (name = t.getName(abc)).getSimpleNamespaceKind(abc.constants)) != 23 && nskind != 22) continue;
            packageTraits.add(j);
        }
        if (packageTraits.isEmpty() || packageTraits.size() > 1) {
            return null;
        }
        return this.traits.traits.get((Integer)packageTraits.get(0)).getName(abc).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, true);
    }

    public List<ScriptPack> getPacks(ABC abc, int scriptIndex, String packagePrefix, List<ABC> allAbcs) {
        ClassPath cp;
        ArrayList<Integer> traitIndices;
        String namespaceSuffix;
        String objectName;
        DottedChain packageName;
        if (packagePrefix == null && this.cachedPacks != null) {
            return new ArrayList<ScriptPack>(this.cachedPacks);
        }
        ArrayList<ScriptPack> ret = new ArrayList<ScriptPack>();
        ArrayList<Integer> otherTraits = new ArrayList<Integer>();
        for (int j = 0; j < this.traits.traits.size(); ++j) {
            Trait t = this.traits.traits.get(j);
            Multiname name = t.getName(abc);
            int nskind = name.getSimpleNamespaceKind(abc.constants);
            if (nskind == 23 || nskind == 22) continue;
            otherTraits.add(j);
        }
        int publicTraitsCount = 0;
        for (int j = 0; j < this.traits.traits.size(); ++j) {
            Trait t = this.traits.traits.get(j);
            Multiname name = t.getName(abc);
            int nskind = name.getSimpleNamespaceKind(abc.constants);
            if (nskind != 23 && nskind != 22) continue;
            ++publicTraitsCount;
        }
        boolean isSimple = publicTraitsCount == 1;
        for (int j = 0; j < this.traits.traits.size(); ++j) {
            Multiname name;
            int nskind;
            Trait t = this.traits.traits.get(j);
            if (!isSimple && t instanceof TraitSlotConst || (nskind = (name = t.getName(abc)).getSimpleNamespaceKind(abc.constants)) != 23 && nskind != 22) continue;
            packageName = name.getSimpleNamespaceName(abc.constants);
            objectName = name.getName(new LinkedHashSet<String>(), abc, abc.constants, null, true, false);
            namespaceSuffix = name.getNamespaceSuffix();
            traitIndices = new ArrayList<Integer>();
            traitIndices.add(j);
            if (!otherTraits.isEmpty()) {
                traitIndices.addAll(otherTraits);
                otherTraits.clear();
            }
            if (packagePrefix != null && !packageName.toPrintableString(new LinkedHashSet<String>(), abc.getSwf(), true).startsWith(packagePrefix)) continue;
            cp = new ClassPath(packageName, objectName, namespaceSuffix, abc.getSwf());
            ScriptPack pack = new ScriptPack(cp, abc, allAbcs, scriptIndex, traitIndices);
            pack.isSimple = isSimple;
            ret.add(pack);
        }
        if (ret.isEmpty() && !otherTraits.isEmpty()) {
            Iterator iterator = otherTraits.iterator();
            while (iterator.hasNext()) {
                int traitIndex = (Integer)iterator.next();
                Trait t = this.traits.traits.get(traitIndex);
                Multiname name = t.getName(abc);
                packageName = name.getSimpleNamespaceName(abc.constants);
                objectName = name.getName(new LinkedHashSet<String>(), abc, abc.constants, null, true, false);
                namespaceSuffix = name.getNamespaceSuffix();
                traitIndices = new ArrayList();
                traitIndices.add(traitIndex);
                cp = new ClassPath(packageName, objectName, namespaceSuffix, abc.getSwf());
                ret.add(new ScriptPack(cp, abc, allAbcs, scriptIndex, traitIndices));
            }
        }
        if (!isSimple) {
            ret.add(new ScriptPack(new ClassPath(DottedChain.EMPTY, "script_" + scriptIndex, "", abc.getSwf()), abc, allAbcs, scriptIndex, new ArrayList<Integer>()));
        }
        if (packagePrefix == null) {
            this.cachedPacks = new ArrayList<ScriptPack>(ret);
        }
        return ret;
    }

    public int removeTraps(int scriptIndex, ABC abc, String path) throws InterruptedException {
        return this.traits.removeTraps(scriptIndex, -1, true, abc, path);
    }

    public String toString() {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString();
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString(abc, fullyQualifiedNames);
    }

    public void delete(ABC abc, boolean d) {
        this.deleted = d;
        abc.method_info.get(this.init_index).delete(abc, d);
        this.traits.delete(abc, d);
        if (d) {
            this.clearPacksCache();
        }
    }
}

