/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types.traits;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.Reference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Traits
implements Cloneable,
Serializable {
    public List<Trait> traits;

    public Traits() {
        this.traits = new ArrayList<Trait>();
    }

    public Traits(int initialCapacity) {
        this.traits = new ArrayList<Trait>(initialCapacity);
    }

    public void delete(ABC abc, boolean d) {
        for (Trait t : this.traits) {
            t.delete(abc, d);
        }
    }

    public int addTrait(Trait t) {
        this.traits.add(t);
        return this.traits.size() - 1;
    }

    public int removeTraps(int scriptIndex, int classIndex, boolean isStatic, ABC abc, String path) throws InterruptedException {
        int ret = 0;
        for (Trait t : this.traits) {
            ret += t.removeTraps(scriptIndex, classIndex, isStatic, abc, path);
        }
        return ret;
    }

    public String toString() {
        String s = "";
        for (int t = 0; t < this.traits.size(); ++t) {
            if (t > 0) {
                s = s + "\r\n";
            }
            s = s + this.traits.get(t).toString();
        }
        return s;
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        String s = "";
        for (int t = 0; t < this.traits.size(); ++t) {
            if (t > 0) {
                s = s + "\r\n";
            }
            s = s + this.traits.get(t).toString(abc, fullyQualifiedNames);
        }
        return s;
    }

    public GraphTextWriter toString(Set<String> usedDeobfuscations, int swfVersion, DottedChain packageName, Reference<Boolean> first, AbcIndexing abcIndex, Class[] traitTypes, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, boolean makePackages, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, List<String> ignoredTraitNames, boolean insideInterface) throws InterruptedException {
        List<Trait> ordered = this.traits;
        for (Trait trait : ordered) {
            int t = this.traits.indexOf(trait);
            if (traitTypes != null) {
                boolean found = false;
                for (Class c : traitTypes) {
                    if (!c.isInstance(trait)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (!trait.isVisible(isStatic, abc) || ignoredTraitNames.contains(trait.getName(abc).getName(usedDeobfuscations, abc, abc.constants, new ArrayList<DottedChain>(), false, false)) || trait instanceof TraitSlotConst && convertData.assignedValues.containsKey((TraitSlotConst)trait) && isStatic) continue;
            if (!first.getVal().booleanValue()) {
                writer.newLine();
            }
            first.setVal(false);
            int h = abc.getGlobalTraitId(TraitType.METHOD, isStatic, classIndex, t);
            writer.startTrait(h);
            if (makePackages) {
                trait.toStringPackaged(usedDeobfuscations, swfVersion, abcIndex, parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel, insideInterface);
            } else {
                trait.toString(usedDeobfuscations, swfVersion, abcIndex, packageName, parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel, insideInterface);
            }
            writer.endTrait();
        }
        return writer;
    }

    public void convert(Set<String> usedDeobfuscations, int swfVersion, AbcIndexing abcIndex, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, boolean makePackages, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, ScopeStack scopeStack) throws InterruptedException {
        if (!parallel || this.traits.size() < 2) {
            for (int t = 0; t < this.traits.size(); ++t) {
                TraitConvertTask task = new TraitConvertTask(usedDeobfuscations, swfVersion, abcIndex, this.traits.get(t), parent, convertData, makePackages, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, t, parallel, scopeStack);
                task.call();
            }
        } else {
            ExecutorService executor = Executors.newFixedThreadPool(Configuration.getParallelThreadCount());
            ArrayList<Future<Void>> futureResults = new ArrayList<Future<Void>>();
            for (int t = 0; t < this.traits.size(); ++t) {
                TraitConvertTask task = new TraitConvertTask(usedDeobfuscations, swfVersion, abcIndex, this.traits.get(t), parent, convertData, makePackages, path, abc, isStatic, exportMode, scriptIndex, classIndex, new NulWriter(), fullyQualifiedNames, t, parallel, scopeStack);
                Future<Void> future = executor.submit(task);
                futureResults.add(future);
            }
            for (int f = 0; f < futureResults.size(); ++f) {
                try {
                    ((Future)futureResults.get(f)).get();
                    continue;
                }
                catch (InterruptedException ex) {
                    executor.shutdownNow();
                    throw ex;
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(Traits.class.getName()).log(Level.SEVERE, "Error during traits converting", ex);
                }
            }
            executor.shutdown();
        }
    }

    public Traits clone() {
        try {
            Traits ret = (Traits)super.clone();
            if (this.traits != null) {
                ret.traits = new ArrayList<Trait>(this.traits.size());
                for (int i = 0; i < this.traits.size(); ++i) {
                    ret.traits.add(this.traits.get(i).clone());
                }
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public void getDependencies(Set<String> usedDeobfuscations, AbcIndexing abcIndex, int scriptIndex, int classIndex, boolean isStatic, String customNs, ABC abc, List<Dependency> dependencies, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, List<String> uses, Reference<Integer> numberContextRef) throws InterruptedException {
        for (Trait t : this.traits) {
            t.getDependencies(usedDeobfuscations, abcIndex, scriptIndex, classIndex, isStatic, customNs, abc, dependencies, ignorePackage, fullyQualifiedNames, uses, numberContextRef);
        }
    }

    public void getMethodInfos(ABC abc, boolean isStatic, int classIndex, List<MethodId> methodInfos) {
        for (int t = 0; t < this.traits.size(); ++t) {
            Trait trait = this.traits.get(t);
            trait.getMethodInfos(abc, abc.getGlobalTraitId(TraitType.METHOD, isStatic, classIndex, t), classIndex, methodInfos);
        }
    }

    private class TraitConvertTask
    implements Callable<Void> {
        Trait trait;
        boolean makePackages;
        String path;
        ABC abc;
        boolean isStatic;
        ScriptExportMode exportMode;
        int scriptIndex;
        int classIndex;
        NulWriter writer;
        List<DottedChain> fullyQualifiedNames;
        int traitIndex;
        boolean parallel;
        Trait parent;
        ConvertData convertData;
        private final Set<String> usedDeobfuscations;
        private final int swfVersion;
        AbcIndexing abcIndex;
        ScopeStack scopeStack;

        public TraitConvertTask(Set<String> usedDeobfuscations, int swfVersion, AbcIndexing abcIndex, Trait trait, Trait parent, ConvertData convertData, boolean makePackages, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, int traitIndex, boolean parallel, ScopeStack scopeStack) {
            this.trait = trait;
            this.parent = parent;
            this.convertData = convertData;
            this.makePackages = makePackages;
            this.path = path;
            this.abc = abc;
            this.isStatic = isStatic;
            this.exportMode = exportMode;
            this.scriptIndex = scriptIndex;
            this.classIndex = classIndex;
            this.writer = writer;
            this.fullyQualifiedNames = fullyQualifiedNames;
            this.traitIndex = traitIndex;
            this.parallel = parallel;
            this.usedDeobfuscations = usedDeobfuscations;
            this.swfVersion = swfVersion;
            this.abcIndex = abcIndex;
            this.scopeStack = scopeStack;
        }

        @Override
        public Void call() throws InterruptedException {
            if (this.makePackages) {
                this.trait.convertPackaged(this.usedDeobfuscations, this.swfVersion, this.abcIndex, this.parent, this.convertData, this.path, this.abc, this.isStatic, this.exportMode, this.scriptIndex, this.classIndex, this.writer, this.fullyQualifiedNames, this.parallel, this.scopeStack);
            } else {
                this.trait.convert(this.usedDeobfuscations, this.swfVersion, this.abcIndex, this.parent, this.convertData, this.path, this.abc, this.isStatic, this.exportMode, this.scriptIndex, this.classIndex, this.writer, this.fullyQualifiedNames, this.parallel, this.scopeStack);
            }
            return null;
        }
    }
}

