/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.usages;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.Usage;
import com.jpexs.decompiler.flash.abc.usages.UsageDetector;
import com.jpexs.decompiler.flash.abc.usages.multinames.ClassNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.ConstVarNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.ConstVarTypeMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.MethodBodyMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.MethodNameMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.MethodParamsMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.MethodReturnTypeMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.SuperClassMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.SuperInterfaceMultinameUsage;
import com.jpexs.decompiler.flash.abc.usages.multinames.TypeNameMultinameUsage;
import java.util.ArrayList;
import java.util.List;

public class MultinameUsageDetector
implements UsageDetector {
    @Override
    public List<Usage> findUsages(ABC abc, int index) {
        return this.findMultinameUsage(abc, index, true);
    }

    public List<Usage> findMultinameUsage(ABC abc, int multinameIndex, boolean exactMatch) {
        ArrayList<Usage> ret = new ArrayList<Usage>();
        if (multinameIndex == 0) {
            return ret;
        }
        for (int s = 0; s < abc.script_info.size(); ++s) {
            this.checkMultinameUsedInMethod(abc, multinameIndex, exactMatch, abc.script_info.get((int)s).init_index, ret, s, -1, 0, 3, true, null, -1);
            this.findMultinameUsageInTraits(abc, abc.script_info.get((int)s).traits, multinameIndex, exactMatch, 3, s, -1, ret, -1);
        }
        block1: for (int t = 1; t < abc.constants.getMultinameCount(); ++t) {
            Multiname multiname = abc.constants.getMultiname(t);
            if (multiname.kind != 29) continue;
            if (multiname.qname_index == multinameIndex) {
                ret.add(new TypeNameMultinameUsage(abc, multinameIndex, t, -1));
                continue;
            }
            for (int mp : multiname.params) {
                if (mp != multinameIndex) continue;
                ret.add(new TypeNameMultinameUsage(abc, multinameIndex, t, -1));
                continue block1;
            }
        }
        return ret;
    }

    @Override
    public List<List<Usage>> findAllUsage(ABC abc) {
        ArrayList<List<Usage>> ret = new ArrayList<List<Usage>>();
        for (int i = 0; i < abc.constants.getMultinameCount(); ++i) {
            ret.add(new ArrayList());
        }
        for (int s = 0; s < abc.script_info.size(); ++s) {
            this.checkAllMultinameUsedInMethod(abc, abc.script_info.get((int)s).init_index, ret, s, -1, 0, 3, true, null, -1);
            this.findAllMultinameUsageInTraits(abc, abc.script_info.get((int)s).traits, 3, s, -1, ret, -1);
        }
        boolean[] foundMultinames = new boolean[abc.constants.getMultinameCount()];
        for (int t = 1; t < abc.constants.getMultinameCount(); ++t) {
            Multiname multiname = abc.constants.getMultiname(t);
            if (multiname.kind != 29) continue;
            if (!foundMultinames[multiname.qname_index]) {
                ((List)ret.get(multiname.qname_index)).add(new TypeNameMultinameUsage(abc, multiname.qname_index, t, -1));
                foundMultinames[multiname.qname_index] = true;
            }
            for (int mp : multiname.params) {
                if (foundMultinames[mp]) continue;
                ((List)ret.get(mp)).add(new TypeNameMultinameUsage(abc, mp, t, -1));
                foundMultinames[mp] = true;
            }
        }
        return ret;
    }

    @Override
    public String getKind() {
        return "string";
    }

    private void findAllMultinameUsageInTraits(ABC abc, Traits traits, int traitsType, int scriptIndex, int classIndex, List<List<Usage>> ret, int parentTraitIndex) {
        for (int t = 0; t < traits.traits.size(); ++t) {
            if (traits.traits.get(t) instanceof TraitClass) {
                TraitClass tc = (TraitClass)traits.traits.get(t);
                ret.get(tc.name_index).add(new ClassNameMultinameUsage(abc, tc.name_index, tc.class_info, scriptIndex));
                int c = tc.class_info;
                int classNameMultinameIndex = abc.instance_info.get((int)c).name_index;
                ret.get(classNameMultinameIndex).add(new ClassNameMultinameUsage(abc, classNameMultinameIndex, c, scriptIndex));
                int extendsMultinameIndex = abc.instance_info.get((int)c).super_index;
                ret.get(extendsMultinameIndex).add(new SuperClassMultinameUsage(abc, extendsMultinameIndex, c, scriptIndex));
                for (int i = 0; i < abc.instance_info.get((int)c).interfaces.length; ++i) {
                    int implementsMultinameIndex = abc.instance_info.get((int)c).interfaces[i];
                    ret.get(implementsMultinameIndex).add(new SuperInterfaceMultinameUsage(abc, implementsMultinameIndex, c, scriptIndex));
                }
                this.checkAllMultinameUsedInMethod(abc, abc.instance_info.get((int)c).iinit_index, ret, -1, c, 0, 2, true, null, -1);
                this.checkAllMultinameUsedInMethod(abc, abc.class_info.get((int)c).cinit_index, ret, -1, c, 0, 1, true, null, -1);
                this.findAllMultinameUsageInTraits(abc, abc.instance_info.get((int)c).instance_traits, 2, -1, c, ret, -1);
                this.findAllMultinameUsageInTraits(abc, abc.class_info.get((int)c).static_traits, 1, -1, c, ret, -1);
            }
            if (traits.traits.get(t) instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)traits.traits.get(t);
                ret.get(tsc.name_index).add(new ConstVarNameMultinameUsage(abc, tsc.name_index, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                ret.get(tsc.type_index).add(new ConstVarTypeMultinameUsage(abc, tsc.type_index, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
            }
            if (!(traits.traits.get(t) instanceof TraitMethodGetterSetter)) continue;
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)traits.traits.get(t);
            ret.get(tmgs.name_index).add(new MethodNameMultinameUsage(abc, tmgs.name_index, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex));
            this.checkAllMultinameUsedInMethod(abc, tmgs.method_info, ret, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex);
        }
    }

    private void checkAllMultinameUsedInMethod(ABC abc, int methodInfo, List<List<Usage>> ret, int scriptIndex, int classIndex, int traitIndex, int traitsType, boolean isInitializer, Traits traits, int parentTraitIndex) {
        boolean[] foundMultinames = new boolean[abc.constants.getMultinameCount()];
        for (int p = 0; p < abc.method_info.get((int)methodInfo).param_types.length; ++p) {
            int methodParamsMultinameIndex = abc.method_info.get((int)methodInfo).param_types[p];
            if (foundMultinames[methodParamsMultinameIndex]) continue;
            ret.get(methodParamsMultinameIndex).add(new MethodParamsMultinameUsage(abc, methodParamsMultinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
            foundMultinames[methodParamsMultinameIndex] = true;
        }
        int methodReturnTypeMultinameIndex = abc.method_info.get((int)methodInfo).ret_type;
        ret.get(methodReturnTypeMultinameIndex).add(new MethodReturnTypeMultinameUsage(abc, methodReturnTypeMultinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
        MethodBody body = abc.findBody(methodInfo);
        if (body != null) {
            this.findAllMultinameUsageInTraits(abc, body.traits, traitsType, scriptIndex, classIndex, ret, traitIndex);
            foundMultinames = new boolean[abc.constants.getMultinameCount()];
            for (ABCException e : body.exceptions) {
                if (!foundMultinames[e.name_index]) {
                    ret.get(e.name_index).add(new MethodBodyMultinameUsage(abc, e.name_index, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    foundMultinames[e.name_index] = true;
                }
                if (foundMultinames[e.type_index]) continue;
                ret.get(e.type_index).add(new MethodBodyMultinameUsage(abc, e.type_index, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                foundMultinames[e.type_index] = true;
            }
            for (AVM2Instruction ins : body.getCode().code) {
                for (int o = 0; o < ins.definition.operands.length; ++o) {
                    int mi;
                    if (ins.definition.operands[o] != 257 || (mi = ins.operands[o]) >= foundMultinames.length || foundMultinames[mi]) continue;
                    ret.get(mi).add(new MethodBodyMultinameUsage(abc, mi, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    foundMultinames[mi] = true;
                }
            }
        }
    }

    private boolean isSameName(ABC abc, int expectedQNameIndex, int checkedNameIndex, boolean exactMatch) {
        if (expectedQNameIndex == checkedNameIndex) {
            return true;
        }
        if (exactMatch) {
            return false;
        }
        Multiname expectedQName = abc.constants.getMultiname(expectedQNameIndex);
        Multiname checkedName = abc.constants.getMultiname(checkedNameIndex);
        if (checkedName == null) {
            return false;
        }
        if (expectedQName.name_index != checkedName.name_index) {
            return false;
        }
        if (checkedName.kind == 7) {
            return expectedQName.namespace_index == checkedName.namespace_index;
        }
        if (checkedName.kind != 9) {
            return false;
        }
        for (int ns : abc.constants.getNamespaceSet((int)checkedName.namespace_set_index).namespaces) {
            if (ns != expectedQName.namespace_index) continue;
            return true;
        }
        return false;
    }

    private void findMultinameUsageInTraits(ABC abc, Traits traits, int multinameIndex, boolean exactMatch, int traitsType, int scriptIndex, int classIndex, List<Usage> ret, int parentTraitIndex) {
        for (int t = 0; t < traits.traits.size(); ++t) {
            if (traits.traits.get(t) instanceof TraitClass) {
                TraitClass tc = (TraitClass)traits.traits.get(t);
                if (this.isSameName(abc, multinameIndex, tc.name_index, exactMatch)) {
                    ret.add(new ClassNameMultinameUsage(abc, multinameIndex, tc.class_info, scriptIndex));
                }
                int c = tc.class_info;
                if (this.isSameName(abc, multinameIndex, abc.instance_info.get((int)c).super_index, exactMatch)) {
                    ret.add(new SuperClassMultinameUsage(abc, multinameIndex, c, scriptIndex));
                }
                for (int i = 0; i < abc.instance_info.get((int)c).interfaces.length; ++i) {
                    if (!this.isSameName(abc, multinameIndex, abc.instance_info.get((int)c).interfaces[i], exactMatch)) continue;
                    ret.add(new SuperInterfaceMultinameUsage(abc, multinameIndex, c, scriptIndex));
                }
                this.checkMultinameUsedInMethod(abc, multinameIndex, exactMatch, abc.instance_info.get((int)c).iinit_index, ret, -1, c, 0, 2, true, null, -1);
                this.checkMultinameUsedInMethod(abc, multinameIndex, exactMatch, abc.class_info.get((int)c).cinit_index, ret, -1, c, 0, 1, true, null, -1);
                this.findMultinameUsageInTraits(abc, abc.instance_info.get((int)c).instance_traits, multinameIndex, exactMatch, 2, -1, c, ret, -1);
                this.findMultinameUsageInTraits(abc, abc.class_info.get((int)c).static_traits, multinameIndex, exactMatch, 1, -1, c, ret, -1);
            }
            if (traits.traits.get(t) instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)traits.traits.get(t);
                if (this.isSameName(abc, multinameIndex, tsc.name_index, exactMatch)) {
                    ret.add(new ConstVarNameMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                }
                if (this.isSameName(abc, multinameIndex, tsc.type_index, exactMatch)) {
                    ret.add(new ConstVarTypeMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, t, traitsType, traits, parentTraitIndex));
                }
            }
            if (!(traits.traits.get(t) instanceof TraitMethodGetterSetter)) continue;
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)traits.traits.get(t);
            if (this.isSameName(abc, multinameIndex, tmgs.name_index, exactMatch)) {
                ret.add(new MethodNameMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex));
            }
            this.checkMultinameUsedInMethod(abc, multinameIndex, exactMatch, tmgs.method_info, ret, scriptIndex, classIndex, t, traitsType, false, traits, parentTraitIndex);
        }
    }

    private void checkMultinameUsedInMethod(ABC abc, int multinameIndex, boolean exactMatch, int methodInfo, List<Usage> ret, int scriptIndex, int classIndex, int traitIndex, int traitsType, boolean isInitializer, Traits traits, int parentTraitIndex) {
        MethodBody body;
        for (int p = 0; p < abc.method_info.get((int)methodInfo).param_types.length; ++p) {
            if (!this.isSameName(abc, multinameIndex, abc.method_info.get((int)methodInfo).param_types[p], exactMatch)) continue;
            ret.add(new MethodParamsMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
            break;
        }
        if (this.isSameName(abc, multinameIndex, abc.method_info.get((int)methodInfo).ret_type, exactMatch)) {
            ret.add(new MethodReturnTypeMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
        }
        if ((body = abc.findBody(methodInfo)) != null) {
            this.findMultinameUsageInTraits(abc, body.traits, multinameIndex, exactMatch, traitsType, scriptIndex, classIndex, ret, traitIndex);
            for (ABCException e : body.exceptions) {
                if (!this.isSameName(abc, multinameIndex, e.name_index, exactMatch) && !this.isSameName(abc, multinameIndex, e.type_index, exactMatch)) continue;
                ret.add(new MethodBodyMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                return;
            }
            for (AVM2Instruction ins : body.getCode().code) {
                for (int o = 0; o < ins.definition.operands.length; ++o) {
                    if (ins.definition.operands[o] != 257 || ins.operands[o] >= abc.constants.getMultinameCount() || !this.isSameName(abc, multinameIndex, ins.operands[o], exactMatch)) continue;
                    ret.add(new MethodBodyMultinameUsage(abc, multinameIndex, scriptIndex, classIndex, traitIndex, traitsType, isInitializer, traits, parentTraitIndex));
                    return;
                }
            }
        }
    }
}

