/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.usages.simple;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCOutputStream;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.simple.ABCSimpleUsageDetector;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.helpers.NulStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ABCCleaner {
    public void clean(ABC abc) {
        int i;
        Object m;
        int i2;
        ABCSimpleUsageDetector usageDetector = new ABCSimpleUsageDetector(abc);
        usageDetector.detect();
        Map<ABCSimpleUsageDetector.ItemKind, List<List<String>>> usages = usageDetector.getUsages();
        HashMap notReferencedIndices = new HashMap();
        HashMap<ABCSimpleUsageDetector.ItemKind, Map<Integer, Integer>> replaceMap = new HashMap<ABCSimpleUsageDetector.ItemKind, Map<Integer, Integer>>();
        for (ABCSimpleUsageDetector.ItemKind kind : usages.keySet()) {
            int pos;
            List<List<String>> usagesList = usages.get((Object)kind);
            notReferencedIndices.put(kind, new ArrayList());
            replaceMap.put(kind, new HashMap());
            if (kind.hasReservedZeroIndex()) {
                ((Map)replaceMap.get((Object)kind)).put(0, 0);
            }
            for (int i3 = pos = kind.hasReservedZeroIndex() ? 1 : 0; i3 < usagesList.size(); ++i3) {
                if (usagesList.get(i3).isEmpty()) {
                    ((List)notReferencedIndices.get((Object)kind)).add(i3);
                    continue;
                }
                ((Map)replaceMap.get((Object)kind)).put(i3, pos);
                ++pos;
            }
        }
        for (i2 = 0; i2 < abc.script_info.size(); ++i2) {
            m = abc.script_info.get(i2);
            ((ScriptInfo)m).init_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, ((ScriptInfo)m).init_index, replaceMap);
            this.walkTraits(abc, ((ScriptInfo)m).traits, replaceMap);
        }
        for (i2 = 0; i2 < abc.method_info.size(); ++i2) {
            int j;
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METHODINFO)).contains(i2)) continue;
            m = abc.method_info.get(i2);
            ((MethodInfo)m).name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((MethodInfo)m).name_index, replaceMap);
            if (((MethodInfo)m).flagHas_paramnames()) {
                for (j = 0; j < ((MethodInfo)m).paramNames.length; ++j) {
                    ((MethodInfo)m).paramNames[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((MethodInfo)m).paramNames[j], replaceMap);
                }
            }
            if (((MethodInfo)m).flagHas_optional()) {
                for (j = 0; j < ((MethodInfo)m).optional.length; ++j) {
                    ((MethodInfo)m).optional[j].value_index = this.handleReplaceValueKind(abc, ((MethodInfo)m).optional[j].value_kind, ((MethodInfo)m).optional[j].value_index, replaceMap);
                }
            }
            for (j = 0; j < ((MethodInfo)m).param_types.length; ++j) {
                ((MethodInfo)m).param_types[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((MethodInfo)m).param_types[j], replaceMap);
            }
            ((MethodInfo)m).ret_type = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((MethodInfo)m).ret_type, replaceMap);
        }
        for (i2 = 0; i2 < abc.metadata_info.size(); ++i2) {
            int j;
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METADATAINFO)).contains(i2)) continue;
            m = abc.metadata_info.get(i2);
            ((MetadataInfo)m).name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((MetadataInfo)m).name_index, replaceMap);
            for (j = 0; j < ((MetadataInfo)m).keys.length; ++j) {
                ((MetadataInfo)m).keys[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((MetadataInfo)m).keys[j], replaceMap);
            }
            for (j = 0; j < ((MetadataInfo)m).values.length; ++j) {
                ((MetadataInfo)m).values[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((MetadataInfo)m).values[j], replaceMap);
            }
        }
        for (i2 = 1; i2 < abc.constants.getMultinameCount(); ++i2) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.MULTINAME)).contains(i2)) continue;
            m = abc.constants.getMultiname(i2);
            if (((Multiname)m).hasOwnName()) {
                ((Multiname)m).name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((Multiname)m).name_index, replaceMap);
            }
            if (((Multiname)m).hasOwnNamespace()) {
                ((Multiname)m).namespace_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACE, ((Multiname)m).namespace_index, replaceMap);
            }
            if (((Multiname)m).hasOwnNamespaceSet()) {
                ((Multiname)m).namespace_set_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACESET, ((Multiname)m).namespace_set_index, replaceMap);
            }
            if (((Multiname)m).kind != 29) continue;
            ((Multiname)m).qname_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((Multiname)m).qname_index, replaceMap);
            for (int j = 0; j < ((Multiname)m).params.length; ++j) {
                ((Multiname)m).params[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((Multiname)m).params[j], replaceMap);
            }
        }
        for (i2 = 1; i2 < abc.constants.getNamespaceCount(); ++i2) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.NAMESPACE)).contains(i2)) continue;
            m = abc.constants.getNamespace(i2);
            ((Namespace)m).name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ((Namespace)m).name_index, replaceMap);
        }
        for (i2 = 1; i2 < abc.constants.getNamespaceSetCount(); ++i2) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.NAMESPACESET)).contains(i2)) continue;
            m = abc.constants.getNamespaceSet(i2);
            for (int j = 0; j < ((NamespaceSet)m).namespaces.length; ++j) {
                ((NamespaceSet)m).namespaces[j] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACE, ((NamespaceSet)m).namespaces[j], replaceMap);
            }
        }
        for (i2 = 0; i2 < abc.bodies.size(); ++i2) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METHODBODY)).contains(i2)) continue;
            m = abc.bodies.get(i2);
            for (int j = 0; j < ((MethodBody)m).exceptions.length; ++j) {
                ((MethodBody)m).exceptions[j].name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((MethodBody)m).exceptions[j].name_index, replaceMap);
                ((MethodBody)m).exceptions[j].type_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ((MethodBody)m).exceptions[j].type_index, replaceMap);
            }
            ((MethodBody)m).method_info = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, ((MethodBody)m).method_info, replaceMap);
            this.walkTraits(abc, ((MethodBody)m).traits, replaceMap);
            AVM2Code acode = ((MethodBody)m).getCode();
            List<AVM2Instruction> code = acode.code;
            boolean bodyModified = false;
            for (int ip = 0; ip < code.size(); ++ip) {
                AVM2Instruction ins = code.get(ip);
                for (int operandIndex = 0; operandIndex < ins.definition.operands.length; ++operandIndex) {
                    int oldOperand = ins.operands[operandIndex];
                    switch (ins.definition.operands[operandIndex]) {
                        case 269: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.CLASS, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 273: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.DECIMAL, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 272: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.DOUBLE, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 277: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.FLOAT, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 278: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.FLOAT4, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 270: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.INT, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 259: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 257: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 279: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACE, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 260: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, ins.operands[operandIndex], replaceMap);
                            break;
                        }
                        case 271: {
                            ins.operands[operandIndex] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.UINT, ins.operands[operandIndex], replaceMap);
                        }
                    }
                    int newOperand = ins.operands[operandIndex];
                    if (oldOperand == newOperand) continue;
                    bodyModified = true;
                    int byteDelta = ABCOutputStream.getU30ByteLength(newOperand) - ABCOutputStream.getU30ByteLength(oldOperand);
                    if (byteDelta == 0) continue;
                    acode.updateInstructionByteCount(ip, byteDelta, (MethodBody)m);
                }
            }
            if (!bodyModified) continue;
            ((MethodBody)m).setModified();
        }
        AVM2ConstantPool newCpool = new AVM2ConstantPool();
        for (i = 1; i < abc.constants.getIntCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.INT)).contains(i)) continue;
            newCpool.addInt(abc.constants.getInt(i));
        }
        for (i = 1; i < abc.constants.getUIntCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.UINT)).contains(i)) continue;
            newCpool.addUInt(abc.constants.getUInt(i));
        }
        for (i = 1; i < abc.constants.getDoubleCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.DOUBLE)).contains(i)) continue;
            newCpool.addDouble(abc.constants.getDouble(i));
        }
        if (abc.hasDecimalSupport()) {
            for (i = 1; i < abc.constants.getDecimalCount(); ++i) {
                if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.DECIMAL)).contains(i)) continue;
                newCpool.addDecimal(abc.constants.getDecimal(i));
            }
        }
        if (abc.hasFloatSupport()) {
            for (i = 1; i < abc.constants.getFloatCount(); ++i) {
                if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.FLOAT)).contains(i)) continue;
                newCpool.addFloat(abc.constants.getFloat(i));
            }
        }
        if (abc.hasFloat4Support()) {
            for (i = 1; i < abc.constants.getFloat4Count(); ++i) {
                if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.FLOAT4)).contains(i)) continue;
                newCpool.addFloat4(abc.constants.getFloat4(i));
            }
        }
        for (i = 1; i < abc.constants.getStringCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.STRING)).contains(i)) continue;
            newCpool.addString(abc.constants.getString(i));
        }
        for (i = 1; i < abc.constants.getNamespaceCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.NAMESPACE)).contains(i)) continue;
            newCpool.addNamespace(abc.constants.getNamespace(i));
        }
        for (i = 1; i < abc.constants.getNamespaceSetCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.NAMESPACESET)).contains(i)) continue;
            newCpool.addNamespaceSet(abc.constants.getNamespaceSet(i));
        }
        for (i = 1; i < abc.constants.getMultinameCount(); ++i) {
            if (((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.MULTINAME)).contains(i)) continue;
            newCpool.addMultiname(abc.constants.getMultiname(i));
        }
        abc.constants = newCpool;
        for (i = abc.metadata_info.size() - 1; i >= 0; --i) {
            if (!((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METADATAINFO)).contains(i)) continue;
            abc.metadata_info.remove(i);
        }
        for (i = abc.bodies.size() - 1; i >= 0; --i) {
            if (!((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METHODBODY)).contains(i)) continue;
            abc.bodies.remove(i);
        }
        for (i = abc.method_info.size() - 1; i >= 0; --i) {
            if (!((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.METHODINFO)).contains(i)) continue;
            abc.method_info.remove(i);
        }
        for (i = abc.instance_info.size() - 1; i >= 0; --i) {
            if (!((List)notReferencedIndices.get((Object)ABCSimpleUsageDetector.ItemKind.CLASS)).contains(i)) continue;
            abc.instance_info.remove(i);
            abc.class_info.remove(i);
        }
        abc.clearAllCaches();
        try {
            abc.saveToStream(new NulStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (abc.parentTag != null) {
            ((Tag)((Object)abc.parentTag)).setModified(true);
        }
        abc.fireChanged();
    }

    private int handleReplace(ABCSimpleUsageDetector.ItemKind kind, int index, Map<ABCSimpleUsageDetector.ItemKind, Map<Integer, Integer>> replaceMap) {
        if (!replaceMap.containsKey((Object)kind) || !replaceMap.get((Object)kind).containsKey(index)) {
            return index;
        }
        return replaceMap.get((Object)kind).get(index);
    }

    private int handleReplaceValueKind(ABC abc, int value_kind, int value_index, Map<ABCSimpleUsageDetector.ItemKind, Map<Integer, Integer>> replaceMap) {
        switch (value_kind) {
            case 3: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.INT, value_index, replaceMap);
            }
            case 4: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.UINT, value_index, replaceMap);
            }
            case 6: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.DOUBLE, value_index, replaceMap);
            }
            case 2: {
                if (abc.hasFloatSupport()) {
                    return this.handleReplace(ABCSimpleUsageDetector.ItemKind.FLOAT, value_index, replaceMap);
                }
                if (!abc.hasDecimalSupport()) break;
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.DECIMAL, value_index, replaceMap);
            }
            case 30: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.FLOAT4, value_index, replaceMap);
            }
            case 1: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.STRING, value_index, replaceMap);
            }
            case 5: 
            case 8: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACE, value_index, replaceMap);
            }
        }
        return value_index;
    }

    private void walkTraits(ABC abc, Traits traits, Map<ABCSimpleUsageDetector.ItemKind, Map<Integer, Integer>> replaceMap) {
        for (Trait t : traits.traits) {
            if ((t.kindFlags & 4) > 0) {
                for (int i = 0; i < t.metadata.length; ++i) {
                    t.metadata[i] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METADATAINFO, t.metadata[i], replaceMap);
                }
            }
            t.name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, t.name_index, replaceMap);
            if (t instanceof TraitMethodGetterSetter) {
                TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
                tmgs.method_info = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, tmgs.method_info, replaceMap);
            }
            if (t instanceof TraitFunction) {
                TraitFunction tf = (TraitFunction)t;
                tf.method_info = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, tf.method_info, replaceMap);
            }
            if (t instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)t;
                tsc.type_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, tsc.type_index, replaceMap);
                tsc.value_index = this.handleReplaceValueKind(abc, tsc.value_kind, tsc.value_index, replaceMap);
            }
            if (!(t instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)t;
            int classIndex = tc.class_info;
            InstanceInfo ii = abc.instance_info.get(classIndex);
            if ((ii.flags & 8) != 0) {
                ii.protectedNS = this.handleReplace(ABCSimpleUsageDetector.ItemKind.NAMESPACE, ii.protectedNS, replaceMap);
            }
            ii.name_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ii.name_index, replaceMap);
            ii.super_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ii.super_index, replaceMap);
            for (int i = 0; i < ii.interfaces.length; ++i) {
                ii.interfaces[i] = this.handleReplace(ABCSimpleUsageDetector.ItemKind.MULTINAME, ii.interfaces[i], replaceMap);
            }
            ii.iinit_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, ii.iinit_index, replaceMap);
            this.walkTraits(abc, ii.instance_traits, replaceMap);
            ClassInfo ci = abc.class_info.get(classIndex);
            ci.cinit_index = this.handleReplace(ABCSimpleUsageDetector.ItemKind.METHODINFO, ci.cinit_index, replaceMap);
            this.walkTraits(abc, ci.static_traits, replaceMap);
            tc.class_info = this.handleReplace(ABCSimpleUsageDetector.ItemKind.CLASS, tc.class_info, replaceMap);
        }
    }
}

