/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionCallFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CallFunctionActionItem
extends ActionItem {
    public final GraphTargetItem functionName;
    public final List<GraphTargetItem> arguments;
    public GraphTargetItem calculatedFunction;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.arguments);
    }

    public CallFunctionActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem functionName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.functionName = functionName;
        this.arguments = arguments;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        HighlightData srcData = this.getSrcData();
        srcData.localName = this.functionName.toStringNoQuotes(localData);
        if (this.functionName instanceof DirectValueActionItem) {
            if (!IdentifiersDeobfuscation.isValidName(false, this.functionName.toStringNoQuotes(localData), new String[0])) {
                this.functionName.toString(writer, localData);
            } else {
                this.functionName.toStringNoQuotes(writer, localData);
            }
        } else {
            if (this.functionName.getPrecedence() > this.getPrecedence()) {
                writer.append("(");
            }
            this.functionName.appendTry(writer, localData);
            if (this.functionName.getPrecedence() > this.getPrecedence()) {
                writer.append(")");
            }
        }
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.allowWrapHere().append(",");
            }
            this.arguments.get(t).toStringNL(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.functionName.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (this.calculatedFunction == null) {
            return false;
        }
        if (dependencies.contains(this.calculatedFunction)) {
            return false;
        }
        dependencies.add(this.calculatedFunction);
        return this.calculatedFunction.isCompileTime(dependencies);
    }

    @Override
    public Object getResult() {
        if (this.calculatedFunction == null) {
            return null;
        }
        return this.calculatedFunction.getResult();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.functionName);
        hash = 37 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallFunctionActionItem other = (CallFunctionActionItem)obj;
        if (!Objects.equals(this.functionName, other.functionName)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallFunctionActionItem other = (CallFunctionActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.functionName, other.functionName)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.arguments, other.arguments);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (this.functionName instanceof VariableActionItem) {
            VariableActionItem varItem = (VariableActionItem)this.functionName;
            if (varItem.getBoxedValue() instanceof DirectValueActionItem && ((DirectValueActionItem)varItem.getBoxedValue()).value instanceof RegisterNumber) {
                return CallFunctionActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), varItem.getBoxedValue(), new DirectValueActionItem(Undefined.INSTANCE), new ActionCallMethod());
            }
            String varName = varItem.getVariableName();
            ActionSourceGenerator asg = (ActionSourceGenerator)generator;
            return CallFunctionActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), asg.pushConst(varName), new ActionCallFunction());
        }
        return CallFunctionActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.functionName, new ActionCallFunction());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

